/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.style;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.ui.render.GeometryPainter;
import com.vividsolutions.jtstest.testbuilder.ui.style.ComponentStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;

public class PolygonStructureStyle
extends ComponentStyle {
    private Color color = Color.BLACK;

    public PolygonStructureStyle(Color color) {
        this.color = color;
    }

    protected void paintComponent(Geometry geometry, Viewport viewport, Graphics2D graphics2D) throws Exception {
        Color color = this.color.darker();
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.setColor(color);
        BasicStroke basicStroke = new BasicStroke(1.2f, 2, 0, 10.0f, new float[]{2.0f, 10.0f}, 0.0f);
        graphics2D2.setStroke(basicStroke);
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                this.paintRing(polygon.getInteriorRingN(i), false, viewport, graphics2D2);
            }
            return;
        }
    }

    private void paintRing(LineString lineString, boolean bl, Viewport viewport, Graphics2D graphics2D) {
        Shape shape = GeometryPainter.getConverter(viewport).toShape((Geometry)lineString);
        graphics2D.draw(shape);
    }
}

