/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.render;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryContainer;
import com.vividsolutions.jtstest.testbuilder.model.Layer;
import com.vividsolutions.jtstest.testbuilder.ui.render.Renderer;
import com.vividsolutions.jtstest.testbuilder.ui.style.Style;
import java.awt.Graphics2D;

public class LayerRenderer
implements Renderer {
    private Layer layer;
    private GeometryContainer geomCont;
    private Viewport viewport;
    private boolean isCancelled = false;

    public LayerRenderer(Layer layer, Viewport viewport) {
        this(layer, layer.getSource(), viewport);
    }

    public LayerRenderer(Layer layer, GeometryContainer geometryContainer, Viewport viewport) {
        this.layer = layer;
        this.geomCont = geometryContainer;
        this.viewport = viewport;
    }

    public void render(Graphics2D graphics2D) {
        if (!this.layer.isEnabled()) {
            return;
        }
        try {
            Geometry geometry = this.getGeometry();
            if (geometry == null) {
                return;
            }
            this.render(graphics2D, this.viewport, geometry, this.layer.getStyles());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private Geometry getGeometry() {
        if (this.geomCont == null) {
            return null;
        }
        Geometry geometry = this.geomCont.getGeometry();
        return geometry;
    }

    private void render(Graphics2D graphics2D, Viewport viewport, Geometry geometry, Style style) throws Exception {
        if (!viewport.intersectsInModel(geometry.getEnvelopeInternal())) {
            return;
        }
        if (geometry instanceof GeometryCollection) {
            this.renderGeometryCollection(graphics2D, viewport, (GeometryCollection)geometry, style);
            return;
        }
        style.paint(geometry, viewport, graphics2D);
    }

    private void renderGeometryCollection(Graphics2D graphics2D, Viewport viewport, GeometryCollection geometryCollection, Style style) throws Exception {
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            this.render(graphics2D, viewport, geometryCollection.getGeometryN(i), style);
            if (!this.isCancelled) continue;
            return;
        }
    }

    public void cancel() {
        this.isCancelled = true;
    }
}

