/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.testbuilder.model.GeometryTransferable;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class SwingUtil {
    public static FileFilter xmlFileFilter = new FileFilter(){

        public String getDescription() {
            return "JTS Test XML File (*.xml)";
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.toString().toLowerCase().endsWith(".xml");
        }
    };
    public static FileFilter javaFileFilter = new FileFilter(){

        public String getDescription() {
            return "Java File (*.java)";
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.toString().toLowerCase().endsWith(".java");
        }
    };
    public static FileFilter pngFileFilter = new FileFilter(){

        public String getDescription() {
            return "PNG File (*.png)";
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.toString().toLowerCase().endsWith(".png");
        }
    };

    public static boolean confirmOverwrite(Component component, File file) {
        int n;
        return !file.exists() || (n = JOptionPane.showConfirmDialog(component, file.getName() + " exists. Overwrite?", "Confirmation", 0, 2)) != 1;
    }

    public static void setEnabled(Component component, boolean bl) {
        component.setEnabled(bl);
        if (bl) {
            component.setBackground(SystemColor.text);
        } else {
            component.setBackground(SystemColor.control);
        }
    }

    public static Integer getInteger(JTextField jTextField, Integer n) {
        String string = jTextField.getText();
        if (string.trim().length() <= 0) {
            return n;
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new Integer(n2);
    }

    public static Double getDouble(JTextField jTextField, Double d) {
        String string = jTextField.getText();
        if (string.trim().length() <= 0) {
            return d;
        }
        double d2 = 0.0;
        try {
            d2 = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new Double(d2);
    }

    public static Object getSelectedValue(JComboBox jComboBox, Object[] objectArray) {
        int n = jComboBox.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return objectArray[n];
    }

    public static void copyToClipboard(Object object, boolean bl) {
        if (object instanceof Geometry) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new GeometryTransferable((Geometry)object, bl), null);
        } else {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(object.toString()), null);
        }
    }

    public static Object getFromClipboard() {
        Transferable transferable = SwingUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
        try {
            if (transferable.isDataFlavorSupported(GeometryTransferable.GEOMETRY_FLAVOR)) {
                return transferable.getTransferData(GeometryTransferable.GEOMETRY_FLAVOR);
            }
            return transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Transferable getContents(Clipboard clipboard) {
        try {
            return clipboard.getContents(null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

