/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.io.shapefile;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.EndianDataInputStream;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.InvalidShapefileException;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.ShapeHandler;
import java.io.IOException;

public class PointHandler
implements ShapeHandler {
    int Ncoords = 2;
    int myShapeType = -1;

    public PointHandler(int n) throws InvalidShapefileException {
        if (n != 1 && n != 11 && n != 21) {
            throw new InvalidShapefileException("PointHandler constructor: expected a type of 1, 11 or 21");
        }
        this.myShapeType = n;
    }

    public PointHandler() {
        this.myShapeType = 1;
    }

    public Geometry read(EndianDataInputStream endianDataInputStream, GeometryFactory geometryFactory, int n) throws IOException, InvalidShapefileException {
        int n2 = 0;
        int n3 = endianDataInputStream.readIntLE();
        n2 += 2;
        if (n3 != this.myShapeType) {
            throw new InvalidShapefileException("pointhandler.read() - handler's shapetype doesnt match file's");
        }
        double d = endianDataInputStream.readDoubleLE();
        double d2 = endianDataInputStream.readDoubleLE();
        double d3 = Double.NaN;
        n2 += 8;
        if (n3 == 11) {
            d3 = endianDataInputStream.readDoubleLE();
            n2 += 4;
        }
        if (n3 >= 11) {
            double d4 = endianDataInputStream.readDoubleLE();
            n2 += 4;
        }
        while (n2 < n) {
            short s = endianDataInputStream.readShortBE();
            ++n2;
        }
        return geometryFactory.createPoint(new Coordinate(d, d2, d3));
    }

    public int getShapeType() {
        return this.myShapeType;
    }

    public int getLength(Geometry geometry) {
        if (this.myShapeType == 1) {
            return 10;
        }
        if (this.myShapeType == 21) {
            return 14;
        }
        return 18;
    }
}

