/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.io.shapefile;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.EndianDataInputStream;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.InvalidShapefileException;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.ShapeHandler;
import java.io.IOException;

public class MultiPointHandler
implements ShapeHandler {
    int myShapeType = -1;

    public MultiPointHandler() {
        this.myShapeType = 8;
    }

    public MultiPointHandler(int n) throws InvalidShapefileException {
        if (n != 8 && n != 18 && n != 28) {
            throw new InvalidShapefileException("Multipointhandler constructor - expected type to be 8, 18, or 28");
        }
        this.myShapeType = n;
    }

    public Geometry read(EndianDataInputStream endianDataInputStream, GeometryFactory geometryFactory, int n) throws IOException, InvalidShapefileException {
        double d;
        int n2;
        int n3 = 0;
        int n4 = endianDataInputStream.readIntLE();
        n3 += 2;
        if (n4 == 0) {
            return new MultiPoint(null, new PrecisionModel(), 0);
        }
        if (n4 != this.myShapeType) {
            throw new InvalidShapefileException("Multipointhandler.read() - expected type code " + this.myShapeType + " but got " + n4);
        }
        endianDataInputStream.readDoubleLE();
        endianDataInputStream.readDoubleLE();
        endianDataInputStream.readDoubleLE();
        endianDataInputStream.readDoubleLE();
        n3 += 16;
        int n5 = endianDataInputStream.readIntLE();
        n3 += 2;
        Coordinate[] coordinateArray = new Coordinate[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            d = endianDataInputStream.readDoubleLE();
            double d2 = endianDataInputStream.readDoubleLE();
            n3 += 8;
            coordinateArray[n2] = new Coordinate(d, d2);
        }
        if (this.myShapeType == 18) {
            endianDataInputStream.readDoubleLE();
            endianDataInputStream.readDoubleLE();
            n3 += 8;
            for (n2 = 0; n2 < n5; ++n2) {
                d = endianDataInputStream.readDoubleLE();
                n3 += 4;
                coordinateArray[n2].z = d;
            }
        }
        if (this.myShapeType >= 18 && n >= (n2 = this.myShapeType == 18 ? 20 + n5 * 8 + 8 + 4 * n5 + 8 + 4 * n5 : 20 + n5 * 8 + 8 + 4 * n5)) {
            endianDataInputStream.readDoubleLE();
            endianDataInputStream.readDoubleLE();
            n3 += 8;
            for (int i = 0; i < n5; ++i) {
                endianDataInputStream.readDoubleLE();
                n3 += 4;
            }
        }
        while (n3 < n) {
            n2 = endianDataInputStream.readShortBE();
            ++n3;
        }
        return geometryFactory.createMultiPoint(coordinateArray);
    }

    double[] zMinMax(Geometry geometry) {
        boolean bl = false;
        Coordinate[] coordinateArray = geometry.getCoordinates();
        double[] dArray = new double[2];
        double d = Double.NaN;
        double d2 = Double.NaN;
        for (int i = 0; i < coordinateArray.length; ++i) {
            double d3 = coordinateArray[i].z;
            if (Double.isNaN(d3)) continue;
            if (bl) {
                if (d3 < d) {
                    d = d3;
                }
                if (!(d3 > d2)) continue;
                d2 = d3;
                continue;
            }
            bl = true;
            d = d3;
            d2 = d3;
        }
        dArray[0] = d;
        dArray[1] = d2;
        return dArray;
    }

    public int getShapeType() {
        return this.myShapeType;
    }

    public int getLength(Geometry geometry) {
        MultiPoint multiPoint = (MultiPoint)geometry;
        if (this.myShapeType == 8) {
            return multiPoint.getNumGeometries() * 8 + 20;
        }
        if (this.myShapeType == 28) {
            return multiPoint.getNumGeometries() * 8 + 20 + 8 + 4 * multiPoint.getNumGeometries();
        }
        return multiPoint.getNumGeometries() * 8 + 20 + 8 + 4 * multiPoint.getNumGeometries() + 8 + 4 * multiPoint.getNumGeometries();
    }
}

