/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jtstest.test.Testable;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.model.TestCaseEdit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TestListPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    private DefaultListModel listModel = new DefaultListModel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList list = new JList(this.listModel);
    BorderLayout borderLayout2 = new BorderLayout();

    public TestListPanel(JTSTestBuilderFrame jTSTestBuilderFrame) {
        this();
    }

    public TestListPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.list.setCellRenderer(new TestListCellRenderer());
        this.registerListSelectionListener();
    }

    private void jbInit() throws Exception {
        this.setSize(200, 250);
        this.setLayout(this.borderLayout2);
        this.list.setSelectionMode(0);
        this.list.setSelectionBackground(Color.GRAY);
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.list, null);
    }

    private void registerListSelectionListener() {
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (TestListPanel.this.list.getSelectedValue() == null) {
                    return;
                }
                JTSTestBuilderFrame.instance().setCurrentTestCase((TestCaseEdit)TestListPanel.this.list.getSelectedValue());
            }
        });
    }

    public void populateList() {
        this.listModel.clear();
        for (Testable testable : JTSTestBuilderFrame.instance().getModel().getTestCases()) {
            this.listModel.addElement(testable);
        }
    }

    private class TestListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private final ImageIcon tickIcon = new ImageIcon(this.getClass().getResource("tickShaded.gif"));
        private final ImageIcon crossIcon = new ImageIcon(this.getClass().getResource("crossShaded.gif"));
        private final ImageIcon clearIcon = new ImageIcon(this.getClass().getResource("clear.gif"));

        private TestListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Testable testable = (Testable)object;
            this.setText(this.testName(testable));
            this.setOpaque(true);
            this.setIcon(testable.isPassed() ? this.tickIcon : (testable.isFailed() ? this.crossIcon : this.clearIcon));
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            return this;
        }

        private String testName(Testable testable) {
            String string = testable.getName();
            if ((string == null || string.length() == 0) && testable instanceof TestCaseEdit) {
                string = ((TestCaseEdit)testable).getDescription();
            }
            if (string == null || string.length() == 0) {
                string = "";
            }
            int n = 1 + JTSTestBuilderFrame.instance().getModel().getTestCases().indexOf(testable);
            String string2 = "Test " + n + " - " + this.testCaseSignatureHTML(testable);
            if (string != "") {
                string2 = string2 + " > " + string;
            }
            return "<html>" + string2 + "<html>";
        }

        private String testCaseSignatureHTML(Testable testable) {
            return "<font color='blue'>" + this.geometrySignature(testable.getGeometry(0)) + "</font>" + " :: " + "<font color='red'>" + this.geometrySignature(testable.getGeometry(1)) + "</font>";
        }

        private String geometrySignature(Geometry geometry) {
            if (geometry == null) {
                return "";
            }
            String string = geometry.getGeometryType();
            string = geometry instanceof GeometryCollection ? string + "[" + geometry.getNumGeometries() + "]" : string + "(" + geometry.getNumPoints() + ")";
            return string;
        }
    }
}

