/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jtstest.test.Testable;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.model.TestCaseEdit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TestListDialog
extends JDialog {
    private JTSTestBuilderFrame testBuilderFrame;
    private DefaultListModel listModel = new DefaultListModel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList list = new JList(this.listModel);
    JButton closeButton = new JButton();
    JButton runAllTestsButton = new JButton();

    public TestListDialog() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TestListDialog(JTSTestBuilderFrame jTSTestBuilderFrame) {
        super(jTSTestBuilderFrame, "Tests", false);
        this.testBuilderFrame = jTSTestBuilderFrame;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.list.setCellRenderer(new TestListCellRenderer());
        this.registerListSelectionListener();
        this.populateList();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.populateList();
        }
        super.setVisible(bl);
    }

    private void registerListSelectionListener() {
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TestListDialog.this.testBuilderFrame.setCurrentTestCase((TestCaseEdit)TestListDialog.this.list.getSelectedValue());
            }
        });
    }

    public void populateList() {
        this.listModel.clear();
        for (Testable testable : this.testBuilderFrame.getModel().getTestCases()) {
            this.listModel.addElement(testable);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(200, 250);
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.flowLayout1);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestListDialog.this.closeButton_actionPerformed(actionEvent);
            }
        });
        this.runAllTestsButton.setText("Run All Tests");
        this.runAllTestsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestListDialog.this.runAllTestsButton_actionPerformed(actionEvent);
            }
        });
        this.list.setBackground(Color.lightGray);
        this.list.setBorder(BorderFactory.createLoweredBevelBorder());
        this.list.setSelectionMode(0);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.runAllTestsButton, null);
        this.jPanel1.add((Component)this.closeButton, null);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.list, null);
    }

    void closeButton_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    void runAllTestsButton_actionPerformed(ActionEvent actionEvent) {
        try {
            for (Testable testable : this.testBuilderFrame.getModel().getTestCases()) {
                if (testable.getWellKnownText(0) == null || testable.getWellKnownText(1) == null) continue;
                testable.runTest();
            }
            this.testBuilderFrame.testCasePanel.relatePanel.runTests();
            this.list.repaint();
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    private class TestListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private final ImageIcon tickIcon = new ImageIcon(this.getClass().getResource("tickShaded.gif"));
        private final ImageIcon crossIcon = new ImageIcon(this.getClass().getResource("crossShaded.gif"));
        private final ImageIcon clearIcon = new ImageIcon(this.getClass().getResource("clear.gif"));

        private TestListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Testable testable = (Testable)object;
            String string = testable.getName();
            if ((string == null || string.length() == 0) && testable instanceof TestCaseEdit) {
                string = ((TestCaseEdit)testable).getDescription();
            }
            if (string == null || string.length() == 0) {
                string = "Test";
            }
            this.setText(string);
            this.setIcon(testable.isPassed() ? this.tickIcon : (testable.isFailed() ? this.crossIcon : this.clearIcon));
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            return this;
        }
    }
}

