/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jtstest.testbuilder.CoordinateNode;
import com.vividsolutions.jtstest.testbuilder.GeometryCollectionNode;
import com.vividsolutions.jtstest.testbuilder.LineStringNode;
import com.vividsolutions.jtstest.testbuilder.LinearRingNode;
import com.vividsolutions.jtstest.testbuilder.PointNode;
import com.vividsolutions.jtstest.testbuilder.PolygonNode;
import java.util.ArrayList;
import java.util.List;

abstract class GeometryNode {
    protected boolean isLeaf = false;
    protected int index = -1;
    protected String text = "";
    protected List children = null;

    public static GeometryNode create(Coordinate coordinate) {
        return new CoordinateNode(coordinate);
    }

    public static GeometryNode create(Geometry geometry) {
        if (geometry instanceof GeometryCollection) {
            return new GeometryCollectionNode((GeometryCollection)geometry);
        }
        if (geometry instanceof Polygon) {
            return new PolygonNode((Polygon)geometry);
        }
        if (geometry instanceof LineString) {
            return new LineStringNode((LineString)geometry);
        }
        if (geometry instanceof LinearRing) {
            return new LinearRingNode((LinearRing)geometry);
        }
        if (geometry instanceof Point) {
            return new PointNode((Point)geometry);
        }
        return null;
    }

    protected static String indexString(int n) {
        return "[" + n + "]";
    }

    protected static String sizeString(int n) {
        return "(" + n + ")";
    }

    public GeometryNode(String string) {
        this.text = string;
    }

    public GeometryNode(Geometry geometry) {
        this(geometry, 0, null);
    }

    public GeometryNode(Geometry geometry, int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.length() > 0) {
            stringBuilder.append(string + " : ");
        }
        stringBuilder.append(geometry.getGeometryType());
        if (geometry.isEmpty()) {
            this.isLeaf = true;
            stringBuilder.append(" EMPTY");
        } else if (n > 0) {
            stringBuilder.append(GeometryNode.sizeString(n));
        }
        this.text = stringBuilder.toString();
    }

    public GeometryNode(Geometry geometry, int n, int n2) {
        this(geometry, n, GeometryNode.indexString(n2));
    }

    public abstract Geometry getGeometry();

    public void setIndex(int n) {
        this.index = n;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public GeometryNode getChildAt(int n) {
        if (this.isLeaf) {
            return null;
        }
        this.populateChildren();
        return (GeometryNode)this.children.get(n);
    }

    public int getChildCount() {
        if (this.isLeaf) {
            return 0;
        }
        this.populateChildren();
        return this.children.size();
    }

    public int getIndexOfChild(GeometryNode geometryNode) {
        if (this.isLeaf) {
            return -1;
        }
        this.populateChildren();
        return this.children.indexOf(geometryNode);
    }

    public String getText() {
        if (this.index >= 0) {
            return GeometryNode.indexString(this.index) + " : " + this.text;
        }
        return this.text;
    }

    protected void populateChildren() {
        if (this.children != null) {
            return;
        }
        this.createChildren();
    }

    private void createChildren() {
        this.children = new ArrayList();
    }

    protected void populateChildren(Coordinate[] coordinateArray) {
        this.createChildren();
        for (int i = 0; i < coordinateArray.length; ++i) {
            GeometryNode geometryNode = GeometryNode.create(coordinateArray[i]);
            geometryNode.setIndex(i);
            this.children.add(geometryNode);
        }
    }
}

