/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.geomop;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.operation.overlay.validate.OverlayResultValidator;
import com.vividsolutions.jtstest.geomop.GeometryMethodOperation;
import com.vividsolutions.jtstest.geomop.GeometryOperation;
import com.vividsolutions.jtstest.testrunner.GeometryResult;
import com.vividsolutions.jtstest.testrunner.Result;

public class OverlayValidatedGeometryOperation
implements GeometryOperation {
    private boolean returnEmptyGC = true;
    private GeometryMethodOperation chainOp = new GeometryMethodOperation();
    private static final double AREA_DIFF_TOL = 5.0;

    public static int overlayOpCode(String string) {
        if (string.equals("intersection")) {
            return 1;
        }
        if (string.equals("union")) {
            return 2;
        }
        if (string.equals("difference")) {
            return 3;
        }
        if (string.equals("symDifference")) {
            return 4;
        }
        return -1;
    }

    public OverlayValidatedGeometryOperation() {
    }

    public Class getReturnType(String string) {
        return this.chainOp.getReturnType(string);
    }

    public OverlayValidatedGeometryOperation(GeometryMethodOperation geometryMethodOperation) {
        this.chainOp = geometryMethodOperation;
    }

    public Result invoke(String string, Geometry geometry, Object[] objectArray) throws Exception {
        int n = OverlayValidatedGeometryOperation.overlayOpCode(string);
        if (n < 0) {
            return this.chainOp.invoke(string, geometry, objectArray);
        }
        return this.invokeValidatedOverlayOp(n, geometry, objectArray);
    }

    public Result invokeValidatedOverlayOp(int n, Geometry geometry, Object[] objectArray) throws Exception {
        Geometry geometry2 = null;
        Geometry geometry3 = (Geometry)objectArray[0];
        geometry2 = OverlayValidatedGeometryOperation.invokeGeometryOverlayMethod(n, geometry, geometry3);
        this.validate(n, geometry, geometry3, geometry2);
        this.areaValidate(geometry, geometry3);
        if (this.returnEmptyGC) {
            geometry2 = geometry2.getFactory().createGeometryCollection(null);
        }
        return new GeometryResult(geometry2);
    }

    private void validate(int n, Geometry geometry, Geometry geometry2, Geometry geometry3) {
        OverlayResultValidator overlayResultValidator = new OverlayResultValidator(geometry, geometry2, geometry3);
        if (!overlayResultValidator.isValid(n)) {
            Coordinate coordinate = overlayResultValidator.getInvalidLocation();
            String string = "Operation result is invalid [OverlayResultValidator] ( " + WKTWriter.toPoint((Coordinate)coordinate) + " )";
            this.reportError(string);
        }
    }

    private void areaValidate(Geometry geometry, Geometry geometry2) {
        double d = OverlayValidatedGeometryOperation.areaDiff(geometry, geometry2);
        if (Math.abs(d) > 5.0) {
            String string = "Operation result is invalid [AreaTest] (" + d + ")";
            this.reportError(string);
        }
    }

    public static double areaDiff(Geometry geometry, Geometry geometry2) {
        double d = geometry.getArea();
        double d2 = geometry.difference(geometry2).getArea();
        double d3 = geometry.intersection(geometry2).getArea();
        return d - d2 - d3;
    }

    private void reportError(String string) {
        throw new RuntimeException(string);
    }

    public static Geometry invokeGeometryOverlayMethod(int n, Geometry geometry, Geometry geometry2) {
        switch (n) {
            case 1: {
                return geometry.intersection(geometry2);
            }
            case 2: {
                return geometry.union(geometry2);
            }
            case 3: {
                return geometry.difference(geometry2);
            }
            case 4: {
                return geometry.symDifference(geometry2);
            }
        }
        throw new IllegalArgumentException("Unknown overlay op code");
    }
}

