/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.JTSVersion;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import com.vividsolutions.jtstest.function.FunctionsUtil;

public class JTSFunctions {
    private static final double HEIGHT = 70.0;
    private static final double WIDTH = 150.0;
    private static final double J_WIDTH = 30.0;
    private static final double J_RADIUS = 25.0;
    private static final double S_RADIUS = 17.5;
    private static final double T_WIDTH = 85.0;

    public static String version(Geometry geometry) {
        return JTSVersion.CURRENT_VERSION.toString();
    }

    public static Geometry logoLines(Geometry geometry) {
        return JTSFunctions.create_J(geometry).union(JTSFunctions.create_T(geometry)).union(JTSFunctions.create_S(geometry));
    }

    public static Geometry logoBuffer(Geometry geometry, double d) {
        Geometry geometry2 = JTSFunctions.logoLines(geometry);
        BufferParameters bufferParameters = new BufferParameters();
        bufferParameters.setEndCapStyle(3);
        return BufferOp.bufferOp((Geometry)geometry2, (double)d, (BufferParameters)bufferParameters);
    }

    private static Geometry create_J(Geometry geometry) {
        GeometryFactory geometryFactory = FunctionsUtil.getFactoryOrDefault(geometry);
        Coordinate[] coordinateArray = new Coordinate[]{new Coordinate(0.0, 70.0), new Coordinate(30.0, 70.0), new Coordinate(30.0, 25.0)};
        Coordinate[] coordinateArray2 = new Coordinate[]{new Coordinate(5.0, 0.0), new Coordinate(0.0, 0.0)};
        GeometricShapeFactory geometricShapeFactory = new GeometricShapeFactory(geometryFactory);
        geometricShapeFactory.setBase(new Coordinate(-20.0, 0.0));
        geometricShapeFactory.setSize(50.0);
        geometricShapeFactory.setNumPoints(10);
        LineString lineString = geometricShapeFactory.createArc(4.71238898038469, 1.5707963267948966);
        CoordinateList coordinateList = new CoordinateList();
        coordinateList.add(coordinateArray, false);
        coordinateList.add(lineString.reverse().getCoordinates(), false, 1, lineString.getNumPoints() - 1);
        coordinateList.add(coordinateArray2, false);
        return geometryFactory.createLineString(coordinateList.toCoordinateArray());
    }

    private static Geometry create_T(Geometry geometry) {
        GeometryFactory geometryFactory = FunctionsUtil.getFactoryOrDefault(geometry);
        Coordinate[] coordinateArray = new Coordinate[]{new Coordinate(30.0, 70.0), new Coordinate(127.5, 70.0)};
        Coordinate[] coordinateArray2 = new Coordinate[]{new Coordinate(72.5, 70.0), new Coordinate(72.5, 0.0)};
        LineString[] lineStringArray = new LineString[]{geometryFactory.createLineString(coordinateArray), geometryFactory.createLineString(coordinateArray2)};
        return geometryFactory.createMultiLineString(lineStringArray);
    }

    private static Geometry create_S(Geometry geometry) {
        GeometryFactory geometryFactory = FunctionsUtil.getFactoryOrDefault(geometry);
        double d = 132.5;
        Coordinate[] coordinateArray = new Coordinate[]{new Coordinate(150.0, 70.0), new Coordinate(d, 70.0)};
        Coordinate[] coordinateArray2 = new Coordinate[]{new Coordinate(d, 0.0), new Coordinate(115.0, 0.0)};
        GeometricShapeFactory geometricShapeFactory = new GeometricShapeFactory(geometryFactory);
        geometricShapeFactory.setCentre(new Coordinate(d, 52.5));
        geometricShapeFactory.setSize(35.0);
        geometricShapeFactory.setNumPoints(10);
        LineString lineString = geometricShapeFactory.createArc(1.5707963267948966, Math.PI);
        GeometricShapeFactory geometricShapeFactory2 = new GeometricShapeFactory(geometryFactory);
        geometricShapeFactory2.setCentre(new Coordinate(d, 17.5));
        geometricShapeFactory2.setSize(35.0);
        geometricShapeFactory2.setNumPoints(10);
        LineString lineString2 = (LineString)geometricShapeFactory2.createArc(4.71238898038469, Math.PI).reverse();
        CoordinateList coordinateList = new CoordinateList();
        coordinateList.add(coordinateArray, false);
        coordinateList.add(lineString.getCoordinates(), false, 1, lineString.getNumPoints() - 1);
        coordinateList.add((Object)new Coordinate(d, 35.0));
        coordinateList.add(lineString2.getCoordinates(), false, 1, lineString2.getNumPoints() - 1);
        coordinateList.add(coordinateArray2, false);
        return geometryFactory.createLineString(coordinateList.toCoordinateArray());
    }
}

