/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io.oracle;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.jdbc.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OraWriter {
    private OracleConnection connection;
    private int dimension = 2;
    private int srid = -1;
    private String DATATYPE = "MDSYS.SDO_GEOMETRY";

    public OraWriter(OracleConnection oracleConnection) {
        this.connection = oracleConnection;
    }

    public OraWriter(OracleConnection oracleConnection, int n) {
        this.connection = oracleConnection;
        this.dimension = n;
    }

    public void setSRID(int n) {
        this.srid = n;
    }

    public STRUCT write(Geometry geometry) throws SQLException {
        ARRAY aRRAY;
        ARRAY aRRAY2;
        STRUCT sTRUCT;
        Object[] objectArray;
        if (geometry == null) {
            return this.toSTRUCT(new Datum[5], this.DATATYPE);
        }
        if (geometry.isEmpty() || geometry.getCoordinate() == null) {
            return this.toSTRUCT(new Datum[5], this.DATATYPE);
        }
        int n = this.gType(geometry);
        NUMBER nUMBER = new NUMBER(n);
        int n2 = this.srid == -1 ? geometry.getSRID() : this.srid;
        NUMBER nUMBER2 = n2 == -1 ? null : new NUMBER(n2);
        double[] dArray = this.point(geometry);
        if (dArray == null) {
            objectArray = this.elemInfo(geometry, n);
            ArrayList arrayList = new ArrayList();
            this.coordinates(arrayList, geometry);
            int n3 = n / 1000;
            int n4 = (n - n3 * 1000) / 100;
            int n5 = n3 + n4;
            double[] dArray2 = new double[arrayList.size() * n5];
            int n6 = 0;
            for (int i = 0; i < arrayList.size() && n6 < dArray2.length; ++i) {
                int n7;
                double[] dArray3 = (double[])arrayList.get(i);
                for (n7 = 0; n7 < n5 && n7 < dArray3.length; ++n7) {
                    dArray2[n6++] = dArray3[n7];
                }
                while (n7 < n5) {
                    dArray2[n6++] = Double.NaN;
                    ++n7;
                }
            }
            arrayList = null;
            sTRUCT = null;
            aRRAY2 = this.toARRAY((int[])objectArray, "MDSYS.SDO_ELEM_INFO_ARRAY");
            aRRAY = this.toARRAY(dArray2, "MDSYS.SDO_ORDINATE_ARRAY");
        } else {
            objectArray = new Datum[]{this.toNUMBER(dArray[0]), this.toNUMBER(dArray[1]), this.toNUMBER(dArray[2])};
            sTRUCT = this.toSTRUCT((Datum[])objectArray, "MDSYS.SDO_POINT_TYPE");
            aRRAY2 = null;
            aRRAY = null;
        }
        objectArray = new Datum[]{nUMBER, nUMBER2, sTRUCT, aRRAY2, aRRAY};
        return this.toSTRUCT((Datum[])objectArray, this.DATATYPE);
    }

    private void coordinates(List list, Geometry geometry) {
        switch (this.template(geometry)) {
            case 1: {
                OraWriter.addCoordinates(list, ((Point)geometry).getCoordinateSequence());
                return;
            }
            case 2: {
                OraWriter.addCoordinates(list, ((LineString)geometry).getCoordinateSequence());
                return;
            }
            case 3: {
                switch (this.elemInfoInterpretation(geometry, 1003)) {
                    case 3: {
                        Envelope envelope = geometry.getEnvelopeInternal();
                        list.add(new double[]{envelope.getMinX(), envelope.getMinY()});
                        list.add(new double[]{envelope.getMaxX(), envelope.getMaxY()});
                        return;
                    }
                    case 1: {
                        Polygon polygon = (Polygon)geometry;
                        int n = polygon.getNumInteriorRing();
                        CoordinateSequence coordinateSequence = polygon.getExteriorRing().getCoordinateSequence();
                        if (!CGAlgorithms.isCCW((Coordinate[])coordinateSequence.toCoordinateArray())) {
                            coordinateSequence = this.reverse(polygon.getFactory().getCoordinateSequenceFactory(), coordinateSequence);
                        }
                        OraWriter.addCoordinates(list, coordinateSequence);
                        for (int i = 0; i < n; ++i) {
                            coordinateSequence = polygon.getInteriorRingN(i).getCoordinateSequence();
                            if (CGAlgorithms.isCCW((Coordinate[])coordinateSequence.toCoordinateArray())) {
                                coordinateSequence = this.reverse(polygon.getFactory().getCoordinateSequenceFactory(), coordinateSequence);
                            }
                            OraWriter.addCoordinates(list, coordinateSequence);
                        }
                        return;
                    }
                }
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                    this.coordinates(list, geometry.getGeometryN(i));
                }
                return;
            }
        }
        throw new IllegalArgumentException("Cannot encode JTS " + geometry.getGeometryType() + " as " + "SDO_ORDINATRES (Limitied to Point, Line, Polygon, " + "GeometryCollection, MultiPoint, MultiLineString and MultiPolygon)");
    }

    private static void addCoordinates(List list, CoordinateSequence coordinateSequence) {
        Coordinate coordinate = null;
        for (int i = 0; i < coordinateSequence.size(); ++i) {
            coordinate = coordinateSequence.getCoordinate(i);
            if (coordinate.z == Double.NaN) {
                list.add(new double[]{coordinate.x, coordinate.y});
                continue;
            }
            list.add(new double[]{coordinate.x, coordinate.y, coordinate.z});
        }
    }

    private int[] elemInfo(Geometry geometry, int n) {
        LinkedList linkedList = new LinkedList();
        this.elemInfo(linkedList, geometry, 1, n);
        int[] nArray = new int[linkedList.size()];
        int n2 = 0;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            nArray[n2] = ((Number)iterator.next()).intValue();
            ++n2;
        }
        return nArray;
    }

    private void elemInfo(List list, Geometry geometry, int n, int n2) {
        switch (n2 - n2 / 100 * 100) {
            case 1: {
                this.addInt(list, n);
                this.addInt(list, 1);
                this.addInt(list, 1);
                return;
            }
            case 5: {
                MultiPoint multiPoint = (MultiPoint)geometry;
                this.addInt(list, n);
                this.addInt(list, 1);
                this.addInt(list, this.elemInfoInterpretation((Geometry)multiPoint, 1));
                return;
            }
            case 2: {
                this.addInt(list, n);
                this.addInt(list, 2);
                this.addInt(list, 1);
                return;
            }
            case 6: {
                MultiLineString multiLineString = (MultiLineString)geometry;
                int n3 = n;
                int n4 = n2 / 1000;
                int n5 = n4 + (n2 - n4 * 1000) / 100;
                for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
                    LineString lineString = (LineString)multiLineString.getGeometryN(i);
                    this.addInt(list, n3);
                    this.addInt(list, 2);
                    this.addInt(list, 1);
                    n3 += lineString.getNumPoints() * n5;
                }
                return;
            }
            case 3: {
                Polygon polygon = (Polygon)geometry;
                int n6 = polygon.getNumInteriorRing();
                if (n6 == 0) {
                    this.addInt(list, n);
                    this.addInt(list, this.elemInfoEType((Geometry)polygon));
                    this.addInt(list, this.elemInfoInterpretation((Geometry)polygon, 1003));
                    return;
                }
                int n7 = n2 / 1000;
                int n8 = n7 + (n2 - n7 * 1000) / 100;
                int n9 = n;
                LineString lineString = polygon.getExteriorRing();
                this.addInt(list, n9);
                this.addInt(list, this.elemInfoEType((Geometry)polygon));
                this.addInt(list, this.elemInfoInterpretation((Geometry)polygon, 1003));
                n9 += lineString.getNumPoints() * n8;
                for (int i = 1; i <= n6; ++i) {
                    lineString = polygon.getInteriorRingN(i - 1);
                    this.addInt(list, n9);
                    this.addInt(list, 2003);
                    this.addInt(list, this.elemInfoInterpretation((Geometry)lineString, 2003));
                    n9 += lineString.getNumPoints() * n8;
                }
                return;
            }
            case 7: {
                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                int n10 = n;
                int n11 = n2 / 1000;
                int n12 = n11 + (n2 - n11 * 1000) / 100;
                for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                    Polygon polygon = (Polygon)multiPolygon.getGeometryN(i);
                    this.elemInfo(list, (Geometry)polygon, n10, this.gType((Geometry)polygon));
                    if (this.isRectangle(polygon)) {
                        n10 += 2 * n12;
                        continue;
                    }
                    n10 += polygon.getNumPoints() * n12;
                }
                return;
            }
            case 4: {
                GeometryCollection geometryCollection = (GeometryCollection)geometry;
                int n13 = n;
                int n14 = n2 / 1000;
                int n15 = n14 + (n2 - n14 * 1000) / 100;
                for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                    geometry = geometryCollection.getGeometryN(i);
                    this.elemInfo(list, geometry, n13, this.gType(geometry));
                    if (geometry instanceof Polygon && this.isRectangle((Polygon)geometry)) {
                        n13 += 2 * n15;
                        continue;
                    }
                    n13 += geometry.getNumPoints() * n15;
                }
                return;
            }
        }
        throw new IllegalArgumentException("Cannot encode JTS " + geometry.getGeometryType() + " as SDO_ELEM_INFO " + "(Limitied to Point, Line, Polygon, GeometryCollection, MultiPoint," + " MultiLineString and MultiPolygon)");
    }

    private void addInt(List list, int n) {
        list.add(new Integer(n));
    }

    private boolean isRectangle(Polygon polygon) {
        if (polygon.getFactory().getSRID() != -1) {
            return false;
        }
        if (this.lrs((Geometry)polygon) != 0) {
            return false;
        }
        Coordinate[] coordinateArray = polygon.getCoordinates();
        if (coordinateArray.length != 5) {
            return false;
        }
        if (coordinateArray[0] == null || coordinateArray[1] == null || coordinateArray[2] == null || coordinateArray[3] == null) {
            return false;
        }
        if (!coordinateArray[0].equals2D(coordinateArray[4])) {
            return false;
        }
        double d = coordinateArray[0].x;
        double d2 = coordinateArray[0].y;
        double d3 = coordinateArray[1].x;
        double d4 = coordinateArray[1].y;
        double d5 = coordinateArray[2].x;
        double d6 = coordinateArray[2].y;
        double d7 = coordinateArray[3].x;
        double d8 = coordinateArray[3].y;
        if (d == d7 && d2 == d4 && d5 == d3 && d6 == d8) {
            return true;
        }
        return d == d3 && d2 == d8 && d5 == d7 && d6 == d4;
    }

    private int elemInfoEType(Geometry geometry) {
        switch (this.template(geometry)) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1003;
            }
        }
        throw new IllegalArgumentException("Unknown encoding of SDO_GTEMPLATE");
    }

    private int elemInfoInterpretation(Geometry geometry, int n) {
        switch (n) {
            case 1: {
                if (geometry instanceof Point) {
                    return 1;
                }
                if (!(geometry instanceof MultiPoint)) break;
                return ((MultiPoint)geometry).getNumGeometries();
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 1003: 
            case 2003: {
                Polygon polygon;
                if (geometry instanceof Polygon && this.isRectangle(polygon = (Polygon)geometry)) {
                    return 3;
                }
                return 1;
            }
        }
        throw new IllegalArgumentException("Cannot encode JTS " + geometry.getGeometryType() + " as " + "SDO_INTERPRETATION (Limitied to Point, Line, Polygon, " + "GeometryCollection, MultiPoint, MultiLineString and MultiPolygon)");
    }

    private double[] point(Geometry geometry) {
        if (geometry instanceof Point && this.lrs(geometry) == 0) {
            Point point = (Point)geometry;
            Coordinate coordinate = point.getCoordinate();
            return new double[]{coordinate.x, coordinate.y, coordinate.z};
        }
        return null;
    }

    private int gType(Geometry geometry) {
        int n = this.dimension(geometry) * 1000;
        int n2 = this.lrs(geometry) * 100;
        int n3 = this.template(geometry);
        return n + n2 + n3;
    }

    private int dimension(Geometry geometry) {
        int n = Double.isNaN(geometry.getCoordinate().z) ? 2 : 3;
        return n < this.dimension ? n : this.dimension;
    }

    private int lrs(Geometry geometry) {
        return 0;
    }

    private int template(Geometry geometry) {
        if (geometry == null) {
            return -1;
        }
        if (geometry instanceof Point) {
            return 1;
        }
        if (geometry instanceof LineString) {
            return 2;
        }
        if (geometry instanceof Polygon) {
            return 3;
        }
        if (geometry instanceof MultiPoint) {
            return 5;
        }
        if (geometry instanceof MultiLineString) {
            return 6;
        }
        if (geometry instanceof MultiPolygon) {
            return 7;
        }
        if (geometry instanceof GeometryCollection) {
            return 4;
        }
        throw new IllegalArgumentException("Cannot encode JTS " + geometry.getGeometryType() + " as SDO_GTEMPLATE " + "(Limitied to Point, Line, Polygon, GeometryCollection, MultiPoint," + " MultiLineString and MultiPolygon)");
    }

    private STRUCT toSTRUCT(Datum[] datumArray, String string) throws SQLException {
        if (string.startsWith("*.")) {
            string = "DRA." + string.substring(2);
        }
        StructDescriptor structDescriptor = StructDescriptor.createDescriptor((String)string, (Connection)this.connection);
        return new STRUCT(structDescriptor, (Connection)this.connection, (Object[])datumArray);
    }

    private ARRAY toARRAY(double[] dArray, String string) throws SQLException {
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)string, (Connection)this.connection);
        return new ARRAY(arrayDescriptor, (Connection)this.connection, (Object)dArray);
    }

    private ARRAY toARRAY(int[] nArray, String string) throws SQLException {
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)string, (Connection)this.connection);
        return new ARRAY(arrayDescriptor, (Connection)this.connection, (Object)nArray);
    }

    private NUMBER toNUMBER(double d) throws SQLException {
        if (Double.isNaN(d)) {
            return null;
        }
        return new NUMBER(d);
    }

    private CoordinateSequence reverse(CoordinateSequenceFactory coordinateSequenceFactory, CoordinateSequence coordinateSequence) {
        CoordinateList coordinateList = new CoordinateList(coordinateSequence.toCoordinateArray());
        Collections.reverse(coordinateList);
        return coordinateSequenceFactory.create(coordinateList.toCoordinateArray());
    }

    public void setDimension(int n) {
        this.dimension = n;
    }
}

