/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.tools;

import com.vividsolutions.jtstest.testbuilder.GeometryEditPanel;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.ui.tools.BasicTool;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class ZoomToClickTool
extends BasicTool {
    private double zoomFactor = 2.0;
    private Cursor cursor = Cursor.getDefaultCursor();
    private Point pressedZoomBoxStart = null;
    private Point pressedZoomBoxEnd = null;
    private Point zoomBoxStart = null;
    private Point zoomBoxEnd = null;
    private static final int MIN_MOVEMENT = 3;

    public ZoomToClickTool() {
    }

    public ZoomToClickTool(double d, Cursor cursor) {
        this();
        this.zoomFactor = d;
        this.cursor = cursor;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        double d = SwingUtilities.isRightMouseButton(mouseEvent) ? 1.0 / this.zoomFactor : this.zoomFactor;
        Point point = mouseEvent.getPoint();
        this.panel().zoom(point, d);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.zoomBoxStart = mouseEvent.getPoint();
        this.zoomBoxEnd = mouseEvent.getPoint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isSignificantMouseMove()) {
            return;
        }
        int n = (this.zoomBoxEnd.x + this.zoomBoxStart.x) / 2;
        int n2 = (this.zoomBoxEnd.y + this.zoomBoxStart.y) / 2;
        Point point = new Point(n, n2);
        int n3 = Math.abs(this.zoomBoxEnd.x - this.zoomBoxStart.x);
        int n4 = Math.abs(this.zoomBoxEnd.y - this.zoomBoxStart.y);
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n4 <= 0) {
            n4 = 1;
        }
        GeometryEditPanel geometryEditPanel = this.getPanel();
        double d = geometryEditPanel.getSize().width / n3;
        double d2 = geometryEditPanel.getSize().height / n4;
        double d3 = Math.min(d, d2);
        this.panel().zoom(point, d3);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Graphics graphics = this.getPanel().getGraphics();
        graphics.setColor(Color.RED);
        graphics.setXORMode(Color.white);
        this.drawRect(graphics);
        this.zoomBoxEnd = point;
        this.drawRect(graphics);
    }

    public void activate() {
    }

    private boolean isSignificantMouseMove() {
        if (Math.abs(this.zoomBoxStart.x - this.zoomBoxEnd.x) < 3) {
            return false;
        }
        return Math.abs(this.zoomBoxStart.y - this.zoomBoxEnd.y) >= 3;
    }

    public void drawRect(Graphics graphics) {
        Point point = new Point(Math.min(this.zoomBoxStart.x, this.zoomBoxEnd.x), Math.min(this.zoomBoxStart.y, this.zoomBoxEnd.y));
        int n = Math.abs(this.zoomBoxEnd.x - this.zoomBoxStart.x);
        int n2 = Math.abs(this.zoomBoxEnd.y - this.zoomBoxStart.y);
        graphics.drawRect(point.x, point.y, n, n2);
    }

    public GeometryEditPanel getPanel() {
        return JTSTestBuilderFrame.getInstance().getTestCasePanel().getGeometryEditPanel();
    }
}

