/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.tools;

import com.vividsolutions.jts.awt.GeometryCollectionShape;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jtstest.testbuilder.IconLoader;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryLocation;
import com.vividsolutions.jtstest.testbuilder.ui.tools.BasicTool;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class EditVertexTool
extends BasicTool {
    Point2D currentIndicatorLoc = null;
    private static EditVertexTool instance = null;
    private Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(IconLoader.icon("MoveVertexCursor.gif").getImage(), new Point(16, 16), "MoveVertex");
    private Coordinate selectedVertexLocation = null;
    private Coordinate[] adjVertices = null;
    private static final double IND_CIRCLE_RADIUS = 10.0;

    public static EditVertexTool getInstance() {
        if (instance == null) {
            instance = new EditVertexTool();
        }
        return instance;
    }

    private EditVertexTool() {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.currentIndicatorLoc = null;
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            return;
        }
        Coordinate coordinate = this.toModelCoordinate(mouseEvent.getPoint());
        double d = this.getModelTolerance();
        this.selectedVertexLocation = this.geomModel().locateVertexPt(coordinate, d);
        if (this.selectedVertexLocation != null) {
            this.adjVertices = this.geomModel().findAdjacentVertices(this.selectedVertexLocation);
            this.currentIndicatorLoc = this.toViewPoint(this.selectedVertexLocation);
            this.redrawIndicator();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            return;
        }
        this.clearIndicator();
        if (this.selectedVertexLocation != null) {
            Coordinate coordinate = this.toModelCoordinate(mouseEvent.getPoint());
            this.geomModel().moveVertex(this.selectedVertexLocation, coordinate);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.currentIndicatorLoc = mouseEvent.getPoint();
        if (this.selectedVertexLocation != null) {
            this.redrawIndicator();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl;
        if (!SwingUtilities.isRightMouseButton(mouseEvent)) {
            return;
        }
        Coordinate coordinate = this.toModelCoordinate(mouseEvent.getPoint());
        double d = this.getModelTolerance();
        boolean bl2 = bl = !mouseEvent.isControlDown();
        if (bl) {
            GeometryLocation geometryLocation = this.geomModel().locateNonVertexPoint(coordinate, d);
            if (geometryLocation != null) {
                this.geomModel().setGeometry(geometryLocation.insert());
            }
        } else {
            GeometryLocation geometryLocation = this.geomModel().locateVertex(coordinate, d);
            if (geometryLocation != null) {
                this.geomModel().setGeometry(geometryLocation.delete());
            }
        }
    }

    protected Shape getShape() {
        GeometryCollectionShape geometryCollectionShape = new GeometryCollectionShape();
        geometryCollectionShape.add(this.getIndicatorCircle(this.currentIndicatorLoc));
        if (this.adjVertices != null) {
            for (int i = 0; i < this.adjVertices.length; ++i) {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)this.currentIndicatorLoc.getX(), (float)this.currentIndicatorLoc.getY());
                Point2D point2D = this.toViewPoint(this.adjVertices[i]);
                generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
                geometryCollectionShape.add((Shape)generalPath);
            }
        }
        return geometryCollectionShape;
    }

    protected Shape getIndicatorCircle(Point2D point2D) {
        return new Ellipse2D.Double(point2D.getX() - 5.0, point2D.getY() - 5.0, 10.0, 10.0);
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void activate() {
    }
}

