/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.tools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jtstest.testbuilder.ui.tools.BasicTool;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public abstract class BoxBandTool
extends BasicTool {
    private Cursor cursor = Cursor.getDefaultCursor();
    private Point zoomBoxStart = null;
    private Point zoomBoxEnd = null;
    private static final int MIN_MOVEMENT = 3;

    public BoxBandTool() {
    }

    public BoxBandTool(Cursor cursor) {
        this();
        this.cursor = cursor;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.zoomBoxStart = mouseEvent.getPoint();
        this.zoomBoxEnd = mouseEvent.getPoint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isSignificantMouseMove()) {
            return;
        }
        int n = (this.zoomBoxEnd.x + this.zoomBoxStart.x) / 2;
        int n2 = (this.zoomBoxEnd.y + this.zoomBoxStart.y) / 2;
        Point point = new Point(n, n2);
        int n3 = Math.abs(this.zoomBoxEnd.x - this.zoomBoxStart.x);
        int n4 = Math.abs(this.zoomBoxEnd.y - this.zoomBoxStart.y);
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n4 <= 0) {
            n4 = 1;
        }
        try {
            this.finishGesture();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Graphics graphics = this.panel().getGraphics();
        graphics.setColor(Color.RED);
        graphics.setXORMode(Color.white);
        this.drawRect(graphics);
        this.zoomBoxEnd = point;
        this.drawRect(graphics);
    }

    public void activate() {
    }

    protected Envelope getEnvelope() {
        Coordinate coordinate = this.snapInModel(this.zoomBoxStart);
        Coordinate coordinate2 = this.snapInModel(this.zoomBoxEnd);
        return new Envelope(coordinate, coordinate2);
    }

    protected List getCoordinates() {
        Envelope envelope = this.getEnvelope();
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        arrayList.add(new Coordinate(envelope.getMinX(), envelope.getMinY()));
        arrayList.add(new Coordinate(envelope.getMinX(), envelope.getMaxY()));
        arrayList.add(new Coordinate(envelope.getMaxX(), envelope.getMaxY()));
        arrayList.add(new Coordinate(envelope.getMaxX(), envelope.getMinY()));
        arrayList.add(new Coordinate(envelope.getMinX(), envelope.getMinY()));
        return arrayList;
    }

    private boolean isSignificantMouseMove() {
        if (Math.abs(this.zoomBoxStart.x - this.zoomBoxEnd.x) < 3) {
            return false;
        }
        return Math.abs(this.zoomBoxStart.y - this.zoomBoxEnd.y) >= 3;
    }

    public void drawRect(Graphics graphics) {
        Point point = new Point(Math.min(this.zoomBoxStart.x, this.zoomBoxEnd.x), Math.min(this.zoomBoxStart.y, this.zoomBoxEnd.y));
        int n = Math.abs(this.zoomBoxEnd.x - this.zoomBoxStart.x);
        int n2 = Math.abs(this.zoomBoxEnd.y - this.zoomBoxStart.y);
        graphics.drawRect(point.x, point.y, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishGesture() throws Exception {
        this.clearIndicator();
        this.gestureFinished();
    }

    protected void gestureFinished() throws Exception {
    }
}

