/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.render;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.ui.render.Style;
import java.awt.Graphics2D;

public abstract class LineStringStyle
implements Style {
    public void paint(Geometry geometry, Viewport viewport, Graphics2D graphics2D) throws Exception {
        LineString lineString;
        if (!viewport.intersectsInModel(geometry.getEnvelopeInternal())) {
            return;
        }
        if (geometry instanceof LineString) {
            lineString = (LineString)geometry;
            if (lineString.getNumPoints() < 2) {
                return;
            }
            this.paintLineString(lineString, viewport, graphics2D);
        }
        if (geometry instanceof Point) {
            return;
        }
        if (geometry instanceof MultiPoint) {
            return;
        }
        if (geometry instanceof GeometryCollection) {
            lineString = (GeometryCollection)geometry;
            for (int i = 0; i < lineString.getNumGeometries(); ++i) {
                this.paint(lineString.getGeometryN(i), viewport, graphics2D);
            }
            return;
        }
        if (geometry instanceof Polygon) {
            lineString = (Polygon)geometry;
            this.paint((Geometry)lineString.getExteriorRing(), viewport, graphics2D);
            for (int i = 0; i < lineString.getNumInteriorRing(); ++i) {
                this.paint((Geometry)lineString.getInteriorRingN(i), viewport, graphics2D);
            }
            return;
        }
    }

    protected abstract void paintLineString(LineString var1, Viewport var2, Graphics2D var3) throws Exception;
}

