/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.testbuilder.geom.ComponentLocater;
import com.vividsolutions.jtstest.testbuilder.geom.FacetLocater;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryLocation;
import com.vividsolutions.jtstest.testbuilder.geom.VertexLocater;
import com.vividsolutions.jtstest.testbuilder.model.Layer;
import com.vividsolutions.jtstest.testbuilder.model.LayerList;
import java.util.Iterator;
import java.util.List;

public class GeometryLocationsWriter {
    private static final int MAX_ITEMS_TO_DISPLAY = 10;
    private boolean isHtmlFormatted = true;
    private String eol = null;
    private String highlightStart = null;
    private String highlightEnd = null;
    private String documentStart = null;
    private String documentEnd = null;

    public static String writeLocation(LayerList layerList, Coordinate coordinate, double d) {
        GeometryLocationsWriter geometryLocationsWriter = new GeometryLocationsWriter();
        return geometryLocationsWriter.writeLocationString(layerList, coordinate, d);
    }

    public GeometryLocationsWriter() {
        this.setHtml(true);
    }

    public void setHtml(boolean bl) {
        this.isHtmlFormatted = bl;
        if (bl) {
            this.eol = "<br>";
            this.highlightStart = "<b>";
            this.highlightEnd = "</b>";
            this.documentStart = "<html>";
            this.documentEnd = "</html>";
        } else {
            this.eol = "\n";
            this.highlightStart = "";
            this.highlightEnd = "";
            this.documentStart = "";
            this.documentEnd = "";
        }
    }

    public String writeLocationString(LayerList layerList, Coordinate coordinate, double d) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < layerList.size(); ++i) {
            Layer layer = layerList.getLayer(i);
            String string = this.writeLocation(layer, coordinate, d);
            if (string == null) continue;
            if (i > 0 && stringBuffer.length() > 0) {
                stringBuffer.append(this.eol);
            }
            stringBuffer.append(this.highlightStart + layer.getName() + this.highlightEnd + this.eol);
            stringBuffer.append(string);
        }
        if (stringBuffer.length() > 0) {
            return this.documentStart + stringBuffer.toString() + this.documentEnd;
        }
        return null;
    }

    public String writeSingleLocation(Layer layer, Coordinate coordinate, double d) {
        Geometry geometry = layer.getGeometry();
        if (geometry == null) {
            return null;
        }
        VertexLocater vertexLocater = new VertexLocater(geometry);
        Coordinate coordinate2 = vertexLocater.getVertex(coordinate, d);
        int n = vertexLocater.getIndex();
        if (coordinate2 == null) {
            return null;
        }
        return "[" + n + "]: " + coordinate2.x + ", " + coordinate2.y;
    }

    public String writeLocation(Layer layer, Coordinate coordinate, double d) {
        Geometry geometry = layer.getGeometry();
        if (geometry == null) {
            return null;
        }
        String string = this.writeComponentLocation(geometry, coordinate, d);
        String string2 = this.writeFacetLocation(geometry, coordinate, d);
        if (string2 == null) {
            return string;
        }
        return string + string2;
    }

    public String writeComponentLocation(Geometry geometry, Coordinate coordinate, double d) {
        ComponentLocater componentLocater = new ComponentLocater(geometry);
        List list = componentLocater.getComponents(coordinate, d);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Object object = list.iterator();
        while (object.hasNext()) {
            GeometryLocation geometryLocation = (GeometryLocation)object.next();
            Geometry geometry2 = geometryLocation.getComponent();
            stringBuffer.append("[" + geometryLocation.pathString() + "]  ");
            stringBuffer.append(geometry2.getGeometryType().toUpperCase());
            if (geometry2.getUserData() != null) {
                stringBuffer.append("  Data: ");
                stringBuffer.append(geometry2.getUserData().toString());
            }
            stringBuffer.append(this.eol);
            if (n++ <= 10) continue;
            stringBuffer.append(" & more..." + this.eol);
            break;
        }
        if (((String)(object = stringBuffer.toString())).length() == 0) {
            return null;
        }
        return object;
    }

    public String writeFacetLocation(Geometry geometry, Coordinate coordinate, double d) {
        FacetLocater facetLocater = new FacetLocater(geometry);
        List list = facetLocater.getLocations(coordinate, d);
        List list2 = FacetLocater.filterVertexLocations(list);
        if (!list2.isEmpty()) {
            return this.writeFacetLocations(list2);
        }
        return this.writeFacetLocations(list);
    }

    private String writeFacetLocations(List list) {
        if (list.size() <= 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            GeometryLocation geometryLocation = (GeometryLocation)iterator.next();
            if (!bl) {
                stringBuffer.append(this.eol);
            }
            bl = false;
            stringBuffer.append(geometryLocation.toFacetString());
            if (n++ <= 10) continue;
            stringBuffer.append(this.eol + " & more..." + this.eol);
            break;
        }
        return stringBuffer.toString();
    }

    public String OLDwriteLocation(Geometry geometry, Coordinate coordinate, double d) {
        VertexLocater vertexLocater = new VertexLocater(geometry);
        List list = vertexLocater.getLocations(coordinate, d);
        if (list.size() <= 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            VertexLocater.Location location = (VertexLocater.Location)iterator.next();
            int n = location.getIndices()[0];
            Coordinate coordinate2 = location.getCoordinate();
            if (!bl) {
                stringBuffer.append(this.eol + "--");
            }
            bl = false;
            String string = "[" + n + "]: " + coordinate2.x + ", " + coordinate2.y;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

