/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.model;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jtstest.testbuilder.GeometryEditPanel;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.testbuilder.model.TestCaseEdit;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JFrame;

public class PNGWriter {
    private static final int IMAGE_WIDTH = 200;
    private static final int IMAGE_HEIGHT = 200;
    private static final int STACK_TRACE_DEPTH = 1;
    private GeometryEditPanel geometryEditPanel = new GeometryEditPanel();
    private JFrame frame = new JFrame();
    private File outputDirectory;

    public PNGWriter() {
        this.geometryEditPanel.setSize(200, 200);
        this.geometryEditPanel.setGridEnabled(false);
        this.geometryEditPanel.setBorder(BorderFactory.createEmptyBorder());
        this.frame.getContentPane().add(this.geometryEditPanel);
    }

    public void write(File file, TestCaseEdit testCaseEdit, PrecisionModel precisionModel) throws IOException {
        Assert.isTrue((boolean)file.isDirectory());
        this.outputDirectory = file;
        this.createPNGFile("geoms", testCaseEdit.getGeometry(0), testCaseEdit.getGeometry(1), testCaseEdit.getResult(), 200, 200);
    }

    private void createPNGFile(String string, Geometry geometry, Geometry geometry2, Geometry geometry3, int n, int n2) throws FileNotFoundException, IOException {
        TestBuilderModel testBuilderModel = new TestBuilderModel();
        TestCaseEdit testCaseEdit = new TestCaseEdit(new Geometry[]{geometry, geometry2});
        testCaseEdit.setResult(geometry3);
        testBuilderModel.getGeometryEditModel().setTestCase(testCaseEdit);
        this.geometryEditPanel.setModel(testBuilderModel);
        this.geometryEditPanel.zoomToFullExtent();
        this.geometryEditPanel.setShowingResult(geometry3 != null);
        this.geometryEditPanel.setShowingGeometryA(geometry != null);
        this.geometryEditPanel.setShowingGeometryB(geometry2 != null);
        String string2 = this.outputDirectory.getPath() + "\\" + string;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
        this.geometryEditPanel.paint(((Image)bufferedImage).getGraphics());
        ImageIO.write((RenderedImage)bufferedImage, "png", new File(string2 + ".png"));
    }
}

