/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jtstest.function.BaseGeometryFunction;
import com.vividsolutions.jtstest.function.GeometryFunction;
import com.vividsolutions.jtstest.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionListener;

public class GeometryFunctionListPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    private DefaultListModel listModel = new DefaultListModel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList list = new JList(this.listModel){

        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.locationToIndex(mouseEvent.getPoint());
            if (-1 < n) {
                GeometryFunction geometryFunction = (GeometryFunction)this.getModel().getElementAt(n);
                return geometryFunction.getSignature();
            }
            return null;
        }
    };
    BorderLayout borderLayout2 = new BorderLayout();
    Border border1;

    public GeometryFunctionListPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.list.setCellRenderer(new GeometryFunctionCellRenderer());
    }

    private void jbInit() throws Exception {
        this.setSize(200, 250);
        this.border1 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        this.setLayout(this.borderLayout2);
        this.setBorder(this.border1);
        this.list.setSelectionMode(0);
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.list, null);
    }

    public void registerListSelectionListener(ListSelectionListener listSelectionListener) {
        this.list.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void registerMouseListener(MouseListener mouseListener) {
        this.list.addMouseListener(mouseListener);
    }

    public GeometryFunction getFunction() {
        if (this.list.getSelectedValue() == null) {
            return null;
        }
        return (GeometryFunction)this.list.getSelectedValue();
    }

    public void populate(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            GeometryFunction geometryFunction = (GeometryFunction)iterator.next();
            this.listModel.addElement(geometryFunction);
        }
    }

    private class GeometryFunctionCellRenderer
    extends JLabel
    implements ListCellRenderer {
        Border spaceBorder = BorderFactory.createEmptyBorder(0, 4, 1, 0);
        private final ImageIcon binaryIcon = new ImageIcon(this.getClass().getResource("BinaryGeomFunction.png"));
        private final ImageIcon unaryIcon = new ImageIcon(this.getClass().getResource("UnaryGeomFunction.png"));

        private GeometryFunctionCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            GeometryFunction geometryFunction = (GeometryFunction)object;
            String string = StringUtil.capitalize(geometryFunction.getName());
            this.setBorder(this.spaceBorder);
            this.setText(string);
            this.setOpaque(true);
            boolean bl3 = BaseGeometryFunction.isBinaryGeomFunction(geometryFunction);
            this.setIcon(bl3 ? this.binaryIcon : this.unaryIcon);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            return this;
        }
    }
}

