/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.geom.util.AffineTransformationFactory;

public class AffineTransformationFunctions {
    public static Geometry transformByVectors(Geometry geometry, Geometry geometry2) {
        int n = geometry2.getNumGeometries();
        Coordinate[] coordinateArray = new Coordinate[n];
        Coordinate[] coordinateArray2 = new Coordinate[n];
        for (int i = 0; i < n; ++i) {
            Geometry geometry3 = geometry2.getGeometryN(i);
            Coordinate[] coordinateArray3 = geometry3.getCoordinates();
            coordinateArray[i] = coordinateArray3[0];
            coordinateArray2[i] = coordinateArray3[1];
        }
        AffineTransformation affineTransformation = AffineTransformationFactory.createFromControlVectors((Coordinate[])coordinateArray, (Coordinate[])coordinateArray2);
        System.out.println(affineTransformation);
        return affineTransformation.transform(geometry);
    }

    public static Geometry transformByBaseline(Geometry geometry, Geometry geometry2) {
        Envelope envelope = geometry.getEnvelopeInternal();
        Coordinate coordinate = new Coordinate(envelope.getMinX(), envelope.getMinY());
        Coordinate coordinate2 = new Coordinate(envelope.getMaxX(), envelope.getMinY());
        Coordinate[] coordinateArray = geometry2.getCoordinates();
        Coordinate coordinate3 = coordinateArray[0];
        Coordinate coordinate4 = coordinateArray[1];
        AffineTransformation affineTransformation = AffineTransformationFactory.createFromBaseLines((Coordinate)coordinate, (Coordinate)coordinate2, (Coordinate)coordinate3, (Coordinate)coordinate4);
        return affineTransformation.transform(geometry);
    }

    private static Coordinate envelopeCentre(Geometry geometry) {
        return geometry.getEnvelopeInternal().centre();
    }

    private static Coordinate envelopeLowerLeft(Geometry geometry) {
        Envelope envelope = geometry.getEnvelopeInternal();
        return new Coordinate(envelope.getMinX(), envelope.getMinY());
    }

    public static Geometry scale(Geometry geometry, double d) {
        Coordinate coordinate = AffineTransformationFunctions.envelopeCentre(geometry);
        AffineTransformation affineTransformation = AffineTransformation.scaleInstance((double)d, (double)d, (double)coordinate.x, (double)coordinate.y);
        return affineTransformation.transform(geometry);
    }

    public static Geometry reflectInX(Geometry geometry) {
        Coordinate coordinate = AffineTransformationFunctions.envelopeCentre(geometry);
        AffineTransformation affineTransformation = AffineTransformation.scaleInstance((double)1.0, (double)-1.0, (double)coordinate.x, (double)coordinate.y);
        return affineTransformation.transform(geometry);
    }

    public static Geometry reflectInY(Geometry geometry) {
        Coordinate coordinate = AffineTransformationFunctions.envelopeCentre(geometry);
        AffineTransformation affineTransformation = AffineTransformation.scaleInstance((double)-1.0, (double)1.0, (double)coordinate.x, (double)coordinate.y);
        return affineTransformation.transform(geometry);
    }

    public static Geometry rotate(Geometry geometry, double d) {
        Coordinate coordinate = AffineTransformationFunctions.envelopeCentre(geometry);
        AffineTransformation affineTransformation = AffineTransformation.rotationInstance((double)(d * Math.PI), (double)coordinate.x, (double)coordinate.y);
        return affineTransformation.transform(geometry);
    }

    public static Geometry translateCentreToOrigin(Geometry geometry) {
        Coordinate coordinate = AffineTransformationFunctions.envelopeCentre(geometry);
        AffineTransformation affineTransformation = AffineTransformation.translationInstance((double)(-coordinate.x), (double)(-coordinate.y));
        return affineTransformation.transform(geometry);
    }

    public static Geometry translateToOrigin(Geometry geometry) {
        Coordinate coordinate = AffineTransformationFunctions.envelopeLowerLeft(geometry);
        AffineTransformation affineTransformation = AffineTransformation.translationInstance((double)(-coordinate.x), (double)(-coordinate.y));
        return affineTransformation.transform(geometry);
    }
}

