/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testrunner;

import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jtstest.geomop.GeometryOperation;
import com.vividsolutions.jtstest.testrunner.ResultMatcher;
import com.vividsolutions.jtstest.testrunner.TestCase;
import com.vividsolutions.jtstest.testrunner.TopologyTestApp;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TestRun
implements Runnable {
    private int testCaseIndexToRun = -1;
    private String description;
    private List testCases = new ArrayList();
    private PrecisionModel precisionModel;
    private GeometryOperation geomOp = null;
    private ResultMatcher resultMatcher = null;
    private int runIndex;
    private File testFile;
    private File workspace;

    public TestRun(String string, int n, PrecisionModel precisionModel, GeometryOperation geometryOperation, ResultMatcher resultMatcher, File file) {
        this.description = string;
        this.runIndex = n;
        this.precisionModel = precisionModel;
        this.geomOp = geometryOperation;
        this.resultMatcher = resultMatcher;
        this.testFile = file;
    }

    public void setWorkspace(File file) {
        this.workspace = file;
    }

    public void setTestCaseIndexToRun(int n) {
        this.testCaseIndexToRun = n;
    }

    public File getWorkspace() {
        return this.workspace;
    }

    public int getTestCount() {
        int n = 0;
        Iterator iterator = this.testCases.iterator();
        while (iterator.hasNext()) {
            TestCase testCase = (TestCase)iterator.next();
            n += testCase.getTestCount();
        }
        return n;
    }

    public String getDescription() {
        return this.description;
    }

    public int getRunIndex() {
        return this.runIndex;
    }

    public PrecisionModel getPrecisionModel() {
        return this.precisionModel;
    }

    public GeometryOperation getGeometryOperation() {
        if (TopologyTestApp.isGeometryOperationSpecified() || this.geomOp == null) {
            return TopologyTestApp.getGeometryOperation();
        }
        return this.geomOp;
    }

    public ResultMatcher getResultMatcher() {
        if (TopologyTestApp.isResultMatcherSpecified() || this.resultMatcher == null) {
            return TopologyTestApp.getResultMatcher();
        }
        return this.resultMatcher;
    }

    public List getTestCases() {
        return Collections.unmodifiableList(this.testCases);
    }

    public File getTestFile() {
        return this.testFile;
    }

    public void addTestCase(TestCase testCase) {
        this.testCases.add(testCase);
    }

    public void run() {
        Iterator iterator = this.testCases.iterator();
        while (iterator.hasNext()) {
            TestCase testCase = (TestCase)iterator.next();
            if (this.testCaseIndexToRun >= 0 && testCase.getCaseIndex() != this.testCaseIndexToRun) continue;
            testCase.run();
        }
    }
}

