/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.tools;

import com.vividsolutions.jtstest.testbuilder.GeometryEditPanel;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.ui.tools.BasicTool;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class ZoomToClickTool
extends BasicTool {
    private double zoomFactor = 2.0;
    private Cursor cursor = Cursor.getDefaultCursor();
    private Point zoomBoxStart = null;
    private Point zoomBoxEnd = null;

    public ZoomToClickTool() {
    }

    public ZoomToClickTool(double d, Cursor cursor) {
        this();
        this.zoomFactor = d;
        this.cursor = cursor;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        double d = SwingUtilities.isRightMouseButton(mouseEvent) ? 1.0 / this.zoomFactor : this.zoomFactor;
        Point point = mouseEvent.getPoint();
        this.zoomPanel(point, d);
    }

    private void zoomPanel(Point point, double d) {
        GeometryEditPanel geometryEditPanel = this.getPanel();
        double d2 = (double)geometryEditPanel.getSize().width / d;
        double d3 = (double)geometryEditPanel.getSize().height / d;
        double d4 = (double)point.y + d3 / 2.0;
        double d5 = (double)point.x - d2 / 2.0;
        Point point2 = new Point((int)d5, (int)d4);
        Point2D point2D = geometryEditPanel.getViewport().toModel(point2);
        geometryEditPanel.getViewport().setScale(geometryEditPanel.getViewport().getScale() * d);
        geometryEditPanel.getViewport().setViewOrigin(point2D.getX(), point2D.getY());
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.zoomBoxStart = mouseEvent.getPoint();
        this.zoomBoxEnd = mouseEvent.getPoint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isSignificantMouseMove()) {
            return;
        }
        int n = (this.zoomBoxEnd.x + this.zoomBoxStart.x) / 2;
        int n2 = (this.zoomBoxEnd.y + this.zoomBoxStart.y) / 2;
        Point point = new Point(n, n2);
        int n3 = Math.abs(this.zoomBoxEnd.x - this.zoomBoxStart.x);
        int n4 = Math.abs(this.zoomBoxEnd.y - this.zoomBoxStart.y);
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n4 <= 0) {
            n4 = 1;
        }
        GeometryEditPanel geometryEditPanel = this.getPanel();
        double d = geometryEditPanel.getSize().width / n3;
        double d2 = geometryEditPanel.getSize().height / n4;
        double d3 = Math.min(d, d2);
        this.zoomPanel(point, d3);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Graphics graphics = this.getPanel().getGraphics();
        graphics.setColor(Color.RED);
        graphics.setXORMode(Color.white);
        this.drawRect(graphics);
        this.zoomBoxEnd = point;
        this.drawRect(graphics);
    }

    public void activate() {
    }

    private boolean isSignificantMouseMove() {
        if (Math.abs(this.zoomBoxStart.x - this.zoomBoxEnd.x) > 1) {
            return true;
        }
        return Math.abs(this.zoomBoxStart.y - this.zoomBoxEnd.y) > 1;
    }

    public void drawRect(Graphics graphics) {
        Point point = new Point(Math.min(this.zoomBoxStart.x, this.zoomBoxEnd.x), Math.min(this.zoomBoxStart.y, this.zoomBoxEnd.y));
        int n = Math.abs(this.zoomBoxEnd.x - this.zoomBoxStart.x);
        int n2 = Math.abs(this.zoomBoxEnd.y - this.zoomBoxStart.y);
        graphics.drawRect(point.x, point.y, n, n2);
    }

    public GeometryEditPanel getPanel() {
        return JTSTestBuilderFrame.getInstance().getTestCasePanel().getGeometryEditPanel();
    }
}

