/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.topostretch;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jtstest.testbuilder.topostretch.NearVertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class NearVertexFinder {
    private Collection linestrings;
    private double tolerance = 0.0;
    private List nearVerts = new ArrayList();
    private static LineSegment distSeg = new LineSegment();

    public static List findNear(Collection collection, double d) {
        NearVertexFinder nearVertexFinder = new NearVertexFinder(collection, d);
        return nearVertexFinder.getNearVertices();
    }

    public NearVertexFinder(Collection collection, double d) {
        this.linestrings = collection;
        this.tolerance = d;
    }

    public List getNearVertices() {
        this.findNearVertices();
        return this.nearVerts;
    }

    private void findNearVertices() {
        Iterator iterator = this.linestrings.iterator();
        while (iterator.hasNext()) {
            LineString lineString = (LineString)iterator.next();
            this.findNearVertices(lineString);
        }
    }

    private void findNearVertices(LineString lineString) {
        Coordinate[] coordinateArray = lineString.getCoordinates();
        for (int i = 0; i < coordinateArray.length; ++i) {
            this.findNearVertex(coordinateArray, i, coordinateArray[i]);
        }
    }

    private void findNearVertex(Coordinate[] coordinateArray, int n, Coordinate coordinate) {
        Iterator iterator = this.linestrings.iterator();
        while (iterator.hasNext()) {
            LineString lineString = (LineString)iterator.next();
            this.findNearVertex(coordinateArray, n, coordinate, lineString);
        }
    }

    private void findNearVertex(Coordinate[] coordinateArray, int n, Coordinate coordinate, LineString lineString) {
        Coordinate[] coordinateArray2 = lineString.getCoordinates();
        for (int i = 0; i < coordinateArray2.length; ++i) {
            Coordinate coordinate2 = coordinateArray2[i];
            NearVertex nearVertex = null;
            double d = coordinate2.distance(coordinate);
            if (d <= this.tolerance && d != 0.0) {
                nearVertex = new NearVertex(coordinate, coordinateArray, i, coordinate2);
            } else if (i < coordinateArray2.length - 1) {
                Coordinate coordinate3 = coordinateArray2[i + 1];
                double d2 = coordinate3.distance(coordinate);
                if (d2 <= this.tolerance) continue;
                double d3 = NearVertexFinder.distanceToSeg(coordinate, coordinate2, coordinate3);
                if (d3 <= this.tolerance && d3 != 0.0) {
                    nearVertex = new NearVertex(coordinate, coordinateArray, i, new LineSegment(coordinate2, coordinateArray2[i + 1]));
                }
            }
            if (nearVertex == null) continue;
            this.nearVerts.add(nearVertex);
        }
    }

    private static double distanceToSeg(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        NearVertexFinder.distSeg.p0 = coordinate2;
        NearVertexFinder.distSeg.p1 = coordinate3;
        double d = distSeg.distance(coordinate);
        if (CGAlgorithms.computeOrientation((Coordinate)coordinate2, (Coordinate)coordinate3, (Coordinate)coordinate) == 0) {
            d = 0.0;
        }
        return d;
    }
}

