/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class StatsPanel
extends JPanel {
    TestBuilderModel tbModel = null;
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea txtStats = new JTextArea();
    BorderLayout tabPanelLayout = new BorderLayout();

    public StatsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.tabPanelLayout);
        this.txtStats.setWrapStyleWord(true);
        this.txtStats.setLineWrap(true);
        this.txtStats.setBackground(SystemColor.control);
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jScrollPane1.getViewport().add((Component)this.txtStats, null);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                StatsPanel.this.refresh();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }

    public void setModel(TestBuilderModel testBuilderModel) {
        this.tbModel = testBuilderModel;
    }

    public void refresh() {
        StringBuffer stringBuffer = new StringBuffer();
        this.writeGeom("A", this.tbModel.getCurrentTestCaseEdit().getGeometry(0), stringBuffer);
        this.writeGeom("B", this.tbModel.getCurrentTestCaseEdit().getGeometry(1), stringBuffer);
        this.writeGeom("Result", this.tbModel.getCurrentTestCaseEdit().getResult(), stringBuffer);
        this.setString(stringBuffer.toString());
    }

    private void writeGeom(String string, Geometry geometry, StringBuffer stringBuffer) {
        if (geometry == null) {
            return;
        }
        stringBuffer.append(string + " --- " + geometry.getGeometryType() + " \n");
        stringBuffer.append("    # pts:  " + geometry.getNumPoints() + "\n");
        stringBuffer.append("    Length: " + geometry.getLength() + "\n");
        stringBuffer.append("    Area:   " + geometry.getArea() + "\n");
        stringBuffer.append("\n");
    }

    private void setString(String string) {
        this.txtStats.setText(string);
    }
}

