/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jts.util.Stopwatch;
import com.vividsolutions.jtstest.clean.CleanDuplicatePoints;
import com.vividsolutions.jtstest.clean.LineStringExtracter;
import com.vividsolutions.jtstest.test.TestCaseList;
import com.vividsolutions.jtstest.test.Testable;
import com.vividsolutions.jtstest.testbuilder.GeometryEditPanel;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilder;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilder_AboutBox;
import com.vividsolutions.jtstest.testbuilder.PrecisionModelDialog;
import com.vividsolutions.jtstest.testbuilder.ResultValuePanel;
import com.vividsolutions.jtstest.testbuilder.ResultWKTPanel;
import com.vividsolutions.jtstest.testbuilder.SpatialFunctionPanelEvent;
import com.vividsolutions.jtstest.testbuilder.SpatialFunctionPanelListener;
import com.vividsolutions.jtstest.testbuilder.StatsPanel;
import com.vividsolutions.jtstest.testbuilder.TestCasePanel;
import com.vividsolutions.jtstest.testbuilder.TestCaseTextDialog;
import com.vividsolutions.jtstest.testbuilder.TestListPanel;
import com.vividsolutions.jtstest.testbuilder.TextViewDialog;
import com.vividsolutions.jtstest.testbuilder.WKTPanel;
import com.vividsolutions.jtstest.testbuilder.model.GeometryEditModel;
import com.vividsolutions.jtstest.testbuilder.model.GeometryEvent;
import com.vividsolutions.jtstest.testbuilder.model.GeometryListener;
import com.vividsolutions.jtstest.testbuilder.model.HtmlWriter;
import com.vividsolutions.jtstest.testbuilder.model.JavaTestWriter;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.testbuilder.model.TestCaseEdit;
import com.vividsolutions.jtstest.testbuilder.model.XMLTestWriter;
import com.vividsolutions.jtstest.testbuilder.ui.dnd.FileDrop;
import com.vividsolutions.jtstest.testbuilder.ui.tools.CreationTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.EditVertexTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.PanTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.ZoomToClickTool;
import com.vividsolutions.jtstest.testrunner.GeometryResult;
import com.vividsolutions.jtstest.testrunner.GuiUtil;
import com.vividsolutions.jtstest.testrunner.StringUtil;
import com.vividsolutions.jtstest.util.FileUtil;
import com.vividsolutions.jtstest.util.MultiFormatReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class JTSTestBuilderFrame
extends JFrame {
    private static JTSTestBuilderFrame singleton = null;
    JPanel contentPane;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    ImageIcon image1;
    ImageIcon image2;
    ImageIcon image3;
    BorderLayout borderLayout1 = new BorderLayout();
    Border border4;
    JMenu jMenu1 = new JMenu();
    JSplitPane jSplitPane1 = new JSplitPane();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    TestCasePanel testCasePanel = new TestCasePanel();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenu jMenu2 = new JMenu();
    JMenuItem menuExchangeGeom = new JMenuItem();
    JMenuItem menuTestText = new JMenuItem();
    JMenuItem menuLoadXmlTestFile = new JMenuItem();
    JPanel jPanel2 = new JPanel();
    JTabbedPane inputTabbedPane = new JTabbedPane();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel testPanel = new JPanel();
    WKTPanel wktPanel = new WKTPanel();
    TestListPanel testListPanel = new TestListPanel(this);
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridLayout gridLayout1 = new GridLayout();
    JMenuItem saveAsXmlMenuItem = new JMenuItem();
    JToolBar jToolBar1 = new JToolBar();
    JButton previousButton = new JButton();
    JButton nextButton = new JButton();
    JButton newButton = new JButton();
    JButton copyButton = new JButton();
    JButton deleteButton = new JButton();
    JButton exchangeButton = new JButton();
    Component component1;
    Component component2;
    Component component5;
    ResultWKTPanel resultWKTPanel = new ResultWKTPanel();
    ResultValuePanel resultValuePanel = new ResultValuePanel();
    StatsPanel statsPanel = new StatsPanel();
    JMenuItem saveAsHtmlMenuItem = new JMenuItem();
    JMenuItem saveAsPNGMenuItem = new JMenuItem();
    Component component3;
    JToggleButton createButton = new JToggleButton();
    JToggleButton zoomInButton = new JToggleButton();
    JButton oneToOneButton = new JButton();
    ButtonGroup buttonGroup = new ButtonGroup();
    JButton zoomToFullExtentButton = new JButton();
    JButton zoomToInputButton = new JButton();
    Component component4;
    JToggleButton panButton = new JToggleButton();
    JMenuItem deleteAllTestCasesMenuItem = new JMenuItem();
    JMenu jMenu3 = new JMenu();
    JCheckBoxMenuItem showVerticesMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem showGridMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem showOrientationsMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem showVertexIndicesMenuItem = new JCheckBoxMenuItem();
    JMenuItem menuLoadXmlTestFolder = new JMenuItem();
    JMenuItem precisionModelMenuItem = new JMenuItem();
    private ZoomToClickTool zoomInTool;
    private final ImageIcon leftIcon = new ImageIcon(this.getClass().getResource("Left.gif"));
    private final ImageIcon rightIcon = new ImageIcon(this.getClass().getResource("Right.gif"));
    private final ImageIcon plusIcon = new ImageIcon(this.getClass().getResource("Plus.gif"));
    private final ImageIcon copyCaseIcon = new ImageIcon(this.getClass().getResource("CopyCase.gif"));
    private final ImageIcon deleteIcon = new ImageIcon(this.getClass().getResource("Delete.gif"));
    private final ImageIcon exchangeGeomsIcon = new ImageIcon(this.getClass().getResource("ExchangeGeoms.png"));
    private final ImageIcon executeIcon = new ImageIcon(this.getClass().getResource("ExecuteProject.gif"));
    private final ImageIcon zoomInIcon = new ImageIcon(this.getClass().getResource("MagnifyCursor.gif"));
    private final ImageIcon createIcon = new ImageIcon(this.getClass().getResource("Draw.gif"));
    private final ImageIcon zoomOneToOneIcon = new ImageIcon(this.getClass().getResource("ZoomOneToOne.png"));
    private final ImageIcon zoomToInputIcon = new ImageIcon(this.getClass().getResource("ZoomInput.png"));
    private final ImageIcon zoomToFullExtentIcon = new ImageIcon(this.getClass().getResource("ZoomAll.png"));
    private final ImageIcon selectIcon = new ImageIcon(this.getClass().getResource("Select.gif"));
    private final ImageIcon moveVertexIcon = new ImageIcon(this.getClass().getResource("MoveVertex.png"));
    private final ImageIcon panIcon = new ImageIcon(this.getClass().getResource("Hand.gif"));
    private final ImageIcon appIcon = new ImageIcon(this.getClass().getResource("app-icon.gif"));
    private JFileChooser fileChooser = new JFileChooser();
    private JFileChooser fileAndDirectoryChooser = new JFileChooser();
    private JFileChooser directoryChooser = new JFileChooser();
    private TestBuilderModel tbModel;
    private FileFilter xmlFileFilter = new FileFilter(){

        public String getDescription() {
            return "JTS Test XML File (*.xml)";
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.toString().toLowerCase().endsWith(".xml");
        }
    };
    private FileFilter javaFileFilter = new FileFilter(){

        public String getDescription() {
            return "Java File (*.java)";
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.toString().toLowerCase().endsWith(".java");
        }
    };
    private TextViewDialog textViewDlg = new TextViewDialog(this, "", true);
    private TestCaseTextDialog testCaseTextDlg = new TestCaseTextDialog(this, "", true);
    private ArrayList wktABeforePMChange = new ArrayList();
    private ArrayList wktBBeforePMChange = new ArrayList();
    JMenu jMenu4 = new JMenu();
    JMenuItem removeDuplicatePoints = new JMenuItem();
    JMenuItem changeToLines = new JMenuItem();
    JToggleButton btnSelectPoint = new JToggleButton();
    private JMenuItem generateExpectedValuesMenuItem = new JMenuItem();

    public JTSTestBuilderFrame() {
        try {
            Assert.isTrue((singleton == null ? 1 : 0) != 0);
            singleton = this;
            this.enableEvents(64L);
            this.setIconImage(this.appIcon.getImage());
            this.jbInit();
            this.testCasePanel.editCtlPanel.setGridSizeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JTSTestBuilderFrame.this.setGridSizeButton_actionPerformed(actionEvent);
                }
            });
            this.testCasePanel.spatialFunctionPanel.addSpatialFunctionPanelListener(new SpatialFunctionPanelListener(){

                public void functionChanged(SpatialFunctionPanelEvent spatialFunctionPanelEvent) {
                    JTSTestBuilderFrame.this.spatialFunctionPanel_functionChanged(spatialFunctionPanelEvent);
                }
            });
            this.testCasePanel.scalarFunctionPanel.addSpatialFunctionPanelListener(new SpatialFunctionPanelListener(){

                public void functionChanged(SpatialFunctionPanelEvent spatialFunctionPanelEvent) {
                    JTSTestBuilderFrame.this.scalarFunctionPanel_functionChanged(spatialFunctionPanelEvent);
                }
            });
            this.testCasePanel.btnSetPrecisionModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JTSTestBuilderFrame.this.precisionModelMenuItem_actionPerformed(actionEvent);
                }
            });
            this.buttonGroup.add(this.createButton);
            this.buttonGroup.add(this.panButton);
            this.buttonGroup.add(this.zoomInButton);
            this.buttonGroup.add(this.btnSelectPoint);
            Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("MagnifyCursor.gif")).getImage(), new Point(16, 16), "Zoom In");
            this.zoomInTool = new ZoomToClickTool(2.0, cursor);
            this.testCasePanel.getGeometryEditPanel().setCurrentTool(CreationTool.getInstance());
            this.showGeomsTab();
            this.initFileDrop(this.testCasePanel);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initFileDrop(Component component) {
        new FileDrop(component, new FileDrop.Listener(){

            public void filesDropped(File[] fileArray) {
                try {
                    JTSTestBuilderFrame.this.openXmlFilesAndDirectories(fileArray);
                }
                catch (Exception exception) {
                    JTSTestBuilderFrame.reportException(null, exception);
                }
            }
        });
    }

    public static JTSTestBuilderFrame getInstance() {
        if (singleton == null) {
            new JTSTestBuilderFrame();
        }
        return singleton;
    }

    public TestBuilderModel getModel() {
        return this.tbModel;
    }

    public void setModel(TestBuilderModel testBuilderModel) {
        this.tbModel = testBuilderModel;
        this.testCasePanel.setModel(this.tbModel);
        this.resultWKTPanel.setModel(testBuilderModel);
        this.resultValuePanel.setModel(testBuilderModel);
        this.statsPanel.setModel(testBuilderModel);
        testBuilderModel.getGeometryEditModel().addGeometryListener(new GeometryListener(){

            public void geometryChanged(GeometryEvent geometryEvent) {
                JTSTestBuilderFrame.this.model_geometryChanged(geometryEvent);
            }
        });
        this.testListPanel.populateList();
        this.refreshNavBar();
    }

    public static void reportException(Component component, Exception exception) {
        JOptionPane.showMessageDialog(component, StringUtil.split(exception.toString(), 80), "Exception", 0);
        exception.printStackTrace(System.out);
    }

    public void setCurrentTestCase(TestCaseEdit testCaseEdit) {
        this.tbModel.setCurrentTestCase(testCaseEdit);
        this.refreshNavBar();
    }

    public TestCasePanel getTestCasePanel() {
        return this.testCasePanel;
    }

    public String getTestJava(TestCaseList testCaseList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < testCaseList.getList().size(); ++i) {
            stringBuffer.append(new JavaTestWriter().write((Testable)testCaseList.getList().get(i)));
        }
        return stringBuffer.toString();
    }

    public void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        JTSTestBuilder_AboutBox jTSTestBuilder_AboutBox = new JTSTestBuilder_AboutBox(this);
        Dimension dimension = jTSTestBuilder_AboutBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        jTSTestBuilder_AboutBox.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        jTSTestBuilder_AboutBox.setModal(true);
        jTSTestBuilder_AboutBox.show();
    }

    public void spatialFunctionPanel_functionChanged(SpatialFunctionPanelEvent spatialFunctionPanelEvent) {
        Object object = this.testCasePanel.getSpatialFunctionPanel().getResult();
        String string = this.testCasePanel.getSpatialFunctionPanel().getOpName();
        Stopwatch stopwatch = this.testCasePanel.getSpatialFunctionPanel().getTimer();
        this.tbModel.getCurrentTestCaseEdit().setOpName(string);
        if (object == null || object instanceof Geometry) {
            this.tbModel.getCurrentTestCaseEdit().setResult((Geometry)object);
        }
        this.getTestCasePanel().getGeometryEditPanel().updateView();
        this.resultWKTPanel.setResult(string, stopwatch.getTimeString(), object);
        this.showResultTab();
    }

    public void scalarFunctionPanel_functionChanged(SpatialFunctionPanelEvent spatialFunctionPanelEvent) {
        Object object = this.testCasePanel.getScalarFunctionPanel().getResult();
        String string = this.testCasePanel.getScalarFunctionPanel().getOpName();
        Stopwatch stopwatch = this.testCasePanel.getScalarFunctionPanel().getTimer();
        this.resultValuePanel.setResult(string, stopwatch.getTimeString(), object);
        this.showResultValueTab();
    }

    public void showGeomsTab() {
        this.inputTabbedPane.setSelectedIndex(this.inputTabbedPane.indexOfTab("Input"));
    }

    public void showResultTab() {
        this.inputTabbedPane.setSelectedIndex(this.inputTabbedPane.indexOfTab("Result"));
    }

    public void showResultValueTab() {
        this.inputTabbedPane.setSelectedIndex(this.inputTabbedPane.indexOfTab("Value"));
    }

    public void openXmlFilesAndDirectories(File[] fileArray) throws Exception {
        if (fileArray.length == 1) {
            this.fileChooser.setSelectedFile(fileArray[0]);
        }
        this.tbModel.openXmlFilesAndDirectories(fileArray);
        this.reportProblemsParsingXmlTestFile(this.tbModel.getParsingProblems());
        this.refreshNavBar();
        this.testListPanel.populateList();
        this.updatePrecisionModelDescription();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.jMenuFileExit_actionPerformed(null);
        }
    }

    void setGridSizeButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.testCasePanel.editPanel.setGridSize(Double.parseDouble(this.testCasePanel.editCtlPanel.txtGridSize.getText()));
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    void menuViewWKT_actionPerformed(ActionEvent actionEvent) {
        this.textViewDlg.setText(this.tbModel.getGeometryEditModel().getText(1));
        this.textViewDlg.show();
    }

    void model_geometryChanged(GeometryEvent geometryEvent) {
        this.testCasePanel.editPanel.updateView();
        this.updateWktPanel();
    }

    void wktPanel_actionPerformed(ActionEvent actionEvent) {
        try {
            this.loadWellKnownText(false);
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    void btnNewCase_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.createNew();
        this.showGeomsTab();
        this.refreshNavBar();
        this.testListPanel.populateList();
    }

    void refreshNavBar() {
        this.testCasePanel.setTestCase(this.tbModel.getCurrentTestCaseEdit());
        this.getTestCasePanel().setCurrentTestCaseIndex(this.tbModel.getCurrentTestIndex() + 1);
        this.getTestCasePanel().setMaxTestCaseIndex(this.tbModel.getTestListSize());
        this.updateWktPanel();
    }

    void btnPrevCase_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.prevCase();
        this.refreshNavBar();
    }

    void btnNextCase_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.nextCase();
        this.refreshNavBar();
    }

    void btnCopyCase_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.copyCase();
        this.refreshNavBar();
        this.testListPanel.populateList();
    }

    public void copyResultToTest() {
        Object object = this.resultWKTPanel.getResult();
        if (!(object instanceof Geometry)) {
            return;
        }
        this.tbModel.addCase(new Geometry[]{(Geometry)object, null});
        this.refreshNavBar();
        this.testListPanel.populateList();
    }

    void btnExchangeGeoms_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.getCurrentTestCaseEdit().exchange();
        this.testCasePanel.setTestCase(this.tbModel.getCurrentTestCaseEdit());
    }

    void btnDeleteCase_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.deleteCase();
        this.refreshNavBar();
        this.testListPanel.populateList();
    }

    void menuExchangeGeom_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.getCurrentTestCaseEdit().exchange();
        this.testCasePanel.setTestCase(this.tbModel.getCurrentTestCaseEdit());
    }

    void menuTestText_actionPerformed(ActionEvent actionEvent) {
        this.testCaseTextDlg.setTestCase(this.tbModel.getCurrentTestCaseEdit());
        this.testCaseTextDlg.show();
    }

    void menuLoadXmlTestFile_actionPerformed(ActionEvent actionEvent) {
        try {
            this.fileChooser.removeChoosableFileFilter(this.javaFileFilter);
            this.fileChooser.addChoosableFileFilter(this.xmlFileFilter);
            this.fileChooser.setDialogTitle("Open XML Test File(s)");
            this.fileChooser.setMultiSelectionEnabled(true);
            if (0 == this.fileChooser.showOpenDialog(this)) {
                File[] fileArray = this.fileChooser.getSelectedFiles();
                if (fileArray.length == 0) {
                    fileArray = new File[]{this.fileChooser.getSelectedFile()};
                }
                this.openXmlFilesAndDirectories(fileArray);
            }
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    void menuSaveAsXml_actionPerformed(ActionEvent actionEvent) {
        try {
            this.fileChooser.removeChoosableFileFilter(this.javaFileFilter);
            this.fileChooser.addChoosableFileFilter(this.xmlFileFilter);
            this.fileChooser.setDialogTitle("Save XML Test File");
            if (0 == this.fileChooser.showSaveDialog(this)) {
                int n;
                File file = this.fileChooser.getSelectedFile();
                if (file.exists() && (n = JOptionPane.showConfirmDialog(this, file.getName() + " exists. Overwrite?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                FileUtil.setContents(this.fileChooser.getSelectedFile().getPath(), XMLTestWriter.getRunXml(this.tbModel.getTestCaseList(), this.tbModel.getPrecisionModel()));
            }
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    public String getRunXml() {
        return XMLTestWriter.getRunXml(this.tbModel.getTestCaseList(), this.tbModel.getPrecisionModel());
    }

    void menuSaveAsJava_actionPerformed(ActionEvent actionEvent) {
        try {
            this.fileChooser.removeChoosableFileFilter(this.xmlFileFilter);
            this.fileChooser.addChoosableFileFilter(this.javaFileFilter);
            this.fileChooser.setDialogTitle("Save Java File");
            if (0 == this.fileChooser.showSaveDialog(this)) {
                int n;
                File file = this.fileChooser.getSelectedFile();
                if (file.exists() && (n = JOptionPane.showConfirmDialog(this, file.getName() + " exists. Overwrite?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                String string = this.fileChooser.getSelectedFile().getName();
                int n2 = string.lastIndexOf(".");
                if (n2 > 0) {
                    string = string.substring(0, n2);
                }
                FileUtil.setContents(this.fileChooser.getSelectedFile().getPath(), this.getRunJava(string));
            }
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    void menuSaveAsHtml_actionPerformed(ActionEvent actionEvent) {
        try {
            this.directoryChooser.setDialogTitle("Select Folder In Which To Save HTML and GIF Files");
            if (0 == this.directoryChooser.showSaveDialog(this)) {
                int n = JOptionPane.showConfirmDialog(this, "Would you like the spatial function images to show the A and B geometries?", "Confirmation", 1);
                HtmlWriter htmlWriter = new HtmlWriter();
                switch (n) {
                    case 2: {
                        return;
                    }
                    case 0: {
                        htmlWriter.setShowingABwithSpatialFunction(true);
                        break;
                    }
                    case 1: {
                        htmlWriter.setShowingABwithSpatialFunction(false);
                    }
                }
                File file = this.directoryChooser.getSelectedFile();
                Assert.isTrue((boolean)file.exists());
                htmlWriter.write(file, this.tbModel.getTestCaseList(), this.tbModel.getPrecisionModel());
            }
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    void menuSaveAsPNG_actionPerformed(ActionEvent actionEvent) {
        try {
            this.directoryChooser.setDialogTitle("Select Folder In Which To Save PNG");
            if (0 == this.directoryChooser.showSaveDialog(this)) {
                File file = this.directoryChooser.getSelectedFile();
                String string = file.getPath() + "\\" + "geoms";
                GeometryEditPanel geometryEditPanel = this.testCasePanel.getGeometryEditPanel();
                BufferedImage bufferedImage = new BufferedImage(geometryEditPanel.getSize().width, geometryEditPanel.getSize().height, 6);
                geometryEditPanel.paint(((Image)bufferedImage).getGraphics());
                ImageIO.write((RenderedImage)bufferedImage, "png", new File(string + ".png"));
            }
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    void createButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(CreationTool.getInstance());
    }

    void zoomInButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(this.zoomInTool);
    }

    void oneToOneButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().getViewport().zoomToInitialExtent();
    }

    void zoomToFullExtentButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().zoomToFullExtent();
    }

    void zoomToInputButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().zoomToInput();
    }

    void panButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(PanTool.getInstance());
    }

    void deleteAllTestCasesMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.initTestCaseList();
        this.refreshNavBar();
        this.testListPanel.populateList();
    }

    void showVerticesMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.setShowingVertices(this.showVerticesMenuItem.isSelected());
    }

    void showOrientationsMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.setShowingOrientations(this.showOrientationsMenuItem.isSelected());
    }

    void showGridMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.editPanel.setGridEnabled(this.showGridMenuItem.isSelected());
        this.testCasePanel.editPanel.updateView();
    }

    public void setShowingOrientations(boolean bl) {
        TestBuilderModel.setShowingOrientations(bl);
        this.testCasePanel.editPanel.updateView();
    }

    public void setShowVertexIndices(boolean bl) {
        TestBuilderModel.setShowingOrientations(bl);
        this.testCasePanel.editPanel.updateView();
    }

    public void setShowingVertices(boolean bl) {
        TestBuilderModel.setShowingVertices(bl);
        this.testCasePanel.editPanel.updateView();
    }

    void showVertexIndicesMenuItem_actionPerformed(ActionEvent actionEvent) {
    }

    void menuLoadXmlTestFolder_actionPerformed(ActionEvent actionEvent) {
        try {
            this.directoryChooser.removeChoosableFileFilter(this.javaFileFilter);
            this.directoryChooser.setDialogTitle("Open Folder(s) Containing XML Test Files");
            this.directoryChooser.setMultiSelectionEnabled(true);
            if (0 == this.directoryChooser.showOpenDialog(this)) {
                File[] fileArray = this.directoryChooser.getSelectedFiles();
                if (fileArray.length == 0) {
                    fileArray = new File[]{this.fileChooser.getSelectedFile()};
                }
                this.openXmlFilesAndDirectories(fileArray);
            }
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    void precisionModelMenuItem_actionPerformed(ActionEvent actionEvent) {
        try {
            PrecisionModelDialog precisionModelDialog = new PrecisionModelDialog(this, "Edit Precision Model", true);
            GuiUtil.center(precisionModelDialog, this);
            precisionModelDialog.setPrecisionModel(this.tbModel.getPrecisionModel());
            precisionModelDialog.setVisible(true);
            this.saveWKTBeforePMChange();
            this.tbModel.setPrecisionModel(precisionModelDialog.getPrecisionModel());
            this.loadWKTAfterPMChange();
            this.updatePrecisionModelDescription();
            this.updateGeometry();
        }
        catch (ParseException parseException) {
            JTSTestBuilderFrame.reportException(this, (Exception)((Object)parseException));
        }
    }

    void moveToOriginButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.loadWellKnownText(true);
        }
        catch (Exception exception) {
            JTSTestBuilderFrame.reportException(this, exception);
        }
    }

    private String getRunJava(String string) {
        return "package com.vividsolutions.jtstest.testsuite;" + StringUtil.newLine + "" + StringUtil.newLine + "import com.vividsolutions.jtstest.test.*;" + StringUtil.newLine + "" + StringUtil.newLine + "public class " + string + " extends TestCaseList {" + StringUtil.newLine + "  public static void main(String[] args) {" + StringUtil.newLine + "    " + string + " test = new " + string + "();" + StringUtil.newLine + "    test.run();" + StringUtil.newLine + "  }" + StringUtil.newLine + "" + StringUtil.newLine + "  public " + string + "() {" + StringUtil.newLine + this.getTestJava(this.tbModel.getTestCaseList()) + "  }" + StringUtil.newLine + "}";
    }

    private void jbInit() throws Exception {
        this.component1 = Box.createHorizontalStrut(8);
        this.component2 = Box.createHorizontalStrut(8);
        this.component3 = Box.createHorizontalStrut(8);
        this.component4 = Box.createHorizontalStrut(8);
        this.component5 = Box.createHorizontalStrut(8);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileAndDirectoryChooser.setFileSelectionMode(2);
        this.fileAndDirectoryChooser.setMultiSelectionEnabled(true);
        this.directoryChooser.setFileSelectionMode(1);
        this.directoryChooser.setMultiSelectionEnabled(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.textViewDlg.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.textViewDlg.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.contentPane = (JPanel)this.getContentPane();
        this.border4 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(93, 93, 93), new Color(134, 134, 134));
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(600, 700));
        this.setTitle("JTS Test Builder");
        this.jMenuFile.setText("File");
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.jMenuHelpAbout_actionPerformed(actionEvent);
            }
        });
        this.jMenu1.setText("View");
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setPreferredSize(new Dimension(601, 690));
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel1.setMinimumSize(new Dimension(431, 0));
        this.contentPane.setPreferredSize(new Dimension(601, 690));
        this.jMenuFileExit.setText("Exit");
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.jMenuFileExit_actionPerformed(actionEvent);
            }
        });
        this.jMenu2.setText("Edit");
        this.menuExchangeGeom.setText("Exchange Geometries");
        this.menuExchangeGeom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.menuExchangeGeom_actionPerformed(actionEvent);
            }
        });
        this.menuTestText.setText("Test Case Text...");
        this.menuTestText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.menuTestText_actionPerformed(actionEvent);
            }
        });
        this.menuLoadXmlTestFile.setText("Open XML File(s)...");
        this.menuLoadXmlTestFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.menuLoadXmlTestFile_actionPerformed(actionEvent);
            }
        });
        this.inputTabbedPane.setTabPlacement(2);
        this.jPanel2.setLayout(this.borderLayout3);
        this.wktPanel.setMinimumSize(new Dimension(111, 0));
        this.wktPanel.setPreferredSize(new Dimension(600, 100));
        this.wktPanel.setToolTipText("Enter WKT, WKB or GML, or drag-and-drop a file");
        this.previousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.btnPrevCase_actionPerformed(actionEvent);
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.btnNextCase_actionPerformed(actionEvent);
            }
        });
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.btnCopyCase_actionPerformed(actionEvent);
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.btnDeleteCase_actionPerformed(actionEvent);
            }
        });
        this.exchangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.btnExchangeGeoms_actionPerformed(actionEvent);
            }
        });
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.btnNewCase_actionPerformed(actionEvent);
            }
        });
        this.testPanel.setLayout(this.gridBagLayout2);
        this.gridLayout1.setRows(4);
        this.gridLayout1.setColumns(1);
        this.saveAsXmlMenuItem.setText("Save As XML...");
        this.saveAsXmlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.menuSaveAsXml_actionPerformed(actionEvent);
            }
        });
        this.previousButton.setFont(new Font("SansSerif", 0, 10));
        this.previousButton.setMaximumSize(new Dimension(30, 30));
        this.previousButton.setMinimumSize(new Dimension(30, 30));
        this.previousButton.setPreferredSize(new Dimension(30, 30));
        this.previousButton.setToolTipText("Previous Case");
        this.previousButton.setHorizontalTextPosition(0);
        this.previousButton.setIcon(this.leftIcon);
        this.previousButton.setMargin(new Insets(0, 0, 0, 0));
        this.previousButton.setVerticalTextPosition(3);
        this.nextButton.setMargin(new Insets(0, 0, 0, 0));
        this.nextButton.setVerticalTextPosition(3);
        this.nextButton.setFont(new Font("SansSerif", 0, 10));
        this.nextButton.setMaximumSize(new Dimension(30, 30));
        this.nextButton.setMinimumSize(new Dimension(30, 30));
        this.nextButton.setPreferredSize(new Dimension(30, 30));
        this.nextButton.setToolTipText("Next Case");
        this.nextButton.setHorizontalTextPosition(0);
        this.nextButton.setIcon(this.rightIcon);
        this.newButton.setMargin(new Insets(0, 0, 0, 0));
        this.newButton.setVerticalTextPosition(3);
        this.newButton.setFont(new Font("SansSerif", 0, 10));
        this.newButton.setMaximumSize(new Dimension(30, 30));
        this.newButton.setMinimumSize(new Dimension(30, 30));
        this.newButton.setPreferredSize(new Dimension(30, 30));
        this.newButton.setToolTipText("New Case");
        this.newButton.setHorizontalTextPosition(0);
        this.newButton.setIcon(this.plusIcon);
        this.copyButton.setMargin(new Insets(0, 0, 0, 0));
        this.copyButton.setVerticalTextPosition(3);
        this.copyButton.setFont(new Font("SansSerif", 0, 10));
        this.copyButton.setMaximumSize(new Dimension(30, 30));
        this.copyButton.setMinimumSize(new Dimension(30, 30));
        this.copyButton.setPreferredSize(new Dimension(30, 30));
        this.copyButton.setToolTipText("Copy Current Case");
        this.copyButton.setHorizontalTextPosition(0);
        this.copyButton.setIcon(this.copyCaseIcon);
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setVerticalTextPosition(3);
        this.deleteButton.setFont(new Font("SansSerif", 0, 10));
        this.deleteButton.setMaximumSize(new Dimension(30, 30));
        this.deleteButton.setMinimumSize(new Dimension(30, 30));
        this.deleteButton.setPreferredSize(new Dimension(30, 30));
        this.deleteButton.setToolTipText("Delete Current Case");
        this.deleteButton.setHorizontalTextPosition(0);
        this.deleteButton.setIcon(this.deleteIcon);
        this.exchangeButton.setMargin(new Insets(0, 0, 0, 0));
        this.exchangeButton.setVerticalTextPosition(3);
        this.exchangeButton.setFont(new Font("SansSerif", 0, 10));
        this.exchangeButton.setMaximumSize(new Dimension(30, 30));
        this.exchangeButton.setMinimumSize(new Dimension(30, 30));
        this.exchangeButton.setPreferredSize(new Dimension(30, 30));
        this.exchangeButton.setToolTipText("Exchange A & B");
        this.exchangeButton.setHorizontalTextPosition(0);
        this.exchangeButton.setIcon(this.exchangeGeomsIcon);
        this.saveAsHtmlMenuItem.setText("Save As HTML...");
        this.saveAsHtmlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.menuSaveAsHtml_actionPerformed(actionEvent);
            }
        });
        this.saveAsPNGMenuItem.setText("Save As PNG...");
        this.saveAsPNGMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.menuSaveAsPNG_actionPerformed(actionEvent);
            }
        });
        this.createButton.setMargin(new Insets(0, 0, 0, 0));
        this.createButton.setPreferredSize(new Dimension(30, 30));
        this.createButton.setIcon(this.createIcon);
        this.createButton.setMinimumSize(new Dimension(30, 30));
        this.createButton.setVerticalTextPosition(3);
        this.createButton.setSelected(true);
        this.createButton.setToolTipText("Edit");
        this.createButton.setHorizontalTextPosition(0);
        this.createButton.setFont(new Font("SansSerif", 0, 10));
        this.createButton.setMaximumSize(new Dimension(30, 30));
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.createButton_actionPerformed(actionEvent);
            }
        });
        this.zoomInButton.setMaximumSize(new Dimension(30, 30));
        this.zoomInButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.zoomInButton_actionPerformed(actionEvent);
            }
        });
        this.zoomInButton.setToolTipText("Zoom In/Out");
        this.zoomInButton.setHorizontalTextPosition(0);
        this.zoomInButton.setFont(new Font("Serif", 0, 10));
        this.zoomInButton.setMinimumSize(new Dimension(30, 30));
        this.zoomInButton.setVerticalTextPosition(3);
        this.zoomInButton.setPreferredSize(new Dimension(30, 30));
        this.zoomInButton.setIcon(this.zoomInIcon);
        this.zoomInButton.setMargin(new Insets(0, 0, 0, 0));
        this.oneToOneButton.setMargin(new Insets(0, 0, 0, 0));
        this.oneToOneButton.setIcon(this.zoomOneToOneIcon);
        this.oneToOneButton.setPreferredSize(new Dimension(30, 30));
        this.oneToOneButton.setMinimumSize(new Dimension(30, 30));
        this.oneToOneButton.setVerticalTextPosition(3);
        this.oneToOneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.oneToOneButton_actionPerformed(actionEvent);
            }
        });
        this.oneToOneButton.setFont(new Font("SansSerif", 0, 10));
        this.oneToOneButton.setToolTipText("Zoom 1:1");
        this.oneToOneButton.setHorizontalTextPosition(0);
        this.oneToOneButton.setMaximumSize(new Dimension(30, 30));
        this.zoomToInputButton.setMargin(new Insets(0, 0, 0, 0));
        this.zoomToInputButton.setIcon(this.zoomToInputIcon);
        this.zoomToInputButton.setPreferredSize(new Dimension(30, 30));
        this.zoomToInputButton.setVerticalTextPosition(3);
        this.zoomToInputButton.setMinimumSize(new Dimension(30, 30));
        this.zoomToInputButton.setFont(new Font("SansSerif", 0, 10));
        this.zoomToInputButton.setHorizontalTextPosition(0);
        this.zoomToInputButton.setToolTipText("Zoom To Input");
        this.zoomToInputButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.zoomToInputButton_actionPerformed(actionEvent);
            }
        });
        this.zoomToInputButton.setMaximumSize(new Dimension(30, 30));
        this.zoomToFullExtentButton.setMargin(new Insets(0, 0, 0, 0));
        this.zoomToFullExtentButton.setIcon(this.zoomToFullExtentIcon);
        this.zoomToFullExtentButton.setPreferredSize(new Dimension(30, 30));
        this.zoomToFullExtentButton.setVerticalTextPosition(3);
        this.zoomToFullExtentButton.setMinimumSize(new Dimension(30, 30));
        this.zoomToFullExtentButton.setFont(new Font("SansSerif", 0, 10));
        this.zoomToFullExtentButton.setHorizontalTextPosition(0);
        this.zoomToFullExtentButton.setToolTipText("Zoom To Full Extent");
        this.zoomToFullExtentButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.zoomToFullExtentButton_actionPerformed(actionEvent);
            }
        });
        this.zoomToFullExtentButton.setMaximumSize(new Dimension(30, 30));
        this.panButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.panButton_actionPerformed(actionEvent);
            }
        });
        this.panButton.setMaximumSize(new Dimension(30, 30));
        this.panButton.setFont(new Font("SansSerif", 0, 10));
        this.panButton.setHorizontalTextPosition(0);
        this.panButton.setToolTipText("Pan");
        this.panButton.setVerticalTextPosition(3);
        this.panButton.setMinimumSize(new Dimension(30, 30));
        this.panButton.setIcon(this.panIcon);
        this.panButton.setPreferredSize(new Dimension(30, 30));
        this.panButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteAllTestCasesMenuItem.setText("Delete All Test Cases");
        this.deleteAllTestCasesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.deleteAllTestCasesMenuItem_actionPerformed(actionEvent);
            }
        });
        this.jMenu3.setText("Options");
        this.showVerticesMenuItem.setText("Show Vertices");
        this.showVerticesMenuItem.setSelected(true);
        this.showVerticesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.showVerticesMenuItem_actionPerformed(actionEvent);
            }
        });
        this.showGridMenuItem.setText("Show Grid");
        this.showGridMenuItem.setSelected(true);
        this.showGridMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.showGridMenuItem_actionPerformed(actionEvent);
            }
        });
        this.showOrientationsMenuItem.setText("Show Orientations");
        this.showOrientationsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.showOrientationsMenuItem_actionPerformed(actionEvent);
            }
        });
        this.showVertexIndicesMenuItem.setText("Show Vertex Indices");
        this.showVertexIndicesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.showVertexIndicesMenuItem_actionPerformed(actionEvent);
            }
        });
        this.menuLoadXmlTestFolder.setText("Open XML Folder(s)...");
        this.menuLoadXmlTestFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.menuLoadXmlTestFolder_actionPerformed(actionEvent);
            }
        });
        this.precisionModelMenuItem.setText("Precision Model...");
        this.precisionModelMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.precisionModelMenuItem_actionPerformed(actionEvent);
            }
        });
        this.jMenu4.setText("Tools");
        this.removeDuplicatePoints.setText("Remove Duplicate Points");
        this.removeDuplicatePoints.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.menuRemoveDuplicatePoints_actionPerformed(actionEvent);
            }
        });
        this.changeToLines.setText("Change to Lines");
        this.changeToLines.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.menuChangeToLines_actionPerformed(actionEvent);
            }
        });
        this.btnSelectPoint.setMaximumSize(new Dimension(30, 30));
        this.btnSelectPoint.setMinimumSize(new Dimension(30, 30));
        this.btnSelectPoint.setToolTipText("<html>Move/Add/Delete Vertex<br>Left-Btn=Move, Right-Btn=Add, Ctl-Right-Btn=Delete</html>");
        this.btnSelectPoint.setIcon(this.moveVertexIcon);
        this.btnSelectPoint.setMargin(new Insets(0, 0, 0, 0));
        this.btnSelectPoint.setMnemonic('0');
        this.btnSelectPoint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.btnSelectPoint_actionPerformed(actionEvent);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.generateExpectedValuesMenuItem.setText("Generate Expected Values");
        this.generateExpectedValuesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.generateExpectedValuesMenuItem_actionPerformed(actionEvent);
            }
        });
        this.jMenuFile.add(this.menuLoadXmlTestFile);
        this.jMenuFile.add(this.menuLoadXmlTestFolder);
        this.jMenuFile.add(this.saveAsPNGMenuItem);
        this.jMenuFile.add(this.saveAsXmlMenuItem);
        this.jMenuFile.add(this.saveAsHtmlMenuItem);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.generateExpectedValuesMenuItem);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenuBar1.add(this.jMenu4);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        this.jMenu1.add(this.menuTestText);
        this.contentPane.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.jPanel1, "top");
        this.jPanel1.add((Component)this.testCasePanel, "Center");
        this.jSplitPane1.add((Component)this.jPanel2, "bottom");
        this.jPanel2.add((Component)this.inputTabbedPane, "Center");
        this.jSplitPane1.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.inputTabbedPane.add((Component)this.testPanel, "Tests");
        this.testPanel.add((Component)this.testListPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.inputTabbedPane.add((Component)this.wktPanel, "Input");
        this.inputTabbedPane.add((Component)this.resultWKTPanel, "Result");
        this.inputTabbedPane.add((Component)this.resultValuePanel, "Value");
        this.inputTabbedPane.add((Component)this.statsPanel, "Stats");
        this.inputTabbedPane.setSelectedIndex(1);
        this.inputTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (JTSTestBuilderFrame.this.inputTabbedPane.getSelectedIndex() == 3) {
                    JTSTestBuilderFrame.this.statsPanel.refresh();
                }
            }
        });
        this.contentPane.add((Component)this.jToolBar1, "North");
        this.jToolBar1.add((Component)this.newButton, null);
        this.jToolBar1.add((Component)this.copyButton, null);
        this.jToolBar1.add((Component)this.deleteButton, null);
        this.jToolBar1.add(this.component2, null);
        this.jToolBar1.add((Component)this.previousButton, null);
        this.jToolBar1.add((Component)this.nextButton, null);
        this.jToolBar1.add(this.component1, null);
        this.jToolBar1.add((Component)this.exchangeButton, null);
        this.jToolBar1.add(this.component5, null);
        this.jToolBar1.add((Component)this.zoomInButton, null);
        this.jToolBar1.add((Component)this.panButton, null);
        this.jToolBar1.add((Component)this.oneToOneButton, null);
        this.jToolBar1.add((Component)this.zoomToInputButton, null);
        this.jToolBar1.add((Component)this.zoomToFullExtentButton, null);
        this.jToolBar1.add(this.component4, null);
        this.jToolBar1.add((Component)this.createButton, null);
        this.jToolBar1.add((Component)this.btnSelectPoint, null);
        this.jMenu2.add(this.deleteAllTestCasesMenuItem);
        this.jMenu2.add(this.menuExchangeGeom);
        this.jMenu2.addSeparator();
        this.jMenu2.add(this.precisionModelMenuItem);
        this.jMenu3.add(this.showVerticesMenuItem);
        this.jMenu3.add(this.showVertexIndicesMenuItem);
        this.jMenu3.add(this.showOrientationsMenuItem);
        this.jMenu3.add(this.showGridMenuItem);
        this.jMenu4.add(this.removeDuplicatePoints);
        this.jMenu4.add(this.changeToLines);
        this.jSplitPane1.setDividerLocation(500);
        this.wktPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTSTestBuilderFrame.this.wktPanel_actionPerformed(actionEvent);
            }
        });
    }

    private void updateGeometry() {
        this.testCasePanel.relatePanel.clearResults();
        this.testCasePanel.setTestCase(this.tbModel.getCurrentTestCaseEdit());
        this.updateWktPanel();
    }

    private void updateWktPanel() {
        Geometry geometry = this.tbModel.getGeometryEditModel().getGeometry(0);
        if (geometry != null) {
            this.wktPanel.setWellKnownTextA(GeometryEditModel.getText(geometry, 1, "a"));
        } else {
            this.wktPanel.setWellKnownTextA("");
        }
        Geometry geometry2 = this.tbModel.getGeometryEditModel().getGeometry(1);
        if (geometry2 != null) {
            this.wktPanel.setWellKnownTextB(GeometryEditModel.getText(geometry2, 1, "b"));
        } else {
            this.wktPanel.setWellKnownTextB("");
        }
    }

    private void reportProblemsParsingXmlTestFile(List list) {
        if (list.isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            System.out.println(string);
        }
        JOptionPane.showMessageDialog(this, StringUtil.split(list.size() + " problems occurred parsing the XML test file." + " The first problem was: " + list.get(0), 80), "Error", 0);
    }

    private void saveWKTBeforePMChange() {
        this.wktABeforePMChange.clear();
        this.wktBBeforePMChange.clear();
        Iterator iterator = this.tbModel.getTestCaseList().getList().iterator();
        while (iterator.hasNext()) {
            Testable testable = (Testable)iterator.next();
            Geometry geometry = testable.getGeometry(0);
            Geometry geometry2 = testable.getGeometry(1);
            this.wktABeforePMChange.add(geometry != null ? geometry.toText() : null);
            this.wktBBeforePMChange.add(geometry2 != null ? geometry2.toText() : null);
        }
    }

    private void loadWKTAfterPMChange() throws ParseException {
        WKTReader wKTReader = new WKTReader(new GeometryFactory(this.tbModel.getPrecisionModel(), 0));
        for (int i = 0; i < this.tbModel.getTestCaseList().getList().size(); ++i) {
            Testable testable = (Testable)this.tbModel.getTestCaseList().getList().get(i);
            String string = (String)this.wktABeforePMChange.get(i);
            String string2 = (String)this.wktBBeforePMChange.get(i);
            testable.setGeometry(0, string != null ? wKTReader.read(string) : null);
            testable.setGeometry(1, string2 != null ? wKTReader.read(string2) : null);
        }
    }

    private double offsetNumber(double d, Coordinate coordinate, boolean bl) {
        return d - (bl ? coordinate.x : coordinate.y);
    }

    private String offset(String string, Coordinate coordinate) throws IOException {
        String string2 = "";
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        boolean bl = false;
        int n = streamTokenizer.nextToken();
        while (n != -1) {
            string2 = string2 + " ";
            switch (n) {
                case 10: {
                    break;
                }
                case -2: {
                    bl = !bl;
                    string2 = string2 + this.offsetNumber(streamTokenizer.nval, coordinate, bl);
                    break;
                }
                case -3: {
                    string2 = string2 + streamTokenizer.sval;
                    break;
                }
                case 40: {
                    string2 = string2 + "(";
                    break;
                }
                case 41: {
                    string2 = string2 + ")";
                    break;
                }
                case 44: {
                    string2 = string2 + ",";
                    break;
                }
                default: {
                    Assert.shouldNeverReachHere();
                }
            }
            n = streamTokenizer.nextToken();
        }
        return string2;
    }

    private void loadWellKnownText(boolean bl) throws ParseException, IOException {
        TestCaseEdit testCaseEdit;
        MultiFormatReader multiFormatReader = new MultiFormatReader(new GeometryFactory(this.tbModel.getPrecisionModel(), 0));
        Geometry geometry = null;
        if (this.wktPanel.getWellKnownTextA().trim().length() > 0) {
            geometry = multiFormatReader.read(this.wktPanel.getWellKnownTextA());
        }
        Geometry geometry2 = null;
        if (this.wktPanel.getWellKnownTextB().trim().length() > 0) {
            geometry2 = multiFormatReader.read(this.wktPanel.getWellKnownTextB());
        }
        if (bl) {
            testCaseEdit = this.pickOffset(geometry, geometry2);
            if (testCaseEdit == null) {
                return;
            }
            if (geometry != null) {
                geometry = multiFormatReader.read(this.offset(this.wktPanel.getWellKnownTextA(), (Coordinate)testCaseEdit));
            }
            if (geometry2 != null) {
                geometry2 = multiFormatReader.read(this.offset(this.wktPanel.getWellKnownTextB(), (Coordinate)testCaseEdit));
            }
        }
        testCaseEdit = this.tbModel.getCurrentTestCaseEdit();
        testCaseEdit.setGeometry(0, geometry);
        testCaseEdit.setGeometry(1, geometry2);
        this.tbModel.getGeometryEditModel().setTestCase(testCaseEdit);
    }

    private void updatePrecisionModelDescription() {
        this.testCasePanel.setPrecisionModelDescription(this.tbModel.getPrecisionModel().toString());
    }

    private void menuRemoveDuplicatePoints_actionPerformed(ActionEvent actionEvent) {
        CleanDuplicatePoints cleanDuplicatePoints = new CleanDuplicatePoints();
        Geometry geometry = cleanDuplicatePoints.clean(this.tbModel.getCurrentTestCaseEdit().getGeometry(0));
        this.tbModel.getCurrentTestCaseEdit().setGeometry(0, geometry);
        this.updateGeometry();
    }

    void menuChangeToLines_actionPerformed(ActionEvent actionEvent) {
        LineStringExtracter lineStringExtracter = new LineStringExtracter();
        Geometry geometry = lineStringExtracter.extract(this.tbModel.getCurrentTestCaseEdit().getGeometry(0));
        this.tbModel.getCurrentTestCaseEdit().setGeometry(0, geometry);
        this.updateGeometry();
    }

    void btnSelectPoint_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(EditVertexTool.getInstance());
    }

    private Coordinate pickOffset(Geometry geometry, Geometry geometry2) {
        if (geometry != null && !geometry.isEmpty()) {
            return geometry.getCoordinates()[0];
        }
        if (geometry2 != null && !geometry2.isEmpty()) {
            return geometry2.getCoordinates()[0];
        }
        return null;
    }

    void generateExpectedValuesMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.generateExpectedOverlayValues();
    }

    private void generateExpectedOverlayValues() {
        Iterator iterator = this.tbModel.getTestCaseList().getList().iterator();
        while (iterator.hasNext()) {
            Testable testable = (Testable)iterator.next();
            Geometry geometry = testable.getGeometry(0);
            Geometry geometry2 = testable.getGeometry(1);
            if (geometry == null || geometry2 == null) continue;
            testable.setExpectedIntersection(this.invokeOverlayMethod(geometry, geometry2, "intersection"));
            testable.setExpectedUnion(this.invokeOverlayMethod(geometry, geometry2, "union"));
            testable.setExpectedDifference(this.invokeOverlayMethod(geometry, geometry2, "difference"));
            testable.setExpectedSymDifference(this.invokeOverlayMethod(geometry, geometry2, "symDifference"));
        }
    }

    private Geometry invokeOverlayMethod(Geometry geometry, Geometry geometry2, String string) {
        try {
            GeometryResult geometryResult = (GeometryResult)JTSTestBuilder.getGeometryOperation().invoke(string, geometry, new Object[]{geometry2});
            return geometryResult.getGeometry();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return null;
        }
    }

    public Testable getCurrentTestable() {
        return this.tbModel.getCurrentTestable();
    }

    public List getTestCases() {
        return this.tbModel.getTestCases();
    }
}

