/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.XMLDeckPaneDefinition;
import com.ibm.as400.ui.framework.XMLMenuDefinition;
import com.ibm.as400.ui.framework.XMLPanelDefinition;
import com.ibm.as400.ui.framework.XMLPropertySheetDefinition;
import com.ibm.as400.ui.framework.XMLSplitPaneDefinition;
import com.ibm.as400.ui.framework.XMLTabbedPaneDefinition;
import com.ibm.as400.ui.framework.XMLWizardDefinition;
import com.ibm.as400.ui.tools.CompileManager;
import com.ibm.as400.ui.tools.DataBeanGenerator;
import com.ibm.as400.ui.tools.DeckPaneProperties;
import com.ibm.as400.ui.tools.EventHandlerGenerator;
import com.ibm.as400.ui.tools.FileProperties;
import com.ibm.as400.ui.tools.GUIConstants;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.HelpException;
import com.ibm.as400.ui.tools.MenuProperties;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.MutableResource;
import com.ibm.as400.ui.tools.MutableResourceParser;
import com.ibm.as400.ui.tools.PaneProperties;
import com.ibm.as400.ui.tools.PanelProperties;
import com.ibm.as400.ui.tools.PropertySheetProperties;
import com.ibm.as400.ui.tools.PulldownProperties;
import com.ibm.as400.ui.tools.RC2XML;
import com.ibm.as400.ui.tools.SplitPaneProperties;
import com.ibm.as400.ui.tools.StringTableProperties;
import com.ibm.as400.ui.tools.TabbedPaneProperties;
import com.ibm.as400.ui.tools.UndoablePDMLEdit;
import com.ibm.as400.ui.tools.WizardProperties;
import com.ibm.as400.ui.tools.XMLGUIDefinition;
import com.ibm.as400.ui.tools.XMLWriter;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.Collator;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

class XMLGUIBuilderDefinition
extends XMLGUIDefinition
implements PropertyChangeListener {
    UndoablePDMLEdit m_edit;
    UndoManager m_undoManager;
    boolean m_tempEdit = false;
    boolean m_modified = false;
    boolean m_rescaleOnSave = false;
    Vector m_names;
    Vector m_usedKeys;
    String m_saveAsResourceName = "";
    MutableResourceParser m_resourceParser = null;

    XMLGUIBuilderDefinition() {
        this.getPDMLRoot().setPDMLDocument(this);
        this.m_undoManager = new UndoManager();
        this.getPDMLRoot().addTreeModelListener(new NameRegistrationListener());
        this.m_rescaleOnSave = true;
    }

    XMLGUIBuilderDefinition(String string, boolean bl) throws ParseException, FileNotFoundException, IOException, MissingResourceException, PDMLSpecificationException {
        super(string, bl);
        this.getPDMLRoot().setPDMLDocument(this);
        this.m_undoManager = new UndoManager();
        this.getPDMLRoot().addTreeModelListener(new NameRegistrationListener());
        this.m_rescaleOnSave = true;
        this.initTargets();
        this.loadResourceBundle();
        try {
            String string2 = string.substring(0, string.lastIndexOf(46));
            String string3 = (String)this.getPDMLRoot().getProperty("Resource");
            string2 = string3.equals("List resource bundle") ? string2 + ".java" : string2 + ".properties";
            this.m_resourceParser = new MutableResourceParser(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_resourceParser = null;
        }
        if (bl) {
            this.processDocument();
        }
    }

    void initTargets() {
        Enumeration<TreeNode> enumeration = this.getPDMLRoot().children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
            mutableProperties.initTargets();
        }
    }

    void loadResourceBundle() throws MissingResourceException, IOException {
        String string = this.m_documentName;
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        File file = new File(string + ".class");
        File file2 = new File(string + ".java");
        if (file.exists() && file2.exists()) {
            long l = file.lastModified();
            long l2 = file2.lastModified();
            if (l2 > l) {
                CompileManager compileManager = new CompileManager();
                compileManager.doCompile(file2.getPath());
            }
        } else if (file2.exists()) {
            CompileManager compileManager = new CompileManager();
            compileManager.doCompile(file2.getPath());
        }
        this.m_resource = MutableResource.loadResource(string);
        this.m_usedKeys = new Vector(50, 50);
    }

    String getResourceString(String string) {
        return this.getResourceString(string, true);
    }

    String getResourceString(String string, boolean bl) {
        if (this.m_resource != null) {
            try {
                if (this.m_usedKeys != null && (bl || !this.m_windowsSource)) {
                    this.m_usedKeys.addElement(string);
                }
                return this.m_resource.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string;
    }

    void removeUsedResourceKeys() {
        if (this.m_resource != null && this.m_usedKeys != null) {
            int n = this.m_usedKeys.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)this.m_usedKeys.elementAt(n2);
                try {
                    this.m_resource.removeObject(string);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                ++n2;
            }
            this.m_usedKeys = null;
        }
    }

    Dimension parseSize(String string) {
        int n = string.indexOf(44);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        try {
            int n2 = Integer.parseInt(string2);
            int n3 = Integer.parseInt(string3);
            Rectangle rectangle = new Rectangle(0, 0, n2, n3);
            if (this.m_windowsSource) {
                rectangle = this.convertDLUs(rectangle);
            }
            if (this.m_scaledResolution) {
                rectangle = this.scaleRect(rectangle);
            }
            return rectangle.getSize();
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    Point parseLocation(String string) {
        int n = string.indexOf(44);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        try {
            int n2 = Integer.parseInt(string2);
            int n3 = Integer.parseInt(string3);
            Rectangle rectangle = new Rectangle(n2, n3, 0, 0);
            if (this.m_windowsSource) {
                rectangle = this.convertDLUs(rectangle);
            }
            if (this.m_scaledResolution) {
                rectangle = this.scaleRect(rectangle);
            }
            return rectangle.getLocation();
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    Rectangle convertDLUs(Rectangle rectangle) {
        rectangle.setLocation(this.m_fontWidth * rectangle.x / 4, (int)((double)(rectangle.y * this.m_fontHeight) / 7.5));
        rectangle.setSize(this.m_fontWidth * rectangle.width / 4, (int)((double)(rectangle.height * this.m_fontHeight) / 7.5));
        return rectangle;
    }

    Rectangle scaleRect(Rectangle rectangle) {
        return rectangle;
    }

    Rectangle getRescaledRect(Rectangle rectangle) {
        return rectangle;
    }

    void processDocument() throws PDMLSpecificationException, ParseException, IOException {
        MutableProperties mutableProperties;
        Object object;
        Object object2;
        if (this.menus() != null) {
            object2 = null;
            object = this.menus();
            while (object.hasMoreElements()) {
                object2 = (XMLMenuDefinition)object.nextElement();
                mutableProperties = new MenuProperties(this, (XMLMenuDefinition)object2);
                this.addNodeInOrder(mutableProperties);
            }
        }
        if (this.panels() != null) {
            object2 = null;
            object = this.panels();
            while (object.hasMoreElements()) {
                object2 = (XMLPanelDefinition)object.nextElement();
                mutableProperties = new PanelProperties(this, (XMLPanelDefinition)object2);
                this.addNodeInOrder(mutableProperties);
            }
        }
        if (this.propertySheets() != null) {
            object2 = null;
            object = this.propertySheets();
            while (object.hasMoreElements()) {
                object2 = (XMLPropertySheetDefinition)object.nextElement();
                mutableProperties = new PropertySheetProperties(this, (XMLPropertySheetDefinition)object2);
                this.addNodeInOrder(mutableProperties);
            }
        }
        if (this.wizards() != null) {
            object2 = null;
            object = this.wizards();
            while (object.hasMoreElements()) {
                object2 = (XMLWizardDefinition)object.nextElement();
                mutableProperties = new WizardProperties(this, (XMLWizardDefinition)object2);
                this.addNodeInOrder(mutableProperties);
            }
        }
        if (this.deckPanes() != null) {
            object2 = null;
            object = this.deckPanes();
            while (object.hasMoreElements()) {
                object2 = (XMLDeckPaneDefinition)object.nextElement();
                mutableProperties = new DeckPaneProperties(this, (XMLDeckPaneDefinition)object2);
                this.addNodeInOrder(mutableProperties);
            }
        }
        if (this.splitPanes() != null) {
            object2 = null;
            object = this.splitPanes();
            while (object.hasMoreElements()) {
                object2 = (XMLSplitPaneDefinition)object.nextElement();
                mutableProperties = new SplitPaneProperties(this, (XMLSplitPaneDefinition)object2);
                this.addNodeInOrder(mutableProperties);
            }
        }
        if (this.tabbedPanes() != null) {
            object2 = null;
            object = this.tabbedPanes();
            while (object.hasMoreElements()) {
                object2 = (XMLTabbedPaneDefinition)object.nextElement();
                mutableProperties = new TabbedPaneProperties(this, (XMLTabbedPaneDefinition)object2);
                this.addNodeInOrder(mutableProperties);
            }
        }
        this.getResourceString("@Package");
        this.getResourceString("@Serialize");
        this.getResourceString("@GenerateBeans");
        this.getResourceString("@GenerateHandlers");
        this.getResourceString("@GenerateHelp");
        this.getResourceString("@EclipsePluginID");
        object2 = this.getResourceString("@StringEditorBounds");
        object = this.getResourceString("@FileEditorBounds");
        if (object != null && !((String)object).equals("") && !((String)object).equals("@FileEditorBounds")) {
            this.getPDMLRoot().m_properties.put("EditorBounds", object);
        }
        this.removeUsedResourceKeys();
        Enumeration enumeration = this.m_resource.getKeys();
        if (enumeration.hasMoreElements()) {
            mutableProperties = new StringTableProperties(this, this.m_resource);
            this.addNodeInOrder(mutableProperties);
            if (object2 != null && !((String)object2).equals("") && !((String)object2).equals("@StringEditorBounds")) {
                mutableProperties.m_properties.put("EditorBounds", object2);
            }
        }
    }

    void addNodeInOrder(MutableProperties mutableProperties) {
        FileProperties fileProperties = this.getPDMLRoot();
        if (fileProperties.getChildCount() > 0) {
            String string = (String)mutableProperties.getProperty("Name");
            if (string == null) {
                string = "";
            }
            int n = mutableProperties.getType();
            Collator collator = Collator.getInstance();
            int n2 = 0;
            Enumeration<TreeNode> enumeration = fileProperties.children();
            while (enumeration.hasMoreElements()) {
                MutableProperties mutableProperties2 = (MutableProperties)enumeration.nextElement();
                int n3 = mutableProperties2.getType();
                if (n == n3) {
                    String string2 = (String)mutableProperties2.getProperty("Name");
                    if (string2 == null) {
                        string2 = "";
                    }
                    if (collator.compare(string2, string) >= 0) {
                        fileProperties.insert(mutableProperties, n2);
                        return;
                    }
                } else if (n < n3) {
                    fileProperties.insert(mutableProperties, n2);
                    return;
                }
                ++n2;
            }
        }
        fileProperties.add(mutableProperties);
    }

    Vector panes(boolean bl) {
        Vector<PaneProperties> vector = null;
        int n = this.getPDMLRoot().getChildCount();
        if (n > 0) {
            String string = null;
            vector = new Vector<PaneProperties>(n);
            FileProperties fileProperties = this.getPDMLRoot();
            String string2 = fileProperties.getResourceName(true, false);
            int n2 = 0;
            while (n2 < n) {
                MutableProperties mutableProperties = (MutableProperties)this.getPDMLRoot().getChildAt(n2);
                int n3 = mutableProperties.getType();
                if (!bl || n3 == 1) {
                    switch (n3) {
                        default: {
                            string = null;
                            break;
                        }
                        case 1: {
                            string = "PANEL";
                            break;
                        }
                        case 60: {
                            string = "DECK";
                            break;
                        }
                        case 61: {
                            string = "SPLIT";
                            break;
                        }
                        case 62: {
                            string = "TAB";
                        }
                    }
                    if (string != null) {
                        PaneProperties paneProperties = new PaneProperties();
                        try {
                            paneProperties.setProperty("Resource", string2);
                            paneProperties.setProperty("ID", mutableProperties.getProperty("Name"));
                            paneProperties.setProperty("Type", string);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        vector.addElement(paneProperties);
                    }
                }
                ++n2;
            }
        }
        return vector;
    }

    Vector pulldowns() {
        Vector<PulldownProperties> vector = null;
        int n = this.getPDMLRoot().getChildCount();
        if (n > 0) {
            vector = new Vector<PulldownProperties>(n);
            FileProperties fileProperties = this.getPDMLRoot();
            String string = fileProperties.getResourceName(true, false);
            int n2 = 0;
            while (n2 < n) {
                MutableProperties mutableProperties = (MutableProperties)this.getPDMLRoot().getChildAt(n2);
                if (mutableProperties.getType() == 51) {
                    PulldownProperties pulldownProperties = new PulldownProperties();
                    try {
                        pulldownProperties.setProperty("Resource", string);
                        pulldownProperties.setProperty("ID", mutableProperties.getProperty("Name"));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    vector.addElement(pulldownProperties);
                }
                ++n2;
            }
        }
        return vector;
    }

    Enumeration selectionPaneNames(MutableProperties mutableProperties) {
        int n;
        MutableProperties mutableProperties2;
        Enumeration<TreeNode> enumeration;
        Vector vector = new Vector(5, 5);
        if (mutableProperties != null) {
            enumeration = mutableProperties.children();
            while (enumeration.hasMoreElements()) {
                mutableProperties2 = (MutableProperties)enumeration.nextElement();
                n = mutableProperties2.getType();
                if (n != 60 && n != 61 && n != 62) continue;
                this.addNameInOrder((String)mutableProperties2.getProperty("Name"), vector);
            }
        }
        enumeration = this.getPDMLRoot().children();
        while (enumeration.hasMoreElements()) {
            mutableProperties2 = (MutableProperties)enumeration.nextElement();
            n = mutableProperties2.getType();
            if (n != 60 && n != 61 && n != 62) continue;
            this.addNameInOrder((String)mutableProperties2.getProperty("Name"), vector);
        }
        return vector.elements();
    }

    Enumeration selectionPanelNames() {
        Vector vector = new Vector(5, 5);
        Enumeration<TreeNode> enumeration = this.getPDMLRoot().children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
            if (mutableProperties.getType() != 1) continue;
            this.addNameInOrder((String)mutableProperties.getProperty("Name"), vector);
        }
        return vector.elements();
    }

    Enumeration linkableMenuNames(MutableProperties mutableProperties) {
        Vector vector = new Vector(5, 5);
        String string = null;
        if (mutableProperties != null && mutableProperties.getPDMLDocument().equals(this)) {
            string = (String)mutableProperties.getProperty("Name");
        }
        Enumeration<TreeNode> enumeration = this.getPDMLRoot().children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties2 = (MutableProperties)enumeration.nextElement();
            if (mutableProperties2.getType() != 51 || !((MenuProperties)mutableProperties2).areLinksAvailable()) continue;
            String string2 = (String)mutableProperties2.getProperty("Name");
            if (string != null && string.equals(string2)) continue;
            this.addNameInOrder((String)mutableProperties2.getProperty("Name"), vector);
        }
        return vector.elements();
    }

    String registerName(String string, int n) {
        if (string == null) {
            string = this.generateName(n);
        } else if (string.equals("")) {
            return string;
        }
        if (this.m_names == null) {
            this.m_names = new Vector(10, 10);
        }
        this.m_names.addElement(string);
        return string;
    }

    boolean unregisterName(String string) {
        if (this.m_names != null && string != null && !string.equals("")) {
            return this.m_names.removeElement(string);
        }
        return false;
    }

    boolean isNameRegistered(String string) {
        if (this.m_names == null) {
            this.m_names = new Vector(10, 10);
            return false;
        }
        return this.m_names.contains(string);
    }

    String generateName(int n) {
        String string = GUIConstants.getType(n);
        string = GUIFactory.getLocalizedElementName(string);
        int n2 = 1;
        String string2 = string + n2;
        while (this.isNameRegistered(string2)) {
            string2 = string + ++n2;
        }
        return string2;
    }

    String generateUniqueName(String string) {
        String string2 = string;
        if (this.isNameRegistered(string)) {
            int n = 1;
            string2 = string + "_" + n;
            while (this.isNameRegistered(string2)) {
                string2 = string + "_" + ++n;
            }
        }
        return string2;
    }

    FileProperties getPDMLRoot() {
        return (FileProperties)this.root;
    }

    public void setRoot(TreeNode treeNode) {
        if (treeNode instanceof FileProperties) {
            this.getPDMLRoot().setPDMLDocument(null);
            super.setRoot(treeNode);
            this.getPDMLRoot().setPDMLDocument(this);
        }
    }

    UndoManager getUndoManager() {
        return this.m_undoManager;
    }

    void beginEdit() {
        this.beginEdit(false);
    }

    void beginEdit(boolean bl) {
        if (this.m_undoManager != null) {
            this.m_edit = new UndoablePDMLEdit(this, bl);
            this.m_tempEdit = bl;
        }
    }

    void addEdit(UndoableEdit undoableEdit) {
        if (this.m_edit != null && undoableEdit != null) {
            this.m_edit.addEdit(undoableEdit);
        }
    }

    void endEdit() {
        if (this.m_edit != null && this.m_undoManager != null) {
            this.m_edit.end();
            this.m_undoManager.addEdit(this.m_edit);
        }
        this.m_tempEdit = false;
        this.setModified(true);
    }

    void abortEdit() {
        if (this.m_edit != null) {
            this.m_edit.end();
            this.m_edit.die();
            this.m_edit = null;
        }
        this.m_tempEdit = false;
    }

    void setTemporaryEdit(boolean bl) {
        this.m_tempEdit = bl;
    }

    boolean isTemporaryEdit() {
        return this.m_tempEdit;
    }

    void setModified(boolean bl) {
        this.m_modified = bl;
    }

    boolean isModified() {
        return this.m_modified;
    }

    String getSaveAsResourceName() {
        return this.m_saveAsResourceName;
    }

    void setSaveAsResourceName(String string) {
        this.m_saveAsResourceName = string;
    }

    boolean backupFile(File file) {
        if (file.exists()) {
            File file2 = new File(file.getPath() + ".backup");
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            return true;
        }
        return false;
    }

    boolean saveAs(File file) throws IOException, HelpException {
        return this.saveAs(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveAs(File file, boolean bl) throws IOException, HelpException {
        Object object;
        BufferedOutputStream bufferedOutputStream;
        block43: {
            if (!bl) {
                this.setSaveAsResourceName(this.getPDMLRoot().getResourceName(true, false));
            }
            bufferedOutputStream = null;
            OutputStream outputStream = null;
            if (!bl) {
                this.backupFile(file);
            }
            try {
                String string;
                Object object2;
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                object = new XMLWriter(bufferedOutputStream);
                ((XMLWriter)object).setOutputStyle(XMLWriter.PRETTY);
                String string2 = (String)this.getPDMLRoot().getProperty("Resource");
                boolean bl2 = string2.equals("List resource bundle");
                String string3 = file.getPath();
                int n = string3.lastIndexOf(46);
                if (n > -1) {
                    string3 = string3.substring(0, n);
                }
                if (!bl) {
                    object2 = new File(string3 + ".properties");
                    if (this.backupFile((File)object2)) {
                        object2 = new File(string3 + ".java.backup");
                        if (((File)object2).exists()) {
                            ((File)object2).delete();
                        }
                    } else {
                        object2 = new File(string3 + ".java");
                        if (this.backupFile((File)object2) && ((File)(object2 = new File(string3 + ".properties.backup"))).exists()) {
                            ((File)object2).delete();
                        }
                    }
                }
                string3 = bl || !bl2 ? string3 + ".properties" : string3 + ".java";
                object2 = new MutableResource();
                this.getPDMLRoot().save((XMLWriter)object, (MutableResource)object2);
                ((OutputStreamWriter)object).close();
                boolean bl3 = (Boolean)this.getPDMLRoot().getProperty("Serialize");
                if (bl3) {
                    ((MutableResource)object2).addObject("@Serialize", "1");
                }
                if (bl3 = ((Boolean)this.getPDMLRoot().getProperty("Generate Beans")).booleanValue()) {
                    ((MutableResource)object2).addObject("@GenerateBeans", "1");
                }
                if (bl3 = ((Boolean)this.getPDMLRoot().getProperty("Generate Handlers")).booleanValue()) {
                    ((MutableResource)object2).addObject("@GenerateHandlers", "1");
                }
                if (bl3 = ((Boolean)this.getPDMLRoot().getProperty("Generate Help")).booleanValue()) {
                    ((MutableResource)object2).addObject("@GenerateHelp", "1");
                }
                if ((string = this.getPDMLRoot().getProperty("Eclipse Plugin ID").toString()) != null && !string.equals("")) {
                    ((MutableResource)object2).addObject("@EclipsePluginID", string);
                }
                outputStream = new BufferedOutputStream(new FileOutputStream(string3));
                ((MutableResource)object2).setResourceParser(this.m_resourceParser);
                if (!bl && bl2) {
                    String string4 = (String)this.getPDMLRoot().getProperty("Package");
                    ((MutableResource)object2).save(outputStream, GUIFactory.getString("IDS_GENERATION_COMMENT"), string3, string4);
                } else {
                    ((MutableResource)object2).save(outputStream, GUIFactory.getString("IDS_GENERATION_COMMENT"));
                }
                outputStream.close();
                try {
                    this.m_resourceParser = new MutableResourceParser(string3);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.m_resourceParser = null;
                }
                Object var15_28 = null;
                if (outputStream == null) break block43;
            }
            catch (Throwable throwable) {
                Object var15_29 = null;
                if (outputStream != null) {
                    outputStream.close();
                }
                if (bufferedOutputStream != null) {
                    ((OutputStream)bufferedOutputStream).close();
                }
                throw throwable;
            }
            outputStream.close();
        }
        if (bufferedOutputStream != null) {
            ((OutputStream)bufferedOutputStream).close();
        }
        if (!bl) {
            try {
                this.getPDMLRoot().setProperty("File Name", file.getPath());
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.setModified(false);
            object = null;
            boolean bl4 = (Boolean)this.getPDMLRoot().getProperty("Generate Help");
            if (bl4) {
                try {
                    RC2XML.generateHelp(file.getPath());
                }
                catch (PDMLSpecificationException pDMLSpecificationException) {
                    pDMLSpecificationException.reportErrors();
                }
                catch (ParseException parseException) {
                    parseException.reportErrors();
                }
                catch (HelpException helpException) {
                    object = helpException;
                }
            }
            if (bl4 = ((Boolean)this.getPDMLRoot().getProperty("Serialize")).booleanValue()) {
                try {
                    RC2XML.serialize(file.getPath());
                }
                catch (PDMLSpecificationException pDMLSpecificationException) {
                    pDMLSpecificationException.reportErrors();
                }
                catch (ParseException parseException) {
                    parseException.reportErrors();
                }
            }
            if (bl4 = ((Boolean)this.getPDMLRoot().getProperty("Generate Beans")).booleanValue()) {
                try {
                    DataBeanGenerator dataBeanGenerator = new DataBeanGenerator(file.getPath());
                }
                catch (MissingResourceException missingResourceException) {
                    System.out.println(missingResourceException);
                }
                catch (ParseException parseException) {
                    parseException.reportErrors();
                }
            }
            if (bl4 = ((Boolean)this.getPDMLRoot().getProperty("Generate Handlers")).booleanValue()) {
                try {
                    EventHandlerGenerator eventHandlerGenerator = new EventHandlerGenerator(file.getPath());
                }
                catch (MissingResourceException missingResourceException) {
                    System.out.println(missingResourceException);
                }
                catch (ParseException parseException) {
                    parseException.reportErrors();
                }
            }
            if (object != null) {
                throw object;
            }
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        MutableProperties mutableProperties = (MutableProperties)propertyChangeEvent.getSource();
        this.nodeChanged(mutableProperties);
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        super.fireTreeNodesChanged(object, objectArray, nArray, objectArray2);
        int n = 0;
        while (n < objectArray.length) {
            MutableProperties mutableProperties = (MutableProperties)objectArray[n];
            Object[] objectArray3 = mutableProperties.getTreeModelListenerList();
            if (objectArray3 != null) {
                TreeModelEvent treeModelEvent = null;
                int n2 = objectArray3.length - 2;
                while (n2 >= 0) {
                    if (treeModelEvent == null) {
                        treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                    }
                    ((TreeModelListener)objectArray3[n2 + 1]).treeNodesChanged(treeModelEvent);
                    n2 -= 2;
                }
            }
            ++n;
        }
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        super.fireTreeNodesInserted(object, objectArray, nArray, objectArray2);
        int n = 0;
        while (n < objectArray.length) {
            MutableProperties mutableProperties = (MutableProperties)objectArray[n];
            Object[] objectArray3 = mutableProperties.getTreeModelListenerList();
            if (objectArray3 != null) {
                TreeModelEvent treeModelEvent = null;
                int n2 = objectArray3.length - 2;
                while (n2 >= 0) {
                    if (treeModelEvent == null) {
                        treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                    }
                    ((TreeModelListener)objectArray3[n2 + 1]).treeNodesInserted(treeModelEvent);
                    n2 -= 2;
                }
            }
            ++n;
        }
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        super.fireTreeNodesRemoved(object, objectArray, nArray, objectArray2);
        int n = 0;
        while (n < objectArray.length) {
            MutableProperties mutableProperties = (MutableProperties)objectArray[n];
            Object[] objectArray3 = mutableProperties.getTreeModelListenerList();
            if (objectArray3 != null) {
                TreeModelEvent treeModelEvent = null;
                int n2 = objectArray3.length - 2;
                while (n2 >= 0) {
                    if (treeModelEvent == null) {
                        treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                    }
                    ((TreeModelListener)objectArray3[n2 + 1]).treeNodesRemoved(treeModelEvent);
                    n2 -= 2;
                }
            }
            ++n;
        }
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        super.fireTreeStructureChanged(object, objectArray, nArray, objectArray2);
        int n = 0;
        while (n < objectArray.length) {
            MutableProperties mutableProperties = (MutableProperties)objectArray[n];
            Object[] objectArray3 = mutableProperties.getTreeModelListenerList();
            if (objectArray3 != null) {
                TreeModelEvent treeModelEvent = null;
                int n2 = objectArray3.length - 2;
                while (n2 >= 0) {
                    if (treeModelEvent == null) {
                        treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                    }
                    ((TreeModelListener)objectArray3[n2 + 1]).treeStructureChanged(treeModelEvent);
                    n2 -= 2;
                }
            }
            ++n;
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class NameRegistrationListener
    implements TreeModelListener {
        NameRegistrationListener() {
        }

        void doRegistration(MutableProperties mutableProperties, String string, boolean bl) {
            String string2 = (String)mutableProperties.getProperty("Name");
            if (string2 != null && !string2.equals("")) {
                if (bl) {
                    string2 = mutableProperties.getFullyQualifiedName(string2);
                    XMLGUIBuilderDefinition.this.registerName(string2, mutableProperties.getType());
                } else {
                    if (string != null && !string.equals("")) {
                        XMLGUIBuilderDefinition.this.unregisterName(string + "." + string2);
                    } else {
                        XMLGUIBuilderDefinition.this.unregisterName(string2);
                    }
                    if (mutableProperties.getType() != 116 && mutableProperties.getType() != 52 && mutableProperties.getType() != 112 && mutableProperties.getType() != 113) {
                        if (string != null && !string.equals("")) {
                            string2 = string + "." + string2;
                        }
                    } else {
                        string2 = string;
                    }
                }
            } else {
                string2 = string;
            }
            int n = mutableProperties.getChildCount();
            int n2 = 0;
            while (n2 < n) {
                MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getChildAt(n2);
                this.doRegistration(mutableProperties2, string2, bl);
                ++n2;
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            Object[] objectArray = treeModelEvent.getChildren();
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                    this.doRegistration(mutableProperties, null, true);
                    ++n;
                }
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            Object[] objectArray = treeModelEvent.getChildren();
            if (objectArray != null) {
                Object object;
                MutableProperties mutableProperties = (MutableProperties)treePath.getLastPathComponent();
                String string = mutableProperties.getFullyQualifiedName(null);
                if (mutableProperties.getType() != 116 && mutableProperties.getType() != 52 && mutableProperties.getType() != 112 && mutableProperties.getType() != 113) {
                    if (!string.equals("")) {
                        string = string + ".";
                    }
                    if ((object = (String)mutableProperties.getProperty("Name")) != null && !((String)object).equals("")) {
                        string = string + mutableProperties.getProperty("Name");
                    }
                }
                int n = 0;
                while (n < objectArray.length) {
                    object = (MutableProperties)objectArray[n];
                    this.doRegistration((MutableProperties)object, string, false);
                    ++n;
                }
            }
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }
}

