/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.tools.BuilderFrame;
import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class ViewManager {
    GUIBuilder m_builder;
    XMLGUIBuilderDefinition m_document;
    Hashtable m_editors;

    ViewManager(GUIBuilder gUIBuilder, XMLGUIBuilderDefinition xMLGUIBuilderDefinition) {
        this.m_builder = gUIBuilder;
        this.m_document = xMLGUIBuilderDefinition;
        this.m_editors = new Hashtable();
        xMLGUIBuilderDefinition.getPDMLRoot().addTreeModelListener(new ViewListener());
    }

    BuilderFrame getEditor(MutableProperties mutableProperties) {
        return (BuilderFrame)this.m_editors.get(mutableProperties);
    }

    void setEditor(MutableProperties mutableProperties, BuilderFrame builderFrame) {
        if (mutableProperties != null && builderFrame != null) {
            this.m_editors.put(mutableProperties, builderFrame);
        }
    }

    void removeEditor(MutableProperties mutableProperties) {
        Serializable serializable;
        if (this.m_editors.containsKey(mutableProperties)) {
            serializable = (BuilderFrame)this.m_editors.get(mutableProperties);
            serializable.uninstallListeners();
            this.m_editors.remove(mutableProperties);
            this.m_builder.removeEditor((BuilderFrame)serializable);
        }
        Enumeration<TreeNode> enumeration = mutableProperties.children();
        while (enumeration.hasMoreElements()) {
            serializable = (MutableProperties)enumeration.nextElement();
            this.removeEditor((MutableProperties)serializable);
        }
    }

    void closeAllEditors() {
        Enumeration enumeration = this.m_editors.elements();
        while (enumeration.hasMoreElements()) {
            BuilderFrame builderFrame = (BuilderFrame)enumeration.nextElement();
            this.m_builder.removeEditor(builderFrame);
        }
        this.m_editors.clear();
    }

    void updateAllEditors() {
        Enumeration enumeration = this.m_editors.elements();
        while (enumeration.hasMoreElements()) {
            BuilderFrame builderFrame = (BuilderFrame)enumeration.nextElement();
            builderFrame.updateBuilder();
        }
    }

    void updateAllEditorBounds() {
        Enumeration enumeration = this.m_editors.elements();
        while (enumeration.hasMoreElements()) {
            BuilderFrame builderFrame = (BuilderFrame)enumeration.nextElement();
            Rectangle rectangle = builderFrame.getBounds();
            builderFrame.getProperties().m_properties.put("EditorBounds", "" + rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height);
        }
    }

    void updateAllTitleBars() {
        String string = (String)this.m_document.getPDMLRoot().getProperty("File Name");
        if (string.equals("")) {
            string = this.m_document.getPDMLRoot().getResourceName(true, true);
        }
        Enumeration enumeration = this.m_editors.elements();
        while (enumeration.hasMoreElements()) {
            BuilderFrame builderFrame = (BuilderFrame)enumeration.nextElement();
            builderFrame.updateTitleBar(string);
        }
    }

    void repaintAllBuilders() {
        Enumeration enumeration = this.m_editors.elements();
        while (enumeration.hasMoreElements()) {
            BuilderFrame builderFrame = (BuilderFrame)enumeration.nextElement();
            builderFrame.repaint();
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class ViewListener
    implements TreeModelListener {
        ViewListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            if (!ViewManager.this.m_document.isTemporaryEdit()) {
                TreePath treePath = treeModelEvent.getTreePath();
                Object[] objectArray = treeModelEvent.getChildren();
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                    ViewManager.this.removeEditor(mutableProperties);
                    ++n;
                }
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }
}

