/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.java.DividerPanel;
import com.ibm.as400.ui.tools.BuilderFrame;
import com.ibm.as400.ui.tools.FixedDefaultTreeModel;
import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.NodeProperties;
import com.ibm.as400.ui.tools.PDMLNodeEvent;
import com.ibm.as400.ui.tools.PDMLNodeListener;
import com.ibm.as400.ui.tools.PanelBuilder;
import com.ibm.as400.ui.tools.TreeProperties;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class TreeBuilder
extends BuilderFrame {
    JPanel m_moveToolBar;
    JPanel m_editToolBar;
    JPanel m_helpToolBar;
    JPanel m_mainToolBar;
    JTree m_tree;
    TreeBuilderCellRenderer m_cellRenderer;
    DefaultTreeModel m_treeModel;
    DefaultMutableTreeNode m_root;
    Hashtable m_nodes;
    JPopupMenu m_contextMenu;
    ActionListener m_menuListener;
    PanelBuilder m_panelBuilder;
    boolean m_allowMultipleRoots = false;
    int m_offset = 1;
    PDMLNodeListener m_pdmlNodeListener;
    TreeModelListener m_treeModelListener;

    TreeBuilder(GUIBuilder gUIBuilder, XMLGUIBuilderDefinition xMLGUIBuilderDefinition, TreeProperties treeProperties) {
        super(gUIBuilder, xMLGUIBuilderDefinition, treeProperties);
        this.m_panelBuilder = (PanelBuilder)gUIBuilder.getEditor((MutableProperties)treeProperties.getParent());
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_treeModelListener = new TreeBuilderTreeModelListener();
        treeProperties.addTreeModelListener(this.m_treeModelListener);
        this.m_pdmlNodeListener = new TreeBuilderPDMLNodeListener();
        treeProperties.addPDMLNodeListener(this.m_pdmlNodeListener);
        this.m_nodes = new Hashtable();
        TreeBuilderActionListener treeBuilderActionListener = new TreeBuilderActionListener();
        this.m_menuListener = treeBuilderActionListener;
        this.m_mainToolBar = new DividerPanel(2);
        this.m_mainToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_mainToolBar.add(GUIFactory.createButton("Add", null, null, "Add.gif", "IDTT_ADD_NODE", true, treeBuilderActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Remove", null, null, "Remove.gif", "IDTT_REMOVE_NODE", false, treeBuilderActionListener));
        this.m_editToolBar = new DividerPanel(2);
        this.m_editToolBar.setLayout(new GridLayout(1, 3, 0, 0));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Cut", null, null, "Cut.gif", "IDTT_EDIT_CUT", false, treeBuilderActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Copy", null, null, "Copy.gif", "IDTT_EDIT_COPY", false, treeBuilderActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Paste", null, null, "Paste.gif", "IDTT_EDIT_PASTE", false, treeBuilderActionListener));
        this.m_moveToolBar = new DividerPanel(2);
        this.m_moveToolBar.setLayout(new GridLayout(1, 4, 0, 0));
        this.m_moveToolBar.add(GUIFactory.createButton("Move Left", null, null, "MoveLeft.gif", "IDTT_MOVE_LEFT", false, treeBuilderActionListener));
        this.m_moveToolBar.add(GUIFactory.createButton("Move Right", null, null, "MoveRight.gif", "IDTT_MOVE_RIGHT", false, treeBuilderActionListener));
        this.m_moveToolBar.add(GUIFactory.createButton("Move Up", null, null, "MoveUp.gif", "IDTT_MOVE_UP", false, treeBuilderActionListener));
        this.m_moveToolBar.add(GUIFactory.createButton("Move Down", null, null, "MoveDown.gif", "IDTT_MOVE_DOWN", false, treeBuilderActionListener));
        this.m_helpToolBar = new JPanel();
        this.m_helpToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_helpToolBar.add(GUIFactory.createButton("Preview", null, null, "Preview.gif", "IDTT_PREVIEW", true, treeBuilderActionListener));
        this.m_helpToolBar.add(GUIFactory.createButton("Help", null, null, "Help.gif", "IDTT_HELP", true, treeBuilderActionListener));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.m_mainToolBar);
        jPanel.add(this.m_editToolBar);
        jPanel.add(this.m_moveToolBar);
        jPanel.add(this.m_helpToolBar);
        this.m_cellRenderer = new TreeBuilderCellRenderer();
        this.m_root = new DefaultMutableTreeNode(treeProperties);
        this.m_nodes.put(treeProperties, this.m_root);
        this.m_treeModel = new FixedDefaultTreeModel(this.m_root);
        this.m_tree = new JTree(this.m_treeModel);
        this.m_tree.setEditable(false);
        this.m_tree.setRootVisible(false);
        this.m_tree.setShowsRootHandles(false);
        this.m_tree.setCellRenderer(this.m_cellRenderer);
        this.m_tree.addTreeSelectionListener(new TreeBuilderTreeSelectionListener());
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.addMouseListener(new TreeBuilderMouseListener());
        ((Frame)this).setIconImage(GUIFactory.getImage("Tree.gif", true).getImage());
        this.updateTitleBar(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)new JScrollPane(this.m_tree), "Center");
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Enumeration<TreeNode> enumeration = treeProperties.children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
            this.insertProperties(mutableProperties, treeProperties, false);
            if (defaultMutableTreeNode != null) continue;
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_nodes.get(mutableProperties);
        }
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = this.m_root;
        }
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.m_tree.expandPath(treePath);
        Dimension dimension = jPanel.getPreferredSize();
        dimension.width += 10;
        if (dimension.width < 400) {
            dimension.width = 400;
        }
        dimension.height = 250;
        Dimension dimension2 = this.getPreferredSize();
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        ((Component)this).setSize(dimension);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.initContextMenu();
    }

    void initContextMenu() {
        this.m_contextMenu = new JPopupMenu();
        JMenu jMenu = GUIFactory.createMenu("Selected", "IDCM_NODE_SELECTED", null, true);
        this.m_contextMenu.add(jMenu);
        jMenu.add(GUIFactory.createMenuItem("Selected Enable", null, "IDM_SELECTED_ENABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Disable", null, "IDM_SELECTED_DISABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Refresh", null, "IDM_SELECTED_REFRESH", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Show", null, "IDM_SELECTED_SHOW", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Hide", null, "IDM_SELECTED_HIDE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Display", null, "IDM_SELECTED_DISPLAY", null, true, this.m_menuListener));
        jMenu.addSeparator();
        jMenu.add(GUIFactory.createMenuItem("Selected Other", null, "IDM_SELECTED_OTHER", null, true, this.m_menuListener));
        this.m_contextMenu.addSeparator();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_NODE_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_NODE_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_NODE_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_NODE_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        this.m_contextMenu.addSeparator();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_NODE_PROPERTIES", null, true, this.m_menuListener));
    }

    JPopupMenu getContextMenu() {
        this.m_contextMenu.getComponent(2).setEnabled(this.canCut());
        this.m_contextMenu.getComponent(3).setEnabled(this.canCopy());
        this.m_contextMenu.getComponent(4).setEnabled(this.canPaste());
        this.m_contextMenu.getComponent(5).setEnabled(this.canDelete());
        return this.m_contextMenu;
    }

    String getHelpName() {
        return "TreeBuilder";
    }

    public void stopEditing() {
    }

    boolean canAdd() {
        return true;
    }

    boolean canMoveLeft() {
        TreePath treePath = this.m_tree.getLeadSelectionPath();
        return treePath != null && treePath.getPathCount() > 2;
    }

    boolean canMoveRight() {
        TreePath treePath = this.m_tree.getLeadSelectionPath();
        if (treePath != null && treePath.getPathCount() > 1) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            return defaultMutableTreeNode.getPreviousSibling() != null;
        }
        return false;
    }

    boolean canMoveUp() {
        TreePath treePath = this.m_tree.getLeadSelectionPath();
        if (treePath != null && treePath.getPathCount() > 1) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            int n = -1;
            if (defaultMutableTreeNode2 != null) {
                n = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
            }
            return n > 0;
        }
        return false;
    }

    boolean canMoveDown() {
        TreePath treePath = this.m_tree.getLeadSelectionPath();
        if (treePath != null && treePath.getPathCount() > 1) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            int n = -1;
            int n2 = -1;
            if (defaultMutableTreeNode2 != null) {
                n = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
                n2 = defaultMutableTreeNode2.getChildCount();
            }
            return n < n2 - 1;
        }
        return false;
    }

    public boolean canCut() {
        TreePath treePath = this.m_tree.getLeadSelectionPath();
        return treePath != null && treePath.getPathCount() > 1;
    }

    public boolean canCopy() {
        TreePath treePath = this.m_tree.getLeadSelectionPath();
        return treePath != null && treePath.getPathCount() > 1;
    }

    public boolean canPaste() {
        boolean bl = false;
        Transferable transferable = this.getBuilder().getClipboard().getContents(this);
        if (transferable != null && transferable instanceof MutableProperties) {
            MutableProperties mutableProperties = (MutableProperties)transferable;
            bl = mutableProperties.getType() == 116;
        }
        return bl;
    }

    public boolean canDelete() {
        TreePath treePath = this.m_tree.getLeadSelectionPath();
        return treePath != null && treePath.getPathCount() > 1;
    }

    public MutableProperties getSelectedProperties() {
        TreePath treePath = this.m_tree.getLeadSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            return (MutableProperties)defaultMutableTreeNode.getUserObject();
        }
        return this.getProperties();
    }

    public void cut() {
        if (!this.canCut()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        MutableProperties mutableProperties = this.getSelectedProperties();
        this.getBuilder().getClipboard().setContents(mutableProperties, mutableProperties);
        this.doRemove();
        this.getPDMLDocument().endEdit();
    }

    public void copy() {
        if (!this.canCopy()) {
            return;
        }
        MutableProperties mutableProperties = this.getSelectedProperties();
        MutableProperties mutableProperties2 = mutableProperties.cloneNode(this.getPDMLDocument(), null);
        this.getBuilder().getClipboard().setContents(mutableProperties2, mutableProperties2);
    }

    public void paste() {
        if (!this.canPaste()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        Transferable transferable = this.getBuilder().getClipboard().getContents(this);
        MutableProperties mutableProperties = (MutableProperties)transferable;
        mutableProperties = ((MutableProperties)transferable).cloneNode(this.getPDMLDocument(), (TreeProperties)this.getProperties());
        mutableProperties.setPDMLDocument(this.getPDMLDocument());
        this.doInsertNodeAfterSelection((NodeProperties)mutableProperties);
        this.getPDMLDocument().endEdit();
    }

    public void delete() {
        if (!this.canDelete()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        this.doRemove();
        this.getPDMLDocument().endEdit();
    }

    void doRemove() {
        MutableProperties mutableProperties = this.getSelectedProperties();
        if (mutableProperties != null) {
            int n = this.m_tree.getMinSelectionRow();
            mutableProperties.removeFromParent();
            int n2 = this.m_tree.getRowCount();
            if (n2 > 0) {
                if (n >= n2) {
                    n = n2 - 1;
                }
                this.m_tree.setSelectionRow(n);
            }
        }
    }

    void doMoveLeft() {
        if (!this.canMoveLeft()) {
            return;
        }
        this.getPDMLDocument().beginEdit(true);
        MutableProperties mutableProperties = this.getSelectedProperties();
        MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
        MutableProperties mutableProperties3 = (MutableProperties)mutableProperties2.getParent();
        if (this.m_allowMultipleRoots || !mutableProperties3.equals(this.getProperties())) {
            int n = mutableProperties3.getIndex(mutableProperties2);
            mutableProperties.removeFromParent();
            mutableProperties3.insert(mutableProperties, n + 1);
        } else {
            mutableProperties.removeFromParent();
            mutableProperties3.add(mutableProperties);
            mutableProperties2.removeFromParent();
            mutableProperties.insert(mutableProperties2, 0 + this.m_offset);
        }
        this.getPDMLDocument().endEdit();
        this.getBuilder().updateBuilder();
    }

    void doMoveRight() {
        if (!this.canMoveRight()) {
            return;
        }
        this.getPDMLDocument().beginEdit(true);
        MutableProperties mutableProperties = this.getSelectedProperties();
        MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
        int n = mutableProperties2.getIndex(mutableProperties);
        MutableProperties mutableProperties3 = (MutableProperties)mutableProperties2.getChildAt(n - 1);
        mutableProperties.removeFromParent();
        mutableProperties3.add(mutableProperties);
        this.getPDMLDocument().endEdit();
        this.getBuilder().updateBuilder();
    }

    void doMoveUp() {
        if (!this.canMoveUp()) {
            return;
        }
        this.getPDMLDocument().beginEdit(true);
        MutableProperties mutableProperties = this.getSelectedProperties();
        MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
        int n = mutableProperties2.getIndex(mutableProperties);
        mutableProperties.removeFromParent();
        mutableProperties2.insert(mutableProperties, n - 1);
        this.getPDMLDocument().endEdit();
        this.getBuilder().updateBuilder();
    }

    void doMoveDown() {
        if (!this.canMoveDown()) {
            return;
        }
        this.getPDMLDocument().beginEdit(true);
        MutableProperties mutableProperties = this.getSelectedProperties();
        MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
        int n = mutableProperties2.getIndex(mutableProperties);
        mutableProperties.removeFromParent();
        mutableProperties2.insert(mutableProperties, n + 1);
        this.getPDMLDocument().endEdit();
        this.getBuilder().updateBuilder();
    }

    void doAdd() {
        NodeProperties nodeProperties = new NodeProperties();
        try {
            nodeProperties.setProperty("Name", ((TreeProperties)this.getProperties()).generateName(116));
            nodeProperties.setProperty("Title", GUIFactory.getString("IDS_DEFAULT_LABEL_NODE"));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        nodeProperties.setPDMLDocument(this.getPDMLDocument());
        this.doInsertNodeAfterSelection(nodeProperties);
    }

    void doInsertNodeAfterSelection(NodeProperties nodeProperties) {
        MutableProperties mutableProperties = this.getSelectedProperties();
        MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
        int n = mutableProperties2.getIndex(mutableProperties);
        if (mutableProperties.equals(this.getProperties())) {
            if (this.m_allowMultipleRoots || mutableProperties.getChildCount() == 0) {
                mutableProperties.add(nodeProperties);
            } else {
                mutableProperties2 = (MutableProperties)mutableProperties.getFirstChild();
                mutableProperties2.add(nodeProperties);
            }
        } else if (mutableProperties2.equals(this.getProperties())) {
            if (this.m_allowMultipleRoots) {
                mutableProperties2.insert(nodeProperties, n + 1);
            } else {
                mutableProperties.add(nodeProperties);
            }
        } else {
            mutableProperties2.insert(nodeProperties, n + 1);
        }
    }

    public void updateBuilder() {
        this.m_mainToolBar.getComponent(0).setEnabled(this.canAdd());
        this.m_mainToolBar.getComponent(1).setEnabled(this.canDelete());
        this.m_editToolBar.getComponent(0).setEnabled(this.canCut());
        this.m_editToolBar.getComponent(1).setEnabled(this.canCopy());
        this.m_editToolBar.getComponent(2).setEnabled(this.canPaste());
        this.m_moveToolBar.getComponent(0).setEnabled(this.canMoveLeft());
        this.m_moveToolBar.getComponent(1).setEnabled(this.canMoveRight());
        this.m_moveToolBar.getComponent(2).setEnabled(this.canMoveUp());
        this.m_moveToolBar.getComponent(3).setEnabled(this.canMoveDown());
    }

    public void updateTitleBar(String string) {
        if (string == null && (string = (String)this.getPDMLDocument().getPDMLRoot().getProperty("File Name")).equals("")) {
            string = this.getPDMLDocument().getPDMLRoot().getResourceName(true, true);
        }
        String string2 = (String)this.getProperties().getProperty("Name");
        string2 = string2 + " (" + string + ")";
        this.setTitle(string2);
    }

    void insertProperties(MutableProperties mutableProperties, MutableProperties mutableProperties2, boolean bl) {
        if (mutableProperties2.getType() != 104 && mutableProperties2.getType() != 116 || mutableProperties.getType() == 90) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(mutableProperties);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.m_nodes.get(mutableProperties2);
        int n = mutableProperties2.getIndex(mutableProperties);
        if (mutableProperties2.getType() == 116) {
            n -= this.m_offset;
        }
        this.m_treeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, n);
        this.m_nodes.put(mutableProperties, defaultMutableTreeNode);
        Enumeration<TreeNode> enumeration = mutableProperties.children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties3 = (MutableProperties)enumeration.nextElement();
            this.insertProperties(mutableProperties3, mutableProperties, false);
        }
        if (bl) {
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.m_tree.expandPath(treePath);
            this.m_tree.setSelectionPath(treePath);
        }
    }

    void removeProperties(MutableProperties mutableProperties) {
        Enumeration<TreeNode> enumeration = mutableProperties.children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties2 = (MutableProperties)enumeration.nextElement();
            this.removeProperties(mutableProperties2);
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_nodes.get(mutableProperties);
        if (defaultMutableTreeNode != null) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            this.m_treeModel.removeNodeFromParent(defaultMutableTreeNode);
            this.m_nodes.remove(mutableProperties);
        }
    }

    public void setSelectedProperties(MutableProperties mutableProperties) {
        this.m_tree.clearSelection();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_nodes.get(mutableProperties);
        if (defaultMutableTreeNode != null) {
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.m_tree.expandPath(treePath);
            this.m_tree.setSelectionPath(treePath);
        }
    }

    public void uninstallListeners() {
        this.getProperties().removePDMLNodeListener(this.m_pdmlNodeListener);
        this.getProperties().removeTreeModelListener(this.m_treeModelListener);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class TreeBuilderActionListener
    implements ActionListener {
        TreeBuilderActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Add")) {
                TreeBuilder.this.getPDMLDocument().beginEdit();
                TreeBuilder.this.doAdd();
                TreeBuilder.this.getPDMLDocument().endEdit();
                TreeBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Remove")) {
                TreeBuilder.this.getPDMLDocument().beginEdit();
                TreeBuilder.this.doRemove();
                TreeBuilder.this.getPDMLDocument().endEdit();
                TreeBuilder.this.getBuilder().updateBuilder();
            } else if (string.startsWith("Move")) {
                if ((string = string.substring(5)).equals("Up")) {
                    TreeBuilder.this.doMoveUp();
                } else if (string.equals("Down")) {
                    TreeBuilder.this.doMoveDown();
                } else if (string.equals("Left")) {
                    TreeBuilder.this.doMoveLeft();
                } else if (string.equals("Right")) {
                    TreeBuilder.this.doMoveRight();
                }
            } else if (string.startsWith("Edit")) {
                if ((string = string.substring(5)).equals("Cut")) {
                    TreeBuilder.this.cut();
                    TreeBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Copy")) {
                    TreeBuilder.this.copy();
                    TreeBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Paste")) {
                    TreeBuilder.this.paste();
                    TreeBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Delete")) {
                    TreeBuilder.this.delete();
                    TreeBuilder.this.getBuilder().updateBuilder();
                }
            } else if (string.startsWith("Selected")) {
                string = string.substring(9);
                TreeBuilder.this.m_panelBuilder.doSelectedEdit(TreeBuilder.this.getSelectedProperties(), true, string, TreeBuilder.this);
            } else if (string.equals("Preview")) {
                TreeBuilder.this.setCursor(Cursor.getPredefinedCursor(3));
                MutableProperties mutableProperties = TreeBuilder.this.getProperties();
                mutableProperties = (MutableProperties)mutableProperties.getParent();
                TreeBuilder.this.getBuilder().doPreview(mutableProperties);
                TreeBuilder.this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (string.equals("Show Properties")) {
                TreeBuilder.this.getBuilder().doShowProperties();
            } else if (string.equals("Help")) {
                TreeBuilder.this.displayHelp();
            }
        }
    }

    class TreeBuilderMouseListener
    extends MouseAdapter {
        TreeBuilderMouseListener() {
        }

        void showContextMenu(MouseEvent mouseEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            MutableProperties mutableProperties;
            MutableProperties mutableProperties2 = TreeBuilder.this.getSelectedProperties();
            TreePath treePath = TreeBuilder.this.m_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null && !mutableProperties2.equals(TreeBuilder.this.getProperties()) && mutableProperties2.equals(mutableProperties = (MutableProperties)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject())) {
                JPopupMenu jPopupMenu = TreeBuilder.this.getContextMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            TreeBuilder.this.fireSelectionChangedEvent();
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                MutableProperties mutableProperties;
                MutableProperties mutableProperties2 = TreeBuilder.this.getSelectedProperties();
                TreePath treePath = TreeBuilder.this.m_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null && !mutableProperties2.equals(TreeBuilder.this.getProperties()) && mutableProperties2.equals(mutableProperties = (MutableProperties)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject())) {
                    TreeBuilder.this.getBuilder().doEditProperty("Title");
                }
            }
        }
    }

    class TreeBuilderPDMLNodeListener
    implements PDMLNodeListener {
        TreeBuilderPDMLNodeListener() {
        }

        public void PDMLNodeChanged(PDMLNodeEvent pDMLNodeEvent) {
            TreeBuilder.this.updateTitleBar(null);
        }

        public void PDMLNodeInserted(PDMLNodeEvent pDMLNodeEvent) {
        }

        public void PDMLNodeRemoved(PDMLNodeEvent pDMLNodeEvent) {
        }
    }

    class TreeBuilderCellRenderer
    extends DefaultTreeCellRenderer {
        TreeBuilderCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            MutableProperties mutableProperties = (MutableProperties)defaultMutableTreeNode.getUserObject();
            String string = null;
            string = bl2 && !bl3 ? (String)mutableProperties.getProperty("Expanded Icon") : (String)mutableProperties.getProperty("Icon");
            if (string != null && !string.equals("")) {
                ImageIcon imageIcon = GUIFactory.getUserImage(string);
                if (imageIcon == null) {
                    imageIcon = GUIFactory.getImage("Bitmap.gif", true);
                }
                this.setIcon(imageIcon);
            }
            this.setText((String)mutableProperties.getProperty("Title"));
            return this;
        }
    }

    class TreeBuilderTreeModelListener
    implements TreeModelListener {
        TreeBuilderTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            Object[] objectArray = treeModelEvent.getChildren();
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)TreeBuilder.this.m_nodes.get(mutableProperties);
                    if (defaultMutableTreeNode != null) {
                        TreeBuilder.this.m_treeModel.nodeChanged(defaultMutableTreeNode);
                    }
                    ++n;
                }
            } else {
                TreeBuilder.this.m_treeModel.nodeChanged(TreeBuilder.this.m_root);
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            MutableProperties mutableProperties = (MutableProperties)treePath.getLastPathComponent();
            Object[] objectArray = treeModelEvent.getChildren();
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties2 = (MutableProperties)objectArray[n];
                    TreeBuilder.this.insertProperties(mutableProperties2, mutableProperties, true);
                    ++n;
                }
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            Object[] objectArray = treeModelEvent.getChildren();
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                    TreeBuilder.this.removeProperties(mutableProperties);
                    ++n;
                }
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    class TreeBuilderTreeSelectionListener
    implements TreeSelectionListener {
        TreeBuilderTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreeBuilder.this.fireSelectionChangedEvent();
        }
    }
}

