/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.java.DividerPanel;
import com.ibm.as400.ui.tools.BuilderFrame;
import com.ibm.as400.ui.tools.ColumnProperties;
import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.ItemProperties;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.PDMLNodeEvent;
import com.ibm.as400.ui.tools.PDMLNodeListener;
import com.ibm.as400.ui.tools.PanelBuilder;
import com.ibm.as400.ui.tools.PropertyTableModel;
import com.ibm.as400.ui.tools.TableBuilderTable;
import com.ibm.as400.ui.tools.TableProperties;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class TableBuilder
extends BuilderFrame {
    static final DataFlavor itemArrayFlavor = new DataFlavor(class$com$ibm$as400$ui$tools$TableBuilder$ItemPropertiesArray == null ? (class$com$ibm$as400$ui$tools$TableBuilder$ItemPropertiesArray = TableBuilder.class$("com.ibm.as400.ui.tools.TableBuilder$ItemPropertiesArray")) : class$com$ibm$as400$ui$tools$TableBuilder$ItemPropertiesArray, "PDML Item Array");
    JPanel m_mainToolBar;
    JPanel m_moveToolBar;
    JPanel m_editToolBar;
    JPanel m_helpToolBar;
    JToggleButton m_autoResizeButton;
    JTable m_table;
    JScrollPane m_scroll;
    PropertyTableModel m_tableModel;
    TableBuilderTableModelListener m_modelListener;
    int m_offset = 2;
    JPopupMenu m_contextMenu;
    JPopupMenu m_columnContextMenu;
    ActionListener m_menuListener;
    PanelBuilder m_panelBuilder;
    int m_lastMovedTo = -1;
    int m_moveIndex = -1;
    PDMLNodeListener m_pdmlNodeListener;
    TreeModelListener m_treeModelListener;
    static /* synthetic */ Class class$com$ibm$as400$ui$tools$TableBuilder$ItemPropertiesArray;
    static /* synthetic */ Class class$java$lang$Object;

    TableBuilder(GUIBuilder gUIBuilder, XMLGUIBuilderDefinition xMLGUIBuilderDefinition, TableProperties tableProperties) {
        super(gUIBuilder, xMLGUIBuilderDefinition, tableProperties);
        this.m_panelBuilder = (PanelBuilder)gUIBuilder.getEditor((MutableProperties)tableProperties.getParent());
        this.m_treeModelListener = new TableBuilderTreeModelListener();
        tableProperties.addTreeModelListener(this.m_treeModelListener);
        this.m_pdmlNodeListener = new TablePDMLNodeListener();
        tableProperties.addPDMLNodeListener(this.m_pdmlNodeListener);
        this.removeKeyListener(this.m_keyListener);
        TableActionListener tableActionListener = new TableActionListener();
        this.m_menuListener = tableActionListener;
        this.m_mainToolBar = new DividerPanel(2);
        this.m_mainToolBar.setLayout(new GridLayout(1, 4, 0, 0));
        this.m_mainToolBar.add(GUIFactory.createButton("Add Column", null, null, "AddColumn.gif", "IDTT_ADD_COLUMN", true, tableActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Add Row", null, null, "AddRow.gif", "IDTT_ADD_ROW", true, tableActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Remove Column", null, null, "RemoveColumn.gif", "IDTT_REMOVE_COLUMN", false, tableActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Remove Row", null, null, "RemoveRow.gif", "IDTT_REMOVE_ROW", false, tableActionListener));
        this.m_moveToolBar = new DividerPanel(2);
        this.m_moveToolBar.setLayout(new GridLayout(1, 3, 0, 0));
        this.m_moveToolBar.add(GUIFactory.createButton("Move Up", null, null, "MoveUp.gif", "IDTT_MOVE_UP", false, tableActionListener));
        this.m_moveToolBar.add(GUIFactory.createButton("Move Down", null, null, "MoveDown.gif", "IDTT_MOVE_DOWN", false, tableActionListener));
        this.m_autoResizeButton = GUIFactory.createToggleButton("Auto Resize", null, null, "Table.gif", "IDTT_AUTO_RESIZE", true, false, null, tableActionListener);
        this.m_moveToolBar.add(this.m_autoResizeButton);
        this.m_editToolBar = new DividerPanel(2);
        this.m_editToolBar.setLayout(new GridLayout(1, 3, 0, 0));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Cut", null, null, "Cut.gif", "IDTT_EDIT_CUT", false, tableActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Copy", null, null, "Copy.gif", "IDTT_EDIT_COPY", false, tableActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Paste", null, null, "Paste.gif", "IDTT_EDIT_PASTE", false, tableActionListener));
        this.m_helpToolBar = new JPanel();
        this.m_helpToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_helpToolBar.add(GUIFactory.createButton("Preview", null, null, "Preview.gif", "IDTT_PREVIEW", true, tableActionListener));
        this.m_helpToolBar.add(GUIFactory.createButton("Help", null, null, "Help.gif", "IDTT_HELP", true, tableActionListener));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.m_mainToolBar);
        jPanel.add(this.m_editToolBar);
        jPanel.add(this.m_moveToolBar);
        jPanel.add(this.m_helpToolBar);
        this.m_tableModel = new PropertyTableModel(tableProperties.getType());
        this.m_table = new TableBuilderTable(gUIBuilder, this.m_tableModel, tableProperties);
        this.m_table.getTableHeader().setUI((TableHeaderUI)new com.ibm.as400.ui.framework.java.TableHeaderUI());
        this.m_table.setOpaque(true);
        this.m_table.setShowGrid(true);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setColumnSelectionAllowed(false);
        this.m_table.setCellSelectionEnabled(false);
        this.m_table.setAutoResizeMode(0);
        this.m_table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = TableBuilder.class$("java.lang.Object")) : class$java$lang$Object, new TableBuilderCellRenderer());
        this.m_table.getTableHeader().setReorderingAllowed(true);
        this.m_table.getTableHeader().addMouseListener(new TableHeaderMouseListener());
        this.m_table.addMouseListener(new TableMouseListener());
        this.m_table.getSelectionModel().setSelectionMode(0);
        TableBuilderSelectionListener tableBuilderSelectionListener = new TableBuilderSelectionListener();
        this.m_table.getSelectionModel().addListSelectionListener(tableBuilderSelectionListener);
        this.m_table.getColumnModel().getSelectionModel().addListSelectionListener(tableBuilderSelectionListener);
        this.m_table.getColumnModel().addColumnModelListener(new TableBuilderColumnModelListener());
        this.m_table.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                TableBuilder.this.stopEditing();
            }
        });
        this.m_modelListener = new TableBuilderTableModelListener();
        this.m_tableModel.addTableModelListener(this.m_modelListener);
        ((Frame)this).setIconImage(GUIFactory.getImage("Table.gif", true).getImage());
        this.updateTitleBar(null);
        this.m_scroll = new JScrollPane(this.m_table);
        this.getContentPane().setBackground(this.m_table.getBackground());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)this.m_scroll, "Center");
        this.refresh();
        Dimension dimension = jPanel.getPreferredSize();
        dimension.width += 10;
        if (dimension.width < 400) {
            dimension.width = 400;
        }
        dimension.height = 250;
        Dimension dimension2 = this.getPreferredSize();
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        ((Component)this).setSize(dimension);
        this.initContextMenus();
    }

    void initContextMenus() {
        this.m_contextMenu = new JPopupMenu();
        JMenu jMenu = GUIFactory.createMenu("Selected", "IDCM_ITEM_SELECTED", null, true);
        this.m_contextMenu.add(jMenu);
        jMenu.add(GUIFactory.createMenuItem("Selected Enable", null, "IDM_SELECTED_ENABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Disable", null, "IDM_SELECTED_DISABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Refresh", null, "IDM_SELECTED_REFRESH", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Show", null, "IDM_SELECTED_SHOW", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Hide", null, "IDM_SELECTED_HIDE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Display", null, "IDM_SELECTED_DISPLAY", null, true, this.m_menuListener));
        jMenu.addSeparator();
        jMenu.add(GUIFactory.createMenuItem("Selected Other", null, "IDM_SELECTED_OTHER", null, true, this.m_menuListener));
        this.m_contextMenu.addSeparator();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_ITEM_EDIT_CUT", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_ITEM_EDIT_COPY", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_ITEM_EDIT_PASTE", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_ITEM_EDIT_DELETE", null, false, this.m_menuListener));
        this.m_contextMenu.addSeparator();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_ITEM_PROPERTIES", null, true, this.m_menuListener));
        this.m_columnContextMenu = new JPopupMenu();
        this.m_columnContextMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_COLUMN_EDIT_CUT", null, false, this.m_menuListener));
        this.m_columnContextMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_COLUMN_EDIT_COPY", null, false, this.m_menuListener));
        this.m_columnContextMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_COLUMN_EDIT_PASTE", null, false, this.m_menuListener));
        this.m_columnContextMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_COLUMN_EDIT_DELETE", null, false, this.m_menuListener));
        this.m_columnContextMenu.addSeparator();
        this.m_columnContextMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_COLUMN_PROPERTIES", null, true, this.m_menuListener));
    }

    JPopupMenu getContextMenu(MutableProperties mutableProperties) {
        int n;
        boolean bl = mutableProperties.getType() == 113;
        JPopupMenu jPopupMenu = bl ? this.m_columnContextMenu : this.m_contextMenu;
        int n2 = n = bl ? 0 : 2;
        if (!bl) {
            MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
            boolean bl2 = (Boolean)mutableProperties2.getProperty("Primary");
            jPopupMenu.getComponent(0).setEnabled(bl2);
        }
        jPopupMenu.getComponent(0 + n).setEnabled(this.canCut());
        jPopupMenu.getComponent(1 + n).setEnabled(this.canCopy());
        jPopupMenu.getComponent(2 + n).setEnabled(this.canPaste());
        jPopupMenu.getComponent(3 + n).setEnabled(this.canDelete());
        return jPopupMenu;
    }

    String getHelpName() {
        return "TableBuilder";
    }

    public void stopEditing() {
        if (this.m_table.isEditing()) {
            ((DefaultCellEditor)this.m_table.getCellEditor()).stopCellEditing();
        }
    }

    public boolean canCut() {
        MutableProperties mutableProperties = this.getSelectedProperties();
        if (mutableProperties != null) {
            int n = mutableProperties.getType();
            if (n == 113) {
                int n2 = this.getProperties().getChildCount() - 2;
                return n2 > 1;
            }
            return n != 103;
        }
        return false;
    }

    public boolean canCopy() {
        MutableProperties mutableProperties = this.getSelectedProperties();
        if (mutableProperties != null) {
            return mutableProperties.getType() != 103;
        }
        return false;
    }

    public boolean canPaste() {
        Transferable transferable = this.getBuilder().getClipboard().getContents(this);
        if (transferable != null) {
            if (transferable instanceof MutableProperties) {
                MutableProperties mutableProperties = (MutableProperties)transferable;
                return mutableProperties.getType() == 113;
            }
            if (transferable instanceof ItemPropertiesArray) {
                return true;
            }
        }
        return false;
    }

    public boolean canDelete() {
        MutableProperties mutableProperties = this.getSelectedProperties();
        if (mutableProperties != null) {
            int n = mutableProperties.getType();
            if (n == 113) {
                int n2 = this.getProperties().getChildCount() - 2;
                return n2 > 1;
            }
            return n != 103;
        }
        return false;
    }

    public void cut() {
        if (!this.canCut()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        MutableProperties mutableProperties = this.getSelectedProperties();
        if (mutableProperties.getType() == 113) {
            this.doRemoveColumn();
            this.getBuilder().getClipboard().setContents(mutableProperties, mutableProperties);
        } else {
            MutableProperties[] mutablePropertiesArray = this.getRowSelection();
            int n = mutablePropertiesArray.length;
            MutableProperties[] mutablePropertiesArray2 = new MutableProperties[n];
            int n2 = 0;
            while (n2 < n) {
                mutablePropertiesArray[n2].removeFromParent();
                mutablePropertiesArray2[n2] = mutablePropertiesArray[n2];
                ++n2;
            }
            this.getBuilder().getClipboard().setContents(new ItemPropertiesArray(mutablePropertiesArray2), mutablePropertiesArray2[0]);
            this.m_table.getSelectionModel().clearSelection();
            this.m_table.getColumnModel().getSelectionModel().clearSelection();
            this.m_table.setColumnSelectionAllowed(false);
        }
        this.getPDMLDocument().endEdit();
    }

    public void copy() {
        if (!this.canCopy()) {
            return;
        }
        MutableProperties mutableProperties = this.getSelectedProperties();
        if (mutableProperties.getType() == 113) {
            MutableProperties mutableProperties2 = mutableProperties.cloneNode(this.getPDMLDocument(), null);
            this.getBuilder().getClipboard().setContents(mutableProperties2, mutableProperties2);
        } else {
            MutableProperties[] mutablePropertiesArray = this.getRowSelection();
            int n = mutablePropertiesArray.length;
            MutableProperties[] mutablePropertiesArray2 = new MutableProperties[n];
            int n2 = 0;
            while (n2 < n) {
                mutablePropertiesArray2[n2] = mutablePropertiesArray[n2].cloneNode(this.getPDMLDocument(), null);
                ++n2;
            }
            this.getBuilder().getClipboard().setContents(new ItemPropertiesArray(mutablePropertiesArray2), mutablePropertiesArray2[0]);
        }
    }

    public void paste() {
        if (!this.canPaste()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        Transferable transferable = this.getBuilder().getClipboard().getContents(this);
        if (transferable instanceof MutableProperties) {
            boolean bl;
            int n = this.m_tableModel.getRowCount();
            MutableProperties mutableProperties = ((MutableProperties)transferable).cloneNode(this.getPDMLDocument(), (TableProperties)this.getProperties());
            mutableProperties.setPDMLDocument(this.getPDMLDocument());
            try {
                mutableProperties.setProperty("Primary", new Boolean(false));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            boolean bl2 = bl = !this.m_autoResizeButton.isSelected();
            if (!bl) {
                try {
                    mutableProperties.setProperty("Width", new Integer(0));
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                int n2 = (Integer)mutableProperties.getProperty("Width");
                if (n2 <= 0) {
                    try {
                        mutableProperties.setProperty("Width", new Integer(75));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
            mutableProperties.setPropertyEditable("Width", bl);
            int n3 = mutableProperties.getChildCount();
            if (n < n3) {
                while (n3 != n) {
                    ItemProperties itemProperties = (ItemProperties)mutableProperties.getLastChild();
                    itemProperties.removeFromParent();
                    --n3;
                }
            } else if (n > n3) {
                while (n3 != n) {
                    ItemProperties itemProperties = new ItemProperties(this.getPDMLDocument());
                    try {
                        itemProperties.setProperty("Name", ((TableProperties)this.getProperties()).generateName(115));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    mutableProperties.add(itemProperties);
                    ++n3;
                }
            }
            MutableProperties mutableProperties2 = this.getColumnSelection();
            if (mutableProperties2 == null) {
                this.getProperties().add(mutableProperties);
            } else {
                this.getProperties().insert(mutableProperties, this.getProperties().getIndex(mutableProperties2) + 1);
            }
        } else if (transferable instanceof ItemPropertiesArray) {
            MutableProperties[] mutablePropertiesArray = ((ItemPropertiesArray)transferable).getArray();
            int n = mutablePropertiesArray.length;
            int n4 = this.m_table.getColumnModel().getColumnCount();
            int n5 = this.getSelectedRow();
            MutableProperties[] mutablePropertiesArray2 = new MutableProperties[n4];
            int n6 = 0;
            while (n6 < n4) {
                ColumnProperties columnProperties = this.getColumnAtIndex(n6);
                if (n6 < n) {
                    mutablePropertiesArray2[n6] = mutablePropertiesArray[n6].cloneNode(this.getPDMLDocument(), (TableProperties)this.getProperties());
                    mutablePropertiesArray2[n6].setPDMLDocument(this.getPDMLDocument());
                } else {
                    mutablePropertiesArray2[n6] = new ItemProperties(this.getPDMLDocument());
                    try {
                        mutablePropertiesArray2[n6].setProperty("Name", ((TableProperties)this.getProperties()).generateName(115));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                if (n5 > -1) {
                    columnProperties.insert(mutablePropertiesArray2[n6], n5 + 1);
                } else {
                    columnProperties.add(mutablePropertiesArray2[n6]);
                }
                ++n6;
            }
        }
        this.getPDMLDocument().endEdit();
    }

    public void delete() {
        if (!this.canDelete()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        MutableProperties mutableProperties = this.getSelectedProperties();
        if (mutableProperties.getType() == 113) {
            this.doRemoveColumn();
        } else {
            MutableProperties[] mutablePropertiesArray = this.getRowSelection();
            int n = mutablePropertiesArray.length;
            int n2 = 0;
            while (n2 < n) {
                mutablePropertiesArray[n2].removeFromParent();
                ++n2;
            }
            this.m_table.getSelectionModel().clearSelection();
            this.m_table.getColumnModel().getSelectionModel().clearSelection();
            this.m_table.setColumnSelectionAllowed(false);
        }
        this.getPDMLDocument().endEdit();
    }

    public MutableProperties getSelectedProperties() {
        MutableProperties[] mutablePropertiesArray = this.getRowSelection();
        MutableProperties mutableProperties = this.getColumnSelection();
        if (mutablePropertiesArray != null && mutableProperties != null) {
            return mutablePropertiesArray[this.m_table.getSelectedColumn()];
        }
        if (mutableProperties != null) {
            return mutableProperties;
        }
        return this.getProperties();
    }

    MutableProperties getColumnSelection() {
        int n = this.m_table.getSelectedColumn();
        if (n > -1 && n < this.m_table.getColumnModel().getColumnCount()) {
            return (MutableProperties)this.m_table.getColumnModel().getColumn(n).getHeaderValue();
        }
        return null;
    }

    MutableProperties[] getRowSelection() {
        int n = this.getSelectedRow();
        int n2 = this.m_table.getColumnModel().getColumnCount();
        if (n > -1 && n < this.m_tableModel.getRowCount() && n2 > 0) {
            MutableProperties[] mutablePropertiesArray = new MutableProperties[n2];
            int n3 = 0;
            while (n3 < n2) {
                mutablePropertiesArray[n3] = (MutableProperties)this.m_tableModel.getValueAt(n, n3);
                ++n3;
            }
            return mutablePropertiesArray;
        }
        return null;
    }

    ItemProperties getItemAtLocation(int n, int n2) {
        ColumnProperties columnProperties = this.getColumnAtIndex(n2);
        if (columnProperties != null) {
            return (ItemProperties)columnProperties.getChildAt(n);
        }
        return null;
    }

    ColumnProperties getColumnAtIndex(int n) {
        return (ColumnProperties)this.getProperties().getChildAt(n + this.m_offset);
    }

    int getColumnIndex(MutableProperties mutableProperties) {
        return this.getProperties().getIndex(mutableProperties) - this.m_offset;
    }

    void refresh() {
        ColumnProperties columnProperties;
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        Vector<ColumnProperties> vector = new Vector<ColumnProperties>();
        Enumeration<TreeNode> enumeration = this.getProperties().children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
            if (mutableProperties.getType() != 113) continue;
            columnProperties = (ColumnProperties)mutableProperties;
            ++n2;
            if (bl) {
                int n3 = (Integer)columnProperties.getProperty("Width");
                bl = n3 > 0;
            }
            vector.addElement(columnProperties);
            int n4 = columnProperties.getChildCount();
            if (n4 <= n) continue;
            n = n4;
        }
        Vector vector2 = new Vector(n);
        int n5 = 0;
        while (n5 < n) {
            Vector<ItemProperties> vector3 = new Vector<ItemProperties>(n2);
            int n6 = 0;
            while (n6 < n2) {
                columnProperties = (ColumnProperties)vector.elementAt(n6);
                ItemProperties itemProperties = n5 < columnProperties.getChildCount() ? (ItemProperties)columnProperties.getChildAt(n5) : null;
                vector3.addElement(itemProperties);
                ++n6;
            }
            vector2.addElement(vector3);
            ++n5;
        }
        this.m_tableModel.setDataVector(vector2, vector);
        this.m_table.getTableHeader().setResizingAllowed(bl);
        this.m_autoResizeButton.setSelected(!bl);
        if (bl) {
            this.m_table.setAutoResizeMode(0);
        } else {
            this.m_table.setAutoResizeMode(4);
        }
        this.resetTableColumns();
        this.m_table.getSelectionModel().clearSelection();
        this.m_table.getColumnModel().getSelectionModel().clearSelection();
        this.m_table.setColumnSelectionAllowed(false);
        if (!bl) {
            this.m_table.sizeColumnsToFit(-1);
        }
        this.m_table.revalidate();
        this.m_table.repaint();
        this.m_scroll.getViewport().invalidate();
        this.m_scroll.validate();
    }

    void resetTableColumns() {
        boolean bl = !this.m_autoResizeButton.isSelected();
        int n = this.m_table.getColumnModel().getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = this.m_table.getColumnModel().getColumn(n2);
            ColumnProperties columnProperties = this.getColumnAtIndex(n2);
            tableColumn.setHeaderValue(columnProperties);
            tableColumn.setHeaderRenderer(new TableBuilderHeaderRenderer());
            columnProperties.setPropertyEditable("Width", bl);
            if (bl) {
                int n3 = (Integer)columnProperties.getProperty("Width");
                tableColumn.setWidth(n3);
                tableColumn.setPreferredWidth(n3);
            }
            ++n2;
        }
    }

    void insertProperties(MutableProperties mutableProperties, MutableProperties mutableProperties2, int n, boolean bl) {
        if (mutableProperties.getType() == 115) {
            int n2 = this.getColumnIndex(mutableProperties2);
            int n3 = this.m_table.getColumnModel().getColumnCount();
            Object[] objectArray = new Object[n3];
            Vector<Vector> vector = this.m_tableModel.getDataVector();
            int n4 = vector.size();
            if (n >= 0) {
                if (n < n4) {
                    Vector vector2 = vector.elementAt(n);
                    int n5 = 0;
                    while (n5 < n3) {
                        if (n5 == n2) {
                            this.m_tableModel.setValueAt(mutableProperties, n, n2);
                        }
                        ++n5;
                    }
                } else {
                    Vector<MutableProperties> vector3 = new Vector<MutableProperties>(n3);
                    int n6 = 0;
                    while (n6 < n3) {
                        if (n6 == n2) {
                            vector3.addElement(mutableProperties);
                        } else {
                            vector3.addElement(null);
                        }
                        ++n6;
                    }
                    this.m_tableModel.addRow(vector3);
                }
            }
            if (bl) {
                this.m_table.setRowSelectionInterval(n, n);
                this.m_table.setColumnSelectionInterval(n2, n2);
                this.m_table.scrollRectToVisible(this.m_table.getCellRect(n, n2, true));
            }
        } else {
            this.m_tableModel.addColumn(mutableProperties);
            int n7 = 0;
            Enumeration<TreeNode> enumeration = mutableProperties.children();
            while (enumeration.hasMoreElements()) {
                MutableProperties mutableProperties3 = (MutableProperties)enumeration.nextElement();
                this.insertProperties(mutableProperties3, mutableProperties, n7, bl);
                ++n7;
            }
            this.refresh();
            if (bl) {
                int n8 = this.getSelectedRow();
                this.m_table.getSelectionModel().clearSelection();
                this.m_table.setColumnSelectionInterval(n, n);
                this.m_table.scrollRectToVisible(this.m_table.getCellRect(n8, n, true));
            }
        }
        this.m_table.revalidate();
        this.m_table.repaint();
    }

    void removeProperties(MutableProperties mutableProperties, MutableProperties mutableProperties2, int n) {
        if (mutableProperties.getType() == 115) {
            Vector<Vector> vector = this.m_tableModel.getDataVector();
            int n2 = vector.size();
            if (n >= 0 && n < n2) {
                int n3 = this.getColumnIndex(mutableProperties2);
                Vector vector2 = vector.elementAt(n);
                this.m_tableModel.setValueAt(null, n, n3);
                boolean bl = true;
                int n4 = this.m_table.getColumnModel().getColumnCount();
                int n5 = 0;
                while (n5 < n4) {
                    MutableProperties mutableProperties3 = (MutableProperties)vector2.elementAt(n5);
                    if (mutableProperties3 != null) {
                        bl = false;
                        break;
                    }
                    ++n5;
                }
                if (bl) {
                    this.m_tableModel.removeRow(n);
                }
            }
        } else {
            this.m_tableModel.removeColumn(n);
            this.refresh();
        }
        this.m_table.revalidate();
        this.m_table.repaint();
    }

    void doAddRow() {
        int n = this.m_table.getSelectedColumn();
        if (n == -1) {
            n = 0;
        }
        int n2 = this.m_table.getColumnModel().getColumnCount();
        int n3 = this.getSelectedRow();
        Object var6_4 = null;
        int n4 = 0;
        while (n4 < n2) {
            ItemProperties itemProperties = new ItemProperties();
            try {
                itemProperties.setProperty("Name", ((TableProperties)this.getProperties()).generateName(115));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            itemProperties.setPDMLDocument(this.getPDMLDocument());
            ColumnProperties columnProperties = this.getColumnAtIndex(n4);
            if (n3 > -1) {
                columnProperties.insert(itemProperties, n3 + 1);
            } else {
                columnProperties.add(itemProperties);
            }
            ++n4;
        }
        int n5 = this.m_table.getRowCount() - 1;
        if (n3 > -1) {
            n5 = n3 + 1;
        }
        this.m_table.setRowSelectionInterval(n5, n5);
        this.m_table.setColumnSelectionInterval(n, n);
    }

    void doAddColumn() {
        boolean bl = !this.m_autoResizeButton.isSelected();
        int n = this.m_table.getColumnModel().getColumnCount();
        ColumnProperties columnProperties = new ColumnProperties();
        columnProperties.setPropertyEditable("Width", bl);
        int n2 = 75;
        try {
            columnProperties.setProperty("Name", ((TableProperties)this.getProperties()).generateName(113));
            columnProperties.setProperty("Title", GUIFactory.getString("IDS_DEFAULT_LABEL_COLUMN") + (n + 1));
            if (bl) {
                columnProperties.setProperty("Width", new Integer(n2));
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        columnProperties.setPDMLDocument(this.getPDMLDocument());
        MutableProperties mutableProperties = this.getColumnSelection();
        if (mutableProperties == null) {
            this.getProperties().add(columnProperties);
        } else {
            this.getProperties().insert(columnProperties, this.getProperties().getIndex(mutableProperties) + 1);
        }
        int n3 = this.m_table.getSelectedColumn();
        int n4 = this.m_tableModel.getRowCount();
        int n5 = 0;
        while (n5 < n4) {
            ItemProperties itemProperties = new ItemProperties();
            try {
                itemProperties.setProperty("Name", ((TableProperties)this.getProperties()).generateName(115));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            itemProperties.setPDMLDocument(this.getPDMLDocument());
            columnProperties.add(itemProperties);
            ++n5;
        }
        this.m_table.getTableHeader().requestFocus();
        this.m_table.getSelectionModel().clearSelection();
        this.m_table.setColumnSelectionInterval(n3, n3);
    }

    void doRemoveRow() {
        int n;
        MutableProperties[] mutablePropertiesArray = this.getRowSelection();
        int n2 = this.getSelectedRow();
        if (mutablePropertiesArray != null) {
            n = mutablePropertiesArray.length;
            int n3 = 0;
            while (n3 < n) {
                mutablePropertiesArray[n3].removeFromParent();
                ++n3;
            }
        }
        this.m_table.getSelectionModel().clearSelection();
        this.m_table.getColumnModel().getSelectionModel().clearSelection();
        this.m_table.setColumnSelectionAllowed(false);
        n = this.m_table.getRowCount();
        if (n > 0) {
            if (n2 >= n) {
                n2 = n - 1;
            }
            this.m_table.setRowSelectionInterval(n2, n2);
        }
    }

    void doRemoveColumn() {
        MutableProperties mutableProperties = this.getColumnSelection();
        int n = this.m_table.getSelectedColumn();
        if (mutableProperties != null) {
            mutableProperties.removeFromParent();
        }
        this.m_table.getSelectionModel().clearSelection();
        this.m_table.getColumnModel().getSelectionModel().clearSelection();
        this.m_table.setColumnSelectionAllowed(false);
        int n2 = this.m_table.getColumnCount();
        if (n2 > 0) {
            if (n >= n2) {
                n = n2 - 1;
            }
            this.m_table.setColumnSelectionInterval(n, n);
        }
    }

    void doMoveUp() {
        MutableProperties[] mutablePropertiesArray = this.getRowSelection();
        if (mutablePropertiesArray != null) {
            int n = mutablePropertiesArray.length;
            int n2 = 0;
            while (n2 < n) {
                MutableProperties mutableProperties = mutablePropertiesArray[n2];
                MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
                int n3 = mutableProperties2.getIndex(mutableProperties);
                mutableProperties.removeFromParent();
                mutableProperties2.insert(mutableProperties, n3 - 1);
                ++n2;
            }
        }
    }

    void doMoveDown() {
        MutableProperties[] mutablePropertiesArray = this.getRowSelection();
        if (mutablePropertiesArray != null) {
            int n = mutablePropertiesArray.length;
            int n2 = 0;
            while (n2 < n) {
                MutableProperties mutableProperties = mutablePropertiesArray[n2];
                MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
                int n3 = mutableProperties2.getIndex(mutableProperties);
                mutableProperties.removeFromParent();
                mutableProperties2.insert(mutableProperties, n3 + 1);
                ++n2;
            }
        }
    }

    public void updateBuilder() {
        boolean bl;
        boolean bl2;
        int n = this.getSelectedRow();
        int n2 = this.m_table.getSelectedColumn();
        int n3 = this.m_tableModel.getRowCount();
        int n4 = this.m_table.getColumnModel().getColumnCount();
        boolean bl3 = n > -1 && n3 > 0;
        boolean bl4 = bl2 = n2 > -1 && n4 > 1 && n == -1;
        boolean bl5 = bl3 ? n > 0 : (bl = false);
        boolean bl6 = bl3 ? n < n3 - 1 : false;
        this.m_mainToolBar.getComponent(2).setEnabled(bl2);
        this.m_mainToolBar.getComponent(3).setEnabled(bl3);
        this.m_moveToolBar.getComponent(0).setEnabled(bl);
        this.m_moveToolBar.getComponent(1).setEnabled(bl6);
        this.m_editToolBar.getComponent(0).setEnabled(this.canCut());
        this.m_editToolBar.getComponent(1).setEnabled(this.canCopy());
        this.m_editToolBar.getComponent(2).setEnabled(this.canPaste());
        this.repaint();
    }

    public void updateTitleBar(String string) {
        if (string == null && (string = (String)this.getPDMLDocument().getPDMLRoot().getProperty("File Name")).equals("")) {
            string = this.getPDMLDocument().getPDMLRoot().getResourceName(true, true);
        }
        String string2 = (String)this.getProperties().getProperty("Name");
        string2 = string2 + " (" + string + ")";
        this.setTitle(string2);
    }

    int getSelectedRow() {
        int[] nArray = this.m_table.getSelectedRows();
        if (nArray.length == 0) {
            return -1;
        }
        return nArray[0];
    }

    public void setSelectedProperties(MutableProperties mutableProperties) {
        block6: {
            int n;
            block5: {
                int n2 = this.getSelectedRow();
                this.m_table.getSelectionModel().clearSelection();
                n = this.m_table.getColumnModel().getColumnCount();
                if (mutableProperties.getType() != 113) break block5;
                int n3 = 0;
                while (n3 < n) {
                    MutableProperties mutableProperties2 = (MutableProperties)this.m_table.getColumnModel().getColumn(n3).getHeaderValue();
                    if (mutableProperties2.equals(mutableProperties)) {
                        this.m_table.setColumnSelectionInterval(n3, n3);
                        this.m_table.scrollRectToVisible(this.m_table.getCellRect(n2, n3, true));
                        return;
                    }
                    ++n3;
                }
                break block6;
            }
            if (mutableProperties.getType() != 115) break block6;
            int n4 = this.m_table.getRowCount();
            int n5 = 0;
            while (n5 < n4) {
                int n6 = 0;
                while (n6 < n) {
                    MutableProperties mutableProperties3 = (MutableProperties)this.m_table.getValueAt(n5, n6);
                    if (mutableProperties3.equals(mutableProperties)) {
                        this.m_table.setRowSelectionInterval(n5, n5);
                        this.m_table.setColumnSelectionInterval(n6, n6);
                        this.m_table.scrollRectToVisible(this.m_table.getCellRect(n5, n6, true));
                        return;
                    }
                    ++n6;
                }
                ++n5;
            }
        }
    }

    public void uninstallListeners() {
        this.getProperties().removePDMLNodeListener(this.m_pdmlNodeListener);
        this.getProperties().removeTreeModelListener(this.m_treeModelListener);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TableMouseListener
    extends MouseAdapter {
        TableMouseListener() {
        }

        void showContextMenu(MouseEvent mouseEvent) {
            int n = TableBuilder.this.m_table.rowAtPoint(mouseEvent.getPoint());
            int n2 = TableBuilder.this.m_table.columnAtPoint(mouseEvent.getPoint());
            if (n != -1 && n == TableBuilder.this.getSelectedRow() && n2 > -1) {
                JPopupMenu jPopupMenu = TableBuilder.this.getContextMenu(TableBuilder.this.getSelectedProperties());
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }
    }

    class ItemPropertiesArray
    implements Transferable {
        DataFlavor[] m_flavors = new DataFlavor[]{itemArrayFlavor, DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};
        MutableProperties[] m_array;

        ItemPropertiesArray(MutableProperties[] mutablePropertiesArray) {
            this.m_array = mutablePropertiesArray;
        }

        MutableProperties[] getArray() {
            return this.m_array;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.m_flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            int n = 0;
            while (n < this.m_flavors.length) {
                if (this.m_flavors[n].equals(dataFlavor)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(this.m_flavors[0])) {
                return this;
            }
            if (dataFlavor.equals(this.m_flavors[1])) {
                return this.toString();
            }
            if (dataFlavor.equals(this.m_flavors[2])) {
                return new StringReader(this.toString());
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }

    class TableBuilderColumnModelListener
    implements TableColumnModelListener {
        TableBuilderColumnModelListener() {
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            int n;
            int n2 = tableColumnModelEvent.getFromIndex();
            TableBuilder.this.m_lastMovedTo = n = tableColumnModelEvent.getToIndex();
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    class TableHeaderMouseListener
    extends MouseAdapter {
        TableHeaderMouseListener() {
        }

        void showContextMenu(MouseEvent mouseEvent) {
            int n = TableBuilder.this.m_table.getTableHeader().columnAtPoint(mouseEvent.getPoint());
            if (n > -1) {
                JPopupMenu jPopupMenu = TableBuilder.this.getContextMenu(TableBuilder.this.getSelectedProperties());
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            } else if (TableBuilder.this.m_moveIndex != -1) {
                MutableProperties mutableProperties = TableBuilder.this.getProperties();
                XMLGUIBuilderDefinition xMLGUIBuilderDefinition = mutableProperties.getPDMLDocument();
                MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getChildAt(TableBuilder.this.m_moveIndex);
                if (TableBuilder.this.m_lastMovedTo != -1) {
                    TableBuilder.this.m_lastMovedTo += TableBuilder.this.m_offset;
                    xMLGUIBuilderDefinition.beginEdit(true);
                    mutableProperties2.removeFromParent();
                    mutableProperties.insert(mutableProperties2, TableBuilder.this.m_lastMovedTo);
                    xMLGUIBuilderDefinition.endEdit();
                    TableBuilder.this.getBuilder().updateBuilder();
                    TableBuilder.this.refresh();
                    TableBuilder.this.m_lastMovedTo -= TableBuilder.this.m_offset;
                    TableBuilder.this.m_table.setColumnSelectionInterval(TableBuilder.this.m_lastMovedTo, TableBuilder.this.m_lastMovedTo);
                } else {
                    boolean bl;
                    boolean bl2 = bl = !TableBuilder.this.m_autoResizeButton.isSelected();
                    if (bl) {
                        int n = (Integer)mutableProperties2.getProperty("Width");
                        TableBuilder.this.m_moveIndex -= TableBuilder.this.m_offset;
                        int n2 = TableBuilder.this.m_table.getColumnModel().getColumn(TableBuilder.this.m_moveIndex).getWidth();
                        if (n != n2) {
                            xMLGUIBuilderDefinition.beginEdit();
                            try {
                                mutableProperties2.setProperty("Width", new Integer(n2));
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                            xMLGUIBuilderDefinition.endEdit();
                            TableBuilder.this.getBuilder().updateBuilder();
                        }
                    }
                }
            }
            TableBuilder.this.m_moveIndex = -1;
            TableBuilder.this.m_lastMovedTo = -1;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            TableBuilder.this.stopEditing();
            Point point = mouseEvent.getPoint();
            int n = TableBuilder.this.m_table.getTableHeader().columnAtPoint(point);
            TableColumn tableColumn = TableBuilder.this.m_table.getTableHeader().getResizingColumn();
            int n2 = n;
            int n3 = TableBuilder.this.m_table.getColumnModel().getColumnCount();
            int n4 = 0;
            while (n4 < n3) {
                if (TableBuilder.this.m_table.getColumnModel().getColumn(n4).equals(tableColumn)) {
                    n2 = n4;
                    break;
                }
                ++n4;
            }
            TableBuilder.this.m_table.getTableHeader().requestFocus();
            TableBuilder.this.m_table.getSelectionModel().clearSelection();
            if (n2 != -1) {
                TableBuilder.this.m_table.setColumnSelectionInterval(n2, n2);
            }
            if (mouseEvent.isPopupTrigger()) {
                TableBuilder.this.m_moveIndex = -1;
                TableBuilder.this.m_lastMovedTo = -1;
                this.showContextMenu(mouseEvent);
            } else {
                TableBuilder.this.m_moveIndex = n2;
                if (TableBuilder.this.m_moveIndex > -1) {
                    TableBuilder.this.m_moveIndex += TableBuilder.this.m_offset;
                }
                TableBuilder.this.m_lastMovedTo = -1;
            }
        }
    }

    class TableBuilderTableModelListener
    implements TableModelListener {
        TableBuilderTableModelListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 0) {
                int n = tableModelEvent.getColumn();
                int n2 = tableModelEvent.getFirstRow();
                int n3 = TableBuilder.this.m_tableModel.getRowCount();
                int n4 = TableBuilder.this.m_table.getColumnModel().getColumnCount();
                if (n2 > -1 && n2 < n3 && n > -1 && n < n4) {
                    TableBuilder.this.m_tableModel.removeTableModelListener(TableBuilder.this.m_modelListener);
                    Object object = TableBuilder.this.m_tableModel.getValueAt(n2, n);
                    if (object instanceof String) {
                        ItemProperties itemProperties = TableBuilder.this.getItemAtLocation(n2, n);
                        String string = (String)itemProperties.getProperty("Title");
                        String string2 = (String)object;
                        TableBuilder.this.m_tableModel.setValueAt(itemProperties, n2, n);
                        if (!string.equals(string2)) {
                            TableBuilder.this.getPDMLDocument().beginEdit();
                            try {
                                itemProperties.setProperty("Title", string2);
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                            TableBuilder.this.getPDMLDocument().endEdit();
                            TableBuilder.this.getBuilder().updateBuilder();
                        }
                    }
                    TableBuilder.this.m_tableModel.addTableModelListener(TableBuilder.this.m_modelListener);
                }
            }
        }
    }

    class TableBuilderTreeModelListener
    implements TreeModelListener {
        TableBuilderTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            int n = TableBuilder.this.getSelectedRow();
            int n2 = TableBuilder.this.m_table.getSelectedColumn();
            TableBuilder.this.refresh();
            if (n != -1) {
                TableBuilder.this.m_table.setRowSelectionInterval(n, n);
            }
            TableBuilder.this.m_table.setColumnSelectionInterval(n2, n2);
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            MutableProperties mutableProperties = (MutableProperties)treePath.getLastPathComponent();
            int n = mutableProperties.getType();
            if (n == 103) {
                TableBuilder.this.refresh();
                TableBuilder.this.m_table.setColumnSelectionAllowed(true);
                int[] nArray = treeModelEvent.getChildIndices();
                int n2 = 0;
                while (n2 < nArray.length) {
                    int n3 = nArray[n2] - TableBuilder.this.m_offset;
                    if (n3 > -1) {
                        TableBuilder.this.m_table.setColumnSelectionInterval(n3, n3);
                        TableBuilder.this.m_table.scrollRectToVisible(TableBuilder.this.m_table.getCellRect(TableBuilder.this.getSelectedRow(), n3, true));
                    }
                    ++n2;
                }
                TableBuilder.this.m_table.getTableHeader().requestFocus();
            } else if (n == 113) {
                TableBuilder.this.refresh();
                TableBuilder.this.m_table.setColumnSelectionAllowed(false);
                int[] nArray = treeModelEvent.getChildIndices();
                int n4 = 0;
                while (n4 < nArray.length) {
                    TableBuilder.this.m_table.setRowSelectionInterval(nArray[n4], nArray[n4]);
                    TableBuilder.this.m_table.scrollRectToVisible(TableBuilder.this.m_table.getCellRect(nArray[n4], TableBuilder.this.m_table.getSelectedColumn(), true));
                    ++n4;
                }
                TableBuilder.this.m_table.requestFocus();
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            MutableProperties mutableProperties = (MutableProperties)treePath.getLastPathComponent();
            int n = mutableProperties.getType();
            if (n == 103 || n == 113) {
                TableBuilder.this.refresh();
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    class TablePDMLNodeListener
    implements PDMLNodeListener {
        TablePDMLNodeListener() {
        }

        public void PDMLNodeChanged(PDMLNodeEvent pDMLNodeEvent) {
            TableBuilder.this.updateTitleBar(null);
        }

        public void PDMLNodeInserted(PDMLNodeEvent pDMLNodeEvent) {
        }

        public void PDMLNodeRemoved(PDMLNodeEvent pDMLNodeEvent) {
        }
    }

    class TableBuilderCellRenderer
    extends DefaultTableCellRenderer {
        TableBuilderCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                super.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                super.setForeground(jTable.getForeground());
                super.setBackground(jTable.getBackground());
            }
            this.setFont(jTable.getFont());
            Border border = null;
            border = bl2 ? UIManager.getBorder("Table.focusCellHighlightBorder") : DefaultTableCellRenderer.noFocusBorder;
            Border border2 = BorderFactory.createEmptyBorder(0, 4, 0, 3);
            this.setBorder(BorderFactory.createCompoundBorder(border, border2));
            if (object != null) {
                this.setValue(object);
                this.setIcon(null);
                if (object instanceof ItemProperties) {
                    String string;
                    ItemProperties itemProperties = (ItemProperties)object;
                    ColumnProperties columnProperties = (ColumnProperties)itemProperties.getParent();
                    if (columnProperties != null) {
                        string = columnProperties.getProperty("Column Alignment").toString();
                        if (string.equals("center")) {
                            this.setHorizontalAlignment(0);
                        } else if (string.equals("right")) {
                            this.setHorizontalAlignment(4);
                        } else {
                            this.setHorizontalAlignment(2);
                        }
                    }
                    this.setText((String)itemProperties.getProperty("Title"));
                    string = (String)itemProperties.getProperty("Icon");
                    if (string != null && !string.equals("")) {
                        String string2 = (String)itemProperties.getProperty("* H Position");
                        String string3 = (String)itemProperties.getProperty("* V Position");
                        ImageIcon imageIcon = null;
                        imageIcon = GUIFactory.getUserImage(string);
                        if (imageIcon == null) {
                            imageIcon = GUIFactory.getImage("Bitmap.gif", true);
                        }
                        this.setIcon(imageIcon);
                        int n3 = 4;
                        int n4 = 0;
                        if (string2.equals("right")) {
                            n3 = 2;
                        } else if (string2.equals("center")) {
                            n3 = 0;
                        }
                        if (string3.equals("top")) {
                            n4 = 1;
                        } else if (string3.equals("bottom")) {
                            n4 = 3;
                        }
                        if (n3 == 0) {
                            if (n4 == 1) {
                                n4 = 3;
                            } else if (n4 == 3) {
                                n4 = 1;
                            }
                        }
                        this.setHorizontalTextPosition(n3);
                        this.setVerticalTextPosition(n4);
                        this.setIcon(imageIcon);
                    }
                }
            }
            return this;
        }
    }

    class TableBuilderHeaderRenderer
    extends DefaultTableCellRenderer {
        TableBuilderHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            Object object3;
            ColumnProperties columnProperties = (ColumnProperties)object;
            if (jTable != null && (object3 = jTable.getTableHeader()) != null) {
                boolean bl3 = (Boolean)columnProperties.getProperty("Primary");
                object2 = ((Component)object3).getForeground();
                Color color = ((Component)object3).getBackground();
                Font font = ((Component)object3).getFont();
                if (bl3) {
                    object2 = Color.blue;
                }
                this.setForeground((Color)object2);
                this.setBackground(color);
                this.setFont(font);
            }
            this.setText(object == null ? "" : (String)columnProperties.getProperty("Title"));
            object3 = BorderFactory.createEmptyBorder(0, 4, 0, 4);
            Border border = null;
            border = jTable.getSelectedColumn() != n2 || TableBuilder.this.getSelectedRow() != -1 ? UIManager.getBorder("TableHeader.cellBorder") : BorderFactory.createLoweredBevelBorder();
            this.setBorder(BorderFactory.createCompoundBorder(border, (Border)object3));
            object2 = (String)columnProperties.getProperty("Header Alignment");
            int n3 = 0;
            if (((String)object2).equals("left")) {
                n3 = 2;
            } else if (((String)object2).equals("right")) {
                n3 = 4;
            }
            this.setHorizontalAlignment(n3);
            return this;
        }
    }

    class TableBuilderSelectionListener
    implements ListSelectionListener {
        TableBuilderSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            TableBuilder.this.m_table.setColumnSelectionAllowed(TableBuilder.this.getSelectedRow() == -1 && TableBuilder.this.m_table.getSelectedColumn() > -1);
            if (TableBuilder.this.getSelectedProperties() != null) {
                TableBuilder.this.fireSelectionChangedEvent();
            }
        }
    }

    class TableActionListener
    implements ActionListener {
        TableActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TableBuilder.this.stopEditing();
            String string = actionEvent.getActionCommand();
            if (string.equals("Add Row")) {
                TableBuilder.this.getPDMLDocument().beginEdit();
                TableBuilder.this.doAddRow();
                TableBuilder.this.getPDMLDocument().endEdit();
                TableBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Remove Row")) {
                TableBuilder.this.getPDMLDocument().beginEdit();
                TableBuilder.this.doRemoveRow();
                TableBuilder.this.getPDMLDocument().endEdit();
                TableBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Add Column")) {
                TableBuilder.this.getPDMLDocument().beginEdit();
                TableBuilder.this.doAddColumn();
                TableBuilder.this.getPDMLDocument().endEdit();
                TableBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Remove Column")) {
                TableBuilder.this.getPDMLDocument().beginEdit();
                TableBuilder.this.doRemoveColumn();
                TableBuilder.this.getPDMLDocument().endEdit();
                TableBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Move Up")) {
                TableBuilder.this.getPDMLDocument().beginEdit(true);
                TableBuilder.this.doMoveUp();
                TableBuilder.this.getPDMLDocument().endEdit();
                TableBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Move Down")) {
                TableBuilder.this.getPDMLDocument().beginEdit(true);
                TableBuilder.this.doMoveDown();
                TableBuilder.this.getPDMLDocument().endEdit();
                TableBuilder.this.getBuilder().updateBuilder();
            } else if (string.startsWith("Edit")) {
                if ((string = string.substring(5)).equals("Cut")) {
                    TableBuilder.this.cut();
                    TableBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Copy")) {
                    TableBuilder.this.copy();
                    TableBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Paste")) {
                    TableBuilder.this.paste();
                    TableBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Delete")) {
                    TableBuilder.this.delete();
                    TableBuilder.this.getBuilder().updateBuilder();
                }
            } else if (string.startsWith("Selected")) {
                string = string.substring(9);
                TableBuilder.this.m_panelBuilder.doSelectedEdit(TableBuilder.this.getSelectedProperties(), true, string, TableBuilder.this);
            } else if (string.equals("Auto Resize")) {
                TableBuilder.this.getPDMLDocument().beginEdit();
                boolean bl = !TableBuilder.this.m_autoResizeButton.isSelected();
                int n = TableBuilder.this.m_table.getColumnModel().getColumnCount();
                int n2 = 0;
                int n3 = 0;
                while (n3 < n) {
                    ColumnProperties columnProperties = TableBuilder.this.getColumnAtIndex(n3);
                    if (bl) {
                        n2 = TableBuilder.this.m_table.getColumnModel().getColumn(n3).getWidth();
                    }
                    try {
                        columnProperties.setProperty("Width", new Integer(n2));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    ++n3;
                }
                TableBuilder.this.getPDMLDocument().endEdit();
                TableBuilder.this.refresh();
                TableBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Preview")) {
                TableBuilder.this.setCursor(Cursor.getPredefinedCursor(3));
                MutableProperties mutableProperties = TableBuilder.this.getProperties();
                mutableProperties = (MutableProperties)mutableProperties.getParent();
                TableBuilder.this.getBuilder().doPreview(mutableProperties);
                TableBuilder.this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (string.equals("Show Properties")) {
                TableBuilder.this.getBuilder().doShowProperties();
            } else if (string.equals("Help")) {
                TableBuilder.this.displayHelp();
            }
        }
    }
}

