/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.tools.BuilderFrame;
import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.SelectionObjectCollection;
import com.ibm.as400.ui.tools.SelectionObjectElement;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeNode;

class SelectionObjectDialog
extends JDialog {
    GUIBuilder m_builder;
    BuilderFrame m_parent;
    MutableProperties m_properties;
    String m_panelName;
    JComboBox m_comboSelected;
    JComboBox m_comboType;
    JComboBox m_comboResource;
    JComboBox m_comboContainer;
    JLabel m_labelAvailable;
    JLabel m_labelContainer;
    JLabel m_labelSelected;
    JButton m_okButton;
    JButton m_addButton;
    JButton m_removeButton;
    JList m_selectedList;
    JList m_availableList;
    int m_lastSelectedIndex = 0;
    int m_lastSelectedTypeIndex = 0;
    ActionListener m_comboActionListener;
    Hashtable m_selectedCollections;
    Hashtable m_deselectedCollections;

    SelectionObjectDialog(BuilderFrame builderFrame, MutableProperties mutableProperties) {
        super(builderFrame, (String)mutableProperties.getProperty("Name"), true);
        Object[] objectArray = new Object[]{mutableProperties.getProperty("Name")};
        String string = MessageFormat.format(GUIFactory.getString("IDS_SELECTED_DIALOG_TITLEBAR"), objectArray);
        this.setTitle(string);
        this.m_properties = mutableProperties;
        this.m_parent = builderFrame;
        this.m_builder = this.m_parent.getBuilder();
        TreeNode[] treeNodeArray = this.m_properties.getPath();
        MutableProperties mutableProperties2 = (MutableProperties)treeNodeArray[1];
        this.m_panelName = (String)mutableProperties2.getProperty("Name");
        this.initCollections();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 5));
        this.m_comboResource = new JComboBox();
        this.m_comboResource.setRenderer(new SelectionResourceRenderer());
        JLabel jLabel = new JLabel(GUIFactory.getString("IDS_SELECTED_DIALOG_RESOURCE"));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)this.m_comboResource, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 5));
        this.m_comboContainer = new JComboBox();
        this.m_labelContainer = new JLabel(GUIFactory.getString("IDS_SELECTED_DIALOG_CONTAINER_PANEL"));
        jPanel2.add((Component)this.m_labelContainer, "North");
        jPanel2.add((Component)this.m_comboContainer, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        this.m_labelAvailable = new JLabel(GUIFactory.getString("IDS_SELECTED_DIALOG_AVAILABLE_COMPONENTS"));
        this.m_availableList = new JList(new DefaultListModel());
        this.m_availableList.setSelectionMode(0);
        this.m_availableList.setCellRenderer(new SelectionListRenderer());
        this.m_availableList.addListSelectionListener(new SelectionListSelectionListener());
        this.m_availableList.addMouseListener(new SelectionMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.m_availableList);
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel3.add((Component)jScrollPane, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 5));
        this.m_comboSelected = new JComboBox();
        this.m_comboSelected.addItem(GUIFactory.getString("IDP_SELECTED"));
        this.m_comboSelected.setSelectedIndex(this.m_lastSelectedIndex);
        if (mutableProperties.getSelectionObject(false) != null) {
            this.m_comboSelected.addItem(GUIFactory.getString("IDP_DESELECTED"));
        }
        JLabel jLabel2 = new JLabel(GUIFactory.getString("IDS_SELECTED_DIALOG_EVENT"));
        jPanel4.add((Component)jLabel2, "North");
        jPanel4.add((Component)this.m_comboSelected, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 5));
        this.m_comboType = new JComboBox();
        this.m_comboType.addItem(GUIFactory.getString("IDP_SELECTED_ENABLE"));
        this.m_comboType.addItem(GUIFactory.getString("IDP_SELECTED_DISABLE"));
        this.m_comboType.addItem(GUIFactory.getString("IDP_SELECTED_REFRESH"));
        this.m_comboType.addItem(GUIFactory.getString("IDP_SELECTED_SHOW"));
        this.m_comboType.addItem(GUIFactory.getString("IDP_SELECTED_HIDE"));
        this.m_comboType.addItem(GUIFactory.getString("IDP_SELECTED_DISPLAY"));
        this.m_comboType.setSelectedIndex(this.m_lastSelectedTypeIndex);
        JLabel jLabel3 = new JLabel(GUIFactory.getString("IDS_SELECTED_DIALOG_ACTION"));
        jPanel5.add((Component)jLabel3, "North");
        jPanel5.add((Component)this.m_comboType, "Center");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        this.m_labelSelected = new JLabel(GUIFactory.getString("IDS_SELECTED_DIALOG_SELECTED_ENABLE"));
        this.m_selectedList = new JList(new DefaultListModel());
        this.m_selectedList.setSelectionMode(0);
        this.m_selectedList.setCellRenderer(new SelectionListRenderer());
        this.m_selectedList.addListSelectionListener(new SelectionListSelectionListener());
        JScrollPane jScrollPane2 = new JScrollPane(this.m_selectedList);
        jScrollPane2.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel6.add((Component)jScrollPane2, "Center");
        this.initResource();
        SelectionComboActionListener selectionComboActionListener = new SelectionComboActionListener();
        this.m_comboActionListener = selectionComboActionListener;
        this.m_comboResource.addActionListener(selectionComboActionListener);
        this.m_comboContainer.addActionListener(selectionComboActionListener);
        this.m_comboSelected.addActionListener(selectionComboActionListener);
        this.m_comboType.addActionListener(selectionComboActionListener);
        Dimension dimension = new Dimension(80, 25);
        SelectionActionListener selectionActionListener = new SelectionActionListener();
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(1, 2, 5, 0));
        this.m_okButton = GUIFactory.createButton("OK", null, "IDS_OK", null, null, true, selectionActionListener);
        jPanel7.add(this.m_okButton);
        JButton jButton = GUIFactory.createButton("Cancel", null, "IDS_CANCEL", null, null, true, selectionActionListener);
        jPanel7.add(jButton);
        JButton jButton2 = GUIFactory.createButton("Help", null, "IDS_HELP", null, null, true, selectionActionListener);
        jPanel7.add(jButton2);
        Dimension dimension2 = this.m_okButton.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        dimension2 = jButton.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        dimension2 = jButton2.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        this.m_okButton.setMinimumSize(dimension);
        jButton.setMinimumSize(dimension);
        jButton2.setMinimumSize(dimension);
        this.m_okButton.setPreferredSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton2.setPreferredSize(dimension);
        this.getRootPane().setDefaultButton(this.m_okButton);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayout(2, 1, 0, 5));
        this.m_addButton = GUIFactory.createButton("Add", null, "IDS_SELECTED_DIALOG_ADD", null, null, true, selectionActionListener);
        jPanel8.add(this.m_addButton);
        this.m_removeButton = GUIFactory.createButton("Remove", null, "IDS_SELECTED_DIALOG_REMOVE", null, null, false, selectionActionListener);
        jPanel8.add(this.m_removeButton);
        dimension2.width = 100;
        dimension2 = this.m_removeButton.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        dimension2 = this.m_addButton.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        this.m_addButton.setMinimumSize(dimension);
        this.m_removeButton.setMinimumSize(dimension);
        this.m_addButton.setPreferredSize(dimension);
        this.m_removeButton.setPreferredSize(dimension);
        JPanel jPanel9 = new JPanel();
        jPanel9.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel9.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel9.add(jPanel);
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel9.add(jPanel2);
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.m_labelAvailable, gridBagConstraints);
        jPanel9.add(this.m_labelAvailable);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel9.add(jPanel3);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(jPanel8, gridBagConstraints);
        jPanel9.add(jPanel8);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel9.add(jPanel4);
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel9.add(jPanel5);
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.m_labelSelected, gridBagConstraints);
        jPanel9.add(this.m_labelSelected);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        jPanel9.add(jPanel6);
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        jPanel9.add(jPanel7);
        Dimension dimension3 = new Dimension(200, 150);
        jScrollPane.setPreferredSize(dimension3);
        jScrollPane2.setPreferredSize(dimension3);
        dimension3 = this.m_comboSelected.getPreferredSize();
        dimension3.width = 200;
        JLabel jLabel4 = new JLabel();
        this.updatePreferredSize(dimension3, jLabel4, jLabel.getText());
        this.updatePreferredSize(dimension3, jLabel4, jLabel2.getText());
        this.updatePreferredSize(dimension3, jLabel4, jLabel3.getText());
        this.updatePreferredSize(dimension3, jLabel4, this.m_labelContainer.getText());
        this.updatePreferredSize(dimension3, jLabel4, this.m_labelAvailable.getText());
        this.updatePreferredSize(dimension3, jLabel4, this.m_labelSelected.getText());
        this.updatePreferredSize(dimension3, jLabel4, GUIFactory.getString("IDS_SELECTED_DIALOG_AVAILABLE_PANES"));
        this.updatePreferredSize(dimension3, jLabel4, GUIFactory.getString("IDS_SELECTED_DIALOG_CONTAINER_PANE"));
        this.updatePreferredSize(dimension3, jLabel4, GUIFactory.getString("IDS_SELECTED_DIALOG_SELECTED_DISABLE"));
        this.updatePreferredSize(dimension3, jLabel4, GUIFactory.getString("IDS_SELECTED_DIALOG_SELECTED_REFRESH"));
        this.updatePreferredSize(dimension3, jLabel4, GUIFactory.getString("IDS_SELECTED_DIALOG_SELECTED_SHOW"));
        this.updatePreferredSize(dimension3, jLabel4, GUIFactory.getString("IDS_SELECTED_DIALOG_SELECTED_HIDE"));
        this.updatePreferredSize(dimension3, jLabel4, GUIFactory.getString("IDS_SELECTED_DIALOG_SELECTED_DISPLAY"));
        this.m_comboSelected.setPreferredSize(dimension3);
        this.m_comboType.setPreferredSize(dimension3);
        this.m_comboResource.setPreferredSize(dimension3);
        this.m_comboContainer.setPreferredSize(dimension3);
        jPanel9.setMinimumSize(jPanel9.getPreferredSize());
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.getContentPane().add((Component)jPanel9, "Center");
        this.pack();
        dimension2 = this.getSize();
        Dimension dimension4 = Toolkit.getDefaultToolkit().getScreenSize();
        Point point = new Point();
        point.x = (dimension4.width - dimension2.width) / 2;
        point.y = (dimension4.height - dimension2.height) / 2;
        ((Component)this).setLocation(point);
        this.addWindowListener(new SelectionWindowListener());
        this.refresh();
        this.addKeyListener(new SelectionKeyListener());
    }

    void updatePreferredSize(Dimension dimension, JLabel jLabel, String string) {
        jLabel.setText(string);
        Dimension dimension2 = jLabel.getPreferredSize();
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
    }

    void initResource() {
        Vector vector = this.m_builder.getAvailableSelectionResources();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.m_comboResource.addItem(vector.elementAt(n2));
            ++n2;
        }
        this.m_comboResource.setSelectedItem(this.m_properties.getPDMLDocument());
        this.refreshContainers();
    }

    void refreshContainers() {
        if (this.m_comboContainer.getItemCount() > 0) {
            this.m_comboContainer.removeAllItems();
        }
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)this.m_comboResource.getSelectedItem();
        Enumeration enumeration = null;
        if (this.m_comboType.getSelectedIndex() != 5) {
            enumeration = xMLGUIBuilderDefinition.selectionPanelNames();
            this.m_labelAvailable.setText(GUIFactory.getString("IDS_SELECTED_DIALOG_AVAILABLE_COMPONENTS"));
        } else {
            MutableProperties mutableProperties = null;
            if (xMLGUIBuilderDefinition.equals(this.m_properties.getPDMLDocument())) {
                TreeNode[] treeNodeArray = this.m_properties.getPath();
                mutableProperties = (MutableProperties)treeNodeArray[1];
            }
            enumeration = xMLGUIBuilderDefinition.selectionPaneNames(mutableProperties);
            this.m_labelAvailable.setText(GUIFactory.getString("IDS_SELECTED_DIALOG_AVAILABLE_PANES"));
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.m_comboContainer.addItem(string);
        }
        this.refreshComponents();
    }

    void refreshComponents() {
        DefaultListModel defaultListModel = (DefaultListModel)this.m_availableList.getModel();
        defaultListModel.clear();
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)this.m_comboResource.getSelectedItem();
        String string = (String)this.m_comboContainer.getSelectedItem();
        if (string != null && !string.equals("")) {
            Vector vector = new Vector(10, 10);
            MutableProperties mutableProperties = xMLGUIBuilderDefinition.getPDMLRoot().getContainerNamed(string);
            Enumeration<TreeNode> enumeration = mutableProperties.children();
            while (enumeration.hasMoreElements()) {
                Object object;
                MutableProperties mutableProperties2 = (MutableProperties)enumeration.nextElement();
                if (mutableProperties2.getType() == 112) {
                    object = mutableProperties2.children();
                    while (object.hasMoreElements()) {
                        mutableProperties2 = (MutableProperties)object.nextElement();
                        this.addPropertiesInOrder(mutableProperties2, vector);
                    }
                    continue;
                }
                if (mutableProperties2.getType() == 103) {
                    object = this.getType(this.m_comboType.getSelectedIndex());
                    if (((String)object).equals("DISABLE") || ((String)object).equals("ENABLE")) continue;
                    this.addPropertiesInOrder(mutableProperties2, vector);
                    continue;
                }
                if (mutableProperties2.getType() == 50 || mutableProperties2.getType() == 55 || mutableProperties2.getType() == 60 || mutableProperties2.getType() == 61 || mutableProperties2.getType() == 62) continue;
                this.addPropertiesInOrder(mutableProperties2, vector);
            }
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                defaultListModel.addElement(vector.elementAt(n2));
                ++n2;
            }
        }
    }

    void addPropertiesInOrder(MutableProperties mutableProperties, Vector vector) {
        String string = (String)mutableProperties.getProperty("Name");
        if (string == null) {
            vector.addElement(mutableProperties);
        } else {
            String string2 = null;
            Collator collator = Collator.getInstance();
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                MutableProperties mutableProperties2 = (MutableProperties)vector.elementAt(n2);
                string2 = (String)mutableProperties2.getProperty("Name");
                if (collator.compare(string2, string) >= 0) {
                    vector.insertElementAt(mutableProperties, n2);
                    return;
                }
                ++n2;
            }
            vector.addElement(mutableProperties);
        }
    }

    void initCollections() {
        SelectionObjectCollection selectionObjectCollection;
        String[] stringArray = new String[]{"ENABLE", "DISABLE", "REFRESH", "SHOW", "HIDE", "DISPLAY"};
        boolean bl = true;
        this.m_selectedCollections = new Hashtable();
        int n = 0;
        while (n < 6) {
            selectionObjectCollection = this.m_properties.getSelectionObjectCollection(bl, stringArray[n]);
            if (selectionObjectCollection != null) {
                this.m_selectedCollections.put(stringArray[n], selectionObjectCollection.cloneNode(selectionObjectCollection.getPDMLDocument(), null));
            }
            ++n;
        }
        bl = false;
        this.m_deselectedCollections = new Hashtable();
        int n2 = 0;
        while (n2 < 6) {
            selectionObjectCollection = this.m_properties.getSelectionObjectCollection(bl, stringArray[n2]);
            if (selectionObjectCollection != null) {
                this.m_deselectedCollections.put(stringArray[n2], selectionObjectCollection.cloneNode(selectionObjectCollection.getPDMLDocument(), null));
            }
            ++n2;
        }
    }

    SelectionObjectCollection getInternalCollection(boolean bl, String string) {
        Hashtable hashtable = bl ? this.m_selectedCollections : this.m_deselectedCollections;
        return (SelectionObjectCollection)hashtable.get(string);
    }

    void setSelectionType(boolean bl, String string) {
        if (this.m_comboSelected.getItemCount() > 1) {
            this.m_comboSelected.setSelectedIndex(bl ? 0 : 1);
        }
        if (string.equalsIgnoreCase("DISPLAY")) {
            this.m_comboType.setSelectedIndex(5);
        } else {
            this.m_comboType.setSelectedIndex(0);
        }
    }

    boolean isSelected(int n) {
        return n == 0;
    }

    String getType(int n) {
        String string;
        switch (n) {
            default: {
                string = "ENABLE";
                break;
            }
            case 1: {
                string = "DISABLE";
                break;
            }
            case 2: {
                string = "REFRESH";
                break;
            }
            case 3: {
                string = "SHOW";
                break;
            }
            case 4: {
                string = "HIDE";
                break;
            }
            case 5: {
                string = "DISPLAY";
            }
        }
        return string;
    }

    void refresh() {
        boolean bl = this.isSelected(this.m_comboSelected.getSelectedIndex());
        String string = this.getType(this.m_comboType.getSelectedIndex());
        switch (this.m_comboType.getSelectedIndex()) {
            case 0: {
                this.m_labelSelected.setText(GUIFactory.getString("IDS_SELECTED_DIALOG_SELECTED_ENABLE"));
                this.m_labelContainer.setText(GUIFactory.getString("IDS_SELECTED_DIALOG_CONTAINER_PANEL"));
                break;
            }
            case 1: {
                this.m_labelSelected.setText(GUIFactory.getString("IDS_SELECTED_DIALOG_SELECTED_DISABLE"));
                this.m_labelContainer.setText(GUIFactory.getString("IDS_SELECTED_DIALOG_CONTAINER_PANEL"));
                break;
            }
            case 2: {
                this.m_labelSelected.setText(GUIFactory.getString("IDS_SELECTED_DIALOG_SELECTED_REFRESH"));
                this.m_labelContainer.setText(GUIFactory.getString("IDS_SELECTED_DIALOG_CONTAINER_PANEL"));
                break;
            }
            case 3: {
                this.m_labelSelected.setText(GUIFactory.getString("IDS_SELECTED_DIALOG_SELECTED_SHOW"));
                this.m_labelContainer.setText(GUIFactory.getString("IDS_SELECTED_DIALOG_CONTAINER_PANEL"));
                break;
            }
            case 4: {
                this.m_labelSelected.setText(GUIFactory.getString("IDS_SELECTED_DIALOG_SELECTED_HIDE"));
                this.m_labelContainer.setText(GUIFactory.getString("IDS_SELECTED_DIALOG_CONTAINER_PANEL"));
                break;
            }
            case 5: {
                this.m_labelSelected.setText(GUIFactory.getString("IDS_SELECTED_DIALOG_SELECTED_DISPLAY"));
                this.m_labelContainer.setText(GUIFactory.getString("IDS_SELECTED_DIALOG_CONTAINER_PANE"));
            }
        }
        SelectionObjectCollection selectionObjectCollection = this.getInternalCollection(bl, string);
        Vector<SelectionObjectElement> vector = new Vector<SelectionObjectElement>(selectionObjectCollection.getChildCount());
        Enumeration<TreeNode> enumeration = selectionObjectCollection.children();
        while (enumeration.hasMoreElements()) {
            SelectionObjectElement selectionObjectElement = (SelectionObjectElement)enumeration.nextElement();
            vector.addElement(selectionObjectElement);
        }
        this.m_selectedList.clearSelection();
        DefaultListModel defaultListModel = (DefaultListModel)this.m_selectedList.getModel();
        defaultListModel.clear();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            defaultListModel.addElement(vector.elementAt(n2));
            ++n2;
        }
    }

    void doAvailableUpdate() {
        int[] nArray = this.m_availableList.getSelectedIndices();
        if (nArray != null && nArray.length > 0) {
            int n = nArray.length;
            Object[] objectArray = this.m_availableList.getSelectedValues();
            Vector<SelectionObjectElement> vector = new Vector<SelectionObjectElement>(n);
            String string = (String)this.m_comboContainer.getSelectedItem();
            int n2 = 0;
            while (n2 < n) {
                MutableProperties mutableProperties = (MutableProperties)objectArray[n2];
                String string2 = (String)mutableProperties.getProperty("Name");
                if (string2 == null) {
                    string2 = (String)mutableProperties.getProperty("ID");
                }
                SelectionObjectElement selectionObjectElement = new SelectionObjectElement();
                try {
                    selectionObjectElement.setProperty("Container", string);
                    selectionObjectElement.setProperty("Component", string2);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                vector.addElement(selectionObjectElement);
                ++n2;
            }
            this.addSelectionObjectElements(vector);
        }
    }

    void doSelectedUpdate() {
        boolean bl = this.isSelected(this.m_lastSelectedIndex);
        String string = this.getType(this.m_lastSelectedTypeIndex);
        ListModel listModel = this.m_selectedList.getModel();
        int n = listModel.getSize();
        SelectionObjectCollection selectionObjectCollection = new SelectionObjectCollection(90);
        int n2 = 0;
        while (n2 < n) {
            SelectionObjectElement selectionObjectElement = (SelectionObjectElement)listModel.getElementAt(n2);
            selectionObjectCollection.add(selectionObjectElement.cloneNode(this.m_properties.getPDMLDocument(), null));
            ++n2;
        }
        Hashtable hashtable = bl ? this.m_selectedCollections : this.m_deselectedCollections;
        hashtable.put(string, selectionObjectCollection);
        this.m_lastSelectedIndex = this.m_comboSelected.getSelectedIndex();
        this.m_lastSelectedTypeIndex = this.m_comboType.getSelectedIndex();
    }

    void doUpdateAll() {
        String[] stringArray = new String[]{"ENABLE", "DISABLE", "REFRESH", "SHOW", "HIDE", "DISPLAY"};
        boolean bl = false;
        int n = 0;
        while (n < 2) {
            boolean bl2 = n == 0;
            Hashtable hashtable = bl2 ? this.m_selectedCollections : this.m_deselectedCollections;
            int n2 = 0;
            while (n2 < 6) {
                SelectionObjectCollection selectionObjectCollection;
                SelectionObjectCollection selectionObjectCollection2 = (SelectionObjectCollection)hashtable.get(stringArray[n2]);
                if (selectionObjectCollection2 != null && !(selectionObjectCollection = this.m_properties.getSelectionObjectCollection(bl2, stringArray[n2])).collectionEquals(selectionObjectCollection2)) {
                    if (!bl) {
                        this.m_properties.getPDMLDocument().beginEdit();
                        bl = true;
                    }
                    selectionObjectCollection.updateCollection(selectionObjectCollection2);
                }
                ++n2;
            }
            ++n;
        }
        if (bl) {
            this.m_properties.getPDMLDocument().endEdit();
        }
    }

    void addSelectionObjectElements(Vector vector) {
        boolean bl = this.isSelected(this.m_comboSelected.getSelectedIndex());
        String string = this.getType(this.m_comboType.getSelectedIndex());
        SelectionObjectCollection selectionObjectCollection = this.getInternalCollection(bl, string);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            SelectionObjectElement selectionObjectElement = (SelectionObjectElement)vector.elementAt(n2);
            if (!selectionObjectCollection.containsSelectionObjectElement(selectionObjectElement)) {
                selectionObjectCollection.add(selectionObjectElement);
            }
            ++n2;
        }
        this.refresh();
    }

    void doAdd() {
        MutableProperties mutableProperties = (MutableProperties)this.m_availableList.getSelectedValue();
        if (mutableProperties == null) {
            return;
        }
        String string = (String)mutableProperties.getProperty("Name");
        if (string == null) {
            string = (String)mutableProperties.getProperty("ID");
        }
        mutableProperties = (MutableProperties)mutableProperties.getParent();
        String string2 = (String)mutableProperties.getProperty("Name");
        this.doAvailableUpdate();
        this.m_availableList.clearSelection();
        ListModel listModel = this.m_selectedList.getModel();
        int n = listModel.getSize();
        if (n > 0) {
            int n2 = n - 1;
            while (n2 >= 0) {
                mutableProperties = (MutableProperties)listModel.getElementAt(n2);
                if (mutableProperties.getProperty("Component").equals(string) && mutableProperties.getProperty("Container").equals(string2)) {
                    this.m_selectedList.setSelectedIndex(n2);
                    break;
                }
                --n2;
            }
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class SelectionKeyListener
    extends KeyAdapter {
        SelectionKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 112) {
                SelectionObjectDialog.this.m_builder.displayHelp("SelectedDialog", SelectionObjectDialog.this);
            }
        }
    }

    class SelectionMouseListener
    extends MouseAdapter {
        SelectionMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                SelectionObjectDialog.this.doAdd();
            }
        }
    }

    class SelectionResourceRenderer
    extends DefaultListCellRenderer {
        SelectionResourceRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)object;
            String string = xMLGUIBuilderDefinition.getPDMLRoot().getResourceName(true, false);
            jLabel.setText(string);
            return jLabel;
        }
    }

    class SelectionWindowListener
    extends WindowAdapter {
        SelectionWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            SelectionObjectDialog.this.dispose();
        }
    }

    class SelectionListRenderer
    extends DefaultListCellRenderer {
        SelectionListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            MutableProperties mutableProperties = (MutableProperties)object;
            if (mutableProperties.getType() == 90 || mutableProperties.getType() == 91) {
                SelectionObjectElement selectionObjectElement = (SelectionObjectElement)object;
                String string = "";
                String string2 = (String)selectionObjectElement.getProperty("Container");
                if (!string2.equals("") && !string2.equals(SelectionObjectDialog.this.m_panelName)) {
                    string = string2 + ".";
                }
                string = string + (String)selectionObjectElement.getProperty("Component");
                jLabel.setText(string);
            } else {
                String string = (String)mutableProperties.getProperty("Name");
                if (string == null) {
                    string = (String)mutableProperties.getProperty("ID");
                }
                jLabel.setText(string);
            }
            return jLabel;
        }
    }

    class SelectionListSelectionListener
    implements ListSelectionListener {
        SelectionListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = SelectionObjectDialog.this.m_selectedList.getSelectedIndices();
            SelectionObjectDialog.this.m_removeButton.setEnabled(nArray != null && nArray.length > 0 && nArray[0] > -1);
            nArray = SelectionObjectDialog.this.m_availableList.getSelectedIndices();
            SelectionObjectDialog.this.m_addButton.setEnabled(nArray != null && nArray.length > 0 && nArray[0] > -1);
        }
    }

    class SelectionActionListener
    implements ActionListener {
        SelectionActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                SelectionObjectDialog.this.doUpdateAll();
                SelectionObjectDialog.this.dispose();
            } else if (string.equals("Cancel")) {
                SelectionObjectDialog.this.dispose();
            } else if (string.equals("Add")) {
                SelectionObjectDialog.this.doAdd();
            } else if (string.equals("Remove")) {
                int[] nArray = SelectionObjectDialog.this.m_selectedList.getSelectedIndices();
                SelectionObjectDialog.this.m_selectedList.clearSelection();
                if (nArray != null) {
                    int n = nArray.length;
                    DefaultListModel defaultListModel = (DefaultListModel)SelectionObjectDialog.this.m_selectedList.getModel();
                    int n2 = n - 1;
                    while (n2 >= 0) {
                        defaultListModel.removeElementAt(nArray[n2]);
                        --n2;
                    }
                    SelectionObjectDialog.this.doSelectedUpdate();
                }
            } else if (string.equals("Help")) {
                SelectionObjectDialog.this.m_builder.displayHelp("SelectedDialog", SelectionObjectDialog.this);
            }
        }
    }

    class SelectionComboActionListener
    implements ActionListener {
        SelectionComboActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(SelectionObjectDialog.this.m_comboResource)) {
                SelectionObjectDialog.this.m_comboResource.removeActionListener(SelectionObjectDialog.this.m_comboActionListener);
                SelectionObjectDialog.this.m_comboContainer.removeActionListener(SelectionObjectDialog.this.m_comboActionListener);
                SelectionObjectDialog.this.refreshContainers();
                SelectionObjectDialog.this.m_comboResource.addActionListener(SelectionObjectDialog.this.m_comboActionListener);
                SelectionObjectDialog.this.m_comboContainer.addActionListener(SelectionObjectDialog.this.m_comboActionListener);
                SelectionObjectDialog.this.m_availableList.clearSelection();
                SelectionObjectDialog.this.m_addButton.setEnabled(false);
            } else if (actionEvent.getSource().equals(SelectionObjectDialog.this.m_comboContainer)) {
                SelectionObjectDialog.this.m_comboResource.removeActionListener(SelectionObjectDialog.this.m_comboActionListener);
                SelectionObjectDialog.this.m_comboContainer.removeActionListener(SelectionObjectDialog.this.m_comboActionListener);
                SelectionObjectDialog.this.refreshComponents();
                SelectionObjectDialog.this.m_comboResource.addActionListener(SelectionObjectDialog.this.m_comboActionListener);
                SelectionObjectDialog.this.m_comboContainer.addActionListener(SelectionObjectDialog.this.m_comboActionListener);
                SelectionObjectDialog.this.m_availableList.clearSelection();
                SelectionObjectDialog.this.m_addButton.setEnabled(false);
            } else if (actionEvent.getSource().equals(SelectionObjectDialog.this.m_comboType)) {
                SelectionObjectDialog.this.doSelectedUpdate();
                SelectionObjectDialog.this.refresh();
                SelectionObjectDialog.this.m_comboResource.removeActionListener(SelectionObjectDialog.this.m_comboActionListener);
                SelectionObjectDialog.this.m_comboContainer.removeActionListener(SelectionObjectDialog.this.m_comboActionListener);
                SelectionObjectDialog.this.refreshContainers();
                SelectionObjectDialog.this.m_comboResource.addActionListener(SelectionObjectDialog.this.m_comboActionListener);
                SelectionObjectDialog.this.m_comboContainer.addActionListener(SelectionObjectDialog.this.m_comboActionListener);
                SelectionObjectDialog.this.m_availableList.clearSelection();
                SelectionObjectDialog.this.m_addButton.setEnabled(false);
            } else {
                SelectionObjectDialog.this.doSelectedUpdate();
                SelectionObjectDialog.this.refresh();
            }
        }
    }
}

