/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.java.DividerPanel;
import com.ibm.as400.ui.tools.BuilderFrame;
import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.LoopDialog;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.PDMLNodeEvent;
import com.ibm.as400.ui.tools.PDMLNodeListener;
import com.ibm.as400.ui.tools.PaneContainerTable;
import com.ibm.as400.ui.tools.PaneProperties;
import com.ibm.as400.ui.tools.PropertyTableModel;
import com.ibm.as400.ui.tools.WizardProperties;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class PaneContainerBuilder
extends BuilderFrame {
    JPanel m_mainToolBar;
    JPanel m_moveToolBar;
    JPanel m_editToolBar;
    JPanel m_helpToolBar;
    JTable m_table;
    PropertyTableModel m_tableModel;
    PaneTableModelListener m_modelListener;
    TableColumn m_stepColumn;
    boolean m_stepsShowing;
    JPopupMenu m_contextMenu;
    ActionListener m_menuListener;
    PDMLNodeListener m_pdmlNodeListener;
    TreeModelListener m_treeModelListener = new PaneTreeModelListener();
    static /* synthetic */ Class class$java$lang$Object;

    PaneContainerBuilder(GUIBuilder gUIBuilder, XMLGUIBuilderDefinition xMLGUIBuilderDefinition, MutableProperties mutableProperties) {
        super(gUIBuilder, xMLGUIBuilderDefinition, mutableProperties);
        Object object;
        Object[] objectArray;
        Object object2;
        mutableProperties.addTreeModelListener(this.m_treeModelListener);
        this.m_pdmlNodeListener = new PanePDMLNodeListener();
        mutableProperties.addPDMLNodeListener(this.m_pdmlNodeListener);
        this.removeKeyListener(this.m_keyListener);
        PaneActionListener paneActionListener = new PaneActionListener();
        this.m_menuListener = paneActionListener;
        this.m_mainToolBar = new DividerPanel(2);
        this.m_mainToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_mainToolBar.add(GUIFactory.createButton("Add", null, null, "Add.gif", "IDTT_ADD_PANE", true, paneActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Remove", null, null, "Remove.gif", "IDTT_REMOVE_PANE", true, paneActionListener));
        this.m_moveToolBar = new DividerPanel(2);
        this.m_moveToolBar.setLayout(new GridLayout(1, 3, 0, 0));
        this.m_moveToolBar.add(GUIFactory.createButton("Move Up", null, null, "MoveUp.gif", "IDTT_MOVE_UP", true, paneActionListener));
        this.m_moveToolBar.add(GUIFactory.createButton("Move Down", null, null, "MoveDown.gif", "IDTT_MOVE_DOWN", true, paneActionListener));
        this.m_moveToolBar.add(GUIFactory.createButton("Loop", null, null, "Loop.gif", "IDTT_LOOP", true, paneActionListener));
        this.m_editToolBar = new DividerPanel(2);
        this.m_editToolBar.setLayout(new GridLayout(1, 3, 0, 0));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Cut", null, null, "Cut.gif", "IDTT_EDIT_CUT", false, paneActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Copy", null, null, "Copy.gif", "IDTT_EDIT_COPY", false, paneActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Paste", null, null, "Paste.gif", "IDTT_EDIT_PASTE", false, paneActionListener));
        this.m_helpToolBar = new JPanel();
        this.m_helpToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        if (mutableProperties.getType() == 120 || mutableProperties.getType() == 121) {
            object2 = GUIFactory.createPopupMenuButton("Preview", null, null, "Preview.gif", "IDTT_PREVIEW", "IDTT_PREVIEW", true, paneActionListener);
            objectArray = new JPopupMenu();
            objectArray.add(GUIFactory.createMenuItem("Preview", null, "IDTT_PREVIEW", null, true, paneActionListener));
            objectArray.add(GUIFactory.createMenuItem("Dynamic Preview", null, "IDTT_DYNAMIC_PREVIEW", null, true, paneActionListener));
            object2.setPopupMenu((JPopupMenu)objectArray);
            this.m_helpToolBar.add((Component)object2);
            object = new JPanel();
            ((Container)object).setLayout(new FlowLayout(0, 0, 0));
            ((Container)object).add(GUIFactory.createButton("Help", null, null, "Help.gif", "IDTT_HELP", true, paneActionListener));
            this.m_helpToolBar.add((Component)object);
        } else {
            this.m_helpToolBar.add(GUIFactory.createButton("Preview", null, null, "Preview.gif", "IDTT_PREVIEW", true, paneActionListener));
            this.m_helpToolBar.add(GUIFactory.createButton("Help", null, null, "Help.gif", "IDTT_HELP", true, paneActionListener));
        }
        object2 = new JPanel();
        ((Container)object2).setLayout(new FlowLayout(0, 0, 0));
        ((Container)object2).add(this.m_mainToolBar);
        ((Container)object2).add(this.m_editToolBar);
        ((Container)object2).add(this.m_moveToolBar);
        ((Container)object2).add(this.m_helpToolBar);
        objectArray = new Object[]{GUIFactory.getString("IDP_RESOURCE"), GUIFactory.getString("IDP_NAME"), GUIFactory.getString("IDS_STEP_HEADER")};
        this.m_tableModel = new PropertyTableModel(mutableProperties.getType());
        this.m_tableModel.setColumnIdentifiers(objectArray);
        this.m_table = new PaneContainerTable(gUIBuilder, this.m_tableModel, mutableProperties);
        this.m_table.setOpaque(true);
        this.m_table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = PaneContainerBuilder.class$("java.lang.Object")) : class$java$lang$Object, new PaneCellRenderer());
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_table.getSelectionModel().setSelectionMode(0);
        this.m_table.getSelectionModel().addListSelectionListener(new PaneSelectionListener());
        this.m_table.addMouseListener(new PaneMouseListener());
        this.m_table.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PaneContainerBuilder.this.stopEditing();
            }
        });
        this.m_modelListener = new PaneTableModelListener();
        this.m_tableModel.addTableModelListener(this.m_modelListener);
        object = null;
        switch (mutableProperties.getType()) {
            case 60: {
                object = "DeckPane.gif";
                break;
            }
            case 61: {
                object = "SplitPane.gif";
                break;
            }
            case 62: {
                object = "TabbedPane.gif";
                break;
            }
            case 120: {
                object = "Propsheet.gif";
                break;
            }
            case 121: {
                object = "Wizard.gif";
            }
        }
        if (object != null) {
            ((Frame)this).setIconImage(GUIFactory.getImage((String)object, true).getImage());
        }
        this.updateTitleBar(null);
        this.getContentPane().setBackground(this.m_table.getBackground());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)object2, "North");
        this.getContentPane().add((Component)new JScrollPane(this.m_table), "Center");
        int n = 0;
        Enumeration<TreeNode> enumeration = mutableProperties.children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties2 = (MutableProperties)enumeration.nextElement();
            this.insertProperties(mutableProperties2, n, false);
            ++n;
        }
        Dimension dimension = ((JComponent)object2).getPreferredSize();
        dimension.width += 10;
        if (dimension.width < 400) {
            dimension.width = 400;
        }
        dimension.height = 250;
        Dimension dimension2 = this.getPreferredSize();
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        ((Component)this).setSize(dimension);
        this.m_stepColumn = this.m_table.getColumnModel().getColumn(2);
        this.m_stepsShowing = true;
        this.toggleStepsColumn();
        this.initContextMenus();
    }

    void initContextMenus() {
        this.m_contextMenu = new JPopupMenu();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_PANE_EDIT_CUT", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_PANE_EDIT_COPY", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_PANE_EDIT_PASTE", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_PANE_EDIT_DELETE", null, false, this.m_menuListener));
    }

    JPopupMenu getContextMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(this.canCut());
        this.m_contextMenu.getComponent(1).setEnabled(this.canCopy());
        this.m_contextMenu.getComponent(2).setEnabled(this.canPaste());
        this.m_contextMenu.getComponent(3).setEnabled(this.canDelete());
        return this.m_contextMenu;
    }

    String getHelpName() {
        switch (this.getProperties().getType()) {
            default: {
                return null;
            }
            case 120: {
                return "PropertySheetBuilder";
            }
            case 121: {
                return "WizardBuilder";
            }
            case 60: {
                return "PaneBuilder";
            }
            case 61: {
                return "PaneBuilder";
            }
            case 62: 
        }
        return "PaneBuilder";
    }

    void toggleStepsColumn() {
        if (this.m_stepsShowing) {
            this.m_table.removeColumn(this.m_stepColumn);
            this.m_stepsShowing = false;
        }
    }

    public void stopEditing() {
        if (this.m_table.isEditing()) {
            ((DefaultCellEditor)this.m_table.getCellEditor()).stopCellEditing();
        }
    }

    boolean canAddPane() {
        return true;
    }

    boolean canAddNewPane() {
        int n = this.getProperties().getType();
        boolean bl = n == 120 || n == 121;
        return this.getBuilder().arePanesAvailable(this.getProperties(), bl);
    }

    public boolean canCut() {
        int n = this.getSelectedRow();
        int n2 = this.m_table.getRowCount();
        return n > -1 && n2 > 0;
    }

    public boolean canCopy() {
        int n = this.getSelectedRow();
        int n2 = this.m_table.getRowCount();
        return n > -1 && n2 > 0;
    }

    public boolean canPaste() {
        boolean bl = this.canAddPane();
        if (bl) {
            MutableProperties mutableProperties;
            int n;
            bl = false;
            Transferable transferable = this.getBuilder().getClipboard().getContents(this);
            if (transferable != null && transferable instanceof MutableProperties && (n = (mutableProperties = (MutableProperties)transferable).getType()) == 66) {
                boolean bl2;
                String string = (String)mutableProperties.getProperty("Resource");
                String string2 = (String)mutableProperties.getProperty("ID");
                String string3 = this.getPDMLDocument().getPDMLRoot().getResourceName(true, false);
                String string4 = (String)this.getProperties().getProperty("Name");
                bl = !string.equals(string3) || !string2.equals(string4);
                boolean bl3 = bl2 = n == 120 || n == 121;
                if (bl2) {
                    String string5 = (String)mutableProperties.getProperty("Type");
                    bl = bl && string5.equals("PANEL");
                }
            }
        }
        return bl;
    }

    public boolean canDelete() {
        int n = this.getSelectedRow();
        int n2 = this.m_table.getRowCount();
        return n > -1 && n2 > 0;
    }

    public void cut() {
        if (!this.canCut()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        MutableProperties mutableProperties = this.getTableSelection();
        this.doRemove();
        this.getBuilder().getClipboard().setContents(mutableProperties, mutableProperties);
        this.getPDMLDocument().endEdit();
    }

    public void copy() {
        if (!this.canCopy()) {
            return;
        }
        MutableProperties mutableProperties = this.getTableSelection();
        MutableProperties mutableProperties2 = mutableProperties.cloneNode(this.getPDMLDocument(), null);
        this.getBuilder().getClipboard().setContents(mutableProperties2, mutableProperties2);
    }

    public void paste() {
        MutableProperties mutableProperties;
        if (!this.canPaste()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        Transferable transferable = this.getBuilder().getClipboard().getContents(this);
        MutableProperties mutableProperties2 = ((MutableProperties)transferable).cloneNode(this.getPDMLDocument(), null);
        mutableProperties2.setPDMLDocument(this.getPDMLDocument());
        try {
            if (mutableProperties2.getProperty("Resource").equals(this.getPDMLDocument().getPDMLRoot().getResourceName(true, false))) {
                mutableProperties = this.getPDMLDocument().getPDMLRoot().getNodeNamed((String)mutableProperties2.getProperty("ID"));
                mutableProperties2.setProperty("File Target", this.getPDMLDocument().getPDMLRoot());
                if (mutableProperties != null) {
                    mutableProperties2.setProperty("Target", mutableProperties);
                } else {
                    mutableProperties2.setProperty("Target", "");
                }
            } else {
                mutableProperties2.setProperty("File Target", "");
                mutableProperties2.setProperty("Target", "");
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        mutableProperties = this.getTableSelection();
        if (mutableProperties == null) {
            this.getProperties().add(mutableProperties2);
        } else {
            this.getProperties().insert(mutableProperties2, this.getProperties().getIndex(mutableProperties) + 1);
        }
        this.getPDMLDocument().endEdit();
    }

    public void delete() {
        if (!this.canDelete()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        this.doRemove();
        this.getPDMLDocument().endEdit();
    }

    public MutableProperties getSelectedProperties() {
        return this.getProperties();
    }

    MutableProperties getTableSelection() {
        int n = this.getSelectedRow();
        if (n > -1) {
            return (MutableProperties)this.m_tableModel.getValueAt(n, 0);
        }
        return null;
    }

    PaneProperties getPaneAtIndex(int n) {
        return (PaneProperties)this.getProperties().getChildAt(n);
    }

    void insertProperties(MutableProperties mutableProperties, int n, boolean bl) {
        Object[] objectArray = new Object[]{mutableProperties, mutableProperties};
        this.m_tableModel.insertRow(n, objectArray);
        if (bl) {
            this.m_table.setRowSelectionInterval(n, n);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(n, 0, true));
        }
    }

    void removeProperties(MutableProperties mutableProperties, int n) {
        this.m_tableModel.removeRow(n);
    }

    void doAdd() {
        MutableProperties mutableProperties;
        int n = this.getProperties().getType();
        boolean bl = n == 120 || n == 121;
        PaneProperties paneProperties = this.getBuilder().getFirstAvailablePane(this.getProperties(), bl);
        paneProperties.setPDMLDocument(this.getPDMLDocument());
        try {
            if (paneProperties.getProperty("Resource").equals(this.getPDMLDocument().getPDMLRoot().getResourceName(true, false))) {
                mutableProperties = this.getPDMLDocument().getPDMLRoot().getNodeNamed((String)paneProperties.getProperty("ID"));
                paneProperties.setProperty("File Target", this.getPDMLDocument().getPDMLRoot());
                if (mutableProperties != null) {
                    paneProperties.setProperty("Target", mutableProperties);
                } else {
                    paneProperties.setProperty("Target", "");
                }
            } else {
                paneProperties.setProperty("File Target", "");
                paneProperties.setProperty("Target", "");
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        mutableProperties = this.getTableSelection();
        if (mutableProperties == null) {
            this.getProperties().add(paneProperties);
        } else {
            this.getProperties().insert(paneProperties, this.getProperties().getIndex(mutableProperties) + 1);
        }
    }

    void doRemove() {
        MutableProperties mutableProperties = this.getTableSelection();
        if (mutableProperties != null) {
            int n = this.getSelectedRow();
            mutableProperties.removeFromParent();
            int n2 = this.m_table.getRowCount();
            if (n2 > 0) {
                if (n >= n2) {
                    n = n2 - 1;
                }
                this.m_table.setRowSelectionInterval(n, n);
            }
        }
    }

    void doMoveUp() {
        MutableProperties mutableProperties = this.getTableSelection();
        if (mutableProperties != null) {
            MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
            int n = mutableProperties2.getIndex(mutableProperties);
            mutableProperties.removeFromParent();
            mutableProperties2.insert(mutableProperties, n - 1);
        }
    }

    void doMoveDown() {
        MutableProperties mutableProperties = this.getTableSelection();
        if (mutableProperties != null) {
            MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
            int n = mutableProperties2.getIndex(mutableProperties);
            mutableProperties.removeFromParent();
            mutableProperties2.insert(mutableProperties, n + 1);
        }
    }

    public void updateBuilder() {
        boolean bl;
        boolean bl2;
        int n = this.getSelectedRow();
        int n2 = this.m_table.getRowCount();
        boolean bl3 = bl2 = n > -1 && n2 > 0;
        boolean bl4 = bl2 ? n > 0 : (bl = false);
        boolean bl5 = bl2 ? n < n2 - 1 : false;
        boolean bl6 = n2 > 0;
        boolean bl7 = n2 > 0;
        this.m_mainToolBar.getComponent(0).setEnabled(this.canAddNewPane());
        this.m_mainToolBar.getComponent(1).setEnabled(bl2);
        this.m_moveToolBar.getComponent(0).setEnabled(bl);
        this.m_moveToolBar.getComponent(1).setEnabled(bl5);
        this.m_moveToolBar.getComponent(2).setEnabled(bl6);
        this.m_editToolBar.getComponent(0).setEnabled(this.canCut());
        this.m_editToolBar.getComponent(1).setEnabled(this.canCopy());
        this.m_editToolBar.getComponent(2).setEnabled(this.canPaste());
        this.m_helpToolBar.getComponent(0).setEnabled(bl7);
    }

    public void updateTitleBar(String string) {
        String string2;
        if (string == null && (string = (String)this.getPDMLDocument().getPDMLRoot().getProperty("File Name")).equals("")) {
            string = this.getPDMLDocument().getPDMLRoot().getResourceName(true, true);
        }
        if ((string2 = (String)this.getProperties().getProperty("Title")) == null) {
            string2 = "";
        }
        string2 = string2 + " (" + this.getProperties().getProperty("Name");
        string2 = string2 + ": " + string + ")";
        this.setTitle(string2);
    }

    int getSelectedRow() {
        int[] nArray = this.m_table.getSelectedRows();
        if (nArray.length == 0) {
            return -1;
        }
        return nArray[0];
    }

    public void setSelectedProperties(MutableProperties mutableProperties) {
        this.m_table.clearSelection();
        int n = this.m_table.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            MutableProperties mutableProperties2 = (MutableProperties)this.m_table.getValueAt(n2, 0);
            if (mutableProperties2.equals(mutableProperties)) {
                this.m_table.setRowSelectionInterval(n2, n2);
                this.m_table.scrollRectToVisible(this.m_table.getCellRect(n2, 0, true));
                break;
            }
            ++n2;
        }
    }

    public void uninstallListeners() {
        this.getProperties().removePDMLNodeListener(this.m_pdmlNodeListener);
        this.getProperties().removeTreeModelListener(this.m_treeModelListener);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PaneTableModelListener
    implements TableModelListener {
        PaneTableModelListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 0) {
                PaneContainerBuilder.this.m_tableModel.removeTableModelListener(PaneContainerBuilder.this.m_modelListener);
                int n = tableModelEvent.getColumn();
                int n2 = tableModelEvent.getFirstRow();
                if (n == 0) {
                    Object object = PaneContainerBuilder.this.m_tableModel.getValueAt(n2, 0);
                    if (object instanceof XMLGUIBuilderDefinition) {
                        int n3 = PaneContainerBuilder.this.getProperties().getType();
                        boolean bl = n3 == 120 || n3 == 121;
                        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)object;
                        PaneProperties paneProperties = PaneContainerBuilder.this.getBuilder().getFirstAvailablePane(xMLGUIBuilderDefinition.getPDMLRoot(), bl);
                        PaneProperties paneProperties2 = PaneContainerBuilder.this.getPaneAtIndex(n2);
                        if (!paneProperties.getProperty("Resource").equals(paneProperties2.getProperty("Resource"))) {
                            PaneContainerBuilder.this.getPDMLDocument().beginEdit();
                            try {
                                paneProperties2.setProperty("Resource", paneProperties.getProperty("Resource"));
                                paneProperties2.setProperty("ID", paneProperties.getProperty("ID"));
                                paneProperties2.setProperty("Type", paneProperties.getProperty("Type"));
                                if (xMLGUIBuilderDefinition.equals(PaneContainerBuilder.this.getPDMLDocument())) {
                                    paneProperties2.setProperty("File Target", PaneContainerBuilder.this.getPDMLDocument().getPDMLRoot());
                                    MutableProperties mutableProperties = xMLGUIBuilderDefinition.getPDMLRoot().getNodeNamed((String)paneProperties.getProperty("ID"));
                                    if (mutableProperties != null) {
                                        paneProperties2.setProperty("Target", mutableProperties);
                                    } else {
                                        paneProperties2.setProperty("Target", "");
                                    }
                                } else {
                                    paneProperties2.setProperty("File Target", "");
                                    paneProperties2.setProperty("Target", "");
                                }
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                            PaneContainerBuilder.this.getPDMLDocument().endEdit();
                        }
                        PaneContainerBuilder.this.m_tableModel.setValueAt(paneProperties2, n2, 0);
                        PaneContainerBuilder.this.m_tableModel.setValueAt(paneProperties2, n2, 1);
                    } else {
                        object = PaneContainerBuilder.this.m_tableModel.getValueAt(n2, 1);
                        PaneContainerBuilder.this.m_tableModel.setValueAt(object, n2, 0);
                    }
                } else if (n == 1) {
                    PaneProperties paneProperties = (PaneProperties)PaneContainerBuilder.this.m_tableModel.getValueAt(n2, n);
                    PaneProperties paneProperties3 = PaneContainerBuilder.this.getPaneAtIndex(n2);
                    if (!paneProperties3.getProperty("ID").equals(paneProperties.getProperty("ID"))) {
                        PaneContainerBuilder.this.getPDMLDocument().beginEdit();
                        try {
                            paneProperties3.setProperty("Resource", paneProperties.getProperty("Resource"));
                            paneProperties3.setProperty("ID", paneProperties.getProperty("ID"));
                            paneProperties3.setProperty("Type", paneProperties.getProperty("Type"));
                            if (paneProperties.getProperty("Resource").equals(PaneContainerBuilder.this.getPDMLDocument().getPDMLRoot().getResourceName(true, false))) {
                                MutableProperties mutableProperties = PaneContainerBuilder.this.getPDMLDocument().getPDMLRoot().getNodeNamed((String)paneProperties.getProperty("ID"));
                                if (mutableProperties != null) {
                                    paneProperties3.setProperty("Target", mutableProperties);
                                } else {
                                    paneProperties3.setProperty("Target", "");
                                }
                            } else {
                                paneProperties3.setProperty("Target", "");
                            }
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        PaneContainerBuilder.this.getPDMLDocument().endEdit();
                    }
                    PaneContainerBuilder.this.m_tableModel.setValueAt(paneProperties3, n2, 1);
                } else if (n == 2) {
                    String string;
                    PaneProperties paneProperties = PaneContainerBuilder.this.getPaneAtIndex(n2);
                    String string2 = (String)PaneContainerBuilder.this.m_tableModel.getValueAt(n2, n);
                    if (!string2.equals(string = (String)paneProperties.getProperty("Step"))) {
                        PaneContainerBuilder.this.getPDMLDocument().beginEdit(true);
                        try {
                            paneProperties.setProperty("Step", string2);
                            PaneContainerBuilder.this.getPDMLDocument().endEdit();
                            ((WizardProperties)PaneContainerBuilder.this.getProperties()).updateSteps();
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            PaneContainerBuilder.this.getPDMLDocument().abortEdit();
                            JOptionPane.showMessageDialog(PaneContainerBuilder.this, propertyVetoException.getMessage(), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                        }
                    }
                    PaneContainerBuilder.this.m_tableModel.setValueAt(paneProperties, n2, 2);
                }
                PaneContainerBuilder.this.m_tableModel.addTableModelListener(PaneContainerBuilder.this.m_modelListener);
            }
            PaneContainerBuilder.this.getBuilder().updateBuilder();
        }
    }

    class PaneTreeModelListener
    implements TreeModelListener {
        PaneTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            PaneContainerBuilder.this.repaint();
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            if (treePath.getLastPathComponent().equals(PaneContainerBuilder.this.getProperties())) {
                Object[] objectArray = treeModelEvent.getChildren();
                int[] nArray = treeModelEvent.getChildIndices();
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                    PaneContainerBuilder.this.insertProperties(mutableProperties, nArray[n], true);
                    ++n;
                }
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            if (treePath.getLastPathComponent().equals(PaneContainerBuilder.this.getProperties())) {
                Object[] objectArray = treeModelEvent.getChildren();
                int[] nArray = treeModelEvent.getChildIndices();
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                    PaneContainerBuilder.this.removeProperties(mutableProperties, nArray[n]);
                    ++n;
                }
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    class PanePDMLNodeListener
    implements PDMLNodeListener {
        PanePDMLNodeListener() {
        }

        public void PDMLNodeChanged(PDMLNodeEvent pDMLNodeEvent) {
            PaneContainerBuilder.this.updateTitleBar(null);
        }

        public void PDMLNodeInserted(PDMLNodeEvent pDMLNodeEvent) {
        }

        public void PDMLNodeRemoved(PDMLNodeEvent pDMLNodeEvent) {
        }
    }

    class PaneCellRenderer
    extends DefaultTableCellRenderer {
        PaneCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                super.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                super.setForeground(jTable.getForeground());
                super.setBackground(jTable.getBackground());
            }
            this.setFont(jTable.getFont());
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(DefaultTableCellRenderer.noFocusBorder);
            }
            if (object != null) {
                this.setValue(object);
                this.setIcon(null);
                if (object instanceof PaneProperties) {
                    PaneProperties paneProperties = (PaneProperties)object;
                    if (n2 == 0) {
                        this.setText((String)paneProperties.getProperty("Resource"));
                    } else if (n2 == 1) {
                        this.setText((String)paneProperties.getProperty("ID"));
                        String string = (String)paneProperties.getProperty("Type");
                        String string2 = null;
                        if (string != null) {
                            if ((string = string.toUpperCase()).equals("PANEL")) {
                                string2 = "Panel.gif";
                            } else if (string.equals("DECK")) {
                                string2 = "DeckPane.gif";
                            } else if (string.equals("SPLIT")) {
                                string2 = "SplitPane.gif";
                            } else if (string.equals("TAB")) {
                                string2 = "TabbedPane.gif";
                            }
                        }
                        if (string2 != null) {
                            this.setIcon(GUIFactory.getImage(string2, true));
                        }
                    } else if (n2 == 2) {
                        this.setText((String)paneProperties.getProperty("Step"));
                    }
                }
            }
            return this;
        }
    }

    class PaneSelectionListener
    implements ListSelectionListener {
        PaneSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            PaneContainerBuilder.this.fireSelectionChangedEvent();
        }
    }

    class PaneMouseListener
    extends MouseAdapter {
        PaneMouseListener() {
        }

        void showContextMenu(MouseEvent mouseEvent) {
            int n = PaneContainerBuilder.this.m_table.rowAtPoint(mouseEvent.getPoint());
            int n2 = PaneContainerBuilder.this.m_table.columnAtPoint(mouseEvent.getPoint());
            if (n != -1 && n == PaneContainerBuilder.this.getSelectedRow() && n2 > -1) {
                JPopupMenu jPopupMenu = PaneContainerBuilder.this.getContextMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }
    }

    class PaneActionListener
    implements ActionListener {
        PaneActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PaneContainerBuilder.this.stopEditing();
            String string = actionEvent.getActionCommand();
            if (string.equals("Add")) {
                PaneContainerBuilder.this.getPDMLDocument().beginEdit();
                PaneContainerBuilder.this.doAdd();
                PaneContainerBuilder.this.getPDMLDocument().endEdit();
                PaneContainerBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Remove")) {
                PaneContainerBuilder.this.getPDMLDocument().beginEdit();
                PaneContainerBuilder.this.doRemove();
                PaneContainerBuilder.this.getPDMLDocument().endEdit();
                PaneContainerBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Move Up")) {
                PaneContainerBuilder.this.getPDMLDocument().beginEdit(true);
                PaneContainerBuilder.this.doMoveUp();
                PaneContainerBuilder.this.getPDMLDocument().endEdit();
                PaneContainerBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Move Down")) {
                PaneContainerBuilder.this.getPDMLDocument().beginEdit(true);
                PaneContainerBuilder.this.doMoveDown();
                PaneContainerBuilder.this.getPDMLDocument().endEdit();
                PaneContainerBuilder.this.getBuilder().updateBuilder();
            } else if (string.startsWith("Edit")) {
                if ((string = string.substring(5)).equals("Cut")) {
                    PaneContainerBuilder.this.cut();
                    PaneContainerBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Copy")) {
                    PaneContainerBuilder.this.copy();
                    PaneContainerBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Paste")) {
                    PaneContainerBuilder.this.paste();
                    PaneContainerBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Delete")) {
                    PaneContainerBuilder.this.delete();
                    PaneContainerBuilder.this.getBuilder().updateBuilder();
                }
            } else if (string.equals("Loop")) {
                LoopDialog loopDialog = new LoopDialog(PaneContainerBuilder.this.getProperties(), PaneContainerBuilder.this.getBuilder(), PaneContainerBuilder.this);
                if (!loopDialog.findLoops() && !loopDialog.loopsExisted()) {
                    JOptionPane.showMessageDialog(PaneContainerBuilder.this, GUIFactory.getString("IDS_NO_LOOP_FOUND"), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 1);
                }
            } else if (string.equals("Preview")) {
                PaneContainerBuilder.this.setCursor(Cursor.getPredefinedCursor(3));
                PaneContainerBuilder.this.getBuilder().doPreview(PaneContainerBuilder.this.getProperties());
                PaneContainerBuilder.this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (string.equals("Dynamic Preview")) {
                PaneContainerBuilder.this.setCursor(Cursor.getPredefinedCursor(3));
                PaneContainerBuilder.this.getBuilder().doPreview(PaneContainerBuilder.this.getProperties(), true);
                PaneContainerBuilder.this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (string.equals("Help")) {
                PaneContainerBuilder.this.displayHelp();
            }
        }
    }
}

