/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.ComponentDescriptor;
import com.ibm.as400.ui.framework.MessageLog;
import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.PropertyPageDescriptor;
import com.ibm.as400.ui.framework.XMLPanelDefinition;
import com.ibm.as400.ui.framework.XMLPropertySheetDefinition;
import com.ibm.as400.ui.tools.HelpDocParser;
import com.ibm.as400.ui.tools.HelpDocTagDescriptor;
import com.ibm.as400.ui.tools.HelpException;
import com.ibm.as400.ui.tools.HelpFileParser;
import com.ibm.as400.ui.tools.ToolsResourceLoader;
import com.ibm.as400.ui.tools.XMLGUIDefinition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Vector;

public class OnlineHelpGeneratorEx {
    public static ToolsResourceLoader resourceLoader = new ToolsResourceLoader();
    public static boolean m_descriptorTrace;
    private static String m_hr;
    private static String m_generatorExtension;
    private static String m_backupExtension;
    public boolean m_update = false;
    private String m_backupFile = null;
    private String m_inputFileName = null;
    private Hashtable m_SegmentList = new Hashtable();
    private Hashtable m_pdmlToDo = new Hashtable();
    private Hashtable m_badLinks = new Hashtable();
    private static PrintWriter m_pwOut;
    private Vector m_componentList = new Vector();
    private HelpFileParser m_hp = new HelpFileParser();

    public static void main(String[] stringArray) throws MissingResourceException, ParseException, FileNotFoundException, IOException, PDMLSpecificationException, HelpException {
        System.setErr(System.out);
        if (stringArray.length == 1) {
            try {
                new OnlineHelpGeneratorEx(stringArray[0]);
            }
            catch (ParseException parseException) {
                System.out.println("IDNA_PARSE_EXCEPTION");
                System.exit(2);
            }
            catch (HelpException helpException) {
                System.out.println(helpException);
                System.exit(2);
            }
            System.exit(0);
        } else {
            System.out.println(resourceLoader.getString("IDOHGX_HELP_GENERATOR_ARGUMENTS"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OnlineHelpGeneratorEx(String string) throws MissingResourceException, ParseException, FileNotFoundException, IOException, PDMLSpecificationException, HelpException {
        File file;
        String string2 = null;
        int n = string.replace('\\', '/').lastIndexOf(47);
        if (n > -1) {
            string2 = string.substring(0, n + 1);
        }
        String string3 = string;
        n = string.replace('\\', '/').lastIndexOf(46);
        if (n > -1) {
            string3 = string.substring(0, n);
        }
        XMLGUIDefinition xMLGUIDefinition = new XMLGUIDefinition(string, string3);
        this.m_inputFileName = string3 + ".html";
        File file2 = new File(this.m_inputFileName);
        this.debug("filename :" + this.m_inputFileName + " exists? " + file2.exists());
        if (file2.exists()) {
            this.m_update = true;
        }
        File file3 = new File(string3 + m_backupExtension);
        File file4 = new File(string3 + m_generatorExtension);
        this.canRename(file2);
        this.canRename(file3);
        this.canRename(file4);
        try {
            Object[] objectArray;
            Object[] objectArray2;
            this.GenerateHelp(string, string2, string3, xMLGUIDefinition);
            try {
                if (file3.exists() && !file3.delete()) {
                    objectArray2 = new Object[]{file3};
                    System.out.println(MessageFormat.format(resourceLoader.getString("IDOHGX_FILE_NOT_DELETED"), objectArray2));
                }
            }
            catch (SecurityException securityException) {
                System.out.println(resourceLoader.getString("IDOHGX_SECURITY_EXCEPTION"));
                System.out.println(securityException.getMessage());
                objectArray = new Object[]{file3};
                System.out.println(MessageFormat.format(resourceLoader.getString("IDOHGX_FILE_NOT_DELETED"), objectArray));
            }
            try {
                if (file2.exists() && !file2.renameTo(file3)) {
                    objectArray2 = new Object[]{file2};
                    System.out.println(MessageFormat.format(resourceLoader.getString("IDOHGX_FILE_NOT_RENAMED"), objectArray2));
                }
            }
            catch (SecurityException securityException) {
                System.out.println(resourceLoader.getString("IDOHGX_SECURITY_EXCEPTION"));
                System.out.println(securityException.getMessage());
                objectArray = new Object[]{file2};
                System.out.println(MessageFormat.format(resourceLoader.getString("IDOHGX_FILE_NOT_RENAMED"), objectArray));
            }
            objectArray2 = new File(string3 + ".html");
            try {
                if (!file4.renameTo((File)objectArray2)) {
                    objectArray = new Object[]{objectArray2};
                    throw new HelpException(MessageFormat.format(resourceLoader.getString("IDOHGX_FILE_NOT_CREATED"), objectArray));
                }
            }
            catch (SecurityException securityException) {
                System.out.println(resourceLoader.getString("IDOHGX_SECURITY_EXCEPTION"));
                System.out.println(securityException.getMessage());
                Object[] objectArray3 = new Object[]{objectArray2};
                String string4 = MessageFormat.format(resourceLoader.getString("IDOHGX_FILE_NOT_CREATED"), objectArray3) + "\n";
                string4 = string4 + securityException.getMessage();
                throw new HelpException(string4);
            }
            Object var14_16 = null;
            file = new File(string3 + m_generatorExtension);
            if (!file.exists()) return;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            File file5 = new File(string3 + m_generatorExtension);
            if (!file5.exists()) throw throwable;
            try {
                file5.delete();
                throw throwable;
            }
            catch (SecurityException securityException) {
                System.out.println(resourceLoader.getString("IDOHGX_SECURITY_EXCEPTION"));
                System.out.println(securityException.getMessage());
                Object[] objectArray = new Object[]{file5};
                System.out.println(MessageFormat.format(resourceLoader.getString("IDOHGX_FILE_NOT_DELETED"), objectArray));
            }
            throw throwable;
        }
        try {
            file.delete();
            return;
        }
        catch (SecurityException securityException) {
            System.out.println(resourceLoader.getString("IDOHGX_SECURITY_EXCEPTION"));
            System.out.println(securityException.getMessage());
            Object[] objectArray = new Object[]{file};
            System.out.println(MessageFormat.format(resourceLoader.getString("IDOHGX_FILE_NOT_DELETED"), objectArray));
        }
    }

    private void canRename(File file) throws HelpException {
        if (file != null && file.exists()) {
            try {
                if (!file.canWrite()) {
                    Object[] objectArray = new Object[]{file};
                    throw new HelpException(MessageFormat.format(resourceLoader.getString("IDOHGX_FILE_IN_USE"), objectArray));
                }
            }
            catch (SecurityException securityException) {
                Object[] objectArray = new Object[]{file};
                throw new HelpException(MessageFormat.format(resourceLoader.getString("IDOHGX_FILE_IN_USE"), objectArray));
            }
        }
    }

    private void GenerateHelp(String string, String string2, String string3, XMLGUIDefinition xMLGUIDefinition) throws MissingResourceException, ParseException, FileNotFoundException, IOException, PDMLSpecificationException, HelpException {
        m_pwOut = new PrintWriter(new FileWriter(string3 + m_generatorExtension));
        try {
            try {
                this.buildPDMLToDo(xMLGUIDefinition, string2);
                this.buildSegmentList();
                this.buildBadLinks();
                if (this.m_update) {
                    this.reuseOldSegments();
                } else {
                    this.writeHeader(resourceLoader.getString("IDOHG_HTML_TITLE"));
                }
                this.processPanels();
                this.catchAllControls();
                this.writeFooter();
                m_pwOut.close();
            }
            catch (HelpException helpException) {
                Object[] objectArray = new Object[]{new String(helpException.getMessage())};
                String string4 = MessageFormat.format(resourceLoader.getString("IDOHGX_PROCESSING_FAILED"), objectArray);
                throw new HelpException(string4);
            }
            Object var9_5 = null;
            m_pwOut.close();
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            m_pwOut.close();
            throw throwable;
        }
    }

    private void buildPDMLToDo(XMLGUIDefinition xMLGUIDefinition, String string) {
        Object object;
        Vector vector = this.getPanelElements(xMLGUIDefinition, string);
        int n = 0;
        while (n < vector.size()) {
            Vector vector2;
            object = (PDMLPanelElement)vector.elementAt(n);
            this.m_pdmlToDo.put(((PDMLPanelElement)object).panel.getPanel().m_name + ".html", object);
            this.debug("");
            this.debug(" TODO: Panel: " + ((PDMLPanelElement)object).panel.getPanel().m_name + ".html");
            this.debug(" ---------------------------------------------------- ");
            ((PDMLPanelElement)object).vElements = vector2 = this.getPanelComponentElements(((PDMLPanelElement)object).panel);
            int n2 = 0;
            while (n2 < vector2.size()) {
                PDMLControlElement pDMLControlElement = (PDMLControlElement)vector2.elementAt(n2);
                this.m_pdmlToDo.put(((PDMLPanelElement)object).panel.getPanel().m_name + "." + pDMLControlElement.cd.m_name + ".html", pDMLControlElement);
                this.debug(" TODO: Control: " + ((PDMLPanelElement)object).panel.getPanel().m_name + "." + pDMLControlElement.cd.m_name + ".html");
                ++n2;
            }
            ++n;
        }
        if (m_descriptorTrace) {
            System.out.println();
            System.out.println("------------Todo Hashtable----------");
            object = this.m_pdmlToDo.keys();
            while (object.hasMoreElements()) {
                System.out.println(object.nextElement());
            }
            System.out.println();
        }
    }

    private void buildBadLinks() {
        Object object;
        Enumeration enumeration = this.m_SegmentList.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (this.m_pdmlToDo.containsKey(object)) continue;
            this.m_badLinks.put(object, object);
        }
        if (m_descriptorTrace) {
            System.out.println();
            System.out.println("------------ BadLinks Hashtable----------");
            object = this.m_badLinks.keys();
            while (object.hasMoreElements()) {
                System.out.println(object.nextElement());
            }
            System.out.println();
        }
    }

    private Vector getPanelElements(XMLGUIDefinition xMLGUIDefinition, String string) {
        String string2;
        Object object;
        Vector<String> vector = new Vector<String>();
        Vector<PDMLPanelElement> vector2 = new Vector<PDMLPanelElement>();
        Enumeration enumeration = xMLGUIDefinition.propertySheets();
        while (enumeration.hasMoreElements()) {
            object = (XMLPropertySheetDefinition)enumeration.nextElement();
            string2 = object.getPropertySheet().m_title;
            Vector vector3 = object.getPropertySheetPages();
            int n = vector3.size();
            int n2 = 0;
            while (n2 < n) {
                PropertyPageDescriptor propertyPageDescriptor = (PropertyPageDescriptor)vector3.elementAt(n2);
                XMLPanelDefinition xMLPanelDefinition = xMLGUIDefinition.getPanel(propertyPageDescriptor.m_pageName);
                if (xMLPanelDefinition != null) {
                    vector.addElement(propertyPageDescriptor.m_pageName);
                    vector2.addElement(new PDMLPanelElement(xMLPanelDefinition, string2, string, null, false));
                }
                ++n2;
            }
        }
        enumeration = xMLGUIDefinition.panelNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (vector.contains(object)) continue;
            string2 = xMLGUIDefinition.getPanel((String)object);
            vector2.addElement(new PDMLPanelElement((XMLPanelDefinition)string2, null, string, null, false));
        }
        return vector2;
    }

    private Vector getPanelComponentElements(XMLPanelDefinition xMLPanelDefinition) {
        int n;
        ComponentDescriptor componentDescriptor;
        this.m_componentList = new Vector();
        Enumeration enumeration = xMLPanelDefinition.getPanelComponents().elements();
        while (enumeration.hasMoreElements()) {
            componentDescriptor = (ComponentDescriptor)enumeration.nextElement();
            if (componentDescriptor.m_element.equals("BUTTONGROUP")) {
                n = 0;
                while (n < componentDescriptor.m_groupButtons.size()) {
                    ComponentDescriptor componentDescriptor2 = (ComponentDescriptor)componentDescriptor.m_groupButtons.elementAt(n);
                    this.processComponent(componentDescriptor2);
                    ++n;
                }
            }
            this.processComponent(componentDescriptor);
        }
        componentDescriptor = new Vector();
        n = 0;
        while (n < this.m_componentList.size()) {
            componentDescriptor.addElement(new PDMLControlElement(xMLPanelDefinition, (ComponentDescriptor)this.m_componentList.elementAt(n), false));
            ++n;
        }
        return componentDescriptor;
    }

    private void writeHeader(String string) {
        m_pwOut.println("<html>");
        m_pwOut.println(resourceLoader.getString("IDOHG_HTML_PRE_HEAD"));
        m_pwOut.println("<head>");
        m_pwOut.println(resourceLoader.getString("IDOHG_HTML_PRE_TITLE"));
        m_pwOut.println("<title>" + string + "</title>");
        m_pwOut.println("</head>");
        m_pwOut.println();
        m_pwOut.println("<body>");
        m_pwOut.println("<!-- HELPDOC:HEADEREND -->");
        m_pwOut.println(m_hr);
        m_pwOut.println();
    }

    private void writeFooter() {
        m_pwOut.println();
        m_pwOut.println();
        m_pwOut.println(m_hr);
        m_pwOut.println("<!-- HELPDOC:FOOTERBEGIN -->");
        m_pwOut.println();
        m_pwOut.println("</body>");
        m_pwOut.println();
        m_pwOut.println("</html>");
    }

    private void processPanels() {
        Enumeration enumeration = this.m_pdmlToDo.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof PDMLPanelElement) || ((PDMLPanelElement)v).done) continue;
            PDMLPanelElement pDMLPanelElement = (PDMLPanelElement)v;
            this.generatePanelHelp(pDMLPanelElement);
        }
    }

    private void catchAllControls() {
        Enumeration enumeration = this.m_pdmlToDo.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof PDMLControlElement) || ((PDMLControlElement)v).done) continue;
            Object[] objectArray = new Object[]{(PDMLControlElement)v};
            MessageLog.traceErr((Object)MessageFormat.format(resourceLoader.getString("IDOHGX_UNEXPECTED_EXTRA_CONTROL_PROCESSED"), objectArray));
        }
    }

    private void generatePanelHelp(PDMLPanelElement pDMLPanelElement) {
        try {
            this.generatePanel(pDMLPanelElement);
        }
        catch (HelpException helpException) {
            helpException.printStackTrace();
        }
    }

    private void generatePanel(PDMLPanelElement pDMLPanelElement) throws HelpException {
        Object object;
        Object object2;
        this.m_componentList = new Vector();
        if (!this.m_update) {
            try {
                this.m_hp.processHelpFile(pDMLPanelElement.sDirectory + pDMLPanelElement.panel.getPanel().m_name + ".html");
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (ParseException parseException) {
                Object[] objectArray = new Object[]{new String(pDMLPanelElement.sDirectory + pDMLPanelElement.panel.getPanel().m_name + ".pdml"), parseException};
                throw new HelpException(MessageFormat.format(resourceLoader.getString("IDOHGX_PARSE_EXCEPTION"), objectArray));
            }
            catch (IOException iOException) {
                object2 = new Object[]{new String(pDMLPanelElement.sDirectory + pDMLPanelElement.panel.getPanel().m_name + ".pdml"), iOException};
                MessageLog.traceErr((Object)MessageFormat.format(resourceLoader.getString("IDOHGX_IO_EXCEPTION_CONTINUE"), object2));
            }
        }
        if (!this.m_SegmentList.containsKey(pDMLPanelElement.panel.getPanel().m_name + ".html")) {
            this.debug("Creating content for Panel: " + pDMLPanelElement.panel.getPanel().m_name + ".html");
            m_pwOut.println();
            m_pwOut.println();
            m_pwOut.println(m_hr);
            m_pwOut.println("<!-- HELPDOC:SEGMENTBEGIN PDMLSYNCH=\"YES\" -->");
            m_pwOut.println("<a name=\"" + pDMLPanelElement.panel.getPanel().m_name + ".html\">" + "</a>");
            m_pwOut.println("<h1>" + pDMLPanelElement.panel.getPanel().m_title + "</h1>");
            Object[] objectArray = new Object[]{new String(pDMLPanelElement.panel.getPanel().m_title)};
            object = MessageFormat.format(resourceLoader.getString("IDOHG_HTML_INSERT_OVERVIEW_HERE"), objectArray);
            m_pwOut.println(this.getHelpcontentOrDefault("OVERVIEW", (String)object));
            if (pDMLPanelElement.vElements.size() > 0) {
                m_pwOut.println(resourceLoader.getString("IDOHG_HTML_DETAIL_LIST_LEAD"));
                m_pwOut.println("<BLOCKQUOTE>");
                m_pwOut.println("<p>");
                int n = 0;
                while (n < pDMLPanelElement.vElements.size()) {
                    object2 = (PDMLControlElement)pDMLPanelElement.vElements.elementAt(n);
                    ComponentDescriptor componentDescriptor = object2.cd;
                    String string = componentDescriptor.m_title != null && componentDescriptor.m_title.length() > 0 ? componentDescriptor.m_title : componentDescriptor.m_name;
                    m_pwOut.println("<a href=\"#" + pDMLPanelElement.panel.getPanel().m_name + "." + componentDescriptor.m_name + ".html\"" + ">" + string + "</a>");
                    m_pwOut.println("<p>");
                    ++n;
                }
                m_pwOut.println("</BLOCKQUOTE>");
            }
            m_pwOut.println("<!-- HELPDOC:SEGMENTEND -->");
            m_pwOut.println(m_hr);
            pDMLPanelElement.done = true;
        }
        int n = 0;
        while (n < pDMLPanelElement.vElements.size()) {
            object = (PDMLControlElement)pDMLPanelElement.vElements.elementAt(n);
            ComponentDescriptor componentDescriptor = ((PDMLControlElement)object).cd;
            if (!this.m_SegmentList.containsKey(pDMLPanelElement.panel.getPanel().m_name + "." + componentDescriptor.m_name + ".html")) {
                m_pwOut.println();
                m_pwOut.println();
                m_pwOut.println(m_hr);
                m_pwOut.println(this.createComponentContent(pDMLPanelElement.panel, componentDescriptor));
                this.debug("Creating content for Control: " + pDMLPanelElement.panel.getPanel().m_name + "." + componentDescriptor.m_name + ".html");
                m_pwOut.println(m_hr);
            }
            ((PDMLControlElement)object).done = true;
            ++n;
        }
    }

    private String createComponentContent(XMLPanelDefinition xMLPanelDefinition, ComponentDescriptor componentDescriptor) {
        String string = "";
        String string2 = componentDescriptor.m_title != null && componentDescriptor.m_title.length() > 0 ? componentDescriptor.m_title : componentDescriptor.m_name;
        string = string + "<!-- HELPDOC:SEGMENTBEGIN PDMLSYNCH=\"YES\" -->\r\n";
        string = string + "<a name=\"" + xMLPanelDefinition.getPanel().m_name + "." + componentDescriptor.m_name + ".html\"" + "></a>\r\n";
        string = string + "<h2>" + string2 + "</h2>\r\n";
        Object[] objectArray = new Object[]{string2};
        String string3 = MessageFormat.format(resourceLoader.getString("IDOHG_HTML_INSERT_HELP_HERE"), objectArray);
        string = string + this.getHelpcontentOrDefault(componentDescriptor.m_name, string3);
        string = string + "<p>\r\n";
        string = string + "<!-- HELPDOC:SEGMENTEND -->\r\n";
        return string;
    }

    private String getHelpcontentOrDefault(String string, String string2) {
        String string3 = "";
        if (!this.m_update) {
            Vector vector = this.m_hp.getSectionContent(string);
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    string3 = string3 + vector.elementAt(n) + "\r\n";
                    ++n;
                }
            } else {
                string3 = string3 + string2 + "\r\n";
            }
        } else {
            string3 = string3 + string2 + "\r\n";
        }
        return string3;
    }

    private void processComponent(ComponentDescriptor componentDescriptor) {
        if (componentDescriptor.m_helpLink != null) {
            if (componentDescriptor.m_helpLink.trim().length() > 0) {
                componentDescriptor.m_title = componentDescriptor.m_helpLink;
            } else if (componentDescriptor.m_title == null) {
                componentDescriptor.m_title = this.cleanPercents(componentDescriptor.m_name);
            }
            componentDescriptor.m_title = componentDescriptor.m_title.trim();
            componentDescriptor.m_title = this.cleanPercents(componentDescriptor.m_title);
            if (componentDescriptor.m_title.endsWith(":")) {
                componentDescriptor.m_title = componentDescriptor.m_title.substring(0, componentDescriptor.m_title.length() - 1);
            }
            if (componentDescriptor.m_title.indexOf("<--") > 0 || componentDescriptor.m_title.indexOf("-->") > 0) {
                componentDescriptor.m_title = componentDescriptor.m_title.replace('<', ' ');
                componentDescriptor.m_title = componentDescriptor.m_title.replace('>', ' ');
                componentDescriptor.m_title = componentDescriptor.m_title.replace('-', ' ');
                componentDescriptor.m_title = componentDescriptor.m_title.trim();
            }
            this.m_componentList.addElement(componentDescriptor);
        }
    }

    private void reuseOldSegments() throws HelpException {
        if (this.m_update) {
            BufferedReader bufferedReader;
            try {
                bufferedReader = new BufferedReader(new FileReader(this.m_inputFileName));
            }
            catch (FileNotFoundException fileNotFoundException) {
                MessageLog.traceErr((Object)fileNotFoundException);
                return;
            }
            HelpDocParser helpDocParser = new HelpDocParser(bufferedReader);
            Object[] objectArray = null;
            String string = null;
            String string2 = null;
            String string3 = "";
            boolean bl = false;
            while (!bl) {
                Object object;
                Object[] objectArray2;
                String string4 = null;
                try {
                    string4 = helpDocParser.nextTag();
                }
                catch (IOException iOException) {
                    objectArray2 = new Object[]{this.m_inputFileName, iOException};
                    MessageLog.traceErr((Object)MessageFormat.format(resourceLoader.getString("IDOHGX_IO_EXCEPTION_CONTINUE"), objectArray2));
                    break;
                }
                String string5 = helpDocParser.previousContent();
                if (string4 == null) break;
                objectArray2 = new HelpDocTagDescriptor(string4);
                if (objectArray2 == null) continue;
                if (objectArray2.m_tag.equalsIgnoreCase("HEADEREND")) {
                    m_pwOut.print(string5);
                    m_pwOut.print(string4);
                    continue;
                }
                if (objectArray2.m_tag.equalsIgnoreCase("FOOTERBEGIN")) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        Object[] objectArray3 = new Object[]{this.m_inputFileName, iOException};
                        MessageLog.traceErr((Object)MessageFormat.format(resourceLoader.getString("IDOHGX_IO_EXCEPTION_CONTINUE"), objectArray3));
                    }
                    int n = string5.lastIndexOf(m_hr);
                    if (n >= 0) {
                        string5 = string5.substring(0, n);
                    }
                    m_pwOut.print(string5);
                    break;
                }
                if (objectArray2.m_tag.equalsIgnoreCase("SEGMENTBEGIN")) {
                    string = string5;
                    string2 = string4;
                    objectArray = objectArray2;
                    this.m_SegmentList.put(objectArray2.m_id, objectArray2.m_PDMLSynch);
                    continue;
                }
                if (objectArray2.m_tag.equalsIgnoreCase("SEGMENTEND")) {
                    if (objectArray != null) {
                        this.debug("Reusing: " + objectArray.m_id + " synch=" + objectArray.m_PDMLSynch);
                        if (objectArray.m_PDMLSynch.equalsIgnoreCase("YES")) {
                            object = this.m_pdmlToDo.get(objectArray.m_id);
                            if (object != null) {
                                if (object instanceof PDMLPanelElement) {
                                    m_pwOut.print(string);
                                    m_pwOut.print(string2);
                                    string5 = this.regenPanel((PDMLPanelElement)object, string5, string4);
                                    string5 = this.handleBadLinks(string5);
                                    m_pwOut.print(string5);
                                    ((PDMLPanelElement)object).done = true;
                                } else {
                                    string5 = this.handleBadLinks(string5);
                                    m_pwOut.print(string);
                                    m_pwOut.print(string2);
                                    m_pwOut.print(string5);
                                    m_pwOut.print(string4);
                                    ((PDMLControlElement)object).done = true;
                                }
                            }
                        } else {
                            object = this.m_pdmlToDo.get(objectArray.m_id);
                            if (object != null) {
                                if (object instanceof PDMLPanelElement) {
                                    ((PDMLPanelElement)object).done = true;
                                } else {
                                    ((PDMLControlElement)object).done = true;
                                }
                            }
                            string5 = this.handleBadLinks(string5);
                            m_pwOut.print(string);
                            m_pwOut.print(string2);
                            m_pwOut.print(string5);
                            m_pwOut.print(string4);
                        }
                        objectArray = null;
                        continue;
                    }
                    object = new Object[]{new Integer(helpDocParser.currentLine())};
                    throw new HelpException(MessageFormat.format(resourceLoader.getString("IDHDS_MISSING_SEGMENTBEGIN"), object));
                }
                object = new Object[]{string4, new Integer(helpDocParser.currentLine())};
                throw new HelpException(MessageFormat.format(resourceLoader.getString("IDOHGX_UNKNOWN_TAG_FOUND"), object));
            }
        }
    }

    private String regenPanel(PDMLPanelElement pDMLPanelElement, String string, String string2) {
        String string3 = "";
        if (pDMLPanelElement.vElements != null) {
            int n = pDMLPanelElement.vElements.size() - 1;
            while (n >= 0) {
                PDMLControlElement pDMLControlElement = (PDMLControlElement)pDMLPanelElement.vElements.elementAt(n);
                String string4 = pDMLPanelElement.panel.getPanel().m_name + "." + pDMLControlElement.cd.m_name + ".html";
                String string5 = "\"#" + string4 + "\"";
                boolean bl = true;
                String string6 = (String)this.m_SegmentList.get(string4);
                if (string6 != null && string6.equalsIgnoreCase("NO")) {
                    bl = false;
                }
                if (bl && this.lastIndexOfHTML(string, string5) < 0) {
                    String string7;
                    Object object;
                    int n2 = string.length();
                    if (n == pDMLPanelElement.vElements.size() - 1) {
                        int n3 = this.lastIndexOfHTML(string, "</BLOCKQUOTE>");
                        if (n3 >= 0) {
                            n2 = n3;
                        }
                    } else {
                        object = (PDMLControlElement)pDMLPanelElement.vElements.elementAt(n + 1);
                        string7 = pDMLPanelElement.panel.getPanel().m_name + "." + ((PDMLControlElement)object).cd.m_name + ".html";
                        String string8 = "\"#" + string7 + "\"";
                        int n4 = this.lastIndexOfHTML(string, string8);
                        if (n4 >= 0) {
                            n4 = this.lastIndexOfHTML(string, "<", n4);
                        }
                        if (n4 >= 0) {
                            n2 = n4;
                        }
                    }
                    object = pDMLControlElement.cd.m_title != null && pDMLControlElement.cd.m_title.length() > 0 ? pDMLControlElement.cd.m_title : pDMLControlElement.cd.m_name;
                    string7 = "<a href=" + string5 + ">" + (String)object + "</a>\r\n<p>\r\n";
                    string = n2 == 0 ? string7 + string : (n2 == string.length() ? string + string7 : string.substring(0, n2) + string7 + string.substring(n2));
                }
                if (null == this.m_SegmentList.get(string4)) {
                    string3 = "\r\n" + m_hr + "\r\n\r\n\r\n" + m_hr + "\r\n" + this.createComponentContent(pDMLPanelElement.panel, pDMLControlElement.cd) + string3;
                    pDMLControlElement.done = true;
                }
                --n;
            }
        }
        return string + string2 + string3;
    }

    private String handleBadLinks(String string) {
        Enumeration enumeration = this.m_badLinks.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = "\"#" + string2 + "\"";
            int n = string.indexOf(string3);
            while (n > -1) {
                Object[] objectArray;
                if (string.lastIndexOf("<!--", n) > string.lastIndexOf("-->", n)) {
                    n = string.indexOf(string3, n + 1);
                    continue;
                }
                backwardHTMLTokenizer backwardHTMLTokenizer2 = new backwardHTMLTokenizer(string, n);
                boolean bl = false;
                int n2 = 0;
                String string4 = backwardHTMLTokenizer2.prevToken();
                if (!string4.startsWith("<A ") && !string4.startsWith("<a ")) {
                    Object[] objectArray2 = new Object[]{string3};
                    MessageLog.traceErr((Object)MessageFormat.format(resourceLoader.getString("IDOHGX_MISSING_ANCHOR_HEAD"), objectArray2));
                }
                int n3 = backwardHTMLTokenizer2.getPos();
                String string5 = backwardHTMLTokenizer2.prevToken();
                while (string5.startsWith("<!--")) {
                    string5 = backwardHTMLTokenizer2.prevToken();
                }
                if (string5.equalsIgnoreCase("<P>")) {
                    n2 = backwardHTMLTokenizer2.getPos();
                    bl = true;
                }
                int n4 = string.indexOf("</a>", n);
                int n5 = string.indexOf("</A>", n);
                if (n4 < 0 && n5 < 0) {
                    objectArray = new Object[]{string3};
                    MessageLog.traceErr((Object)MessageFormat.format(resourceLoader.getString("IDOHGX_MISSING_ANCHOR_TAIL"), objectArray));
                }
                if (n4 < 0) {
                    n4 = string.length();
                }
                if (n5 < 0) {
                    n5 = string.length();
                }
                n4 = n4 < n5 ? n4 : n5;
                string = bl ? string.substring(0, n2) + "<!-- BadLink removed: \r\n" + string.substring(n2, n4 + 4) + " -->" + string.substring(n4 + 4) : string.substring(0, n3) + "<!-- BadLink warning:  The following tag is bad. -->" + string.substring(n3);
                n4 = string.indexOf("</a>", n);
                n5 = string.indexOf("</A>", n);
                if (n4 < 0 && n5 < 0) {
                    objectArray = new Object[]{string3};
                    MessageLog.traceErr((Object)MessageFormat.format(resourceLoader.getString("IDOHGX_MISSING_ANCHOR_TAIL"), objectArray));
                }
                if (n4 < 0) {
                    n4 = string.length();
                }
                if (n5 < 0) {
                    n5 = string.length();
                }
                n4 = n4 < n5 ? n4 : n5;
                n = string.indexOf(string3, n4);
            }
        }
        return string;
    }

    private void buildSegmentList() throws HelpException {
        Object object;
        if (this.m_update) {
            try {
                object = new BufferedReader(new FileReader(this.m_inputFileName));
            }
            catch (FileNotFoundException fileNotFoundException) {
                MessageLog.traceErr((Object)fileNotFoundException);
                return;
            }
            HelpDocParser helpDocParser = new HelpDocParser((BufferedReader)object);
            Object[] objectArray = null;
            String string = "";
            boolean bl = false;
            while (!bl) {
                Object[] objectArray2;
                String string2 = null;
                try {
                    string2 = helpDocParser.nextTag();
                }
                catch (IOException iOException) {
                    objectArray2 = new Object[]{this.m_inputFileName, iOException};
                    MessageLog.traceErr((Object)MessageFormat.format(resourceLoader.getString("IDOHGX_IO_EXCEPTION_CONTINUE"), objectArray2));
                    break;
                }
                String string3 = helpDocParser.previousContent();
                if (string2 == null) break;
                objectArray2 = new HelpDocTagDescriptor(string2);
                if (objectArray2 == null || objectArray2.m_tag.equalsIgnoreCase("HEADEREND")) continue;
                if (objectArray2.m_tag.equalsIgnoreCase("FOOTERBEGIN")) {
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (IOException iOException) {
                        Object[] objectArray3 = new Object[]{this.m_inputFileName, iOException};
                        MessageLog.traceErr((Object)MessageFormat.format(resourceLoader.getString("IDOHGX_IO_EXCEPTION_CONTINUE"), objectArray3));
                    }
                    int n = string3.lastIndexOf(m_hr);
                    if (n < 0) break;
                    string3 = string3.substring(0, n);
                    break;
                }
                if (objectArray2.m_tag.equalsIgnoreCase("SEGMENTBEGIN")) {
                    objectArray = objectArray2;
                    this.m_SegmentList.put(objectArray2.m_id, objectArray2.m_PDMLSynch);
                    continue;
                }
                if (objectArray2.m_tag.equalsIgnoreCase("SEGMENTEND")) {
                    objectArray = null;
                    continue;
                }
                Object[] objectArray4 = new Object[]{string2, new Integer(helpDocParser.currentLine())};
                throw new HelpException(MessageFormat.format(resourceLoader.getString("IDOHGX_UNKNOWN_TAG_FOUND"), objectArray4));
            }
        }
        if (m_descriptorTrace) {
            System.out.println();
            System.out.println("------------SegmentList----------");
            object = this.m_SegmentList.keys();
            while (object.hasMoreElements()) {
                System.out.println(object.nextElement());
            }
        }
    }

    private int lastIndexOfHTML(String string, String string2) {
        return this.lastIndexOfHTML(string, string2, string.length());
    }

    private int lastIndexOfHTML(String string, String string2, int n) {
        int n2;
        while ((n2 = string.lastIndexOf(string2, n)) > -1) {
            int n3;
            n = string.lastIndexOf("<!--", n2);
            if (n < 0 || n <= (n3 = string.lastIndexOf("-->", n2))) break;
        }
        return n2;
    }

    private String cleanPercents(String string) {
        int n = 0;
        while ((n = string.indexOf("%")) >= 0) {
            string = n == 0 ? string.substring(1) : (n == string.length() ? string.substring(0, string.length() - 1) : string.substring(0, n) + string.substring(n + 1, string.length()));
        }
        return string;
    }

    private void debug(String string) {
        if (m_descriptorTrace) {
            System.out.println("OnlineHelpGeneratorEx: " + string);
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static {
        resourceLoader.setResourceName("com.ibm.as400.ui.tools.HelpGenMRI");
        try {
            MessageLog.setLogFileName((String)("Service" + System.getProperty("file.separator") + "OpNav.Java.Service.log"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        m_descriptorTrace = false;
        m_hr = "<HR WIDTH=\"25%\" align=\"left\">";
        m_generatorExtension = ".tmp.OnlineHelpGenerator";
        m_backupExtension = ".html.backup";
    }

    class backwardHTMLTokenizer {
        String string = "";
        String Tdelim = "<>";
        String delim = "";
        int Spos = 0;
        int Tpos = 0;

        public backwardHTMLTokenizer(String string) {
            this.string = string;
            this.Spos = this.string.length() - 1;
        }

        public backwardHTMLTokenizer(String string, int n) {
            this.string = string;
            this.Spos = n;
        }

        public String prevToken() {
            String string;
            if (this.Spos < 0) {
                this.Tpos = -1;
                return "";
            }
            int n = this.string.lastIndexOf(">", this.Spos);
            int n2 = this.string.lastIndexOf("<", this.Spos);
            if (n2 > n) {
                this.Tpos = n2;
                String string2 = this.string.substring(n2, this.Spos + 1);
                this.Spos = n2 - 1;
                return string2;
            }
            if (n < 0) {
                this.Tpos = 0;
                String string3 = this.string.substring(0, this.Spos + 1);
                this.Spos = -1;
                return string3;
            }
            if (n < this.Spos) {
                this.Tpos = n + 1;
                string = this.string.substring(this.Tpos, this.Spos + 1);
                this.Spos = n;
                if (string.trim().length() > 0) {
                    return string;
                }
            }
            this.Tpos = n2;
            string = this.string.substring(n2, n + 1);
            this.Spos = n2 - 1;
            return string;
        }

        public int getPos() {
            return this.Tpos;
        }
    }

    class PDMLControlElement {
        ComponentDescriptor cd = null;
        XMLPanelDefinition panel = null;
        boolean done = false;

        PDMLControlElement(XMLPanelDefinition xMLPanelDefinition, ComponentDescriptor componentDescriptor, boolean bl) {
            this.cd = componentDescriptor;
            this.panel = xMLPanelDefinition;
            this.done = bl;
        }
    }

    class PDMLPanelElement {
        ComponentDescriptor cd = null;
        XMLPanelDefinition panel = null;
        String sTitle = null;
        String sDirectory = null;
        boolean done = false;
        Vector vElements = null;

        PDMLPanelElement(XMLPanelDefinition xMLPanelDefinition, String string, String string2, Vector vector, boolean bl) {
            this.panel = xMLPanelDefinition;
            this.sTitle = string;
            this.sDirectory = string2;
            this.done = bl;
            this.vElements = vector;
        }
    }
}

