/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.ComponentDescriptor;
import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.XMLPanelDefinition;
import com.ibm.as400.ui.tools.HelpFileParser;
import com.ibm.as400.ui.tools.ToolsResourceLoader;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class OnlineHelpGenerator {
    public static ToolsResourceLoader resourceLoader = new ToolsResourceLoader();
    public static int m_searchMode;
    public static boolean m_descriptorTrace;
    private XMLPanelDefinition m_pd;
    private String m_propsheetTitle;
    private static PrintWriter m_pwOut;
    private Vector m_componentList = new Vector();
    private HelpFileParser m_hp = new HelpFileParser();

    public static void main(String[] stringArray) {
        System.setErr(System.out);
        if (stringArray.length == 2) {
            new OnlineHelpGenerator(stringArray[0], null, stringArray[1], null);
        } else if (stringArray.length == 3) {
            new OnlineHelpGenerator(stringArray[0], null, stringArray[1], stringArray[2]);
        } else {
            System.out.println(resourceLoader.getString("IDOHG_HELP_GENERATOR_ARGUMENTS"));
        }
    }

    public OnlineHelpGenerator(String string, Locale locale, String string2, String string3) {
        if (string == null) {
            System.out.println(resourceLoader.getString("IDOHG_BAD_PARM_RESOURCENAME_NULL"));
            return;
        }
        if (string2 == null) {
            System.out.println(resourceLoader.getString("IDOHG_BAD_PARM_PANELNAME_NULL"));
            return;
        }
        this.m_propsheetTitle = string3 != null ? string3 + " - " : "";
        try {
            this.m_pd = new XMLPanelDefinition(string, locale, string2);
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        try {
            this.generateHelp();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public OnlineHelpGenerator(String string, Locale locale, String string2, String string3, String string4) {
        if (string == null) {
            System.out.println(resourceLoader.getString("IDOHG_BAD_PARM_RESOURCENAME_NULL"));
            return;
        }
        if (string2 == null) {
            System.out.println(resourceLoader.getString("IDOHG_BAD_PARM_PANELNAME_NULL"));
            return;
        }
        this.m_propsheetTitle = string3 != null ? string3 + " - " : "";
        try {
            this.m_pd = new XMLPanelDefinition(string, locale, string2);
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        try {
            this.generateHelp(string4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public OnlineHelpGenerator(XMLPanelDefinition xMLPanelDefinition, String string, String string2) {
        this.m_pd = xMLPanelDefinition;
        this.m_propsheetTitle = string != null ? string + " - " : "";
        try {
            this.generateHelp(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void generateHelp(String string) throws IOException {
        if (string != null) {
            this.produceHTML(string + this.m_pd.getPanel().m_name + ".html");
        } else {
            this.generateHelp();
        }
    }

    public void generateHelp() throws IOException {
        this.produceHTML(this.m_pd.getPanel().m_name + ".html");
    }

    private void produceHTML(String string) throws IOException {
        String string2 = resourceLoader.getString("IDOHG_CREATING_FILE");
        Object[] objectArray = new Object[]{string};
        String string3 = MessageFormat.format(string2, objectArray);
        System.out.println(string3);
        try {
            this.m_hp.processHelpFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (ParseException parseException) {
            System.out.println("IDNA_PARSE_EXCEPTION");
            return;
        }
        catch (IOException iOException) {
            System.out.println("IDNA_IO_EXCEPTION");
            return;
        }
        m_pwOut = new PrintWriter(new FileWriter(string));
        this.writeHeader();
        this.writeBody();
        this.writeFooter();
        m_pwOut.close();
    }

    private void writeHeader() {
        m_pwOut.println("<html>");
        m_pwOut.println();
        m_pwOut.println("<head>");
        m_pwOut.println("<title>" + this.m_propsheetTitle + this.m_pd.getPanel().m_title + "</title>");
        m_pwOut.println("</head>");
        m_pwOut.println();
        m_pwOut.println("<body>");
        m_pwOut.println();
    }

    private void writeBody() {
        Object object;
        int n;
        m_pwOut.println("<h1>" + this.m_propsheetTitle + this.m_pd.getPanel().m_title + "</h1>");
        m_pwOut.println();
        m_pwOut.println("<helpcontent name=OVERVIEW>");
        m_pwOut.println();
        Vector vector = this.m_hp.getSectionContent("OVERVIEW");
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                m_pwOut.println(vector.elementAt(n));
                ++n;
            }
        } else {
            m_pwOut.println("<p>Insert the overview help here.");
            m_pwOut.println("Content within these <kbd>&lt;helpcontent&gt;</kbd> tags will be preserved.");
            m_pwOut.println();
            m_pwOut.println("<p>");
            m_pwOut.println("<p>Obtain help on any field listed below by selecting the hyperlink or by clicking the field and pressing F1.");
        }
        m_pwOut.println("<p>");
        m_pwOut.println("</helpcontent><p>");
        m_pwOut.println();
        Enumeration enumeration = this.m_pd.getPanelComponents().elements();
        while (enumeration.hasMoreElements()) {
            ComponentDescriptor componentDescriptor = (ComponentDescriptor)enumeration.nextElement();
            if (componentDescriptor.m_element.equals("BUTTONGROUP")) {
                int n2 = 0;
                while (n2 < componentDescriptor.m_groupButtons.size()) {
                    object = (ComponentDescriptor)componentDescriptor.m_groupButtons.elementAt(n2);
                    this.processComponent((ComponentDescriptor)object);
                    ++n2;
                }
                continue;
            }
            this.processComponent(componentDescriptor);
        }
        if (this.m_componentList.size() == 0) {
            return;
        }
        m_pwOut.println("<!-- Fields -->");
        m_pwOut.println();
        m_pwOut.println("<h3>Fields</h3>");
        m_pwOut.println("<p>");
        int n3 = 0;
        while (n3 < this.m_componentList.size()) {
            ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_componentList.elementAt(n3);
            object = componentDescriptor.m_title != null && componentDescriptor.m_title.length() > 0 ? componentDescriptor.m_title : componentDescriptor.m_name;
            m_pwOut.println("<a href=#" + componentDescriptor.m_name + ">" + (String)object + "</a>");
            m_pwOut.println("<p>");
            ++n3;
        }
        m_pwOut.println();
        int n4 = 0;
        while (n4 < this.m_componentList.size()) {
            object = (ComponentDescriptor)this.m_componentList.elementAt(n4);
            String string = object.m_title != null && object.m_title.length() > 0 ? object.m_title : object.m_name;
            m_pwOut.println("<!-- " + string + " -->");
            m_pwOut.println();
            m_pwOut.println("<a name=" + object.m_name + "><hr></a>");
            m_pwOut.println("<h4>" + string + "</h4>");
            m_pwOut.println();
            m_pwOut.println("<helpcontent name=" + object.m_name + ">");
            m_pwOut.println();
            vector = this.m_hp.getSectionContent(object.m_name);
            if (vector != null) {
                n = 0;
                while (n < vector.size()) {
                    m_pwOut.println(vector.elementAt(n));
                    ++n;
                }
            } else {
                m_pwOut.println("<p>Insert help for " + string + " here.");
                m_pwOut.println("Content within these <kbd>&lt;helpcontent&gt;</kbd> tags will be preserved.");
                m_pwOut.println();
            }
            m_pwOut.println("<p>");
            m_pwOut.println("</helpcontent><p>");
            m_pwOut.println();
            ++n4;
        }
    }

    private void processComponent(ComponentDescriptor componentDescriptor) {
        if (componentDescriptor.m_aliasName == null && componentDescriptor.m_title != null) {
            if (componentDescriptor.m_element.equals("TEXTFIELD") || componentDescriptor.m_element.equals("TEXTAREA") || componentDescriptor.m_element.equals("IMAGE") || componentDescriptor.m_title.equals("...")) {
                return;
            }
            componentDescriptor.m_title = componentDescriptor.m_title.trim();
            if (componentDescriptor.m_title.endsWith(":")) {
                componentDescriptor.m_title = componentDescriptor.m_title.substring(0, componentDescriptor.m_title.length() - 1);
            } else if (componentDescriptor.m_element.equals("LABEL")) {
                return;
            }
            if (componentDescriptor.m_title.indexOf("<--") > 0 || componentDescriptor.m_title.indexOf("-->") > 0) {
                componentDescriptor.m_title = componentDescriptor.m_title.replace('<', ' ');
                componentDescriptor.m_title = componentDescriptor.m_title.replace('>', ' ');
                componentDescriptor.m_title = componentDescriptor.m_title.replace('-', ' ');
                componentDescriptor.m_title = componentDescriptor.m_title.trim();
            }
            int n = 0;
            while (n < this.m_componentList.size()) {
                if (componentDescriptor.m_position.y == ((ComponentDescriptor)this.m_componentList.elementAt((int)n)).m_position.y) {
                    if (componentDescriptor.m_position.x < ((ComponentDescriptor)this.m_componentList.elementAt((int)n)).m_position.x) {
                        this.m_componentList.insertElementAt(componentDescriptor, n);
                        break;
                    }
                } else if (componentDescriptor.m_position.y < ((ComponentDescriptor)this.m_componentList.elementAt((int)n)).m_position.y) {
                    this.m_componentList.insertElementAt(componentDescriptor, n);
                    break;
                }
                ++n;
            }
            if (n >= this.m_componentList.size()) {
                this.m_componentList.addElement(componentDescriptor);
            }
        }
    }

    private void writeFooter() {
        m_pwOut.println();
        m_pwOut.println("<!-- STANDARD FOOTER -->");
        m_pwOut.println();
        m_pwOut.println("</body>");
        m_pwOut.println();
        m_pwOut.println("</html>");
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static {
        resourceLoader.setResourceName("com.ibm.as400.ui.tools.HelpGenMRI");
        m_searchMode = 2;
        m_descriptorTrace = false;
    }
}

