/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.MenuItemDescriptor;
import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.tools.ComponentProperties;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MenuProperties;
import com.ibm.as400.ui.tools.MenuSeparatorProperties;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.MutableResource;
import com.ibm.as400.ui.tools.NameGenerator;
import com.ibm.as400.ui.tools.SelectionObject;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import com.ibm.as400.ui.tools.XMLWriter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.KeyStroke;
import javax.swing.tree.TreeNode;

class MenuItemProperties
extends ComponentProperties {
    private static int m_parentMenuType = 50;
    private static Hashtable m_virtualKeyDictionary = new Hashtable();
    private static Hashtable m_modifierDictionary = new Hashtable();

    KeyStroke getAccelerator() {
        String string = (String)this.getProperty("* Key");
        if (string == null || string.equals("")) {
            return null;
        }
        String string2 = (String)this.getProperty("* Modifier");
        int n = string.length() == 1 ? string.charAt(0) : ((Integer)m_virtualKeyDictionary.get(string)).intValue();
        int n2 = (Integer)m_modifierDictionary.get(string2);
        return KeyStroke.getKeyStroke(n, n2);
    }

    MenuItemProperties() {
        super(52);
    }

    MenuItemProperties(XMLGUIBuilderDefinition xMLGUIBuilderDefinition) throws PDMLSpecificationException {
        super(xMLGUIBuilderDefinition, 52);
    }

    MenuItemProperties(XMLGUIBuilderDefinition xMLGUIBuilderDefinition, MenuItemDescriptor menuItemDescriptor) throws PDMLSpecificationException {
        super(xMLGUIBuilderDefinition, 52);
        String string;
        if (menuItemDescriptor.m_name != null) {
            try {
                this.setProperty("Name", menuItemDescriptor.m_name);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.m_properties.put("Name", menuItemDescriptor.m_name);
        }
        if (menuItemDescriptor.m_type != null) {
            string = menuItemDescriptor.m_type.equalsIgnoreCase("standard") ? "menu item" : menuItemDescriptor.m_type.toLowerCase();
            try {
                this.setProperty("Menu Item Type", string);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (menuItemDescriptor.m_title != null) {
            string = xMLGUIBuilderDefinition.getResourceString(menuItemDescriptor.m_titleBundle);
            try {
                this.setProperty("Title", string);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (menuItemDescriptor.m_icon != null) {
            string = xMLGUIBuilderDefinition.getResourceString(menuItemDescriptor.m_icon);
            try {
                this.setProperty("Icon", string);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            string = menuItemDescriptor.m_iconPosition == null ? (m_parentMenuType == 55 ? "center" : "right") : menuItemDescriptor.m_iconPosition.toLowerCase();
            try {
                this.setProperty("* H Position", string);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            string = menuItemDescriptor.m_vIconPosition == null ? (m_parentMenuType == 55 ? "top" : "center") : menuItemDescriptor.m_vIconPosition.toLowerCase();
            try {
                this.setProperty("* V Position", string);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (menuItemDescriptor.m_action != null) {
            try {
                this.setProperty("Menu Action", menuItemDescriptor.m_action);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (menuItemDescriptor.m_accelerator != null) {
            try {
                this.setProperty("* Key", menuItemDescriptor.m_accelerator.m_keyString);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            try {
                this.setProperty("* Modifier", menuItemDescriptor.m_accelerator.m_modifierString);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (!(menuItemDescriptor.m_flyover == null && menuItemDescriptor.m_flyover.equals("") || menuItemDescriptor.m_flyoverBundle == null)) {
            string = xMLGUIBuilderDefinition.getResourceString(menuItemDescriptor.m_flyoverBundle);
            try {
                this.setProperty("Flyover Text", string);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        try {
            this.setProperty("Disabled", new Boolean(menuItemDescriptor.m_disabled));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.setProperty("Toggle Selected", new Boolean(menuItemDescriptor.m_selected));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.setProperty("Default Menu Item", new Boolean(menuItemDescriptor.m_default));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (menuItemDescriptor.m_children != null) {
            MutableProperties mutableProperties = null;
            Enumeration enumeration = menuItemDescriptor.m_children.elements();
            while (enumeration.hasMoreElements()) {
                MenuItemDescriptor menuItemDescriptor2 = (MenuItemDescriptor)enumeration.nextElement();
                mutableProperties = menuItemDescriptor2.m_name == null ? new MenuSeparatorProperties(xMLGUIBuilderDefinition) : new MenuItemProperties(xMLGUIBuilderDefinition, menuItemDescriptor2);
                this.add(mutableProperties);
                string = "submenu";
                try {
                    this.setProperty("Menu Item Type", string);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    static void setParentMenuType(int n) {
        m_parentMenuType = n;
    }

    void initProperties() {
        super.initProperties();
        this.setPropertyVisible("Bounds", false);
        this.setPropertyVisible("Data Class", false);
        this.setPropertyVisible("Attribute", false);
        this.setPropertyVisible("Generate Field Help", false);
        this.setPropertyVisible("* Help Alias", false);
        this.setPropertyVisible("* Help Link", false);
        this.insertProperty("Menu Item Type", 0);
        try {
            this.setProperty("Menu Item Type", "menuitem");
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.addProperty("Toggle Selected");
        try {
            this.setProperty("Toggle Selected", new Boolean(true));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.addProperty("Default Menu Item");
        try {
            this.setProperty("Default Menu Item", new Boolean(false));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.addProperty("Icon");
        this.addProperty("* H Position");
        this.addProperty("* V Position");
        this.setPropertyVisible("* H Position", false);
        this.setPropertyVisible("* V Position", false);
        try {
            this.setProperty("* H Position", "left");
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.setProperty("* V Position", "center");
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.addProperty("Accelerator");
        this.addProperty("* Key");
        this.addProperty("* Modifier");
        try {
            this.setProperty("* Modifier", "none");
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setPropertyEditable("Accelerator", false);
        this.addProperty("Menu Action");
        try {
            this.setProperty("Menu Action", GUIFactory.getString("IDS_DEFAULT_MENU_ACTION_CLASS"));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    MenuItemProperties getDefaultMenuItem(MenuItemProperties menuItemProperties) {
        MutableProperties mutableProperties = null;
        MenuItemProperties menuItemProperties2 = null;
        boolean bl = false;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            mutableProperties = (MutableProperties)enumeration.nextElement();
            if (mutableProperties.getType() != 52 || mutableProperties == menuItemProperties || !mutableProperties.hasProperty("Default Menu Item")) continue;
            bl = (Boolean)mutableProperties.getProperty("Default Menu Item");
            if (bl) {
                return (MenuItemProperties)mutableProperties;
            }
            if (!mutableProperties.getProperty("Menu Item Type").equals("submenu") || (menuItemProperties2 = ((MenuItemProperties)mutableProperties).getDefaultMenuItem(menuItemProperties)) == null) continue;
            return menuItemProperties2;
        }
        return null;
    }

    void propertyUpdate(String string, Object object, Object object2) {
        MenuProperties menuProperties;
        MenuItemProperties menuItemProperties;
        TreeNode[] treeNodeArray;
        boolean bl;
        super.propertyUpdate(string, object, object2);
        if (string.equals("Icon")) {
            String string2 = (String)object2;
            boolean bl2 = string2.equals("");
            this.setPropertyVisible("* H Position", !bl2);
            this.setPropertyVisible("* V Position", !bl2);
            if (bl2) {
                try {
                    this.setProperty("* H Position", "left");
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                try {
                    this.setProperty("* V Position", "center");
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        } else if (string.equals("Menu Item Type")) {
            String string3 = (String)object2;
            String string4 = (String)object;
            boolean bl3 = string3.equals("separator");
            boolean bl4 = string4.equals("separator");
            boolean bl5 = string3.equals("submenu");
            this.setPropertyVisible("Title", !bl3);
            this.setPropertyVisible("Icon", !bl3);
            this.setPropertyVisible("Menu Action", !bl3 && !bl5);
            this.setPropertyVisible("Disabled", !bl3);
            this.setPropertyVisible("Flyover Text", !bl3 && !bl5);
            this.setPropertyVisible("Accelerator", !bl3 && !bl5);
            this.setPropertyVisible("* Key", !bl3 && !bl5);
            this.setPropertyVisible("Toggle Selected", string3.equals("check") || string3.equals("radio"));
            this.setPropertyVisible("Default Menu Item", !bl3 && !bl5);
            if (bl5 || bl3) {
                try {
                    this.setProperty("* Key", "");
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            this.setPropertyVisible("* Modifier", !bl3 && !bl5);
        } else if (string.equals("Default Menu Item") && (bl = ((Boolean)object2).booleanValue()) && (treeNodeArray = this.getPath()) != null && treeNodeArray.length > 2 && (menuItemProperties = (menuProperties = (MenuProperties)treeNodeArray[1]).getDefaultMenuItem(this)) != null) {
            try {
                menuItemProperties.setProperty("Default Menu Item", new Boolean(false));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        String string;
        super.vetoableChange(propertyChangeEvent);
        String string2 = propertyChangeEvent.getPropertyName();
        if (string2.equals("Menu Item Type")) {
            String string3 = (String)propertyChangeEvent.getOldValue();
            if (string3.equals("submenu") && this.getChildCount() > 0) {
                String string4 = GUIFactory.getString("IDS_SUBMENU_NOT_EMPTY");
                throw new PropertyVetoException(string4, propertyChangeEvent);
            }
        } else if (string2.equals("Menu Action")) {
            String string5 = (String)propertyChangeEvent.getNewValue();
            if (!this.isValidClassName(string5)) {
                Object[] objectArray = new Object[]{string5};
                String string6 = MessageFormat.format(GUIFactory.getString("IDS_CLASS_NOT_VALID"), objectArray);
                throw new PropertyVetoException(string6, propertyChangeEvent);
            }
        } else if (string2.equals("* Key") && (string = (String)propertyChangeEvent.getNewValue()).length() > 2 && !m_virtualKeyDictionary.containsKey(string)) {
            Object[] objectArray = new Object[]{string};
            String string7 = MessageFormat.format(GUIFactory.getString("IDS_ACCELERATOR_KEY_NOT_VALID"), objectArray);
            throw new PropertyVetoException(string7, propertyChangeEvent);
        }
    }

    String getOpenTag() {
        boolean bl;
        boolean bl2;
        String string = "<MENUITEM name=\"" + this.getProperty("Name");
        String string2 = (String)this.getProperty("Menu Item Type");
        if (!(string2.equals("menu item") || string2.equals("submenu") || string2.equals("menuitem"))) {
            string = string + "\" type=\"" + string2;
        }
        if (bl2 = ((Boolean)this.getProperty("Disabled")).booleanValue()) {
            string = string + "\" disabled=\"yes";
        }
        if (this.isPropertyVisible("Toggle Selected")) {
            bl = (Boolean)this.getProperty("Toggle Selected");
            string = bl ? string + "\" selected=\"yes" : string + "\" selected=\"no";
        }
        if (this.isPropertyVisible("Default Menu Item") && (bl = ((Boolean)this.getProperty("Default Menu Item")).booleanValue())) {
            string = string + "\" default=\"yes";
        }
        string = string + "\">";
        return string;
    }

    String getCloseTag() {
        return "</MENUITEM>";
    }

    void save(XMLWriter xMLWriter, MutableResource mutableResource) throws IOException {
        String string = (String)this.getProperty("Menu Item Type");
        if (string.equals("separator")) {
            xMLWriter.writeIndent();
            xMLWriter.writeChars("<SEPARATOR/>");
            xMLWriter.writeNewLine();
        } else {
            super.save(xMLWriter, mutableResource);
        }
    }

    void saveChildren(XMLWriter xMLWriter, MutableResource mutableResource) throws IOException {
        String string;
        String string2;
        String string3 = (String)this.getProperty("Name");
        string3 = this.getFullyQualifiedName(string3);
        String string4 = (String)this.getProperty("Flyover Text");
        boolean bl = this.getProperty("Menu Item Type").equals("submenu");
        String string5 = (String)this.getProperty("Icon");
        if (!string5.equals("")) {
            string2 = string3 + ".Icon";
            mutableResource.addObject(string2, string5);
            string = (String)this.getProperty("* H Position");
            String string6 = (String)this.getProperty("* V Position");
            String string7 = "<ICON";
            if (m_parentMenuType == 55) {
                if (!string.equals("center")) {
                    string7 = string7 + " position=\"" + string + "\"";
                }
                if (!string6.equals("top")) {
                    string7 = string7 + " vposition=\"" + string6 + "\"";
                }
            } else {
                if (!string.equals("right")) {
                    string7 = string7 + " position=\"" + string + "\"";
                }
                if (!string6.equals("center")) {
                    string7 = string7 + " vposition=\"" + string6 + "\"";
                }
            }
            string7 = string7 + ">" + string2 + "</ICON>";
            xMLWriter.writeIndent();
            xMLWriter.writeChars(string7);
            xMLWriter.writeNewLine();
        }
        if (!bl && !string4.equals("")) {
            string2 = string3 + ".Flyover";
            mutableResource.addObject(string2, string4);
            xMLWriter.writeIndent();
            xMLWriter.writeChars("<FLYOVER>" + string2 + "</FLYOVER>");
            xMLWriter.writeNewLine();
        }
        if (!(string2 = (String)this.getProperty("* Key")).equals("") && this.isPropertyVisible("Accelerator")) {
            string = (String)this.getProperty("* Modifier");
            xMLWriter.writeIndent();
            xMLWriter.writeChars("<ACCELERATOR key=\"" + string2 + "\" modifier=\"" + string + "\"/>");
            xMLWriter.writeNewLine();
        }
        string = (String)this.getProperty("Menu Action");
        if (!bl && !string.equals("") || bl && this.getChildCount() == 0) {
            xMLWriter.writeIndent();
            xMLWriter.writeChars("<ACTION>" + string + "</ACTION>");
            xMLWriter.writeNewLine();
        }
        super.saveChildren(xMLWriter, mutableResource);
    }

    void saveLastChildren(XMLWriter xMLWriter, MutableResource mutableResource) throws IOException {
    }

    MutableProperties cloneNodeInstance() {
        MenuItemProperties menuItemProperties = new MenuItemProperties();
        return menuItemProperties;
    }

    MutableProperties cloneNode(XMLGUIBuilderDefinition xMLGUIBuilderDefinition, NameGenerator nameGenerator) {
        Object object;
        Object object2;
        MutableProperties mutableProperties = this.cloneNodeInstance();
        try {
            object2 = (String)this.getProperty("Name");
            Enumeration enumeration = this.propertyNames();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (((String)object).equals("Name") && nameGenerator != null) {
                    mutableProperties.setProperty("Name", nameGenerator.generateUniqueName((String)object2));
                } else {
                    mutableProperties.setProperty((String)object, this.getProperty((String)object));
                }
                mutableProperties.setPropertyVisible((String)object, this.isPropertyVisible((String)object));
                mutableProperties.setPropertyEditable((String)object, this.isPropertyEditable((String)object));
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        mutableProperties.setPDMLDocument(xMLGUIBuilderDefinition);
        object2 = this.children();
        while (object2.hasMoreElements()) {
            object = (MutableProperties)object2.nextElement();
            if (((MutableProperties)object).getType() == 56) {
                if (xMLGUIBuilderDefinition == null || this.getPDMLDocument() == null || !xMLGUIBuilderDefinition.equals(this.getPDMLDocument())) continue;
                mutableProperties.add(((MutableProperties)object).cloneNode(xMLGUIBuilderDefinition, nameGenerator));
                continue;
            }
            if (((MutableProperties)object).getType() != 90 && ((MutableProperties)object).getType() != 91) {
                mutableProperties.add(((MutableProperties)object).cloneNode(xMLGUIBuilderDefinition, nameGenerator));
                continue;
            }
            boolean bl = ((MutableProperties)object).getType() == 90;
            SelectionObject selectionObject = mutableProperties.getSelectionObject(bl);
            object = ((MutableProperties)object).cloneNode(xMLGUIBuilderDefinition, nameGenerator);
            int n = mutableProperties.getIndex(selectionObject);
            selectionObject.removeFromParent();
            mutableProperties.insert((MutableProperties)object, n);
        }
        return mutableProperties;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static {
        m_virtualKeyDictionary.put("ESC", new Integer(27));
        m_virtualKeyDictionary.put("PAUSE", new Integer(19));
        m_virtualKeyDictionary.put("BACKSPACE", new Integer(8));
        m_virtualKeyDictionary.put("INSERT", new Integer(155));
        m_virtualKeyDictionary.put("HOME", new Integer(36));
        m_virtualKeyDictionary.put("PAGEUP", new Integer(33));
        m_virtualKeyDictionary.put("TAB", new Integer(9));
        m_virtualKeyDictionary.put("DELETE", new Integer(127));
        m_virtualKeyDictionary.put("END", new Integer(35));
        m_virtualKeyDictionary.put("PAGEDOWN", new Integer(34));
        m_virtualKeyDictionary.put("ENTER", new Integer(10));
        m_virtualKeyDictionary.put("SPACE", new Integer(32));
        m_virtualKeyDictionary.put("UP", new Integer(38));
        m_virtualKeyDictionary.put("LEFT", new Integer(37));
        m_virtualKeyDictionary.put("DOWN", new Integer(40));
        m_virtualKeyDictionary.put("RIGHT", new Integer(39));
        m_virtualKeyDictionary.put("F1", new Integer(112));
        m_virtualKeyDictionary.put("F2", new Integer(113));
        m_virtualKeyDictionary.put("F3", new Integer(114));
        m_virtualKeyDictionary.put("F4", new Integer(115));
        m_virtualKeyDictionary.put("F5", new Integer(116));
        m_virtualKeyDictionary.put("F6", new Integer(117));
        m_virtualKeyDictionary.put("F7", new Integer(118));
        m_virtualKeyDictionary.put("F8", new Integer(119));
        m_virtualKeyDictionary.put("F9", new Integer(120));
        m_virtualKeyDictionary.put("F10", new Integer(121));
        m_virtualKeyDictionary.put("F11", new Integer(122));
        m_virtualKeyDictionary.put("F12", new Integer(123));
        m_modifierDictionary.put("none", new Integer(0));
        m_modifierDictionary.put("ctrl", new Integer(2));
        m_modifierDictionary.put("alt", new Integer(8));
        m_modifierDictionary.put("shift", new Integer(1));
        m_modifierDictionary.put("ctrl-alt", new Integer(10));
        m_modifierDictionary.put("ctrl-shift", new Integer(3));
        m_modifierDictionary.put("alt-shift", new Integer(9));
        m_modifierDictionary.put("ctrl-alt-shift", new Integer(11));
    }
}

