/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.PaneProperties;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreeNode;

class LoopDialog
extends JDialog {
    MutableProperties m_properties;
    GUIBuilder m_builder;
    JButton m_okButton;
    JTable m_table;
    Stack m_stack;
    boolean m_loopRemoved = false;
    boolean m_loopsExisted = false;
    static /* synthetic */ Class class$java$lang$Object;

    LoopDialog(MutableProperties mutableProperties, GUIBuilder gUIBuilder, JFrame jFrame) {
        super(jFrame, GUIFactory.getString("IDS_LOOP_DIALOG_TITLEBAR"), true);
        this.m_properties = mutableProperties;
        this.m_builder = gUIBuilder;
        JLabel jLabel = new JLabel(GUIFactory.getString("IDS_SELECT_PANE_TO_REMOVE"));
        this.m_table = new JTable();
        this.m_table.addMouseListener(new LoopMouseListener());
        this.m_table.setOpaque(true);
        this.m_table.setAutoResizeMode(4);
        this.m_table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = LoopDialog.class$("java.lang.Object")) : class$java$lang$Object, new LoopCellRenderer());
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_table.getSelectionModel().setSelectionMode(0);
        this.m_table.getSelectionModel().addListSelectionListener(new LoopSelectionListener());
        JScrollPane jScrollPane = new JScrollPane(this.m_table);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 5));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        Dimension dimension = new Dimension(80, 25);
        LoopActionListener loopActionListener = new LoopActionListener();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3, 5, 0));
        this.m_okButton = GUIFactory.createButton("OK", null, "IDS_REMOVE", null, null, false, loopActionListener);
        jPanel2.add(this.m_okButton);
        JButton jButton = GUIFactory.createButton("Cancel", null, "IDS_CANCEL", null, null, true, loopActionListener);
        jPanel2.add(jButton);
        JButton jButton2 = GUIFactory.createButton("Help", null, "IDS_HELP", null, null, true, loopActionListener);
        jPanel2.add(jButton2);
        this.getRootPane().setDefaultButton(this.m_okButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "East");
        Dimension dimension2 = this.m_okButton.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        dimension2 = jButton.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        dimension2 = jButton2.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        this.m_okButton.setPreferredSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton2.setPreferredSize(dimension);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 10));
        jPanel4.add((Component)jPanel, "Center");
        jPanel4.add((Component)jPanel3, "South");
        jPanel4.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel4, "Center");
        this.setDefaultCloseOperation(2);
        this.addKeyListener(new LoopKeyListener());
    }

    boolean loopsExisted() {
        return this.m_loopsExisted;
    }

    boolean findLoops() {
        this.m_loopsExisted = false;
        MutableProperties mutableProperties = this.m_properties;
        MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
        int n = mutableProperties.getType();
        if (n == 126) {
            Enumeration<TreeNode> enumeration = mutableProperties.children();
            while (enumeration.hasMoreElements()) {
                mutableProperties = (MutableProperties)enumeration.nextElement();
                n = mutableProperties.getType();
                if (n == 60 || n == 61 || n == 62) {
                    this.m_stack = new Stack();
                    this.m_stack.push(mutableProperties);
                    while (this.findPaneLoops()) {
                        this.m_loopsExisted = true;
                        if (!this.showLoopDialog()) {
                            return true;
                        }
                        this.m_stack.setSize(1);
                    }
                    this.m_stack.pop();
                    continue;
                }
                if (n != 1) continue;
                this.m_stack = new Stack();
                this.m_stack.push(mutableProperties);
                Enumeration<TreeNode> enumeration2 = mutableProperties.children();
                while (enumeration2.hasMoreElements()) {
                    mutableProperties = (MutableProperties)enumeration2.nextElement();
                    n = mutableProperties.getType();
                    if (n != 60 && n != 61 && n != 62) continue;
                    this.m_stack.push(mutableProperties);
                    while (this.findPaneLoops()) {
                        this.m_loopsExisted = true;
                        if (!this.showLoopDialog()) {
                            return true;
                        }
                        this.m_stack.setSize(2);
                    }
                    this.m_stack.pop();
                }
                this.m_stack.pop();
            }
        } else if (n == 1) {
            this.m_stack = new Stack();
            this.m_stack.push(mutableProperties);
            Enumeration<TreeNode> enumeration = mutableProperties.children();
            while (enumeration.hasMoreElements()) {
                mutableProperties = (MutableProperties)enumeration.nextElement();
                n = mutableProperties.getType();
                if (n != 60 && n != 61 && n != 62) continue;
                this.m_stack.push(mutableProperties);
                while (this.findPaneLoops()) {
                    this.m_loopsExisted = true;
                    if (!this.showLoopDialog()) {
                        return true;
                    }
                    this.m_stack.setSize(2);
                }
                this.m_stack.pop();
            }
            this.m_stack.pop();
        } else if (n == 60 || n == 61 || n == 62 || n == 120 || n == 121) {
            this.m_stack = new Stack();
            boolean bl = false;
            if (mutableProperties2 != null && mutableProperties2.getType() == 1) {
                this.m_stack.push(mutableProperties2);
                bl = true;
            }
            this.m_stack.push(mutableProperties);
            while (this.findPaneLoops()) {
                this.m_loopsExisted = true;
                if (!this.showLoopDialog()) {
                    return true;
                }
                this.m_stack.setSize(bl ? 2 : 1);
            }
            if (bl) {
                this.m_stack.pop();
            }
            this.m_stack.pop();
        }
        return false;
    }

    private boolean findPaneLoops() {
        MutableProperties mutableProperties = (MutableProperties)this.m_stack.peek();
        Enumeration<TreeNode> enumeration = mutableProperties.children();
        while (enumeration.hasMoreElements()) {
            int n;
            Enumeration<TreeNode> enumeration2;
            MutableProperties mutableProperties2;
            MutableProperties mutableProperties3 = (MutableProperties)enumeration.nextElement();
            if (mutableProperties3.getType() == 67) continue;
            Object object = mutableProperties3.getProperty("Target");
            if (!object.equals("")) {
                mutableProperties2 = (MutableProperties)object;
                if (this.m_stack.search(mutableProperties2) != -1) {
                    this.m_stack.push(mutableProperties2);
                    return true;
                }
                this.m_stack.push(mutableProperties2);
                if (mutableProperties2.getType() == 1) {
                    enumeration2 = mutableProperties2.children();
                    while (enumeration2.hasMoreElements()) {
                        mutableProperties2 = (MutableProperties)enumeration2.nextElement();
                        n = mutableProperties2.getType();
                        if (n != 60 && n != 61 && n != 62) continue;
                        this.m_stack.push(mutableProperties2);
                        if (this.findPaneLoops()) {
                            return true;
                        }
                        this.m_stack.pop();
                    }
                    this.m_stack.pop();
                    continue;
                }
                if (this.findPaneLoops()) {
                    return true;
                }
                this.m_stack.pop();
                continue;
            }
            String string = (String)mutableProperties3.getProperty("Resource");
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition = this.m_builder.getPDMLDocument(string);
            if (xMLGUIBuilderDefinition == null || (mutableProperties2 = xMLGUIBuilderDefinition.getPDMLRoot().getNodeNamed((String)mutableProperties3.getProperty("ID"))) == null) continue;
            if (this.m_stack.search(mutableProperties2) != -1) {
                this.m_stack.push(mutableProperties2);
                return true;
            }
            this.m_stack.push(mutableProperties2);
            if (mutableProperties2.getType() == 1) {
                enumeration2 = mutableProperties2.children();
                while (enumeration2.hasMoreElements()) {
                    mutableProperties2 = (MutableProperties)enumeration2.nextElement();
                    n = mutableProperties2.getType();
                    if (n != 60 && n != 61 && n != 62) continue;
                    this.m_stack.push(mutableProperties2);
                    if (this.findPaneLoops()) {
                        return true;
                    }
                    this.m_stack.pop();
                }
                this.m_stack.pop();
                continue;
            }
            if (this.findPaneLoops()) {
                return true;
            }
            this.m_stack.pop();
        }
        return false;
    }

    private boolean showLoopDialog() {
        int n = this.m_stack.size();
        Vector vector = new Vector(n - 1);
        int n2 = 0;
        while (n2 < n - 1) {
            Vector<MutableProperties> vector2 = new Vector<MutableProperties>(2);
            MutableProperties mutableProperties = (MutableProperties)this.m_stack.elementAt(n2);
            MutableProperties mutableProperties2 = (MutableProperties)this.m_stack.elementAt(n2 + 1);
            vector2.addElement(mutableProperties);
            vector2.addElement(mutableProperties2);
            vector.addElement(vector2);
            ++n2;
        }
        Vector<String> vector3 = new Vector<String>(2);
        vector3.addElement(GUIFactory.getString("IDS_CONTAINER_HEADER"));
        vector3.addElement(GUIFactory.getString("IDS_PANE_HEADER"));
        this.m_table.setModel(new LoopTableModel(vector, vector3));
        this.m_table.sizeColumnsToFit(-1);
        Dimension dimension = this.getPreferredSize();
        if (dimension.width < 400) {
            dimension.width = 400;
        }
        dimension.height = 300;
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Point point = new Point();
        point.x = (dimension2.width - dimension.width) / 2;
        point.y = (dimension2.height - dimension.height) / 2;
        ((Component)this).setBounds(point.x, point.y, dimension.width, dimension.height);
        this.m_loopRemoved = false;
        this.show();
        return this.m_loopRemoved;
    }

    private void doRemove() {
        int[] nArray = this.m_table.getSelectedRows();
        if (nArray == null || nArray.length < 1 || nArray[0] < 0) {
            return;
        }
        MutableProperties mutableProperties = (MutableProperties)this.m_table.getModel().getValueAt(nArray[0], 0);
        if (mutableProperties.getType() == 1) {
            return;
        }
        MutableProperties mutableProperties2 = (MutableProperties)this.m_table.getModel().getValueAt(nArray[0], 1);
        String string = mutableProperties2.getPDMLDocument().getPDMLRoot().getResourceName(true, false);
        String string2 = (String)mutableProperties2.getProperty("Name");
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = mutableProperties.getPDMLDocument();
        PaneProperties paneProperties = null;
        Enumeration<TreeNode> enumeration = mutableProperties.children();
        while (enumeration.hasMoreElements()) {
            paneProperties = (PaneProperties)enumeration.nextElement();
            String string3 = (String)paneProperties.getProperty("Resource");
            String string4 = (String)paneProperties.getProperty("ID");
            if (!string2.equals(string4) || !string.equals(string3)) continue;
            xMLGUIBuilderDefinition.beginEdit();
            paneProperties.removeFromParent();
            xMLGUIBuilderDefinition.endEdit();
            this.m_builder.updateBuilder();
            break;
        }
        this.m_loopRemoved = true;
        this.dispose();
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class LoopKeyListener
    extends KeyAdapter {
        LoopKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 112) {
                LoopDialog.this.m_builder.displayHelp("LoopDialog", LoopDialog.this);
            }
        }
    }

    class LoopActionListener
    implements ActionListener {
        LoopActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                LoopDialog.this.doRemove();
            } else if (string.equals("Cancel")) {
                LoopDialog.this.dispose();
            } else if (string.equals("Help")) {
                LoopDialog.this.m_builder.displayHelp("LoopDialog", LoopDialog.this);
            }
        }
    }

    class LoopTableModel
    extends DefaultTableModel {
        LoopTableModel(Vector vector, Vector vector2) {
            super(vector, vector2);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    class LoopSelectionListener
    implements ListSelectionListener {
        LoopSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl;
            int[] nArray = LoopDialog.this.m_table.getSelectedRows();
            boolean bl2 = bl = nArray != null && nArray.length > 0;
            if (bl) {
                MutableProperties mutableProperties = (MutableProperties)LoopDialog.this.m_table.getModel().getValueAt(nArray[0], 0);
                bl = mutableProperties.getType() != 1;
            }
            LoopDialog.this.m_okButton.setEnabled(bl);
        }
    }

    class LoopCellRenderer
    extends DefaultTableCellRenderer {
        LoopCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            MutableProperties mutableProperties = (MutableProperties)object;
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition = mutableProperties.getPDMLDocument();
            jLabel.setText(xMLGUIBuilderDefinition.getPDMLRoot().getResourceName(true, false) + "." + mutableProperties.getProperty("Name"));
            return jLabel;
        }
    }

    class LoopMouseListener
    extends MouseAdapter {
        LoopMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                LoopDialog.this.doRemove();
            }
        }
    }
}

