/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.java.DividerPanel;
import com.ibm.as400.ui.tools.BuilderFrame;
import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.ItemProperties;
import com.ibm.as400.ui.tools.ListBuilderTable;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.NameGenerator;
import com.ibm.as400.ui.tools.PDMLNodeEvent;
import com.ibm.as400.ui.tools.PDMLNodeListener;
import com.ibm.as400.ui.tools.PanelBuilder;
import com.ibm.as400.ui.tools.PropertyTableModel;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class ListBuilder
extends BuilderFrame {
    JPanel m_mainToolBar;
    JPanel m_moveToolBar;
    JPanel m_editToolBar;
    JPanel m_helpToolBar;
    JTable m_table;
    PropertyTableModel m_tableModel;
    ListTableModelListener m_modelListener;
    int m_offset;
    JPopupMenu m_contextMenu;
    ActionListener m_menuListener;
    PanelBuilder m_panelBuilder;
    PDMLNodeListener m_pdmlNodeListener;
    TreeModelListener m_treeModelListener;
    static /* synthetic */ Class class$java$lang$Object;

    ListBuilder(GUIBuilder gUIBuilder, XMLGUIBuilderDefinition xMLGUIBuilderDefinition, MutableProperties mutableProperties) {
        super(gUIBuilder, xMLGUIBuilderDefinition, mutableProperties);
        this.m_panelBuilder = (PanelBuilder)gUIBuilder.getEditor((MutableProperties)mutableProperties.getParent());
        this.m_treeModelListener = new ListTreeModelListener();
        mutableProperties.addTreeModelListener(this.m_treeModelListener);
        this.m_pdmlNodeListener = new ListPDMLNodeListener();
        mutableProperties.addPDMLNodeListener(this.m_pdmlNodeListener);
        this.m_offset = mutableProperties.getType() == 9 ? 2 : 0;
        this.removeKeyListener(this.m_keyListener);
        ListActionListener listActionListener = new ListActionListener();
        this.m_menuListener = listActionListener;
        this.m_mainToolBar = new DividerPanel(2);
        this.m_mainToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_mainToolBar.add(GUIFactory.createButton("Add", null, null, "Add.gif", "IDTT_ADD_ITEM", true, listActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Remove", null, null, "Remove.gif", "IDTT_REMOVE_ITEM", true, listActionListener));
        this.m_moveToolBar = new DividerPanel(2);
        this.m_moveToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_moveToolBar.add(GUIFactory.createButton("Move Up", null, null, "MoveUp.gif", "IDTT_MOVE_UP", true, listActionListener));
        this.m_moveToolBar.add(GUIFactory.createButton("Move Down", null, null, "MoveDown.gif", "IDTT_MOVE_DOWN", true, listActionListener));
        this.m_editToolBar = new DividerPanel(2);
        this.m_editToolBar.setLayout(new GridLayout(1, 3, 0, 0));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Cut", null, null, "Cut.gif", "IDTT_EDIT_CUT", false, listActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Copy", null, null, "Copy.gif", "IDTT_EDIT_COPY", false, listActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Paste", null, null, "Paste.gif", "IDTT_EDIT_PASTE", false, listActionListener));
        this.m_helpToolBar = new JPanel();
        this.m_helpToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_helpToolBar.add(GUIFactory.createButton("Preview", null, null, "Preview.gif", "IDTT_PREVIEW", true, listActionListener));
        this.m_helpToolBar.add(GUIFactory.createButton("Help", null, null, "Help.gif", "IDTT_HELP", true, listActionListener));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.m_mainToolBar);
        jPanel.add(this.m_editToolBar);
        jPanel.add(this.m_moveToolBar);
        jPanel.add(this.m_helpToolBar);
        Object[] objectArray = new Object[]{GUIFactory.getString("IDS_ITEMS_HEADER")};
        this.m_tableModel = new PropertyTableModel(mutableProperties.getType());
        this.m_tableModel.setColumnIdentifiers(objectArray);
        this.m_table = new ListBuilderTable(gUIBuilder, this.m_tableModel, mutableProperties);
        this.m_table.setOpaque(true);
        this.m_table.setShowGrid(true);
        this.m_table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = ListBuilder.class$("java.lang.Object")) : class$java$lang$Object, new ListCellRenderer());
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_table.getSelectionModel().setSelectionMode(0);
        this.m_table.getSelectionModel().addListSelectionListener(new ListBuilderSelectionListener());
        this.m_table.addMouseListener(new ListMouseListener());
        this.m_table.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ListBuilder.this.stopEditing();
            }
        });
        this.m_modelListener = new ListTableModelListener();
        this.m_tableModel.addTableModelListener(this.m_modelListener);
        String string = null;
        switch (mutableProperties.getType()) {
            case 8: {
                string = "Combobox.gif";
                break;
            }
            case 9: {
                string = "Listbox.gif";
            }
        }
        if (string != null) {
            ((Frame)this).setIconImage(GUIFactory.getImage(string, true).getImage());
        }
        this.updateTitleBar(null);
        this.getContentPane().setBackground(this.m_table.getBackground());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)new JScrollPane(this.m_table), "Center");
        int n = 0;
        Enumeration<TreeNode> enumeration = mutableProperties.children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties2 = (MutableProperties)enumeration.nextElement();
            if (mutableProperties2.getType() != 115) continue;
            this.insertProperties(mutableProperties2, n, false);
            ++n;
        }
        Dimension dimension = jPanel.getPreferredSize();
        dimension.width += 10;
        if (dimension.width < 400) {
            dimension.width = 400;
        }
        dimension.height = 250;
        Dimension dimension2 = this.getPreferredSize();
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        ((Component)this).setSize(dimension);
        this.initContextMenu();
    }

    void initContextMenu() {
        this.m_contextMenu = new JPopupMenu();
        JMenu jMenu = GUIFactory.createMenu("Selected", "IDCM_ITEM_SELECTED", null, true);
        this.m_contextMenu.add(jMenu);
        jMenu.add(GUIFactory.createMenuItem("Selected Enable", null, "IDM_SELECTED_ENABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Disable", null, "IDM_SELECTED_DISABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Refresh", null, "IDM_SELECTED_REFRESH", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Show", null, "IDM_SELECTED_SHOW", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Hide", null, "IDM_SELECTED_HIDE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Display", null, "IDM_SELECTED_DISPLAY", null, true, this.m_menuListener));
        jMenu.addSeparator();
        jMenu.add(GUIFactory.createMenuItem("Selected Other", null, "IDM_SELECTED_OTHER", null, true, this.m_menuListener));
        this.m_contextMenu.addSeparator();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_ITEM_EDIT_CUT", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_ITEM_EDIT_COPY", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_ITEM_EDIT_PASTE", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_ITEM_EDIT_DELETE", null, false, this.m_menuListener));
        this.m_contextMenu.addSeparator();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_ITEM_PROPERTIES", null, true, this.m_menuListener));
    }

    JPopupMenu getContextMenu() {
        this.m_contextMenu.getComponent(2).setEnabled(this.canCut());
        this.m_contextMenu.getComponent(3).setEnabled(this.canCopy());
        this.m_contextMenu.getComponent(4).setEnabled(this.canPaste());
        this.m_contextMenu.getComponent(5).setEnabled(this.canDelete());
        return this.m_contextMenu;
    }

    String getHelpName() {
        return "ListBuilder";
    }

    public void stopEditing() {
        if (this.m_table.isEditing()) {
            ((DefaultCellEditor)this.m_table.getCellEditor()).stopCellEditing();
        }
    }

    boolean canAddItem() {
        return true;
    }

    public boolean canCut() {
        int n = this.getSelectedRow();
        int n2 = this.m_table.getRowCount();
        return n > -1 && n2 > 0;
    }

    public boolean canCopy() {
        int n = this.getSelectedRow();
        int n2 = this.m_table.getRowCount();
        return n > -1 && n2 > 0;
    }

    public boolean canPaste() {
        boolean bl = this.canAddItem();
        if (bl) {
            bl = false;
            Transferable transferable = this.getBuilder().getClipboard().getContents(this);
            if (transferable != null && transferable instanceof MutableProperties) {
                MutableProperties mutableProperties = (MutableProperties)transferable;
                bl = mutableProperties.getType() == 115;
            }
        }
        return bl;
    }

    public boolean canDelete() {
        int n = this.getSelectedRow();
        int n2 = this.m_table.getRowCount();
        return n > -1 && n2 > 0;
    }

    public void cut() {
        if (!this.canCut()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        MutableProperties mutableProperties = this.getTableSelection();
        this.doRemove();
        this.getBuilder().getClipboard().setContents(mutableProperties, mutableProperties);
        this.getPDMLDocument().endEdit();
    }

    public void copy() {
        if (!this.canCopy()) {
            return;
        }
        MutableProperties mutableProperties = this.getTableSelection();
        MutableProperties mutableProperties2 = mutableProperties.cloneNode(this.getPDMLDocument(), null);
        this.getBuilder().getClipboard().setContents(mutableProperties2, mutableProperties2);
    }

    public void paste() {
        if (!this.canPaste()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        Transferable transferable = this.getBuilder().getClipboard().getContents(this);
        MutableProperties mutableProperties = ((MutableProperties)transferable).cloneNode(this.getPDMLDocument(), (NameGenerator)((Object)this.getProperties()));
        mutableProperties.setPDMLDocument(this.getPDMLDocument());
        MutableProperties mutableProperties2 = this.getTableSelection();
        if (mutableProperties2 == null) {
            this.getProperties().add(mutableProperties);
        } else {
            this.getProperties().insert(mutableProperties, this.getProperties().getIndex(mutableProperties2) + 1);
        }
        this.getPDMLDocument().endEdit();
    }

    public void delete() {
        if (!this.canDelete()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        this.doRemove();
        this.getPDMLDocument().endEdit();
    }

    public MutableProperties getSelectedProperties() {
        MutableProperties mutableProperties = this.getTableSelection();
        if (mutableProperties != null) {
            return mutableProperties;
        }
        return this.getProperties();
    }

    MutableProperties getTableSelection() {
        int n = this.getSelectedRow();
        if (n > -1) {
            return (MutableProperties)this.m_tableModel.getValueAt(n, 0);
        }
        return null;
    }

    ItemProperties getItemAtIndex(int n) {
        return (ItemProperties)this.getProperties().getChildAt(n + this.m_offset);
    }

    void insertProperties(MutableProperties mutableProperties, int n, boolean bl) {
        Object[] objectArray = new Object[]{mutableProperties};
        this.m_tableModel.insertRow(n, objectArray);
        if (bl) {
            this.m_table.setRowSelectionInterval(n, n);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(n, 0, true));
        }
    }

    void removeProperties(MutableProperties mutableProperties, int n) {
        this.m_tableModel.removeRow(n);
    }

    void doAdd() {
        ItemProperties itemProperties = new ItemProperties();
        try {
            int n = this.getProperties().getType();
            itemProperties.setProperty("Name", ((NameGenerator)((Object)this.getProperties())).generateName(115));
            itemProperties.setProperty("Title", GUIFactory.getString("IDS_DEFAULT_LABEL_ITEM"));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        itemProperties.setPDMLDocument(this.getPDMLDocument());
        MutableProperties mutableProperties = this.getTableSelection();
        if (mutableProperties == null) {
            this.getProperties().add(itemProperties);
        } else {
            this.getProperties().insert(itemProperties, this.getProperties().getIndex(mutableProperties) + 1);
        }
    }

    void doRemove() {
        MutableProperties mutableProperties = this.getTableSelection();
        if (mutableProperties != null) {
            int n = this.getSelectedRow();
            mutableProperties.removeFromParent();
            int n2 = this.m_table.getRowCount();
            if (n2 > 0) {
                if (n >= n2) {
                    n = n2 - 1;
                }
                this.m_table.setRowSelectionInterval(n, n);
            }
        }
    }

    void doMoveUp() {
        MutableProperties mutableProperties = this.getTableSelection();
        if (mutableProperties != null) {
            MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
            int n = mutableProperties2.getIndex(mutableProperties);
            mutableProperties.removeFromParent();
            mutableProperties2.insert(mutableProperties, n - 1);
        }
    }

    void doMoveDown() {
        MutableProperties mutableProperties = this.getTableSelection();
        if (mutableProperties != null) {
            MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
            int n = mutableProperties2.getIndex(mutableProperties);
            mutableProperties.removeFromParent();
            mutableProperties2.insert(mutableProperties, n + 1);
        }
    }

    public void updateBuilder() {
        boolean bl;
        boolean bl2;
        int n = this.getSelectedRow();
        int n2 = this.m_table.getRowCount();
        boolean bl3 = bl2 = n > -1 && n2 > 0;
        boolean bl4 = bl2 ? n > 0 : (bl = false);
        boolean bl5 = bl2 ? n < n2 - 1 : false;
        this.m_mainToolBar.getComponent(0).setEnabled(this.canAddItem());
        this.m_mainToolBar.getComponent(1).setEnabled(bl2);
        this.m_moveToolBar.getComponent(0).setEnabled(bl);
        this.m_moveToolBar.getComponent(1).setEnabled(bl5);
        this.m_editToolBar.getComponent(0).setEnabled(this.canCut());
        this.m_editToolBar.getComponent(1).setEnabled(this.canCopy());
        this.m_editToolBar.getComponent(2).setEnabled(this.canPaste());
    }

    public void updateTitleBar(String string) {
        if (string == null && (string = (String)this.getPDMLDocument().getPDMLRoot().getProperty("File Name")).equals("")) {
            string = this.getPDMLDocument().getPDMLRoot().getResourceName(true, true);
        }
        String string2 = (String)this.getProperties().getProperty("Name");
        string2 = string2 + " (" + string + ")";
        this.setTitle(string2);
    }

    int getSelectedRow() {
        int[] nArray = this.m_table.getSelectedRows();
        if (nArray.length == 0) {
            return -1;
        }
        return nArray[0];
    }

    public void setSelectedProperties(MutableProperties mutableProperties) {
        this.m_table.clearSelection();
        int n = this.m_table.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            MutableProperties mutableProperties2 = (MutableProperties)this.m_table.getValueAt(n2, 0);
            if (mutableProperties2.equals(mutableProperties)) {
                this.m_table.setRowSelectionInterval(n2, n2);
                this.m_table.scrollRectToVisible(this.m_table.getCellRect(n2, 0, true));
                break;
            }
            ++n2;
        }
    }

    public void uninstallListeners() {
        this.getProperties().removePDMLNodeListener(this.m_pdmlNodeListener);
        this.getProperties().removeTreeModelListener(this.m_treeModelListener);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ListMouseListener
    extends MouseAdapter {
        ListMouseListener() {
        }

        void showContextMenu(MouseEvent mouseEvent) {
            int n = ListBuilder.this.m_table.rowAtPoint(mouseEvent.getPoint());
            int n2 = ListBuilder.this.m_table.columnAtPoint(mouseEvent.getPoint());
            if (n != -1 && n == ListBuilder.this.getSelectedRow() && n2 == 0) {
                JPopupMenu jPopupMenu = ListBuilder.this.getContextMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }
    }

    class ListTableModelListener
    implements TableModelListener {
        ListTableModelListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 0) {
                ListBuilder.this.m_tableModel.removeTableModelListener(ListBuilder.this.m_modelListener);
                int n = tableModelEvent.getColumn();
                int n2 = tableModelEvent.getFirstRow();
                Object object = ListBuilder.this.m_tableModel.getValueAt(n2, 0);
                if (object instanceof String) {
                    String string;
                    ItemProperties itemProperties = ListBuilder.this.getItemAtIndex(n2);
                    String string2 = (String)itemProperties.getProperty("Title");
                    if (!string2.equals(string = (String)object)) {
                        ListBuilder.this.getPDMLDocument().beginEdit();
                        try {
                            itemProperties.setProperty("Title", string);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        ListBuilder.this.getPDMLDocument().endEdit();
                        ListBuilder.this.getBuilder().updateBuilder();
                    }
                    ListBuilder.this.m_tableModel.setValueAt(itemProperties, n2, 0);
                }
                ListBuilder.this.m_tableModel.addTableModelListener(ListBuilder.this.m_modelListener);
            }
        }
    }

    class ListTreeModelListener
    implements TreeModelListener {
        ListTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            ListBuilder.this.repaint();
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            if (treePath.getLastPathComponent().equals(ListBuilder.this.getProperties())) {
                Object[] objectArray = treeModelEvent.getChildren();
                int[] nArray = treeModelEvent.getChildIndices();
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                    int n2 = nArray[n] - ListBuilder.this.m_offset;
                    if (n2 > -1) {
                        ListBuilder.this.insertProperties(mutableProperties, n2, true);
                    }
                    ++n;
                }
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            if (treePath.getLastPathComponent().equals(ListBuilder.this.getProperties())) {
                Object[] objectArray = treeModelEvent.getChildren();
                int[] nArray = treeModelEvent.getChildIndices();
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                    int n2 = nArray[n] - ListBuilder.this.m_offset;
                    if (n2 > -1) {
                        ListBuilder.this.removeProperties(mutableProperties, n2);
                    }
                    ++n;
                }
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    class ListPDMLNodeListener
    implements PDMLNodeListener {
        ListPDMLNodeListener() {
        }

        public void PDMLNodeChanged(PDMLNodeEvent pDMLNodeEvent) {
            ListBuilder.this.updateTitleBar(null);
        }

        public void PDMLNodeInserted(PDMLNodeEvent pDMLNodeEvent) {
        }

        public void PDMLNodeRemoved(PDMLNodeEvent pDMLNodeEvent) {
        }
    }

    class ListCellRenderer
    extends DefaultTableCellRenderer {
        ListCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                super.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                super.setForeground(jTable.getForeground());
                super.setBackground(jTable.getBackground());
            }
            this.setFont(jTable.getFont());
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(DefaultTableCellRenderer.noFocusBorder);
            }
            if (object != null) {
                this.setValue(object);
                this.setIcon(null);
                if (object instanceof ItemProperties) {
                    ItemProperties itemProperties = (ItemProperties)object;
                    this.setText((String)itemProperties.getProperty("Title"));
                    String string = (String)itemProperties.getProperty("Icon");
                    if (string != null && !string.equals("")) {
                        String string2 = (String)itemProperties.getProperty("* H Position");
                        String string3 = (String)itemProperties.getProperty("* V Position");
                        ImageIcon imageIcon = null;
                        imageIcon = GUIFactory.getUserImage(string);
                        if (imageIcon == null) {
                            imageIcon = GUIFactory.getImage("Bitmap.gif", true);
                        }
                        this.setIcon(imageIcon);
                        int n3 = 4;
                        int n4 = 0;
                        if (string2.equals("right")) {
                            n3 = 2;
                        } else if (string2.equals("center")) {
                            n3 = 0;
                        }
                        if (string3.equals("top")) {
                            n4 = 1;
                        } else if (string3.equals("bottom")) {
                            n4 = 3;
                        }
                        if (n3 == 0) {
                            if (n4 == 1) {
                                n4 = 3;
                            } else if (n4 == 3) {
                                n4 = 1;
                            }
                        }
                        this.setHorizontalTextPosition(n3);
                        this.setVerticalTextPosition(n4);
                        this.setIcon(imageIcon);
                    }
                }
            }
            return this;
        }
    }

    class ListBuilderSelectionListener
    implements ListSelectionListener {
        ListBuilderSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListBuilder.this.fireSelectionChangedEvent();
        }
    }

    class ListActionListener
    implements ActionListener {
        ListActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ListBuilder.this.stopEditing();
            String string = actionEvent.getActionCommand();
            if (string.equals("Add")) {
                ListBuilder.this.getPDMLDocument().beginEdit();
                ListBuilder.this.doAdd();
                ListBuilder.this.getPDMLDocument().endEdit();
                ListBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Remove")) {
                ListBuilder.this.getPDMLDocument().beginEdit();
                ListBuilder.this.doRemove();
                ListBuilder.this.getPDMLDocument().endEdit();
                ListBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Move Up")) {
                ListBuilder.this.getPDMLDocument().beginEdit(true);
                ListBuilder.this.doMoveUp();
                ListBuilder.this.getPDMLDocument().endEdit();
                ListBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Move Down")) {
                ListBuilder.this.getPDMLDocument().beginEdit(true);
                ListBuilder.this.doMoveDown();
                ListBuilder.this.getPDMLDocument().endEdit();
                ListBuilder.this.getBuilder().updateBuilder();
            } else if (string.startsWith("Edit")) {
                if ((string = string.substring(5)).equals("Cut")) {
                    ListBuilder.this.cut();
                    ListBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Copy")) {
                    ListBuilder.this.copy();
                    ListBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Paste")) {
                    ListBuilder.this.paste();
                    ListBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Delete")) {
                    ListBuilder.this.delete();
                    ListBuilder.this.getBuilder().updateBuilder();
                }
            } else if (string.startsWith("Selected")) {
                string = string.substring(9);
                ListBuilder.this.m_panelBuilder.doSelectedEdit(ListBuilder.this.getSelectedProperties(), true, string, ListBuilder.this);
            } else if (string.equals("Preview")) {
                ListBuilder.this.setCursor(Cursor.getPredefinedCursor(3));
                MutableProperties mutableProperties = ListBuilder.this.getProperties();
                mutableProperties = (MutableProperties)mutableProperties.getParent();
                ListBuilder.this.getBuilder().doPreview(mutableProperties);
                ListBuilder.this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (string.equals("Show Properties")) {
                ListBuilder.this.getBuilder().doShowProperties();
            } else if (string.equals("Help")) {
                ListBuilder.this.displayHelp();
            }
        }
    }
}

