/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.MessageLog;
import com.ibm.as400.ui.tools.HelpDocParser;
import com.ibm.as400.ui.tools.HelpDocTagDescriptor;
import com.ibm.as400.ui.tools.HelpException;
import com.ibm.as400.ui.tools.ToolsResourceLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Vector;

public class HelpDocSplitter {
    static boolean m_Trace = false;
    public static final int SPLIT_SUCCESS = 0;
    public static final int SPLIT_FAILURE = 2;
    String mapFileContent = "";
    Vector mapFileEntries = new Vector();
    private String first;
    private String second = null;
    private static String m_countryCode = "";
    public static ToolsResourceLoader resourceLoader = new ToolsResourceLoader();

    public static void main(String[] stringArray) {
        Object object;
        boolean bl = false;
        String string = "";
        if (stringArray.length == 0 || stringArray.length > 4) {
            System.out.println(resourceLoader.getString("IDHDS_HELP_SPLITTER_ARGUMENTS"));
            System.exit(2);
        }
        if (stringArray.length >= 1) {
            string = stringArray[0];
        }
        String string2 = stringArray.length >= 2 ? stringArray[1] : null;
        String string3 = stringArray.length >= 3 ? stringArray[2] : null;
        m_countryCode = stringArray.length >= 4 ? stringArray[3] : "";
        if (string3 != null && ((File)(object = new File(string3))).exists()) {
            bl = true;
        }
        try {
            object = new HelpDocSplitter(string, string2, string3, bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Object[] objectArray = new Object[]{new String(fileNotFoundException.getMessage())};
            String string4 = MessageFormat.format(resourceLoader.getString("IDHDS_ERROR_FILE_NOT_FOUND"), objectArray);
            System.out.println(string4);
            System.exit(2);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            System.exit(2);
        }
        catch (HelpException helpException) {
            Object[] objectArray = new Object[]{new String(helpException.getMessage())};
            String string5 = MessageFormat.format(resourceLoader.getString("IDHDS_ERROR_GENERAL"), objectArray);
            System.out.println(string5);
            System.exit(2);
        }
    }

    HelpDocSplitter(String string, String string2, String string3, boolean bl) throws IOException, FileNotFoundException, HelpException {
        Object var5_5 = null;
        String string4 = "";
        String string5 = "";
        String string6 = null;
        int n = string.replace('\\', '/').lastIndexOf(47);
        if (n > -1) {
            string6 = string.substring(0, n + 1);
        }
        String string7 = string;
        n = string.replace('\\', '/').lastIndexOf(46);
        if (n > -1) {
            string7 = string.substring(0, n);
        }
        if (string2 == null) {
            string2 = string7 + System.getProperty("file.separator");
        }
        if (string3 != null) {
            this.createMapFile(string3, bl);
        }
        if (string != null) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            HelpDocParser helpDocParser = new HelpDocParser(bufferedReader);
            HelpDocTagDescriptor helpDocTagDescriptor = null;
            String string8 = "";
            boolean bl2 = false;
            boolean bl3 = false;
            while (!bl3) {
                Object object;
                String string9 = helpDocParser.nextTag();
                String string10 = helpDocParser.previousContent();
                if (string9 == null) break;
                HelpDocTagDescriptor helpDocTagDescriptor2 = new HelpDocTagDescriptor(string9);
                if (helpDocTagDescriptor2.m_tag.equalsIgnoreCase("HEADEREND")) {
                    HelpDocSplitter.debug("Found header ");
                    bl2 = true;
                    string8 = string10;
                    if (helpDocTagDescriptor2.m_headerFilename == null || helpDocTagDescriptor2.m_headerFilename.trim().length() <= 0 || (object = HelpDocSplitter.OpenReadFile(helpDocTagDescriptor2.m_headerFilename)) == null || object.length() <= 0) continue;
                    string8 = object;
                    continue;
                }
                if (helpDocTagDescriptor2.m_tag.equalsIgnoreCase("FOOTERBEGIN")) {
                    HelpDocSplitter.debug("Found footer begin ");
                    continue;
                }
                if (helpDocTagDescriptor2.m_tag.equalsIgnoreCase("SEGMENTBEGIN")) {
                    if (!bl2) {
                        throw new HelpException(resourceLoader.getString("IDHDS_MISSING_HEADEREND"));
                    }
                    helpDocTagDescriptor = helpDocTagDescriptor2;
                    HelpDocSplitter.debug("Found segment begin ");
                    continue;
                }
                if (helpDocTagDescriptor2.m_tag.equalsIgnoreCase("SEGMENTEND")) {
                    if (helpDocTagDescriptor != null) {
                        String string11;
                        HelpDocSplitter.debug("-------------------");
                        HelpDocSplitter.debug("Creating segment: ");
                        HelpDocSplitter.debug("type: " + helpDocTagDescriptor.m_tag);
                        HelpDocSplitter.debug("name: " + helpDocTagDescriptor.m_id);
                        HelpDocSplitter.debug("header: " + helpDocTagDescriptor.m_headerFilename);
                        object = string8;
                        if (helpDocTagDescriptor.m_headerFilename != null && helpDocTagDescriptor.m_headerFilename.trim().length() > 0 && (string11 = HelpDocSplitter.OpenReadFile(string6 + helpDocTagDescriptor.m_headerFilename)) != null && string11.length() > 0) {
                            object = string11;
                        }
                        HelpDocSplitter.debug("header content: " + (String)object);
                        string11 = HelpDocSplitter.adjustAnchors(string10);
                        HelpDocSplitter.debug("body content: " + string11);
                        HelpDocSplitter.debug("footer: " + helpDocTagDescriptor.m_footerFilename);
                        HelpDocSplitter.debug("footer content: </BODY></HTML>");
                        HelpDocSplitter.debug("-------------------");
                        Object[] objectArray = new Object[]{new String(string2 + helpDocTagDescriptor.m_id)};
                        System.out.println(MessageFormat.format(resourceLoader.getString("IDHDS_CREATING_FILE"), objectArray));
                        PrintWriter printWriter = new PrintWriter(new FileWriter(string2 + helpDocTagDescriptor.m_id));
                        object = this.fixTitle((String)object, string11);
                        printWriter.println((String)object);
                        printWriter.println(string11);
                        printWriter.println("</BODY>\r\n</HTML>");
                        printWriter.close();
                        if (string3 != null) {
                            String string12;
                            String string13 = helpDocTagDescriptor.m_id;
                            if ((string13 = string13.toLowerCase()).endsWith(".html")) {
                                string4 = helpDocTagDescriptor.m_id.substring(0, string13.indexOf(".html"));
                            }
                            if ((string12 = string2).indexOf(":") != -1) {
                                string12 = "";
                            }
                            HelpDocSplitter.debug("MapFile entry is " + string4 + "=" + helpDocTagDescriptor.m_id);
                            string5 = "<mapID target=\"" + string4 + "\"  url=\"" + string12 + helpDocTagDescriptor.m_id + "\" />";
                            this.mapFileEntries.addElement(string5);
                        }
                        helpDocTagDescriptor = null;
                        continue;
                    }
                    object = new Object[]{new Integer(helpDocParser.currentLine())};
                    throw new HelpException(MessageFormat.format(resourceLoader.getString("IDHDS_MISSING_SEGMENTBEGIN"), object));
                }
                object = new Object[]{string9, new Integer(helpDocParser.currentLine())};
                throw new HelpException(MessageFormat.format(resourceLoader.getString("IDHDS_UNKNOWN_TAG_FOUND"), object));
            }
            if (!bl2) {
                throw new HelpException(resourceLoader.getString("IDHDS_MISSING_HEADEREND"));
            }
            if (string3 != null) {
                this.writeMapFile(string3, bl);
            }
        }
    }

    private static String adjustAnchors(String string) {
        String string2 = "";
        int n = string.indexOf("href=");
        int n2 = string.indexOf("HREF=");
        if (n < 0 || n2 < n && n2 != -1) {
            n = n2;
        }
        while (n >= 0) {
            string2 = string2 + string.substring(0, n + 5);
            string = string.substring(n + 5);
            int n3 = string.indexOf(">");
            String string3 = string.substring(0, n3);
            HelpDocSplitter.debug("Anchor " + string3);
            int n4 = string3.indexOf(".htm");
            if (n4 > -1) {
                string2 = string3.startsWith("\"#") ? string2 + "\"" + string3.substring(2) : (string3.startsWith("#") ? string2 + string3.substring(1) : (string3.startsWith("jar:") || string3.startsWith("\"jar:") ? string2 + HelpDocSplitter.adjustJarAnchor(string3, m_countryCode) : string2 + string3));
                string = string.substring(n3);
            }
            n = string.indexOf("href=");
            n2 = string.indexOf("HREF=");
            if (n >= 0 && (n2 >= n || n2 == -1)) continue;
            n = n2;
        }
        string2 = string2 + string;
        return string2;
    }

    private static String adjustJarAnchor(String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n = 0;
        String string6 = string.toLowerCase();
        n = string6.indexOf(".jar!");
        if (n == -1) {
            return string;
        }
        string4 = string.substring(0, n);
        string5 = string.substring(n);
        string3 = string4 + string2 + string5;
        return string3;
    }

    private static String OpenReadFile(String string) throws HelpException, FileNotFoundException {
        String string2 = "";
        if (string == null) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        try {
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                string2 = string2 + "\n" + string3;
                string3 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{string, iOException};
            throw new HelpException(MessageFormat.format(resourceLoader.getString("IDHDS_IO_EXCEPTION"), objectArray));
        }
        return string2;
    }

    private void createMapFile(String string, boolean bl) throws HelpException, FileNotFoundException {
        boolean bl2 = false;
        File file = new File(string);
        if (file.exists() && bl) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            try {
                String string2 = bufferedReader.readLine();
                while (!bl2) {
                    if (string2.indexOf("</map>") == -1) {
                        this.mapFileContent = this.mapFileContent + "\r\n" + string2;
                        string2 = bufferedReader.readLine();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[]{string, iOException};
                throw new HelpException(MessageFormat.format(resourceLoader.getString("IDHDS_IO_EXCEPTION"), objectArray));
            }
        }
    }

    private void writeMapFile(String string, boolean bl) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(string));
        if (bl) {
            printWriter.println(this.mapFileContent);
        } else {
            printWriter.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
            printWriter.println("<!DOCTYPE map");
            printWriter.println(" PUBLIC ");
            printWriter.println("\"-//Sun Microsystems Inc.//DTD JavaHelp Map Version 1.0//EN\"");
            printWriter.println("\"http://java.sun.com/products/javahelp/map_1_0.dtd\">");
            printWriter.println("<map version=\"1.0\">");
        }
        int n = 0;
        while (n < this.mapFileEntries.size()) {
            printWriter.println(this.mapFileEntries.elementAt(n));
            ++n;
        }
        printWriter.println("</map>");
        printWriter.close();
    }

    private String fixTitle(String string, String string2) {
        String string3 = string2.toLowerCase();
        String string4 = string.toLowerCase();
        int n = string3.indexOf("<h");
        int n2 = string3.indexOf("</h");
        if (n == -1 || n2 == -1) {
            return string;
        }
        String string5 = string2.substring(n + 4, n2);
        if (this.first == null && this.second == null) {
            n = string4.indexOf("<title>");
            n2 = string4.indexOf("</title>");
            this.first = string.substring(0, n + 7);
            this.second = string.substring(n2);
        }
        if (n == -1 || n2 == -1) {
            return string;
        }
        string = this.first + string5 + this.second;
        return string;
    }

    private static void debug(String string) {
        if (m_Trace) {
            System.out.println("HelpDocSplitter: " + string);
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static {
        resourceLoader.setResourceName("com.ibm.as400.ui.tools.HelpGenMRI");
        try {
            MessageLog.setLogFileName((String)("Service" + System.getProperty("file.separator") + "OpNav.Java.Service.log"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

