/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.java.DividerPanel;
import com.ibm.as400.ui.tools.BuilderFrame;
import com.ibm.as400.ui.tools.ButtonProperties;
import com.ibm.as400.ui.tools.DeckPaneProperties;
import com.ibm.as400.ui.tools.FileProperties;
import com.ibm.as400.ui.tools.FixedDefaultTreeModel;
import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MenuProperties;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.PDMLNodeEvent;
import com.ibm.as400.ui.tools.PDMLNodeListener;
import com.ibm.as400.ui.tools.PanelProperties;
import com.ibm.as400.ui.tools.PropertySheetProperties;
import com.ibm.as400.ui.tools.SplitPaneProperties;
import com.ibm.as400.ui.tools.StringTableProperties;
import com.ibm.as400.ui.tools.TabbedPaneProperties;
import com.ibm.as400.ui.tools.WizardProperties;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class FileBuilder
extends BuilderFrame {
    JPanel m_fileToolBar;
    JPanel m_editToolBar;
    JPanel m_helpToolBar;
    JPanel m_mainToolBar;
    JTree m_tree;
    DefaultTreeModel m_treeModel;
    DefaultMutableTreeNode m_root;
    Hashtable m_nodes;
    JPopupMenu m_contextMenu;
    JPopupMenu m_fileContextMenu;
    ActionListener m_menuListener;
    boolean m_hasStringTable = false;
    PDMLNodeListener m_pdmlNodeListener;
    TreeModelListener m_treeModelListener;

    FileBuilder(GUIBuilder gUIBuilder, XMLGUIBuilderDefinition xMLGUIBuilderDefinition, FileProperties fileProperties) {
        super(gUIBuilder, xMLGUIBuilderDefinition, fileProperties);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_treeModelListener = new FileTreeModelListener();
        fileProperties.addTreeModelListener(this.m_treeModelListener);
        this.m_pdmlNodeListener = new FilePDMLNodeListener();
        fileProperties.addPDMLNodeListener(this.m_pdmlNodeListener);
        this.m_nodes = new Hashtable();
        FileActionListener fileActionListener = new FileActionListener();
        this.m_menuListener = fileActionListener;
        this.m_editToolBar = new DividerPanel(2);
        this.m_editToolBar.setLayout(new GridLayout(1, 5, 0, 0));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Cut", null, null, "Cut.gif", "IDTT_EDIT_CUT", false, fileActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Copy", null, null, "Copy.gif", "IDTT_EDIT_COPY", false, fileActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Paste", null, null, "Paste.gif", "IDTT_EDIT_PASTE", false, fileActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Undo", null, null, "Undo.gif", "IDTT_EDIT_UNDO", false, fileActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Redo", null, null, "Redo.gif", "IDTT_EDIT_REDO", false, fileActionListener));
        this.m_fileToolBar = new DividerPanel(2);
        this.m_fileToolBar.setLayout(new GridLayout(1, 1, 0, 0));
        this.m_fileToolBar.add(GUIFactory.createButton("Edit Save", null, null, "Save.gif", "IDTT_SAVE_FILE", false, fileActionListener));
        this.m_mainToolBar = new JPanel();
        this.m_mainToolBar.setLayout(new GridLayout(1, 8, 0, 0));
        this.m_mainToolBar.add(GUIFactory.createButton("Panel", null, null, "InsertPanel.gif", "IDTT_INSERT_PANEL", true, fileActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Property Sheet", null, null, "InsertPropSheet.gif", "IDTT_INSERT_PROPERTYSHEET", true, fileActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Wizard", null, null, "InsertWizard.gif", "IDTT_INSERT_WIZARD", true, fileActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Deck Pane", null, null, "InsertDeckPane.gif", "IDTT_INSERT_DECKPANE", true, fileActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Split Pane", null, null, "InsertSplitPane.gif", "IDTT_INSERT_SPLITPANE", true, fileActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Tabbed Pane", null, null, "InsertTabbedPane.gif", "IDTT_INSERT_TABBEDPANE", true, fileActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Menu", null, null, "InsertMenu.gif", "IDTT_INSERT_MENU", true, fileActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Tool Menu", null, null, "InsertToolBar.gif", "IDTT_INSERT_TOOL_MENU", true, fileActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("String Table", null, null, "InsertStringTable.gif", "IDTT_INSERT_STRINGTABLE", true, fileActionListener));
        this.m_helpToolBar = new JPanel();
        this.m_helpToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_helpToolBar.add(GUIFactory.createButton("Preview", null, null, "Preview.gif", "IDTT_PREVIEW", true, fileActionListener));
        this.m_helpToolBar.add(GUIFactory.createButton("Help", null, null, "Help.gif", "IDTT_HELP", true, fileActionListener));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.m_fileToolBar);
        jPanel.add(this.m_editToolBar);
        jPanel.add(this.m_helpToolBar);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 0, 0));
        jPanel2.add(this.m_mainToolBar);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        if (!this.getBuilder().isTranslationMode()) {
            jPanel3.add((Component)jPanel2, "South");
        }
        jPanel3.add((Component)jPanel, "North");
        this.m_root = new DefaultMutableTreeNode(fileProperties);
        this.m_treeModel = new FixedDefaultTreeModel(this.m_root);
        this.m_tree = new JTree(this.m_treeModel);
        this.m_tree.setCellRenderer(new FileCellRenderer());
        this.m_tree.addTreeSelectionListener(new FileSelectionListener());
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.addMouseListener(new FileMouseListener());
        this.setDefaultCloseOperation(0);
        this.updateTitleBar(null);
        ((Frame)this).setIconImage(GUIFactory.getImage("File.gif", true).getImage());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel3, "North");
        JScrollPane jScrollPane = new JScrollPane(this.m_tree);
        this.getContentPane().add((Component)jScrollPane, "Center");
        Enumeration<TreeNode> enumeration = fileProperties.children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
            this.insertProperties(mutableProperties, false);
        }
        this.m_tree.expandPath(new TreePath(this.m_root));
        Dimension dimension = jPanel3.getPreferredSize();
        dimension.width += 10;
        if (dimension.width < 250) {
            dimension.width = 250;
        }
        dimension.height = 400;
        Dimension dimension2 = this.getPreferredSize();
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        ((Component)this).setSize(dimension);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.initContextMenus();
    }

    void initContextMenus() {
        this.m_contextMenu = new JPopupMenu();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Show Editor", null, "IDCM_FILE_EDIT", null, true, this.m_menuListener));
        this.m_contextMenu.addSeparator();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_FILE_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_FILE_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_FILE_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_FILE_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        this.m_contextMenu.addSeparator();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_FILE_PROPERTIES", null, true, this.m_menuListener));
        this.m_fileContextMenu = new JPopupMenu();
        this.m_fileContextMenu.add(GUIFactory.createMenuItem("Edit Save", null, "IDM_FILE_SAVE", null, false, KeyStroke.getKeyStroke(83, 2), this.m_menuListener));
        this.m_fileContextMenu.add(GUIFactory.createMenuItem("Edit Close", null, "IDM_FILE_CLOSE", null, true, this.m_menuListener));
        this.m_fileContextMenu.addSeparator();
        this.m_fileContextMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_FILE_PROPERTIES", null, true, this.m_menuListener));
    }

    JPopupMenu getContextMenu() {
        if (this.getSelectedProperties().getType() == 126) {
            this.m_fileContextMenu.getComponent(0).setEnabled(this.getPDMLDocument().isModified());
            return this.m_fileContextMenu;
        }
        this.m_contextMenu.getComponent(2).setEnabled(this.canCut());
        this.m_contextMenu.getComponent(3).setEnabled(this.canCopy());
        this.m_contextMenu.getComponent(4).setEnabled(this.canPaste());
        this.m_contextMenu.getComponent(5).setEnabled(this.canDelete());
        return this.m_contextMenu;
    }

    String getHelpName() {
        return "FileEditor";
    }

    public void stopEditing() {
    }

    public boolean canCut() {
        if (this.getBuilder().isTranslationMode()) {
            return false;
        }
        TreePath treePath = this.m_tree.getLeadSelectionPath();
        return treePath != null && treePath.getPathCount() == 3;
    }

    public boolean canCopy() {
        if (this.getBuilder().isTranslationMode()) {
            return false;
        }
        TreePath treePath = this.m_tree.getLeadSelectionPath();
        return treePath != null && treePath.getPathCount() == 3;
    }

    public boolean canPaste() {
        if (this.getBuilder().isTranslationMode()) {
            return false;
        }
        boolean bl = false;
        Transferable transferable = this.getBuilder().getClipboard().getContents(this);
        if (transferable != null && transferable instanceof MutableProperties) {
            MutableProperties mutableProperties = (MutableProperties)transferable;
            int n = mutableProperties.getType();
            boolean bl2 = bl = n == 1 || n == 120 || n == 121 || n == 60 || n == 61 || n == 62 || n == 51;
            if (n == 80) {
                boolean bl3 = bl = !this.m_hasStringTable;
            }
            if (n == 52 && mutableProperties.getProperty("Menu Item Type").equals("submenu")) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean canDelete() {
        if (this.getBuilder().isTranslationMode()) {
            return false;
        }
        TreePath treePath = this.m_tree.getLeadSelectionPath();
        return treePath != null && treePath.getPathCount() == 3;
    }

    public MutableProperties getSelectedProperties() {
        TreePath treePath = this.m_tree.getLeadSelectionPath();
        if (treePath != null && treePath.getPathCount() == 3) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            return (MutableProperties)defaultMutableTreeNode.getUserObject();
        }
        return this.getProperties();
    }

    public void cut() {
        if (!this.canCut()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        MutableProperties mutableProperties = this.getSelectedProperties();
        this.getBuilder().getClipboard().setContents(mutableProperties, mutableProperties);
        this.doRemove();
        this.getPDMLDocument().endEdit();
        this.getBuilder().updateBuilder();
    }

    public void copy() {
        if (!this.canCopy()) {
            return;
        }
        MutableProperties mutableProperties = this.getSelectedProperties();
        MutableProperties mutableProperties2 = mutableProperties.cloneNode(this.getPDMLDocument(), null);
        this.getBuilder().getClipboard().setContents(mutableProperties2, mutableProperties2);
        this.getBuilder().updateBuilder();
    }

    public void paste() {
        if (!this.canPaste()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        Transferable transferable = this.getBuilder().getClipboard().getContents(this);
        MutableProperties mutableProperties = (MutableProperties)transferable;
        if (mutableProperties.getType() != 52) {
            mutableProperties = ((MutableProperties)transferable).cloneNode(this.getPDMLDocument(), (FileProperties)this.getProperties());
            mutableProperties.setPDMLDocument(this.getPDMLDocument());
        } else {
            Object object;
            Enumeration<TreeNode> enumeration;
            MutableProperties mutableProperties2 = mutableProperties;
            mutableProperties = new MenuProperties(this.getPDMLDocument());
            try {
                enumeration = mutableProperties2.propertyNames();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    if (((String)object).equals("Name")) {
                        mutableProperties.setProperty("Name", ((FileProperties)this.getProperties()).generateUniqueName((String)mutableProperties2.getProperty("Name")));
                        continue;
                    }
                    if (!mutableProperties.hasProperty((String)object)) continue;
                    mutableProperties.setProperty((String)object, mutableProperties2.getProperty((String)object));
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            mutableProperties.setPDMLDocument(this.getPDMLDocument());
            enumeration = mutableProperties2.children();
            while (enumeration.hasMoreElements()) {
                object = (MutableProperties)enumeration.nextElement();
                mutableProperties.add(((MutableProperties)object).cloneNode(this.getPDMLDocument(), (MenuProperties)mutableProperties));
            }
        }
        this.getPDMLDocument().addNodeInOrder(mutableProperties);
        this.getPDMLDocument().endEdit();
        this.getBuilder().updateBuilder();
    }

    public void delete() {
        if (!this.canDelete()) {
            return;
        }
        MutableProperties mutableProperties = this.getSelectedProperties();
        Object[] objectArray = new Object[]{mutableProperties.getType() == 80 ? GUIFactory.getString("IDS_STRINGTABLE") : mutableProperties.getProperty("Name")};
        String string = MessageFormat.format(GUIFactory.getString("IDS_CONFIRM_DELETE"), objectArray);
        int n = JOptionPane.showConfirmDialog(this, string);
        if (n != 0) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        this.doRemove();
        this.getPDMLDocument().endEdit();
        this.getBuilder().updateBuilder();
    }

    void doRemove() {
        MutableProperties mutableProperties = this.getSelectedProperties();
        if (mutableProperties != null) {
            int n = this.m_tree.getMinSelectionRow();
            mutableProperties.removeFromParent();
            int n2 = this.m_tree.getRowCount();
            if (n2 > 0) {
                if (n >= n2) {
                    n = n2 - 1;
                }
                this.m_tree.setSelectionRow(n);
            }
        }
    }

    public void updateBuilder() {
        boolean bl;
        this.m_editToolBar.getComponent(0).setEnabled(this.canCut());
        this.m_editToolBar.getComponent(1).setEnabled(this.canCopy());
        this.m_editToolBar.getComponent(2).setEnabled(this.canPaste());
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = this.getPDMLDocument();
        this.m_fileToolBar.getComponent(0).setEnabled(xMLGUIBuilderDefinition.isModified());
        this.m_editToolBar.getComponent(3).setEnabled(xMLGUIBuilderDefinition.getUndoManager().canUndo());
        this.m_editToolBar.getComponent(4).setEnabled(xMLGUIBuilderDefinition.getUndoManager().canRedo());
        boolean bl2 = this.getBuilder().arePanesAvailable(true);
        this.m_mainToolBar.getComponent(1).setEnabled(bl2);
        this.m_mainToolBar.getComponent(2).setEnabled(bl2);
        boolean bl3 = this.getBuilder().arePanesAvailable(false);
        this.m_mainToolBar.getComponent(3).setEnabled(bl3);
        this.m_mainToolBar.getComponent(4).setEnabled(bl3);
        this.m_mainToolBar.getComponent(5).setEnabled(bl3);
        this.m_mainToolBar.getComponent(8).setEnabled(!this.m_hasStringTable);
        int n = this.getSelectedProperties().getType();
        boolean bl4 = bl = n != 126 && n != 80;
        if (bl && n != 1) {
            bl = this.getSelectedProperties().getChildCount() > 0;
        }
        this.m_helpToolBar.getComponent(0).setEnabled(bl);
    }

    public void updateTitleBar(String string) {
        if (string == null && (string = (String)this.getPDMLDocument().getPDMLRoot().getProperty("File Name")).equals("")) {
            string = ((FileProperties)this.getProperties()).getResourceName(true, true);
        }
        this.setTitle(string);
    }

    void insertProperties(MutableProperties mutableProperties, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        int n = mutableProperties.getType();
        if (n == 80) {
            this.m_hasStringTable = true;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getFolder(n);
        int n2 = 0;
        String string = (String)mutableProperties.getProperty("Name");
        Collator collator = Collator.getInstance();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode2.children();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            MutableProperties mutableProperties2 = (MutableProperties)defaultMutableTreeNode.getUserObject();
            String string2 = (String)mutableProperties2.getProperty("Name");
            if (collator.compare(string2, string) >= 0) break;
            ++n2;
        }
        defaultMutableTreeNode = new DefaultMutableTreeNode(mutableProperties);
        this.m_treeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, n2);
        this.m_nodes.put(mutableProperties, defaultMutableTreeNode);
        if (bl) {
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.m_tree.expandPath(treePath);
            this.m_tree.setSelectionPath(treePath);
        }
    }

    void removeProperties(MutableProperties mutableProperties) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (mutableProperties.getType() == 80) {
            this.m_hasStringTable = false;
        }
        if ((defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_nodes.get(mutableProperties)) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            this.m_treeModel.removeNodeFromParent(defaultMutableTreeNode);
            if (defaultMutableTreeNode2.getChildCount() == 0) {
                this.m_treeModel.removeNodeFromParent(defaultMutableTreeNode2);
            }
            this.m_nodes.remove(mutableProperties);
        }
    }

    DefaultMutableTreeNode getFolder(int n) {
        String string;
        DefaultMutableTreeNode defaultMutableTreeNode;
        String string2 = null;
        switch (n) {
            default: {
                return null;
            }
            case 1: {
                string2 = "IDS_PANEL_FOLDER";
                break;
            }
            case 120: {
                string2 = "IDS_PROPERTYSHEET_FOLDER";
                break;
            }
            case 121: {
                string2 = "IDS_WIZARD_FOLDER";
                break;
            }
            case 60: {
                string2 = "IDS_DECKPANE_FOLDER";
                break;
            }
            case 61: {
                string2 = "IDS_SPLITPANE_FOLDER";
                break;
            }
            case 62: {
                string2 = "IDS_TABBEDPANE_FOLDER";
                break;
            }
            case 51: {
                string2 = "IDS_MENU_FOLDER";
                break;
            }
            case 80: {
                string2 = "IDS_STRINGTABLE_FOLDER";
            }
        }
        Enumeration<TreeNode> enumeration = this.m_root.children();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            string = (String)defaultMutableTreeNode.getUserObject();
            if (string.equals(string2)) {
                return defaultMutableTreeNode;
            }
            defaultMutableTreeNode = null;
        }
        defaultMutableTreeNode = new DefaultMutableTreeNode(string2);
        boolean bl = false;
        int n2 = 0;
        Enumeration<TreeNode> enumeration2 = this.m_root.children();
        while (enumeration2.hasMoreElements()) {
            if (bl) break;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration2.nextElement();
            string = (String)defaultMutableTreeNode2.getUserObject();
            switch (n) {
                case 1: {
                    this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_root, 0);
                    bl = true;
                    break;
                }
                case 120: {
                    if (string.equals("IDS_PANEL_FOLDER")) {
                        this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_root, n2 + 1);
                        bl = true;
                        break;
                    }
                    this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_root, n2);
                    bl = true;
                    break;
                }
                case 121: {
                    if (string.equals("IDS_PROPERTYSHEET_FOLDER")) {
                        this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_root, n2 + 1);
                        bl = true;
                        break;
                    }
                    if (string.equals("IDS_PANEL_FOLDER")) break;
                    this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_root, n2);
                    bl = true;
                    break;
                }
                case 60: {
                    if (string.equals("IDS_WIZARD_FOLDER")) {
                        this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_root, n2 + 1);
                        bl = true;
                        break;
                    }
                    if (string.equals("IDS_PANEL_FOLDER") || string.equals("IDS_PROPERTYSHEET_FOLDER")) break;
                    this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_root, n2);
                    bl = true;
                    break;
                }
                case 61: {
                    if (string.equals("IDS_DECKPANE_FOLDER")) {
                        this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_root, n2 + 1);
                        bl = true;
                        break;
                    }
                    if (string.equals("IDS_PANEL_FOLDER") || string.equals("IDS_PROPERTYSHEET_FOLDER") || string.equals("IDS_WIZARD_FOLDER")) break;
                    this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_root, n2);
                    bl = true;
                    break;
                }
                case 62: {
                    if (string.equals("IDS_SPLITPANE_FOLDER")) {
                        this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_root, n2 + 1);
                        bl = true;
                        break;
                    }
                    if (string.equals("IDS_PANEL_FOLDER") || string.equals("IDS_PROPERTYSHEET_FOLDER") || string.equals("IDS_WIZARD_FOLDER") || string.equals("IDS_DECKPANE_FOLDER")) break;
                    this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_root, n2);
                    bl = true;
                    break;
                }
                case 51: {
                    if (string.equals("IDS_TABBEDPANE_FOLDER")) {
                        this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_root, n2 + 1);
                        bl = true;
                        break;
                    }
                    if (string.equals("IDS_PANEL_FOLDER") || string.equals("IDS_PROPERTYSHEET_FOLDER") || string.equals("IDS_WIZARD_FOLDER") || string.equals("IDS_DECKPANE_FOLDER") || string.equals("IDS_SPLITPANE_FOLDER")) break;
                    this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_root, n2);
                    bl = true;
                    break;
                }
                case 80: {
                    this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_root, this.m_root.getChildCount());
                    bl = true;
                }
            }
            ++n2;
        }
        if (!bl) {
            this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_root, this.m_root.getChildCount());
        }
        return defaultMutableTreeNode;
    }

    public void uninstallListeners() {
        this.getProperties().removePDMLNodeListener(this.m_pdmlNodeListener);
        this.getProperties().removeTreeModelListener(this.m_treeModelListener);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class FilePDMLNodeListener
    implements PDMLNodeListener {
        FilePDMLNodeListener() {
        }

        public void PDMLNodeChanged(PDMLNodeEvent pDMLNodeEvent) {
        }

        public void PDMLNodeInserted(PDMLNodeEvent pDMLNodeEvent) {
        }

        public void PDMLNodeRemoved(PDMLNodeEvent pDMLNodeEvent) {
        }
    }

    class FileActionListener
    implements ActionListener {
        FileActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileBuilder.this.setCursor(Cursor.getPredefinedCursor(3));
            String string = actionEvent.getActionCommand();
            if (string.equals("Panel")) {
                Cloneable cloneable;
                FileBuilder.this.getPDMLDocument().beginEdit();
                Rectangle rectangle = null;
                PanelProperties panelProperties = new PanelProperties();
                String string2 = GUIFactory.getString("IDE_PANEL");
                try {
                    panelProperties.setProperty("Name", ((FileProperties)FileBuilder.this.getProperties()).generateName(1));
                    cloneable = (Dimension)panelProperties.getProperty("Size");
                    rectangle = new Rectangle(0, 0, cloneable.width, cloneable.height);
                    Rectangle rectangle2 = new Rectangle(0, 0, cloneable.width, cloneable.height);
                    rectangle2 = FileBuilder.this.getPDMLDocument().scaleRect(rectangle2);
                    panelProperties.setProperty("Size", rectangle2.getSize());
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                panelProperties.setPDMLDocument(FileBuilder.this.getPDMLDocument());
                FileBuilder.this.getPDMLDocument().addNodeInOrder(panelProperties);
                try {
                    if (FileBuilder.this.getBuilder().includePanelDefaultButtons()) {
                        cloneable = FileBuilder.this.getBuilder().getPanelMargins();
                        rectangle = FileBuilder.this.getPDMLDocument().scaleRect(rectangle);
                        Rectangle rectangle3 = new Rectangle(0, 0, 80, 25);
                        rectangle3 = FileBuilder.this.getPDMLDocument().scaleRect(rectangle3);
                        Rectangle rectangle4 = new Rectangle(rectangle.width - ((Insets)cloneable).right - rectangle3.width, rectangle.height - ((Insets)cloneable).bottom - rectangle3.height, rectangle3.width, rectangle3.height);
                        Rectangle rectangle5 = new Rectangle(rectangle4.x - rectangle3.width - 5, rectangle4.y, rectangle3.width, rectangle3.height);
                        Rectangle rectangle6 = new Rectangle(rectangle5.x - rectangle3.width - 5, rectangle4.y, rectangle3.width, rectangle3.height);
                        ButtonProperties buttonProperties = new ButtonProperties();
                        buttonProperties.setProperty("Name", panelProperties.generateName(6));
                        buttonProperties.setProperty("Title", GUIFactory.getString("IDS_OK"));
                        buttonProperties.setProperty("Action", "COMMIT");
                        buttonProperties.setProperty("Bounds", rectangle6);
                        buttonProperties.setPDMLDocument(FileBuilder.this.getPDMLDocument());
                        panelProperties.add(buttonProperties);
                        ButtonProperties buttonProperties2 = new ButtonProperties();
                        buttonProperties2.setProperty("Name", panelProperties.generateName(6));
                        buttonProperties2.setProperty("Title", GUIFactory.getString("IDS_CANCEL"));
                        buttonProperties2.setProperty("Action", "CANCEL");
                        buttonProperties2.setProperty("Bounds", rectangle5);
                        buttonProperties2.setPDMLDocument(FileBuilder.this.getPDMLDocument());
                        panelProperties.add(buttonProperties2);
                        ButtonProperties buttonProperties3 = new ButtonProperties();
                        buttonProperties3.setProperty("Name", panelProperties.generateName(6));
                        buttonProperties3.setProperty("Title", GUIFactory.getString("IDS_HELP"));
                        buttonProperties3.setProperty("Action", "HELP");
                        buttonProperties3.setProperty("Bounds", rectangle4);
                        buttonProperties3.setPDMLDocument(FileBuilder.this.getPDMLDocument());
                        panelProperties.add(buttonProperties3);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                FileBuilder.this.getPDMLDocument().endEdit();
                FileBuilder.this.getBuilder().showEditor(panelProperties);
                FileBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Property Sheet")) {
                FileBuilder.this.getPDMLDocument().beginEdit();
                PropertySheetProperties propertySheetProperties = new PropertySheetProperties();
                String string3 = GUIFactory.getString("IDE_PROPERTYSHEET");
                try {
                    propertySheetProperties.setProperty("Name", ((FileProperties)FileBuilder.this.getProperties()).generateName(120));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                propertySheetProperties.setPDMLDocument(FileBuilder.this.getPDMLDocument());
                FileBuilder.this.getPDMLDocument().addNodeInOrder(propertySheetProperties);
                FileBuilder.this.getPDMLDocument().endEdit();
                FileBuilder.this.getBuilder().showEditor(propertySheetProperties);
                FileBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Wizard")) {
                FileBuilder.this.getPDMLDocument().beginEdit();
                WizardProperties wizardProperties = new WizardProperties();
                String string4 = GUIFactory.getString("IDE_WIZARD");
                try {
                    wizardProperties.setProperty("Name", ((FileProperties)FileBuilder.this.getProperties()).generateName(121));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                wizardProperties.setPDMLDocument(FileBuilder.this.getPDMLDocument());
                FileBuilder.this.getPDMLDocument().addNodeInOrder(wizardProperties);
                FileBuilder.this.getPDMLDocument().endEdit();
                FileBuilder.this.getBuilder().showEditor(wizardProperties);
                FileBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Deck Pane")) {
                FileBuilder.this.getPDMLDocument().beginEdit();
                DeckPaneProperties deckPaneProperties = new DeckPaneProperties();
                String string5 = GUIFactory.getString("IDE_DECKPANE");
                try {
                    deckPaneProperties.setProperty("Name", ((FileProperties)FileBuilder.this.getProperties()).generateName(60));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                deckPaneProperties.setPDMLDocument(FileBuilder.this.getPDMLDocument());
                FileBuilder.this.getPDMLDocument().addNodeInOrder(deckPaneProperties);
                FileBuilder.this.getPDMLDocument().endEdit();
                FileBuilder.this.getBuilder().showEditor(deckPaneProperties);
                FileBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Split Pane")) {
                FileBuilder.this.getPDMLDocument().beginEdit();
                SplitPaneProperties splitPaneProperties = new SplitPaneProperties();
                String string6 = GUIFactory.getString("IDE_SPLITPANE");
                try {
                    splitPaneProperties.setProperty("Name", ((FileProperties)FileBuilder.this.getProperties()).generateName(61));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                splitPaneProperties.setPDMLDocument(FileBuilder.this.getPDMLDocument());
                FileBuilder.this.getPDMLDocument().addNodeInOrder(splitPaneProperties);
                FileBuilder.this.getPDMLDocument().endEdit();
                FileBuilder.this.getBuilder().showEditor(splitPaneProperties);
                FileBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Tabbed Pane")) {
                FileBuilder.this.getPDMLDocument().beginEdit();
                TabbedPaneProperties tabbedPaneProperties = new TabbedPaneProperties();
                String string7 = GUIFactory.getString("IDE_TABBEDPANE");
                try {
                    tabbedPaneProperties.setProperty("Name", ((FileProperties)FileBuilder.this.getProperties()).generateName(62));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                tabbedPaneProperties.setPDMLDocument(FileBuilder.this.getPDMLDocument());
                FileBuilder.this.getPDMLDocument().addNodeInOrder(tabbedPaneProperties);
                FileBuilder.this.getPDMLDocument().endEdit();
                FileBuilder.this.getBuilder().showEditor(tabbedPaneProperties);
                FileBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Menu") || string.equals("Tool Menu")) {
                FileBuilder.this.getPDMLDocument().beginEdit();
                MenuProperties menuProperties = new MenuProperties();
                try {
                    if (string.equals("Menu")) {
                        menuProperties.setProperty("Name", ((FileProperties)FileBuilder.this.getProperties()).generateName(51));
                    } else {
                        menuProperties.setProperty("Name", ((FileProperties)FileBuilder.this.getProperties()).generateName(55));
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                try {
                    menuProperties.setProperty("Title", GUIFactory.getString("IDS_DEFAULT_LABEL_MENU"));
                    if (string.equals("Tool Menu")) {
                        menuProperties.setProperty("Type", "toolbar");
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                menuProperties.setPDMLDocument(FileBuilder.this.getPDMLDocument());
                FileBuilder.this.getPDMLDocument().addNodeInOrder(menuProperties);
                FileBuilder.this.getPDMLDocument().endEdit();
                FileBuilder.this.getBuilder().showEditor(menuProperties);
                FileBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("String Table")) {
                FileBuilder.this.getPDMLDocument().beginEdit();
                StringTableProperties stringTableProperties = new StringTableProperties(FileBuilder.this.getPDMLDocument());
                FileBuilder.this.getPDMLDocument().addNodeInOrder(stringTableProperties);
                FileBuilder.this.getPDMLDocument().endEdit();
                FileBuilder.this.getBuilder().showEditor(stringTableProperties);
                FileBuilder.this.getBuilder().updateBuilder();
            } else if (string.startsWith("Edit")) {
                if ((string = string.substring(5)).equals("Cut")) {
                    FileBuilder.this.cut();
                } else if (string.equals("Copy")) {
                    FileBuilder.this.copy();
                } else if (string.equals("Paste")) {
                    FileBuilder.this.paste();
                } else if (string.equals("Delete")) {
                    FileBuilder.this.delete();
                } else if (string.equals("Undo")) {
                    FileBuilder.this.getBuilder().doUndo();
                } else if (string.equals("Redo")) {
                    FileBuilder.this.getBuilder().doRedo();
                } else if (string.equals("Save")) {
                    FileBuilder.this.getBuilder().doSave(false);
                } else if (string.equals("Close")) {
                    FileBuilder.this.getBuilder().doClose();
                }
            } else if (string.equals("Show Editor")) {
                FileBuilder.this.setCursor(Cursor.getPredefinedCursor(3));
                FileBuilder.this.getBuilder().showEditor(FileBuilder.this.getSelectedProperties());
                FileBuilder.this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (string.equals("Show Properties")) {
                FileBuilder.this.getBuilder().doShowProperties();
            } else if (string.equals("Preview")) {
                MutableProperties mutableProperties = FileBuilder.this.getSelectedProperties();
                FileBuilder.this.getBuilder().doPreview(mutableProperties);
            } else if (string.equals("Help")) {
                FileBuilder.this.displayHelp();
            }
            FileBuilder.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    class FileMouseListener
    extends MouseAdapter {
        FileMouseListener() {
        }

        void showContextMenu(Point point) {
            MutableProperties mutableProperties;
            DefaultMutableTreeNode defaultMutableTreeNode;
            MutableProperties mutableProperties2 = FileBuilder.this.getSelectedProperties();
            TreePath treePath = FileBuilder.this.m_tree.getPathForLocation(point.x, point.y);
            if (treePath != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject() instanceof MutableProperties && mutableProperties2.equals(mutableProperties = (MutableProperties)defaultMutableTreeNode.getUserObject())) {
                JPopupMenu jPopupMenu = FileBuilder.this.getContextMenu();
                if (FileBuilder.this.getBuilder().isTranslationMode() && mutableProperties2.getType() != 126) {
                    jPopupMenu.getComponent(0).setEnabled(mutableProperties2.getType() == 1);
                }
                jPopupMenu.show(FileBuilder.this.m_tree, point.x, point.y);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent.getPoint());
                return;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent.getPoint());
                return;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            MutableProperties mutableProperties;
            DefaultMutableTreeNode defaultMutableTreeNode;
            MutableProperties mutableProperties2;
            TreePath treePath;
            if (mouseEvent.getClickCount() == 2 && (treePath = FileBuilder.this.m_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && treePath.getPathCount() > 2 && (mutableProperties2 = (MutableProperties)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()).equals(mutableProperties = FileBuilder.this.getSelectedProperties())) {
                FileBuilder.this.getBuilder().showEditor(mutableProperties2);
            }
        }
    }

    class FileCellRenderer
    extends DefaultTreeCellRenderer {
        FileCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof FileProperties) {
                FileProperties fileProperties = (FileProperties)object2;
                jLabel.setIcon(GUIFactory.getImage("File.gif", true));
                String string = fileProperties.getResourceName(true, true);
                jLabel.setText(string);
            } else if (object2 instanceof MutableProperties) {
                MutableProperties mutableProperties = (MutableProperties)object2;
                String string = null;
                switch (mutableProperties.getType()) {
                    case 1: {
                        string = "Panel.gif";
                        break;
                    }
                    case 120: {
                        string = "Propsheet.gif";
                        break;
                    }
                    case 121: {
                        string = "Wizard.gif";
                        break;
                    }
                    case 60: {
                        string = "DeckPane.gif";
                        break;
                    }
                    case 61: {
                        string = "SplitPane.gif";
                        break;
                    }
                    case 62: {
                        string = "TabbedPane.gif";
                        break;
                    }
                    case 51: {
                        if (mutableProperties.getProperty("Type").toString().equals("menu")) {
                            string = "Menu.gif";
                            break;
                        }
                        string = "ToolBar.gif";
                        break;
                    }
                    case 80: {
                        string = "Stringtable.gif";
                    }
                }
                if (string != null) {
                    jLabel.setIcon(GUIFactory.getImage(string, true));
                }
                if (mutableProperties.getType() == 80) {
                    jLabel.setText(GUIFactory.getString("IDS_STRINGTABLE"));
                } else {
                    jLabel.setText((String)mutableProperties.getProperty("Name"));
                }
            } else if (object2 instanceof String) {
                String string = (String)object2;
                jLabel.setText(GUIFactory.getString(string));
            }
            return jLabel;
        }
    }

    class FileTreeModelListener
    implements TreeModelListener {
        FileTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            if (treePath.getLastPathComponent().equals(FileBuilder.this.getProperties())) {
                Object[] objectArray = treeModelEvent.getChildren();
                if (objectArray != null) {
                    int n = 0;
                    while (n < objectArray.length) {
                        MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)FileBuilder.this.m_nodes.get(mutableProperties);
                        if (defaultMutableTreeNode != null) {
                            FileBuilder.this.m_treeModel.nodeChanged(defaultMutableTreeNode);
                        }
                        ++n;
                    }
                } else {
                    FileBuilder.this.m_treeModel.nodeChanged(FileBuilder.this.m_root);
                }
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            Object[] objectArray;
            TreePath treePath = treeModelEvent.getTreePath();
            if (treePath.getLastPathComponent().equals(FileBuilder.this.getProperties()) && (objectArray = treeModelEvent.getChildren()) != null) {
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                    FileBuilder.this.insertProperties(mutableProperties, true);
                    ++n;
                }
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            Object[] objectArray;
            TreePath treePath = treeModelEvent.getTreePath();
            if (treePath.getLastPathComponent().equals(FileBuilder.this.getProperties()) && (objectArray = treeModelEvent.getChildren()) != null) {
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                    FileBuilder.this.removeProperties(mutableProperties);
                    ++n;
                }
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    class FileSelectionListener
    implements TreeSelectionListener {
        FileSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            FileBuilder.this.fireSelectionChangedEvent();
            FileBuilder.this.m_builder.m_propertyDialog.requestFocus();
            FileBuilder.this.requestFocus();
        }
    }
}

