/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class EventHandlerParser {
    private BufferedReader m_input = null;
    private String m_baseClass = "Object";
    private String m_className = null;
    private Vector m_interfaces = new Vector();
    private Vector m_headers = new Vector();
    private Vector m_trailers = new Vector();
    private Vector m_body = new Vector();
    private Hashtable m_interfaceMethods = new Hashtable();

    public EventHandlerParser(String string) throws FileNotFoundException, IOException {
        this(new File(string));
    }

    public EventHandlerParser(File file) throws FileNotFoundException, IOException {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        this.m_input = new BufferedReader(new FileReader(file));
        this.processDocument();
        this.m_input.close();
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getBaseClassName() {
        return this.m_baseClass;
    }

    public Vector getInterfaces() {
        return this.m_interfaces;
    }

    public Vector getHeaders() {
        return this.m_headers;
    }

    public Vector getTrailers() {
        return this.m_trailers;
    }

    public Vector getBody() {
        return this.m_body;
    }

    public String getInterfaceMethodDeclaration(String string) {
        Enumeration enumeration = this.m_interfaceMethods.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            return string2;
        }
        return null;
    }

    public Enumeration getInterfaceMethodDeclarations() {
        return this.m_interfaceMethods.keys();
    }

    public Vector getInterfaceMethodBody(String string) {
        return (Vector)this.m_interfaceMethods.get(string);
    }

    public boolean hasImport(String string) {
        int n = this.m_headers.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)this.m_headers.elementAt(n2);
            if (string2.startsWith(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void processDocument() throws IOException {
        boolean bl = true;
        String string = null;
        while ((string = this.m_input.readLine()) != null) {
            String string2 = string.trim();
            if (string2.startsWith("public class ")) {
                Object object;
                while (!string2.endsWith("{")) {
                    object = this.m_input.readLine();
                    if (object == null) break;
                    string2 = ((String)object).trim();
                    string = string + " " + (String)object;
                }
                object = new StringTokenizer(string);
                block2: while (((StringTokenizer)object).hasMoreTokens()) {
                    String string3 = ((StringTokenizer)object).nextToken();
                    if (string3.equals("class") && ((StringTokenizer)object).hasMoreTokens()) {
                        this.m_className = ((StringTokenizer)object).nextToken();
                        continue;
                    }
                    if (string3.equals("extends") && ((StringTokenizer)object).hasMoreTokens()) {
                        this.m_baseClass = ((StringTokenizer)object).nextToken();
                        continue;
                    }
                    if (!string3.equals("implements")) continue;
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        string3 = ((StringTokenizer)object).nextToken();
                        if (string3.equals("{")) continue block2;
                        if (string3.endsWith(",") || string3.endsWith("{")) {
                            string3 = string3.substring(0, string3.lastIndexOf(","));
                        }
                        this.m_interfaces.addElement(string3);
                    }
                }
                this.processClass();
                bl = false;
            } else if (bl) {
                this.m_headers.addElement(string);
            } else {
                this.m_trailers.addElement(string);
            }
            if (string != null) continue;
        }
    }

    private void processClass() throws IOException {
        int n = 1;
        String string = "public " + this.m_className + "(";
        string = string + (this.m_baseClass.equals("ActionHandler") ? "MenuManager" : "PanelManager");
        String string2 = null;
        while ((string2 = this.m_input.readLine()) != null) {
            if (string2.indexOf(123) > -1) {
                ++n;
            }
            if (string2.indexOf(125) > -1) {
                --n;
            }
            String string3 = string2.trim();
            if (n == 0) break;
            boolean bl = false;
            if (string3.startsWith("public void actionPerformed(") || string3.startsWith("public void itemDoubleClicked(") || string3.startsWith("public void stateChanged(") || string3.startsWith("public void itemStateChanged(") || string3.startsWith(string)) {
                String string4 = string3.substring(0, string3.indexOf(41) + 1);
                while (!string3.endsWith("{")) {
                    string2 = string2 + " " + this.m_input.readLine();
                    string3 = string2.trim();
                }
                this.m_interfaceMethods.put(string4, this.saveMethodBody());
                bl = true;
            }
            if (!bl) {
                this.m_body.addElement(string2);
            }
            if (string2 != null) continue;
        }
    }

    private Vector saveMethodBody() throws IOException {
        int n = 1;
        Vector<String> vector = new Vector<String>();
        String string = null;
        while ((string = this.m_input.readLine()) != null) {
            if (string.indexOf(123) > -1) {
                ++n;
            }
            if (string.indexOf(125) > -1) {
                --n;
            }
            String string2 = string.trim();
            if (n == 0) break;
            vector.addElement(string);
            if (string != null) continue;
        }
        return vector;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

