/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.tools.BuilderFrame;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.ToolsFileChooser;
import com.ibm.as400.ui.tools.ToolsFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

class BrowseCellEditor
extends JPanel
implements TableCellEditor {
    static final int IMAGE_BROWSE = 0;
    static final int CLASS_BROWSE = 1;
    static final int TEXT_BROWSE = 2;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    JTextField m_textField;
    JButton m_browseButton;
    BuilderFrame m_parent;
    int m_browseType = 0;
    String m_fileName;
    JTextField m_packageField;
    JDialog m_packageDialog;
    String m_text;
    JTextArea m_textArea;
    JDialog m_textDialog;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;

    BrowseCellEditor(BuilderFrame builderFrame) {
        this(builderFrame, 0);
    }

    BrowseCellEditor(BuilderFrame builderFrame, boolean bl) {
        this(builderFrame, bl ? 1 : 0);
    }

    BrowseCellEditor(BuilderFrame builderFrame, int n) {
        this.m_browseType = n;
        this.m_parent = builderFrame;
        this.m_textField = new JTextField();
        this.m_textField.setBorder(null);
        this.m_textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowseCellEditor.this.stopCellEditing();
            }
        });
        this.m_browseButton = new JButton(GUIFactory.getImage("Browse.gif", true));
        this.m_browseButton.setToolTipText(GUIFactory.getString("IDS_BROWSE_TOOLTIP"));
        this.m_browseButton.setFocusPainted(false);
        this.m_browseButton.setBorder(new BevelBorder(0));
        this.m_browseButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowseCellEditor.this.doBrowse();
            }
        });
        this.setBorder(new LineBorder(Color.black));
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_textField, "Center");
        this.add((Component)this.m_browseButton, "East");
    }

    void doBrowse() {
        if (this.m_browseType == 2) {
            this.doTextDialog();
            if (this.m_text != null) {
                this.m_textField.setText(this.m_text);
                this.stopCellEditing();
            }
        } else {
            final boolean bl = this.m_browseType == 1;
            ToolsFileChooser toolsFileChooser = new ToolsFileChooser(this.m_parent.getBuilder().getLastDirectory());
            String[] stringArray = new String[]{".class"};
            String[] stringArray2 = new String[]{".gif", ".jpg"};
            String string = bl ? GUIFactory.getString("IDS_FILE_FILTER_CLASS") : GUIFactory.getString("IDS_FILE_FILTER_IMAGE");
            ToolsFileFilter toolsFileFilter = new ToolsFileFilter(bl ? stringArray : stringArray2, string){

                public boolean accept(File file) {
                    if (!super.accept(file)) {
                        return false;
                    }
                    if (bl) {
                        return file.getPath().toLowerCase().indexOf(36) == -1;
                    }
                    return true;
                }
            };
            toolsFileChooser.addChoosableFileFilter(toolsFileFilter);
            toolsFileChooser.setFileFilter(toolsFileFilter);
            toolsFileChooser.setDialogTitle(GUIFactory.getString("IDS_BROWSE_TITLEBAR"));
            toolsFileChooser.setMultiSelectionEnabled(false);
            int n = toolsFileChooser.showDialog(this, GUIFactory.getString("IDS_BROWSE_SELECT"));
            if (n == 0) {
                this.m_parent.getBuilder().setLastDirectory(toolsFileChooser.getCurrentDirectory().getPath());
                String string2 = toolsFileChooser.getSelectedFile().getPath().replace('\\', '/');
                int n2 = string2.indexOf(":/");
                if (n2 > -1) {
                    string2 = string2.substring(3);
                }
                if (string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
                if (this.m_browseType == 1 && (n2 = (string2 = string2.replace('/', '.')).indexOf(".class")) > -1) {
                    string2 = string2.substring(0, n2);
                }
                this.doPackageDialog(string2);
                if (this.m_fileName != null) {
                    this.m_textField.setText(this.m_fileName);
                    this.stopCellEditing();
                }
            }
        }
    }

    void doPackageDialog(String string) {
        JDialog jDialog;
        JTextField jTextField;
        this.m_fileName = null;
        int n = 0;
        n = this.m_browseType == 1 ? string.lastIndexOf(46) : string.lastIndexOf(47);
        JLabel jLabel = new JLabel(GUIFactory.getString("IDS_BROWSE_PACKAGE"));
        this.m_packageField = jTextField = new JTextField(string, 40);
        Dimension dimension = jTextField.getPreferredSize();
        dimension.height += 6;
        jTextField.setPreferredSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 5));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jTextField, "Center");
        BrowsePackageActionListener browsePackageActionListener = new BrowsePackageActionListener();
        Dimension dimension2 = new Dimension(80, 25);
        JButton jButton = new JButton(GUIFactory.getString("IDS_OK"));
        jButton.setActionCommand("OK");
        jButton.addActionListener(browsePackageActionListener);
        JButton jButton2 = new JButton(GUIFactory.getString("IDS_CANCEL"));
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(browsePackageActionListener);
        JButton jButton3 = new JButton(GUIFactory.getString("IDS_HELP"));
        jButton3.setActionCommand("Help");
        jButton3.addActionListener(browsePackageActionListener);
        dimension = jButton.getPreferredSize();
        if (dimension.width > dimension2.width) {
            dimension2.width = dimension.width;
        }
        if (dimension.height > dimension2.height) {
            dimension2.height = dimension.height;
        }
        dimension = jButton2.getPreferredSize();
        if (dimension.width > dimension2.width) {
            dimension2.width = dimension.width;
        }
        if (dimension.height > dimension2.height) {
            dimension2.height = dimension.height;
        }
        dimension = jButton3.getPreferredSize();
        if (dimension.width > dimension2.width) {
            dimension2.width = dimension.width;
        }
        if (dimension.height > dimension2.height) {
            dimension2.height = dimension.height;
        }
        jButton.setPreferredSize(dimension2);
        jButton2.setPreferredSize(dimension2);
        jButton3.setPreferredSize(dimension2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3, 5, 0));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2, 0, 0));
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 10));
        jPanel4.add((Component)jPanel, "Center");
        jPanel4.add((Component)jPanel3, "South");
        jPanel4.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.m_packageDialog = jDialog = new JDialog(this.m_parent, GUIFactory.getString("IDS_BROWSE_PACKAGE_TITLEBAR"), true);
        jDialog.setDefaultCloseOperation(2);
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)jPanel4, "Center");
        Point point = this.m_parent.getLocation();
        point.x += 25;
        point.y += 25;
        ((Component)jDialog).setLocation(point);
        jDialog.pack();
        jTextField.requestFocus();
        jTextField.setSelectionStart(0);
        jTextField.setSelectionEnd(n + 1);
        jDialog.addKeyListener(new BrowsePackageKeyListener());
        jDialog.show();
    }

    void doTextDialog() {
        JDialog jDialog;
        String string = this.m_parent.getProperties().getProperty("Title").toString();
        this.m_textArea = new JTextArea(string, 4, 40);
        this.m_textArea.setFont(this.m_textField.getFont());
        JScrollPane jScrollPane = new JScrollPane(this.m_textArea);
        jScrollPane.setBorder(new BevelBorder(1));
        BrowseTextActionListener browseTextActionListener = new BrowseTextActionListener();
        Dimension dimension = new Dimension(80, 25);
        JButton jButton = new JButton(GUIFactory.getString("IDS_OK"));
        jButton.setActionCommand("OK");
        jButton.addActionListener(browseTextActionListener);
        JButton jButton2 = new JButton(GUIFactory.getString("IDS_CANCEL"));
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(browseTextActionListener);
        JButton jButton3 = new JButton(GUIFactory.getString("IDS_HELP"));
        jButton3.setActionCommand("Help");
        jButton3.addActionListener(browseTextActionListener);
        Dimension dimension2 = jButton.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        dimension2 = jButton2.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        dimension2 = jButton3.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        jButton.setPreferredSize(dimension);
        jButton2.setPreferredSize(dimension);
        jButton3.setPreferredSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3, 5, 0));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2, 0, 0));
        jPanel2.add(jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 10));
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel3.add((Component)jPanel2, "South");
        jPanel3.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.m_textDialog = jDialog = new JDialog(this.m_parent, GUIFactory.getString("IDS_BROWSE_TEXT_TITLEBAR"), true);
        jDialog.setDefaultCloseOperation(2);
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)jPanel3, "Center");
        Point point = this.m_parent.getLocation();
        point.x += 25;
        point.y += 25;
        ((Component)jDialog).setLocation(point);
        jDialog.pack();
        this.m_textArea.requestFocus();
        this.m_textArea.selectAll();
        jDialog.addKeyListener(new BrowsePackageKeyListener());
        jDialog.show();
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object != null) {
            this.m_textField.setText(object.toString());
        } else {
            this.m_textField.setText("");
        }
        this.m_textField.requestFocus();
        return this;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        this.m_textField.requestFocus();
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public Object getCellEditorValue() {
        return this.m_textField.getText();
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = BrowseCellEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = BrowseCellEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, cellEditorListener);
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$CellEditorListener == null ? BrowseCellEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n + 1]).editingStopped(this.changeEvent);
            }
            n -= 2;
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$CellEditorListener == null ? BrowseCellEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n + 1]).editingCanceled(this.changeEvent);
            }
            n -= 2;
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class BrowsePackageKeyListener
    extends KeyAdapter {
        BrowsePackageKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 112) {
                if (BrowseCellEditor.this.m_browseType == 2) {
                    BrowseCellEditor.this.m_parent.getBuilder().displayHelp("EditTextDialog", BrowseCellEditor.this.m_textDialog);
                } else {
                    BrowseCellEditor.this.m_parent.getBuilder().displayHelp("EditPackageDialog", BrowseCellEditor.this.m_packageDialog);
                }
            }
        }
    }

    class BrowseTextActionListener
    implements ActionListener {
        BrowseTextActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                if (BrowseCellEditor.this.m_textArea != null) {
                    BrowseCellEditor.this.m_text = BrowseCellEditor.this.m_textArea.getText();
                }
                if (BrowseCellEditor.this.m_textDialog != null) {
                    BrowseCellEditor.this.m_textDialog.dispose();
                }
            } else if (string.equals("Cancel")) {
                if (BrowseCellEditor.this.m_textDialog != null) {
                    BrowseCellEditor.this.m_textDialog.dispose();
                }
            } else if (string.equals("Help")) {
                BrowseCellEditor.this.m_parent.getBuilder().displayHelp("EditTextDialog", BrowseCellEditor.this.m_textDialog);
            }
        }
    }

    class BrowsePackageActionListener
    implements ActionListener {
        BrowsePackageActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                if (BrowseCellEditor.this.m_packageField != null) {
                    BrowseCellEditor.this.m_fileName = BrowseCellEditor.this.m_packageField.getText();
                }
                if (BrowseCellEditor.this.m_packageDialog != null) {
                    BrowseCellEditor.this.m_packageDialog.dispose();
                }
            } else if (string.equals("Cancel")) {
                if (BrowseCellEditor.this.m_packageDialog != null) {
                    BrowseCellEditor.this.m_packageDialog.dispose();
                }
            } else if (string.equals("Help")) {
                BrowseCellEditor.this.m_parent.getBuilder().displayHelp("EditPackageDialog", BrowseCellEditor.this.m_packageDialog);
            }
        }
    }
}

