/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.packet;

import com.ibm.iseries.debug.BreakpointDescriptor;
import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.ModuleDescriptor;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.dialog.PickFromTableDialog;
import com.ibm.iseries.debug.manager.BreakpointGroupManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.request.LnBrkRequest;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.DebugDesktop;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.unix.packet.UnixPacket;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;

public class UnixResolveMethodPacket
extends UnixPacket
implements DebugConstants {
    private static final int GOTO = 1;
    private static final int BRKPT = 2;
    private static final int GOTO_FROM_VIEWID = 3;
    private int m_action;
    private String m_origMethod;
    private String[] m_methods;
    private BreakpointDescriptor[] m_descriptors;
    private ISeriesMessage m_msgObj;

    public UnixResolveMethodPacket() {
        super(3011);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_origMethod = null;
        this.m_methods = null;
        this.m_descriptors = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        BreakpointGroupManager breakpointGroupManager = (BreakpointGroupManager)this.m_ctxt.getManager("brkgrpmgr");
        int n2 = breakpointGroupManager.getCurrentGroupId();
        this.m_action = commLink.readInt();
        this.m_origMethod = commLink.readString();
        int n3 = commLink.readInt();
        this.m_methods = new String[n3];
        this.m_descriptors = new BreakpointDescriptor[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.m_methods[n4] = commLink.readString();
            this.m_descriptors[n4] = new BreakpointDescriptor();
            this.m_descriptors[n4].read(commLink);
            this.m_descriptors[n4].setGroupId(n2);
            ++n4;
        }
        int n5 = commLink.readInt();
        if (n5 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        this.m_ctxt.retractClock();
        if (this.m_msgObj == null) {
            switch (this.m_action) {
                case 1: 
                case 3: {
                    this.gotoMethod();
                    break;
                }
                case 2: {
                    this.addMethodBrk();
                }
            }
        } else {
            this.displayMessage(this.m_msgObj);
        }
        this.cleanUp();
    }

    private void gotoMethod() {
        if (this.m_descriptors.length > 1) {
            Object object;
            PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
            String string = MRI.get("DBG_GOTO_METHOD");
            String string2 = MRI.get("DBG_SELECT_METHOD_LABEL");
            String[][] stringArray = new String[this.m_descriptors.length + 1][4];
            stringArray[0][0] = MRI.get("DBG_METHOD");
            stringArray[0][1] = MRI.get("DBG_MODULE");
            stringArray[0][2] = MRI.get("DBG_LINE");
            stringArray[0][3] = MRI.get("DBG_PROGRAM");
            int n = 0;
            while (n < this.m_descriptors.length) {
                object = pgmManager.getProgram(this.m_descriptors[n].getViewId());
                ModuleDescriptor moduleDescriptor = pgmManager.getModule(this.m_descriptors[n].getViewId());
                stringArray[n + 1][0] = this.m_methods[n];
                stringArray[n + 1][1] = moduleDescriptor.getModuleName();
                stringArray[n + 1][2] = String.valueOf(this.m_descriptors[n].getLineNum());
                stringArray[n + 1][3] = ((PgmDescriptor)object).getPgmPath();
                ++n;
            }
            object = new PickFromTableDialog(this.m_ctxt.getJFrame(), string, string2, MRI.get("DBG_OK"), null, stringArray, 0);
            ((PickFromTableDialog)object).setSingleSelect();
            ((Dialog)object).display(this.m_ctxt);
            if (!((Dialog)object).wasCanceled()) {
                int n2 = ((PickFromTableDialog)object).getSelectedIndex();
                this.gotoSrc(this.m_descriptors[n2].getViewId(), this.m_descriptors[n2].getLineNum());
            }
        } else if (this.m_descriptors.length > 0) {
            this.gotoSrc(this.m_descriptors[0].getViewId(), this.m_descriptors[0].getLineNum());
        }
    }

    private void gotoSrc(String string, int n) {
        SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
        DebugDesktop debugDesktop = this.m_ctxt.getDesktop();
        DebugSource debugSource = debugDesktop.getSource(string);
        if (debugSource == null) {
            sourceViewManager.requestSourceViewLineNum(string, n);
        } else if (n > 0 && !debugSource.containsLineNum(n)) {
            sourceViewManager.requestSourceViewLineNum(string, n);
        } else {
            debugDesktop.activateSource(debugSource, n);
            debugSource.viewRequestFocus();
        }
    }

    private void addMethodBrk() {
        TabPanel tabPanel = this.m_ctxt.getPanel("breakpoints");
        if (this.m_descriptors.length > 1) {
            Object object;
            Object object2;
            PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
            Object[] objectArray = new Object[]{this.m_origMethod};
            String string = MRI.get("DBG_ADD_METHOD_BRK_DIALOG_TITLE");
            String string2 = MessageFormat.format(MRI.get("DBG_SELECT_METHOD_BRK_FMT"), objectArray);
            String[][] stringArray = new String[this.m_descriptors.length + 1][4];
            stringArray[0][0] = MRI.get("DBG_METHOD");
            stringArray[0][1] = MRI.get("DBG_MODULE");
            stringArray[0][2] = MRI.get("DBG_LINE");
            stringArray[0][3] = MRI.get("DBG_PROGRAM");
            int n = 0;
            while (n < this.m_descriptors.length) {
                object2 = pgmManager.getProgram(this.m_descriptors[n].getViewId());
                object = pgmManager.getModule(this.m_descriptors[n].getViewId());
                stringArray[n + 1][0] = this.m_methods[n];
                stringArray[n + 1][1] = ((ModuleDescriptor)object).getModuleName();
                stringArray[n + 1][2] = String.valueOf(this.m_descriptors[n].getLineNum());
                stringArray[n + 1][3] = ((PgmDescriptor)object2).getPgmPath();
                ++n;
            }
            object2 = new PickFromTableDialog(this.m_ctxt.getJFrame(), string, string2, MRI.get("DBG_OK"), null, stringArray, 0);
            ((Dialog)object2).display(this.m_ctxt);
            if (!((Dialog)object2).wasCanceled()) {
                object = ((PickFromTableDialog)object2).getSelectedIndices();
                ArrayList<BreakpointDescriptor> arrayList = new ArrayList<BreakpointDescriptor>(((Object)object).length);
                int n2 = 0;
                while (n2 < ((Object)object).length) {
                    Object object3 = object[n2];
                    arrayList.add(this.m_descriptors[object3]);
                    if (n2 == 0) {
                        this.gotoSrc(this.m_descriptors[object3].getViewId(), this.m_descriptors[object3].getLineNum());
                    }
                    ++n2;
                }
                tabPanel.expose();
                LnBrkRequest lnBrkRequest = new LnBrkRequest(1, arrayList);
                this.m_ctxt.sendRequest(lnBrkRequest);
                this.m_ctxt.getPgmEnv().setSaved(false);
            }
        } else if (this.m_descriptors.length > 0) {
            tabPanel.expose();
            this.gotoSrc(this.m_descriptors[0].getViewId(), this.m_descriptors[0].getLineNum());
            LnBrkRequest lnBrkRequest = new LnBrkRequest(1, this.m_descriptors[0]);
            this.m_ctxt.sendRequest(lnBrkRequest);
            this.m_ctxt.getPgmEnv().setSaved(false);
        }
    }
}

