/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.IleDebugContext;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.unix.packet.UnixPacket;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;

public class UnixRemoteAttachPacket
extends UnixPacket
implements DebugConstants {
    private static final int ATTACH_PORT = 1;
    private static final int ATTACH_ILE = 2;
    private int m_reason;
    private int m_port;
    private String m_info;

    public UnixRemoteAttachPacket() {
        super(3003);
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_reason = commLink.readInt();
        this.m_port = commLink.readInt();
        this.m_info = commLink.readString();
    }

    public void run() {
        this.m_ctxt.postClock();
        switch (this.m_reason) {
            case 1: {
                this.attachPort();
                break;
            }
            case 2: {
                this.attachILE();
            }
        }
        this.m_ctxt.retractClock();
    }

    private void attachPort() {
        String[] stringArray;
        this.m_ctxt.commitUserConfig();
        Rectangle rectangle = this.m_ctxt.getJFrame().getBounds();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (rectangle.width < dimension.width || rectangle.height < dimension.height) {
            stringArray = this.m_ctxt.getUserConfig();
            stringArray.setInt("windowTop", rectangle.y += 20);
            stringArray.setInt("windowLeft", rectangle.x += 20);
            stringArray.commit();
        }
        stringArray = new String[]{"-s", this.m_ctxt.getSystem(), "-u", this.m_ctxt.getUser(), "-svrPort", String.valueOf(this.m_port)};
        this.m_ctxt.clone(stringArray);
    }

    private void attachILE() {
        if (!this.m_ctxt.hasPartnerContext()) {
            String[] stringArray = new String[]{"-s", this.m_ctxt.getSystem(), "-u", this.m_ctxt.getUser(), "-pid", this.m_info};
            IleDebugContext ileDebugContext = new IleDebugContext(this.m_ctxt.getDebugFrame(), stringArray);
            this.m_ctxt.getDebugFrame().appendDebugContext(ileDebugContext, true);
            ileDebugContext.init();
        }
    }
}

