/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.packet;

import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.unix.packet.UnixPacket;
import com.ibm.iseries.unix.panel.UnixMethodsPanel;
import java.io.IOException;

public class UnixMethodsPacket
extends UnixPacket {
    private String[] m_methods;
    private ISeriesMessage m_msgObj;

    public UnixMethodsPacket() {
        super(3012);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_methods = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        int n2 = commLink.readInt();
        this.m_methods = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.m_methods[n3] = commLink.readString();
            ++n3;
        }
        int n4 = commLink.readInt();
        if (n4 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        if (this.m_msgObj == null) {
            UnixMethodsPanel unixMethodsPanel = (UnixMethodsPanel)this.m_ctxt.getPanel("methods");
            if (unixMethodsPanel != null) {
                unixMethodsPanel.setMethods(this.m_methods);
            }
        } else {
            this.displayMessage(this.m_msgObj);
        }
        this.cleanUp();
    }
}

