/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.packet;

import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.dialog.ISeriesMessageDialog;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.DebugWindow;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.Toolbox;
import com.ibm.iseries.debugmanager.DebugManager;
import com.ibm.iseries.unix.UnixProcessDescriptor;
import com.ibm.iseries.unix.dialog.UnixBrowseProcessDialog;
import com.ibm.iseries.unix.packet.UnixPacket;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class UnixListProcessPacket
extends UnixPacket {
    private ArrayList m_process;
    private ISeriesMessage m_msgObj;

    public UnixListProcessPacket() {
        super(1524);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_process = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        int n2 = commLink.readInt();
        this.m_process = new ArrayList(n2);
        int n3 = 0;
        while (n3 < n2) {
            UnixProcessDescriptor unixProcessDescriptor = new UnixProcessDescriptor();
            unixProcessDescriptor.read(commLink);
            this.m_process.add(unixProcessDescriptor);
            ++n3;
        }
        Collections.sort(this.m_process);
        int n4 = commLink.readInt();
        if (n4 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        DebugWindow debugWindow = this.m_ctxt;
        if (debugWindow == null) {
            debugWindow = DebugManager.instance();
        }
        Dialog dialog = debugWindow.getActiveDialog();
        if (this.m_msgObj != null) {
            String string = Toolbox.instance().getMsgText(debugWindow, this.m_msgObj);
            String string2 = Toolbox.instance().getMsgHelp(this.m_msgObj);
            if (dialog != null) {
                ISeriesMessageDialog iSeriesMessageDialog = new ISeriesMessageDialog(dialog, string, string2);
                iSeriesMessageDialog.display();
            } else if (this.m_ctxt != null) {
                ISeriesMessageDialog iSeriesMessageDialog = new ISeriesMessageDialog(debugWindow, string, string2);
                iSeriesMessageDialog.display(debugWindow);
            }
        }
        if (dialog != null && dialog instanceof UnixBrowseProcessDialog) {
            ((UnixBrowseProcessDialog)dialog).setProcesses(this.m_process);
        }
        this.cleanUp();
    }
}

