/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.event.ContextEvent;
import com.ibm.iseries.debug.event.DebuggerEvent;
import com.ibm.iseries.debug.manager.ContextManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.util.ActionGroup;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.unix.packet.UnixPacket;
import java.io.IOException;

public class UnixContextPacket
extends UnixPacket
implements DebugConstants {
    private String m_viewId;
    private int m_lineNum;
    private String m_asmViewId;
    private int m_asmLineNum;
    private int m_mask;
    private int m_watchNum;
    private ISeriesMessage m_msgObj;

    public UnixContextPacket() {
        super(3002);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_viewId = null;
        this.m_asmViewId = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_viewId = commLink.readString();
        this.m_lineNum = commLink.readInt();
        this.m_asmViewId = commLink.readString();
        this.m_asmLineNum = commLink.readInt();
        this.m_mask = commLink.readInt();
        this.m_watchNum = commLink.readInt();
        int n2 = commLink.readInt();
        if (n2 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        Object object;
        Object object2;
        this.m_ctxt.stopAnimation();
        String string = null;
        if (ContextEvent.isAsmMask(this.m_mask) && (object2 = ((PgmManager)(object = (PgmManager)this.m_ctxt.getManager("pgmmgr"))).getModuleAddress(this.m_asmViewId)) != null) {
            string = ((MemoryAddress)object2).add((this.m_asmLineNum - 1) * 4).toString();
        }
        object = new ContextEvent(this, this.m_viewId, this.m_lineNum, this.m_asmViewId, this.m_asmLineNum, string, this.m_mask, this.m_watchNum, this.m_msgObj);
        object2 = this.m_ctxt.getActionGroup();
        if (((ActionGroup)object2).isCallstackContext() && (((ActionGroup)object2).m_lineNum == this.m_lineNum || ((ActionGroup)object2).m_lineNum == this.m_asmLineNum)) {
            ((DebuggerEvent)object).setType(2);
        }
        ContextManager contextManager = (ContextManager)this.m_ctxt.getManager("ctxtmgr");
        contextManager.fireContextEvent((ContextEvent)object);
        ((ContextEvent)object).cleanUp();
        this.cleanUp();
    }
}

