/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.dialog;

import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.util.DebugWindow;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Util;
import com.ibm.iseries.unix.UnixProcessDescriptor;
import com.ibm.iseries.unix.request.UnixListProcessRequest;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;

public class UnixBrowseProcessDialog
extends Dialog
implements MouseListener,
ListSelectionListener {
    private static final int COL_COUNT = 4;
    private static final int USER_COL = 0;
    private static final int PID_COL = 1;
    private static final int PPID_COL = 2;
    private static final int CMD_COL = 3;
    private static final String PROCESS = "process";
    private static final String USER = "user";
    private static final String SEARCH = "search";
    private DebugWindow m_wnd;
    private SettingsManager m_settingsMgr;
    private JPanel m_panel;
    private JPanel m_basePanel;
    private JPanel m_labelPanel;
    private JPanel m_ctrlPanel;
    private JPanel m_buttonPanel;
    private JPanel m_tablePanel;
    private JComboBox m_processCtrl;
    private JComboBox m_userCtrl;
    private JButton m_searchButton;
    private JScrollPane m_tableScroll;
    private TblModel m_tableModel;
    private Tbl m_table;
    private JTableHeader m_tableHeader;
    private ArrayList m_process;
    private int m_processIndex;
    private int[] m_columns;
    static /* synthetic */ Class class$java$lang$String;

    public UnixBrowseProcessDialog(DebugWindow debugWindow, JDialog jDialog, SettingsManager settingsManager, String string) {
        super(jDialog, MRI.get("DBG_BROWSE_PROCESS_DIALOG_TITLE"), true, "dbgbrowseproc");
        this.m_wnd = debugWindow;
        this.m_settingsMgr = settingsManager;
        this.m_columns = new int[4];
        if (this.m_isLtoR) {
            this.m_columns[0] = 0;
            this.m_columns[1] = 1;
            this.m_columns[2] = 2;
            this.m_columns[3] = 3;
        } else {
            this.m_columns[0] = 3;
            this.m_columns[1] = 2;
            this.m_columns[2] = 1;
            this.m_columns[3] = 0;
        }
        this.m_panel = new JPanel(new BorderLayout());
        this.m_basePanel = new JPanel(new BorderLayout());
        this.m_labelPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_ctrlPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_buttonPanel = new JPanel();
        this.m_tablePanel = new JPanel(new BorderLayout());
        this.m_panel.setBorder(this.getEmptyBorder(15, 15, 15, 15));
        this.m_basePanel.setBorder(this.getTitledBorder(MRI.get("DBG_ENTER_SEARCH_CRITERIA")));
        this.m_labelPanel.setBorder(this.getEmptyBorder(10, 10, 10, 10));
        this.m_ctrlPanel.setBorder(this.getEmptyBorder(10, 10, 10, 10));
        this.m_buttonPanel.setBorder(this.getEmptyBorder(3, 10, 10, 10));
        this.addComponents(string);
        this.m_panel.add((Component)this.m_basePanel, "North");
        this.m_panel.add((Component)this.m_tablePanel, "Center");
        this.m_panel.add((Component)this.defaultButtons(MRI.get("DBG_OK")), "South");
        this.setContentPane(this.m_panel);
        this.doSearch();
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_wnd = null;
        this.m_settingsMgr = null;
        this.m_panel = null;
        this.m_basePanel = null;
        this.m_labelPanel = null;
        this.m_ctrlPanel = null;
        this.m_buttonPanel = null;
        this.m_tablePanel = null;
        this.m_processCtrl = null;
        this.m_userCtrl = null;
        this.m_searchButton = null;
        this.m_tableScroll = null;
        this.m_tableModel = null;
        this.m_table = null;
        this.m_tableHeader = null;
    }

    private void addComponents(String string) {
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_COMMAND_LABEL"));
        JLabel jLabel2 = Util.getAccessibleLabel(MRI.get("DBG_USER_LABEL"));
        this.m_labelPanel.add(jLabel);
        this.m_labelPanel.add(jLabel2);
        string = Util.firstUpper(string);
        Settings settings = this.m_settingsMgr.getUserConfig();
        String string2 = MRI.get("DBG_ALL");
        String string3 = settings.getString("browseProcess", string2);
        String string4 = settings.getString("browseUser", string);
        this.m_processCtrl = new JComboBox();
        this.m_processCtrl.setRenderer(new DummyRenderer());
        this.m_processCtrl.setEditable(true);
        this.m_processCtrl.addItem(string2);
        this.m_processCtrl.setSelectedItem(string3);
        this.m_processCtrl.setActionCommand(PROCESS);
        this.m_processCtrl.addActionListener(this);
        this.m_userCtrl = new JComboBox();
        this.m_userCtrl.setRenderer(new DummyRenderer());
        this.m_userCtrl.setEditable(true);
        this.m_userCtrl.addItem(string2);
        this.m_userCtrl.addItem(string);
        this.m_userCtrl.setSelectedItem(string4);
        this.m_userCtrl.setActionCommand(USER);
        this.m_userCtrl.addActionListener(this);
        this.m_ctrlPanel.add(this.m_processCtrl);
        this.m_ctrlPanel.add(this.m_userCtrl);
        String string5 = MRI.get("DBG_SEARCH");
        JButton jButton = new JButton(string5);
        jButton.setActionCommand(SEARCH);
        jButton.addActionListener(this);
        this.m_buttonPanel.add(jButton);
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        JLabel jLabel3 = new JLabel(" ");
        JLabel jLabel4 = Util.getAccessibleLabel(MRI.get("DBG_PROCESSES_FOUND_LABEL"));
        jPanel.setOpaque(true);
        jPanel.add(jLabel3);
        jPanel.add(jLabel4);
        this.m_tableModel = new TblModel();
        this.m_table = new Tbl(this.m_tableModel);
        this.m_tableHeader = this.m_table.getTableHeader();
        this.m_tableScroll = new JScrollPane(this.m_table);
        this.m_tablePanel.add((Component)jPanel, "North");
        this.m_tablePanel.add((Component)this.m_tableScroll, "Center");
        this.m_table.setSelectionMode(0);
        this.m_tableScroll.getViewport().setBackground(this.m_table.getBackground());
        this.m_tablePanel.setBackground(this.m_table.getBackground());
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.addMouseListener(this);
        this.m_tableHeader.addMouseListener(this);
        Util.setAccessible((Accessible)this.m_processCtrl, jLabel);
        Util.setAccessible((Accessible)this.m_userCtrl, jLabel2);
        Util.setAccessible((Accessible)jButton, string5);
        Util.setOrientation(this.m_processCtrl, jLabel);
        Util.setOrientation(this.m_userCtrl, jLabel2);
        Util.setOrientation(jButton);
        Util.setOrientation(jLabel4);
        Util.setOrientation(this.m_tableScroll);
        Util.setOrientation(this.m_processCtrl.getEditor().getEditorComponent());
        Util.setOrientation(this.m_userCtrl.getEditor().getEditorComponent());
        this.m_basePanel.add((Component)this.m_labelPanel, this.m_isLtoR ? "West" : "East");
        this.m_basePanel.add((Component)this.m_ctrlPanel, "Center");
        this.m_basePanel.add((Component)this.m_buttonPanel, this.m_isLtoR ? "East" : "West");
        this.listenForEscape(this.m_panel);
        this.listenForEscape(this.m_table);
    }

    public String getPID() {
        UnixProcessDescriptor unixProcessDescriptor = (UnixProcessDescriptor)this.m_process.get(this.m_processIndex);
        return unixProcessDescriptor.getPID();
    }

    public void setProcesses(ArrayList arrayList) {
        this.m_process = arrayList;
        this.m_tableModel.fireTableDataChanged();
        this.m_doItButton.setEnabled(this.m_process.size() > 0 && this.m_table.getSelectedRowCount() > 0);
        this.retractClock();
    }

    private void selectComboBox(JComboBox jComboBox) {
        Component component;
        ComboBoxEditor comboBoxEditor = jComboBox.getEditor();
        jComboBox.requestFocus();
        if (comboBoxEditor != null && (component = comboBoxEditor.getEditorComponent()) != null && component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            jTextField.selectAll();
        }
    }

    public void doOk() {
        int n = this.m_table.getSelectedRow();
        if (n >= 0) {
            this.m_processIndex = n;
            String string = ((String)this.m_processCtrl.getSelectedItem()).trim();
            String string2 = ((String)this.m_userCtrl.getSelectedItem()).trim();
            Settings settings = this.m_settingsMgr.getUserConfig();
            settings.setString("browseProcess", string);
            settings.setString("browseUser", string2);
            this.setCanceled(false);
            this.dispose();
        }
    }

    private void doSearch() {
        String string = ((String)this.m_processCtrl.getSelectedItem()).trim();
        String string2 = ((String)this.m_userCtrl.getSelectedItem()).trim();
        String string3 = MRI.get("DBG_ALL").toUpperCase();
        if (string.length() == 0 || string.startsWith("*")) {
            this.selectComboBox(this.m_processCtrl);
            this.getToolkit().beep();
            return;
        }
        if (string.toUpperCase().equals(string3)) {
            string = "*ALL";
        }
        if (string2.length() == 0 || string2.startsWith("*")) {
            this.selectComboBox(this.m_userCtrl);
            this.getToolkit().beep();
            return;
        }
        if (string2.toUpperCase().equals(string3)) {
            string2 = "*ALL";
        }
        this.postClock();
        UnixListProcessRequest unixListProcessRequest = new UnixListProcessRequest(string, string2);
        boolean bl = this.m_wnd.sendRequest(unixListProcessRequest);
        if (!bl) {
            this.retractClock();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox;
        super.actionPerformed(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string.equals("doit")) {
            this.doOk();
        } else if (string.equals(SEARCH)) {
            this.doSearch();
        } else if ((string.equals(PROCESS) || string.equals(USER)) && !(jComboBox = (JComboBox)actionEvent.getSource()).isPopupVisible()) {
            this.doSearch();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.m_table) {
            if (mouseEvent.getClickCount() == 2) {
                this.doOk();
            }
        } else if (mouseEvent.getSource() == this.m_tableHeader) {
            int n = this.m_tableHeader.columnAtPoint(mouseEvent.getPoint());
            int n2 = -1;
            switch (this.m_columns[n]) {
                case 0: {
                    n2 = 0;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                }
            }
            if (n2 != UnixProcessDescriptor.getSortMode()) {
                UnixProcessDescriptor.setSortMode(n2);
                if (this.m_table.getRowCount() > 1) {
                    Collections.sort(this.m_process);
                    this.m_table.clearSelection();
                    this.m_tableModel.fireTableDataChanged();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.m_doItButton.setEnabled(this.m_table.getSelectedRowCount() > 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DummyRenderer
    extends DefaultListCellRenderer {
    }

    private class TblModel
    extends AbstractTableModel {
        private TblModel() {
        }

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return UnixBrowseProcessDialog.this.m_process != null ? UnixBrowseProcessDialog.this.m_process.size() : 0;
        }

        public String getColumnName(int n) {
            switch (UnixBrowseProcessDialog.this.m_columns[n]) {
                case 0: {
                    return MRI.get("DBG_USER");
                }
                case 1: {
                    return MRI.get("DBG_PID");
                }
                case 2: {
                    return MRI.get("DBG_PPID");
                }
                case 3: {
                    return MRI.get("DBG_COMMAND");
                }
            }
            return "";
        }

        public Object getValueAt(int n, int n2) {
            UnixProcessDescriptor unixProcessDescriptor = (UnixProcessDescriptor)UnixBrowseProcessDialog.this.m_process.get(n);
            switch (UnixBrowseProcessDialog.this.m_columns[n2]) {
                case 0: {
                    return unixProcessDescriptor.getUser();
                }
                case 1: {
                    return unixProcessDescriptor.getPID();
                }
                case 2: {
                    return unixProcessDescriptor.getPPID();
                }
                case 3: {
                    return unixProcessDescriptor.getCmd();
                }
            }
            return "";
        }

        public Class getColumnClass(int n) {
            return class$java$lang$String == null ? (class$java$lang$String = UnixBrowseProcessDialog.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    protected class Tbl
    extends JTable {
        public Tbl(TblModel tblModel) {
            super(tblModel);
        }

        public Dimension getPreferredScrollableViewportSize() {
            Dimension dimension = super.getPreferredScrollableViewportSize();
            int n = 15;
            dimension.height = n * this.getRowHeight();
            return dimension;
        }
    }
}

