/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.pase;

import com.ibm.iseries.debug.AbstractDebugContext;
import com.ibm.iseries.debug.DebugFrame;
import com.ibm.iseries.debug.Desktop;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.manager.BreakpointGroupManager;
import com.ibm.iseries.debug.manager.BreakpointManager;
import com.ibm.iseries.debug.manager.ContextManager;
import com.ibm.iseries.debug.manager.CursorManager;
import com.ibm.iseries.debug.manager.LAFManager;
import com.ibm.iseries.debug.manager.MemoryManager;
import com.ibm.iseries.debug.manager.RegisterManager;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.manager.VariableManager;
import com.ibm.iseries.debug.register.RegisterSet;
import com.ibm.iseries.debug.source.DisassemblyPane;
import com.ibm.iseries.debug.util.ActionGroup;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugDesktop;
import com.ibm.iseries.debug.util.DebugPgmEnv;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Menubar;
import com.ibm.iseries.debug.util.Packet;
import com.ibm.iseries.debug.util.PacketInflater;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Toolbar;
import com.ibm.iseries.debug.util.Util;
import com.ibm.iseries.pase.PaseMenubar;
import com.ibm.iseries.pase.PaseToolbar;
import com.ibm.iseries.unix.UnixCommLink;
import com.ibm.iseries.unix.UnixPgmEnvironment;
import com.ibm.iseries.unix.UnixRegisterSet;
import com.ibm.iseries.unix.manager.UnixPgmManager;
import com.ibm.iseries.unix.manager.UnixSourceViewManager;
import com.ibm.iseries.unix.packet.UnixPacketInflater;
import com.ibm.iseries.unix.packet.UnixStartDebugPacket;
import com.ibm.iseries.unix.request.UnixPrimeStepRequest;
import com.ibm.iseries.unix.request.UnixStartServerRequest;
import java.awt.Component;
import java.awt.Toolkit;
import java.net.UnknownHostException;
import java.text.MessageFormat;

public class PaseDebugContext
extends AbstractDebugContext {
    private PacketInflater m_inflater = new UnixPacketInflater(this);
    private RegisterSet m_32BitRegSet;
    private RegisterSet m_64BitRegSet;
    private int m_addrSize = 32;
    private String m_libPathArg = "";
    private String m_envVarsArg = "";
    private String m_srcPathArg = "";
    private String m_pluginLoadArg = "";
    private String m_pluginPathArg = "";
    private int m_multiProcArg = -1;
    private String m_commandArg = "";
    private int m_optionsArg = -1;
    private int m_hubPortArg = -1;
    private int m_svrPortArg = -1;
    private boolean m_reatt = false;

    public PaseDebugContext(DebugFrame debugFrame, String[] stringArray) {
        super(debugFrame);
        this.loadSettings("com/ibm/iseries/pase/idbgpase.cfg", ".idbgpase", SettingsManager.PASE_COMMENT);
        this.parseArgs(stringArray);
        this.loadConfig();
    }

    protected void directConnectToServer(String string, String string2, int n) {
        this.postClock();
        this.clearMessage();
        try {
            UnixCommLink unixCommLink = new UnixCommLink(this, string, string2, n, "", this.m_inflater);
            unixCommLink.addListener(this);
            unixCommLink.setUnicodeHeaders(false);
            unixCommLink.setUnicodeMessages(false);
            unixCommLink.setRequireSignOn(false);
            boolean bl = unixCommLink.connect(false);
            if (bl) {
                this.m_commLink = unixCommLink;
                unixCommLink.setUnicodeStrings(false);
                unixCommLink.listen();
                this.m_initialized = true;
            } else {
                unixCommLink.removeListener(this);
            }
        }
        catch (UnknownHostException unknownHostException) {
            Object[] objectArray = new Object[]{Util.firstUpper(this.m_sysArg)};
            String string3 = MessageFormat.format(MRI.get("DBG_UNKNOWN_HOST_SYSTEM_FMT"), objectArray);
            String string4 = MRI.get("DBG_ERROR");
            Util.errorMessage(this.m_frame, string4, string3);
        }
        this.setTitle();
        this.retractClock();
    }

    public String getDebuggerName() {
        return MRI.get("DBG_PASE_DEBUGGER");
    }

    public int getHelpSetId() {
        return 1;
    }

    public boolean isSupported(int n, double d) {
        switch (n) {
            case 9: {
                return d >= 5.30002 && (!this.hasPartnerContext() || this.isMasterContext());
            }
        }
        return super.isSupported(n, d);
    }

    public void init() {
        if (this.m_multiProcArg == -1) {
            this.m_multiProcArg = this.getUserConfig().getInt("strdbgMultiProc", 3);
        }
        if (this.m_srcPathArg == null || this.m_srcPathArg.length() == 0) {
            this.m_srcPathArg = this.getUserConfig().getString("strdbgHostSrcPath", "");
        }
        if (this.m_pluginLoadArg == null || this.m_pluginLoadArg.length() == 0) {
            this.m_pluginLoadArg = this.getUserConfig().getString("strdbgHostPluginLoad", "");
        }
        if (this.m_pluginPathArg == null || this.m_pluginPathArg.length() == 0) {
            this.m_pluginPathArg = this.getUserConfig().getString("strdbgHostPluginPath", "");
        }
        if (this.m_optionsArg == -1) {
            this.m_optionsArg = this.getDebugOptions();
        }
        if (this.m_svrPortArg >= 0) {
            this.enableAction("strdbg", false);
            this.directConnectToServer(this.m_sysArg, this.m_userArg, this.m_svrPortArg);
        } else if (this.m_pgmArg.length() == 0 && this.m_jobIdArg.length() == 0) {
            this.m_initialized = true;
            this.enableAction("strdbg", true);
            this.getAction("strdbg").run();
        } else if (this.m_sysArg.length() > 0) {
            this.enableAction("strdbg", false);
            this.establishCommLink();
            this.m_initialized = true;
        } else {
            this.m_initialized = true;
        }
    }

    public void cleanUp() {
        this.m_inflater = null;
        this.m_libPathArg = null;
        this.m_envVarsArg = null;
        this.m_srcPathArg = null;
        this.m_pluginLoadArg = null;
        this.m_pluginPathArg = null;
        this.m_32BitRegSet = null;
        this.m_64BitRegSet = null;
        super.cleanUp();
    }

    public void clear(int n) {
        super.clear(n);
        this.m_envVarsArg = "";
        this.m_srcPathArg = "";
        this.m_pluginLoadArg = "";
        this.m_pluginPathArg = "";
        this.m_commandArg = "";
    }

    public DebugContext clone(String[] stringArray) {
        PaseDebugContext paseDebugContext = PaseDebugContext.createPaseDebugger(stringArray);
        return paseDebugContext;
    }

    public void setTitle() {
        if (this.m_pgmArg.length() > 0) {
            Object[] objectArray = new Object[]{this.m_pgmArg, this.m_jobIdArg, Util.firstUpper(Util.getSystemShortName(this.m_sysArg)), Util.firstUpper(this.m_userArg)};
            this.setTitle(MessageFormat.format(MRI.get("DBG_PASE_TITLE_BAR_FMT"), objectArray));
        } else {
            Object[] objectArray = new Object[]{this.m_jobIdArg, Util.firstUpper(Util.getSystemShortName(this.m_sysArg)), Util.firstUpper(this.m_userArg)};
            this.setTitle(MessageFormat.format(MRI.get("DBG_PASE_ATTACH_TITLE_BAR_FMT"), objectArray));
        }
    }

    public void setProgramInfo(Packet packet) {
        if (!(packet instanceof UnixStartDebugPacket)) {
            return;
        }
        this.postClock();
        UnixStartDebugPacket unixStartDebugPacket = (UnixStartDebugPacket)packet;
        this.m_addrSize = unixStartDebugPacket.getAddrSizeInBits();
        this.m_pgmArg = unixStartDebugPacket.getPgmPath();
        this.m_jobIdArg = unixStartDebugPacket.getPid();
        if (this.m_jobIdArg.length() > 0) {
            this.m_pidArg = Integer.parseInt(this.m_jobIdArg);
        }
        MemoryManager memoryManager = (MemoryManager)this.getManager("memmgr");
        RegisterManager registerManager = (RegisterManager)this.getManager("regmgr");
        RegisterSet registerSet = null;
        switch (this.m_addrSize) {
            case 32: {
                if (this.m_32BitRegSet == null) {
                    this.m_32BitRegSet = new UnixRegisterSet(this.m_addrSize);
                }
                registerSet = this.m_32BitRegSet;
                break;
            }
            case 64: {
                if (this.m_64BitRegSet == null) {
                    this.m_64BitRegSet = new UnixRegisterSet(this.m_addrSize);
                }
                registerSet = this.m_64BitRegSet;
            }
        }
        memoryManager.fireMemoryAddressSizeChanged(this.m_addrSize, 0);
        registerManager.setRegisterSet(registerSet);
        this.setTitle();
        this.setDebugIcon(8);
        PgmDescriptor pgmDescriptor = new PgmDescriptor(unixStartDebugPacket.getPgmPath());
        this.m_pgmEnv.autoOpen(pgmDescriptor.getPgmLibrary(), pgmDescriptor.getPgmName(), pgmDescriptor.getPgmType());
        this.retractClock();
    }

    public int getDebugOptions() {
        if (this.m_optionsArg == -1) {
            Settings settings = this.getUserConfig();
            this.m_optionsArg = 0;
            int n = settings.getInt("strdbgBreakBehavior", 0);
            switch (n) {
                case 0: {
                    this.m_optionsArg |= 0x40;
                    break;
                }
                case 1: {
                    this.m_optionsArg |= 4;
                    break;
                }
                case 2: {
                    this.m_optionsArg |= 0x100;
                    break;
                }
            }
            if (settings.getBool("strdbgResolveLoadmap", true)) {
                this.m_optionsArg |= 2;
            }
            if (settings.getBool("strdbgResolveMethods", true)) {
                this.m_optionsArg |= 0x20;
            }
            if (settings.getBool("strdbgPauseOnLoad", true)) {
                this.m_optionsArg |= 8;
            }
            if (settings.getBool("strdbgIncludeStatics", true)) {
                this.m_optionsArg |= 0x10;
            }
            if (settings.getBool("strdbgExcludeCompiler", true)) {
                this.m_optionsArg |= 0x80;
            }
            if (settings.getBool("strdbgRedirectIO", false)) {
                this.m_optionsArg |= 0x200;
            }
            if (settings.getBool("strdbgGenCodePase", true)) {
                this.m_optionsArg |= 0x800;
            }
            if (settings.getBool("strdbgIgnoreTrapPase", true)) {
                this.m_optionsArg |= 0x1000;
            }
            if (settings.getBool("strdbgIlePase", false)) {
                this.m_optionsArg |= 0x400;
            }
        }
        return this.m_optionsArg;
    }

    public int getAddrSizeInBits() {
        return this.m_addrSize;
    }

    public int getAddrOffsetSizeInBits() {
        return 0;
    }

    public void primePartnerStep() {
        if (this.m_lastRunAction != 4) {
            this.sendRequest(new UnixPrimeStepRequest());
            this.m_lastRunAction = 4;
        }
    }

    public void loadSettings(String string, String string2, String string3) {
        this.m_settingsMgr = SettingsManager.instance(1);
        this.m_settingsMgr.init(string, string2, string3);
    }

    protected ActionGroup loadActionGroup(Settings settings) {
        return new ActionGroup(this, settings);
    }

    protected DebugPgmEnv loadPgmEnv(Settings settings) {
        return new UnixPgmEnvironment(this, ".idbgpaseenv", MRI.get("DBG_PASE_ENV_FILTER_TITLE"));
    }

    protected void loadManagers(Settings settings) {
        this.m_mgrs.put(this.m_settingsMgr.getKey(), this.m_settingsMgr);
        BreakpointGroupManager breakpointGroupManager = new BreakpointGroupManager(this);
        BreakpointManager breakpointManager = new BreakpointManager(this);
        ContextManager contextManager = new ContextManager(this);
        UnixPgmManager unixPgmManager = new UnixPgmManager(this);
        UnixSourceViewManager unixSourceViewManager = new UnixSourceViewManager(this);
        RegisterManager registerManager = new RegisterManager(this);
        MemoryManager memoryManager = new MemoryManager(this);
        VariableManager variableManager = new VariableManager(this);
        CursorManager cursorManager = new CursorManager();
        this.m_mgrs.put(breakpointGroupManager.getKey(), breakpointGroupManager);
        this.m_mgrs.put(breakpointManager.getKey(), breakpointManager);
        this.m_mgrs.put(contextManager.getKey(), contextManager);
        this.m_mgrs.put(unixPgmManager.getKey(), unixPgmManager);
        this.m_mgrs.put(unixSourceViewManager.getKey(), unixSourceViewManager);
        this.m_mgrs.put(registerManager.getKey(), registerManager);
        this.m_mgrs.put(memoryManager.getKey(), memoryManager);
        this.m_mgrs.put(variableManager.getKey(), variableManager);
        this.m_mgrs.put(cursorManager.getKey(), cursorManager);
        this.m_mgrs.put(LAFManager.instance().getKey(), LAFManager.instance());
    }

    protected Menubar loadMenuBar(Settings settings) {
        PaseMenubar paseMenubar = (PaseMenubar)Util.loadObject(settings.getString("menuBar", null));
        paseMenubar.init(this);
        return paseMenubar;
    }

    protected Toolbar loadToolBar(Settings settings) {
        PaseToolbar paseToolbar = (PaseToolbar)Util.loadObject(settings.getString("toolBar", null));
        paseToolbar.init(this);
        return paseToolbar;
    }

    protected DebugDesktop loadDesktop(Settings settings) {
        return new Desktop(this);
    }

    protected DebugSource loadDisassembly(Settings settings) {
        return new DisassemblyPane(this);
    }

    protected CommLink createCommLink() throws UnknownHostException {
        return new UnixCommLink(this, this.m_sysArg, this.m_userArg, this.m_hubPortArg, "as-debug", this.m_inflater);
    }

    protected boolean startDebugServer() {
        String string;
        if (this.m_reatt) {
            string = "-A:";
            string = string + this.m_srcPathArg;
        } else {
            string = this.m_srcPathArg;
        }
        if (this.m_pluginLoadArg.length() > 1 || this.m_pluginPathArg.length() > 1) {
            string = string + ":@";
            string = string + this.m_pluginLoadArg;
            string = string + ":@";
            string = string + this.m_pluginPathArg;
        }
        UnixStartServerRequest unixStartServerRequest = new UnixStartServerRequest(this.m_pgmArg, this.m_pgmParmsArg, this.m_libPathArg, this.m_envVarsArg, string, this.m_jobIdArg, this.m_multiProcArg, this.m_commandArg, this.m_optionsArg, this.m_userArg);
        return this.sendRequest(unixStartServerRequest);
    }

    public void loadConfig() {
        super.loadConfig();
        this.setTitle();
        BreakpointGroupManager breakpointGroupManager = (BreakpointGroupManager)this.getManager("brkgrpmgr");
        breakpointGroupManager.init();
    }

    /*
     * Unable to fully structure code
     */
    public void parseArgs(String[] var1_1) {
        var2_2 = this.getUserConfig();
        var3_3 = 0;
        while (var3_3 < var1_1.length) {
            block35: {
                block34: {
                    var4_4 = var1_1[var3_3].charAt(0);
                    var5_5 = var1_1[var3_3].length() > 1 ? (int)var1_1[var3_3].charAt(1) : 32;
                    var6_6 = false;
                    if (var4_4 != '-' || var3_3 + 1 >= var1_1.length) break block34;
                    switch (var5_5) {
                        case 99: {
                            if (var1_1[var3_3].equals("-c") || var1_1[var3_3].equals("-command")) {
                                this.m_commandArg = var1_1[++var3_3];
                                var2_2.setString("strdbgCmd", this.m_commandArg);
                                break;
                            }
                            if (var1_1[var3_3].equals("-clientsourcepath")) {
                                var2_2.setString("strdbgClientSrcPath", var1_1[++var3_3]);
                                break;
                            }
                            var6_6 = true;
                            break;
                        }
                        case 101: {
                            if (var1_1[var3_3].equals("-env")) {
                                this.m_envVarsArg = var1_1[++var3_3];
                                var2_2.setString("strdbgEnvVars", this.m_envVarsArg);
                                break;
                            }
                            var6_6 = true;
                            break;
                        }
                        case 108: {
                            if (var1_1[var3_3].equals("-libpath")) {
                                this.m_libPathArg = var1_1[++var3_3];
                                var2_2.setString("strdbgLibPath", this.m_libPathArg);
                                break;
                            }
                            if (!var1_1[var3_3].equals("-location")) ** GOTO lbl42
                            if ((var8_9 = (var7_7 = var1_1[++var3_3]).indexOf(120)) > 0) {
                                var9_10 = Toolkit.getDefaultToolkit().getScreenSize();
                                var10_11 = Integer.parseInt(var7_7.substring(0, var8_9));
                                var11_12 = Integer.parseInt(var7_7.substring(var8_9 + 1));
                                if (var10_11 >= 0 && var10_11 < var9_10.width) {
                                    var2_2.setInt("windowLeft", var10_11);
                                }
                                if (var11_12 >= 0 && var11_12 < var9_10.height) {
                                    var2_2.setInt("windowTop", var11_12);
                                    break;
                                }
                            }
                            break block35;
lbl42:
                            // 1 sources

                            var6_6 = true;
                            break;
                        }
                        case 109: {
                            if ((var1_1[var3_3].equals("-m") || var1_1[var3_3].equals("-multiproc")) && (var7_8 = Integer.parseInt(var1_1[++var3_3])) >= 1 && var7_8 <= 3) {
                                this.m_multiProcArg = var7_8;
                                var2_2.setInt("strdbgMultiProc", this.m_multiProcArg);
                                break;
                            }
                            break block35;
                        }
                        case 111: {
                            if (var1_1[var3_3].equals("-o") || var1_1[var3_3].equals("-options")) {
                                this.m_optionsArg = Integer.parseInt(var1_1[++var3_3]);
                                var2_2.setBool("strdbgResolveLoadmap", (this.m_optionsArg & 2) != 0);
                                var2_2.setBool("strdbgExtendBrks", (this.m_optionsArg & 4) != 0);
                                var2_2.setBool("strdbgPauseOnLoad", (this.m_optionsArg & 8) != 0);
                                var2_2.setBool("strdbgIncludeStatics", (this.m_optionsArg & 16) != 0);
                                break;
                            }
                            break block35;
                        }
                        case 112: {
                            if (var1_1[var3_3].equals("-p") || var1_1[var3_3].equals("-program")) {
                                this.m_pgmArg = var1_1[++var3_3];
                                var2_2.setString("strdbgPgmName", this.m_pgmArg);
                                break;
                            }
                            if (!var1_1[var3_3].equals("-pid")) ** GOTO lbl71
                            this.m_jobIdArg = var1_1[++var3_3];
                            var2_2.setString("strdbgPid", this.m_jobIdArg);
                            if (this.m_jobIdArg.length() > 0) {
                                this.m_pidArg = Integer.parseInt(this.m_jobIdArg);
                                break;
                            }
                            break block35;
lbl71:
                            // 1 sources

                            if (var1_1[var3_3].equals("-parms")) {
                                while (++var3_3 < var1_1.length) {
                                    this.m_pgmParmsArg = this.m_pgmParmsArg + var1_1[var3_3];
                                    this.m_pgmParmsArg = this.m_pgmParmsArg + " ";
                                }
                                this.m_pgmParmsArg.trim();
                                var2_2.setString("strdbgPgmParms", this.m_pgmParmsArg);
                                break;
                            }
                            if (var1_1[var3_3].equals("-port")) {
                                this.m_hubPortArg = Integer.parseInt(var1_1[++var3_3]);
                                break;
                            }
                            if (var1_1[var3_3].equals("-pluginload")) {
                                this.m_pluginLoadArg = var1_1[++var3_3];
                                var2_2.setString("strdbgHostPluginLoad", this.m_pluginLoadArg);
                                break;
                            }
                            if (var1_1[var3_3].equals("-pluginpath")) {
                                this.m_pluginPathArg = var1_1[++var3_3];
                                var2_2.setString("strdbgHostPluginPath", this.m_pluginPathArg);
                                break;
                            }
                            var6_6 = true;
                            break;
                        }
                        case 114: {
                            if (var1_1[var3_3].equals("-reatt")) {
                                this.m_reatt = true;
                                ++var3_3;
                                break;
                            }
                            var6_6 = true;
                            break;
                        }
                        case 115: {
                            if (var1_1[var3_3].equals("-s") || var1_1[var3_3].equals("-system")) {
                                this.m_sysArg = var1_1[++var3_3];
                                break;
                            }
                            if (var1_1[var3_3].equals("-svrPort")) {
                                this.m_svrPortArg = Integer.parseInt(var1_1[++var3_3]);
                                break;
                            }
                            if (var1_1[var3_3].equals("-sourcepath")) {
                                this.m_srcPathArg = var1_1[++var3_3];
                                var2_2.setString("strdbgHostSrcPath", this.m_srcPathArg);
                                break;
                            }
                            var6_6 = true;
                            break;
                        }
                        case 117: {
                            if (var1_1[var3_3].equals("-u") || var1_1[var3_3].equals("-user")) {
                                this.m_userArg = var1_1[++var3_3];
                                break;
                            }
                            var6_6 = true;
                            break;
                        }
                        default: {
                            var6_6 = true;
                            break;
                        }
                    }
                    break block35;
                }
                var6_6 = true;
            }
            if (var6_6) {
                System.out.println("Bad argument: " + var1_1[var3_3]);
            }
            ++var3_3;
        }
    }

    public static PaseDebugContext createPaseDebugger(String[] stringArray) {
        DebugFrame debugFrame = new DebugFrame();
        PaseDebugContext paseDebugContext = new PaseDebugContext(debugFrame, stringArray);
        debugFrame.addInitialDebugContext(paseDebugContext);
        debugFrame.pack();
        ((Component)debugFrame).setVisible(true);
        paseDebugContext.init();
        return paseDebugContext;
    }
}

