/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.util;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.util.MRI;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class Util
implements DebugConstants {
    public static final int YES = 0;
    public static final int NO = 1;
    private static HashMap s_classes = new HashMap();
    private static char s_mnemonic = '\u0000';

    public static Object loadObject(String string) {
        Object var1_1 = null;
        try {
            Class<?> clazz = (Class<?>)s_classes.get(string);
            if (clazz == null) {
                clazz = Class.forName(string);
                s_classes.put(string, clazz);
            }
            var1_1 = clazz.newInstance();
        }
        catch (Throwable throwable) {
            System.out.println("DebuggerUtil.loadObject  " + string + ": caught exception: " + throwable.toString());
            throwable.printStackTrace();
        }
        if (var1_1 == null) {
            System.exit(-1);
        }
        return var1_1;
    }

    public static JLabel getAccessibleLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.getAccessibleContext().setAccessibleName(string);
        jLabel.getAccessibleContext().setAccessibleDescription(string);
        return jLabel;
    }

    public static void setAccessible(Accessible accessible, JLabel jLabel) {
        String string = jLabel.getText();
        accessible.getAccessibleContext().setAccessibleName(string);
        accessible.getAccessibleContext().setAccessibleDescription(string);
        jLabel.setLabelFor((JComponent)((Object)accessible));
    }

    public static void setAccessible(Accessible accessible, String string) {
        accessible.getAccessibleContext().setAccessibleName(string);
        accessible.getAccessibleContext().setAccessibleDescription(string);
    }

    public static void setAccessible(Accessible accessible, String string, String string2) {
        accessible.getAccessibleContext().setAccessibleName(string);
        accessible.getAccessibleContext().setAccessibleDescription(string2);
    }

    public static void setOrientation(Component component) {
        if (MRI.isRtoL()) {
            component.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
    }

    public static void setOrientation(Component component, JLabel jLabel) {
        if (MRI.isRtoL()) {
            component.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            jLabel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
    }

    public static String parseMnemonic(String string) {
        s_mnemonic = '\u0000';
        String string2 = string;
        int n = string.indexOf(37);
        while (n != -1 && n < string.length() - 1) {
            char c = string.charAt(n + 1);
            if (c != '%') {
                s_mnemonic = c;
                string2 = string.substring(0, n) + string.substring(n + 1);
                break;
            }
            n = string.indexOf(37, n + 1);
        }
        return string2;
    }

    public static boolean parsedMnemonic() {
        return s_mnemonic != '\u0000';
    }

    public static char getMnemonic() {
        return s_mnemonic;
    }

    public static String getSystemShortName(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c != '.' && !Character.isDigit(c)) {
                return string.substring(0, n);
            }
            ++n3;
        }
        return string;
    }

    public static String upper(String string) {
        if (MRI.isTurkish()) {
            return string.toUpperCase(Locale.ENGLISH);
        }
        return string.toUpperCase();
    }

    public static String lower(String string) {
        if (MRI.isTurkish()) {
            return string.toLowerCase(Locale.ENGLISH);
        }
        return string.toLowerCase();
    }

    public static String firstUpper(String string) {
        if (string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(Character.toUpperCase(string.charAt(0)));
        stringBuffer.append(Util.lower(string.substring(1)));
        return stringBuffer.toString();
    }

    public static String firstUpperJobId(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.indexOf(47);
        if (n >= 0) {
            stringBuffer.append(string.substring(0, ++n));
            int n2 = n;
            n = string.indexOf(47, n2);
            if (n >= 0) {
                stringBuffer.append(Util.firstUpper(string.substring(n2, ++n)));
                stringBuffer.append(Util.firstUpper(string.substring(n)));
            }
        }
        return stringBuffer.toString();
    }

    public static String firstUpperObjectPath(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.indexOf(47);
        if (n >= 0) {
            stringBuffer.append(Util.firstUpper(string.substring(0, ++n)));
            stringBuffer.append(Util.firstUpper(string.substring(n)));
        }
        return stringBuffer.toString();
    }

    public static void errorMessage(JFrame jFrame, String string, String string2) {
        JOptionPane.showMessageDialog(jFrame, string2, string, 0);
    }

    public static void warnMessage(JFrame jFrame, String string, String string2) {
        JOptionPane.showMessageDialog(jFrame, string2, string, 2);
    }

    public static void infoMessage(JFrame jFrame, String string, String string2) {
        JOptionPane.showMessageDialog(jFrame, string2, string, 1);
    }

    public static int confirm(JFrame jFrame, String string, String string2) {
        return JOptionPane.showConfirmDialog(jFrame, string2, string, 0);
    }

    public static String getInput(JFrame jFrame, String string, String string2, String string3) {
        return (String)JOptionPane.showInputDialog(jFrame, string2, string, 3, null, null, string3);
    }

    public static void errorMessage(JDialog jDialog, String string, String string2) {
        JOptionPane.showMessageDialog(jDialog, string2, string, 0);
    }

    public static void infoMessage(JDialog jDialog, String string, String string2) {
        JOptionPane.showMessageDialog(jDialog, string2, string, 1);
    }

    public static int confirm(JDialog jDialog, String string, String string2) {
        return JOptionPane.showConfirmDialog(jDialog, string2, string, 0);
    }

    public static String getInput(JDialog jDialog, String string, String string2, String string3) {
        return (String)JOptionPane.showInputDialog(jDialog, string2, string, 3, null, null, string3);
    }

    public static String validateHexData(String string) {
        int n;
        int n2 = string.length();
        string = string.toUpperCase();
        if (n2 > 1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            n = 0;
            while (n < stringBuffer.length()) {
                char c = stringBuffer.charAt(n);
                if (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                    stringBuffer.deleteCharAt(n--);
                }
                ++n;
            }
            string = stringBuffer.toString();
        }
        if ((n2 = string.length()) == 0) {
            return null;
        }
        int n3 = 0;
        while (n3 < n2) {
            n = string.charAt(n3);
            switch (n) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    break;
                }
                default: {
                    Toolkit.getDefaultToolkit().beep();
                    return null;
                }
            }
            ++n3;
        }
        return string;
    }

    public static String validateBitData(String string) {
        int n;
        int n2 = string.length();
        if (n2 > 1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            n = 0;
            while (n < stringBuffer.length()) {
                char c = stringBuffer.charAt(n);
                if (c == ' ' || c == '\r' || c == '\n' || c == '\t') {
                    stringBuffer.deleteCharAt(n--);
                }
                ++n;
            }
            string = stringBuffer.toString();
        }
        if ((n2 = string.length()) == 0) {
            return null;
        }
        int n3 = 0;
        while (n3 < n2) {
            n = string.charAt(n3);
            switch (n) {
                case 48: 
                case 49: {
                    break;
                }
                default: {
                    Toolkit.getDefaultToolkit().beep();
                    return null;
                }
            }
            ++n3;
        }
        return string;
    }

    public static String validateTagData(String string) {
        int n;
        int n2 = string.length();
        string = string.toUpperCase();
        if (n2 > 1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            n = 0;
            while (n < stringBuffer.length()) {
                char c = stringBuffer.charAt(n);
                if (c == ' ' || c == '\r' || c == '\n' || c == '\t') {
                    stringBuffer.deleteCharAt(n--);
                }
                ++n;
            }
            string = stringBuffer.toString();
        }
        if ((n2 = string.length()) == 0) {
            return null;
        }
        int n3 = 0;
        while (n3 < n2) {
            n = string.charAt(n3);
            switch (n) {
                case 84: 
                case 95: {
                    break;
                }
                default: {
                    Toolkit.getDefaultToolkit().beep();
                    return null;
                }
            }
            ++n3;
        }
        return string;
    }

    public static int getAppCount() {
        String string = System.getProperty("IBM_APP_COUNT");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 0;
    }

    public static void registerApp() {
        String string = System.getProperty("IBM_APP_COUNT");
        if (string != null) {
            int n = Integer.parseInt(string);
            string = String.valueOf(++n);
        } else {
            string = "1";
        }
        System.setProperty("IBM_APP_COUNT", string);
    }

    public static void deregisterApp() {
        String string = System.getProperty("IBM_APP_COUNT");
        if (string != null) {
            int n = Integer.parseInt(string);
            string = String.valueOf(--n);
            System.setProperty("IBM_APP_COUNT", string);
        }
    }
}

