/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.util;

import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugPanelFrame;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.Util;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabbedPane
extends JTabbedPane
implements ChangeListener,
MouseListener,
MouseMotionListener {
    private DebugContext m_ctxt = null;
    private ArrayList m_panels = null;
    private int m_topPanel = -1;
    private Point m_clickPoint = null;
    private boolean m_cloneSupported = false;
    private boolean m_cloneActive = false;
    private DebugPanelFrame m_cloneFrame = null;

    public TabbedPane(DebugContext debugContext) {
        Util.setOrientation(this);
        this.m_ctxt = debugContext;
        this.m_panels = new ArrayList();
        this.addChangeListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void saveSettings() {
        int n = this.m_panels.size();
        int n2 = 0;
        while (n2 < n) {
            TabPanel tabPanel = (TabPanel)this.m_panels.get(n2);
            tabPanel.saveSettings();
            ++n2;
        }
    }

    public void cleanUp() {
        this.removeChangeListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeAll();
        this.m_panels.clear();
        this.m_ctxt = null;
        this.m_panels = null;
        this.m_clickPoint = null;
    }

    public void clearPanels() {
        int n = this.m_panels.size();
        int n2 = 0;
        while (n2 < n) {
            TabPanel tabPanel = (TabPanel)this.m_panels.get(n2);
            tabPanel.clear(false);
            ++n2;
        }
    }

    public void addTab(TabPanel tabPanel) {
        this.m_panels.add(tabPanel);
        super.addTab(tabPanel.getTabText(), tabPanel.getTabIcon(), tabPanel.getComponent());
        tabPanel.init(this.m_ctxt, this);
    }

    public void setTabText(TabPanel tabPanel, String string) {
        int n = this.indexOfComponent(tabPanel.getComponent());
        if (n >= 0) {
            this.setTitleAt(n, string);
        }
    }

    public void setTabIcon(TabPanel tabPanel, Icon icon) {
        int n = this.indexOfComponent(tabPanel.getComponent());
        if (n >= 0) {
            this.setIconAt(n, icon);
        }
    }

    public boolean isPanelExposed(TabPanel tabPanel) {
        TabPanel tabPanel2 = (TabPanel)this.m_panels.get(this.m_topPanel);
        return tabPanel == tabPanel2;
    }

    public void exposePanel(TabPanel tabPanel) {
        if (!this.isPanelExposed(tabPanel)) {
            this.setSelectedComponent(tabPanel.getComponent());
        }
    }

    public boolean isSupported(TabPanel tabPanel) {
        int n = this.indexOfComponent(tabPanel.getComponent());
        return n >= 0 && this.isEnabledAt(n);
    }

    public void setSupported(TabPanel tabPanel, boolean bl) {
        int n = this.indexOfComponent(tabPanel.getComponent());
        if (n >= 0) {
            this.setEnabledAt(n, bl);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        TabPanel tabPanel = null;
        if (this.m_topPanel >= 0) {
            tabPanel = (TabPanel)this.m_panels.get(this.m_topPanel);
            tabPanel.setExposed(false);
        }
        this.m_topPanel = this.getSelectedIndex();
        if (this.m_topPanel >= 0) {
            tabPanel = (TabPanel)this.m_panels.get(this.m_topPanel);
            tabPanel.setExposed(true);
            this.m_ctxt.setActivePanel(tabPanel);
            this.m_cloneSupported = tabPanel.canClone();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_cloneActive = this.m_cloneSupported;
        this.m_clickPoint = mouseEvent.getPoint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.m_cloneActive = false;
        this.m_cloneFrame = null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.m_cloneFrame != null) {
            Rectangle rectangle = this.m_cloneFrame.getBounds();
            Point point = new Point(mouseEvent.getPoint());
            SwingUtilities.convertPointToScreen(point, this);
            rectangle.x = point.x - rectangle.width / 2;
            rectangle.y = point.y;
            ((Component)this.m_cloneFrame).setBounds(rectangle);
        } else if (this.m_cloneActive && (Math.abs(mouseEvent.getPoint().y - this.m_clickPoint.y) >= 10 || Math.abs(mouseEvent.getPoint().x - this.m_clickPoint.x) >= 10)) {
            TabPanel tabPanel = (TabPanel)this.m_panels.get(this.m_topPanel);
            Point point = new Point(mouseEvent.getPoint());
            SwingUtilities.convertPointToScreen(point, this);
            this.m_cloneFrame = tabPanel.cloneFrame(point.x, point.y);
            this.m_cloneActive = false;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

