/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.util;

import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public abstract class DialogTabPanel {
    protected static final int GRID_GAP = 3;
    protected static final int PANEL_GAP = 15;
    protected static final int BORDER_GAP = 10;
    protected String m_name = "";
    protected int m_type = -1;
    protected boolean m_isLtoR = true;
    protected Dialog m_dialog = null;

    public DialogTabPanel(String string, int n) {
        this.m_name = string;
        this.m_type = n;
        this.m_isLtoR = MRI.isLtoR();
    }

    public DialogTabPanel(Dialog dialog, String string, int n) {
        this(string, n);
        this.m_dialog = dialog;
    }

    public abstract JComponent getComponent();

    public abstract boolean doOk();

    public abstract void cleanUp();

    public String getTabText() {
        return this.m_name;
    }

    public int getType() {
        return this.m_type;
    }

    public void setDialog(Dialog dialog) {
        this.m_dialog = dialog;
    }

    public Dialog getDialog() {
        return this.m_dialog;
    }

    protected void postClock() {
        if (this.m_dialog != null) {
            this.m_dialog.postClock();
        }
    }

    protected void retractClock() {
        if (this.m_dialog != null) {
            this.m_dialog.retractClock();
        }
    }

    protected Border getEmptyBorder(int n, int n2, int n3, int n4) {
        Border border = null;
        border = this.m_isLtoR ? BorderFactory.createEmptyBorder(n, n2, n3, n4) : BorderFactory.createEmptyBorder(n, n4, n3, n2);
        return border;
    }

    protected Border getTitledBorder(String string) {
        TitledBorder titledBorder = null;
        titledBorder = this.m_isLtoR ? BorderFactory.createTitledBorder(null, string, 1, 2) : BorderFactory.createTitledBorder(null, string, 3, 2);
        return titledBorder;
    }
}

