/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.util;

import com.ibm.iseries.debug.util.ActionGroup;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Util;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public abstract class Action
extends AbstractAction
implements Runnable {
    public static final String ABOUT = "about";
    public static final String CLOSE = "close";
    public static final String STR_DBG = "strdbg";
    public static final String END_DBG = "enddbg";
    public static final String RESTR_DBG = "rstrdbg";
    public static final String STR_PASE_DBG = "strpdbg";
    public static final String ADD_LINE_BRK = "abrk";
    public static final String ENABLE_LINE_BRK = "ebrk";
    public static final String DISABLE_LINE_BRK = "dbrk";
    public static final String EDIT_LINE_BRK = "editbrk";
    public static final String CHG_LINE_BRK = "brkp";
    public static final String RMV_LINE_BRK = "rbrk";
    public static final String RMV_ALL_LINE_BRK = "rabrk";
    public static final String NEW_BRK_GROUP = "ngrp";
    public static final String DLT_BRK_GROUP = "dgrp";
    public static final String CHG_BRK_GROUP = "grpp";
    public static final String ADD_PGM = "addpgm";
    public static final String RMV_PGM = "rmvpgm";
    public static final String END_PGM = "endpgm";
    public static final String RESUME = "resume";
    public static final String PAUSE = "pause";
    public static final String PAUSE_TRANSITION = "pauset";
    public static final String STEP_OVER = "stepover";
    public static final String STEP_OVER_SKIP = "stepoversb";
    public static final String STEP_IN = "stepin";
    public static final String STEP_OUT = "stepout";
    public static final String STEP_OUT_SKIP = "stepoutsk";
    public static final String STEP_ASM = "stepasm";
    public static final String RUN_CURSOR = "rtoc";
    public static final String RUN_CURSOR_SKIP = "rtocsb";
    public static final String CLS_ALL_WINDOWS = "clsa";
    public static final String MIN_ALL_WINDOWS = "mina";
    public static final String HELP = "help";
    public static final String PANEL_HELP = "helpp";
    public static final String SAVE_ENV = "senv";
    public static final String SAVE_ENV_AS = "senvas";
    public static final String OPEN_ENV = "oenv";
    public static final String GOTO_SRC = "gosrc";
    public static final String GOTO_LINE = "goline";
    public static final String GOTO_ADDR = "goaddr";
    public static final String GOTO_METHOD = "gometh";
    public static final String GOTO_DSM = "godsm";
    public static final String SUSPEND_PANEL = "supd";
    public static final String RESUME_PANEL = "rupd";
    public static final String FIND = "find";
    public static final String COPY = "copy";
    public static final String COPY_PANEL = "cpypnl";
    public static final String COLUMNS = "cols";
    public static final String PREFERENCES = "prefs";
    public static final String AUTO_EVAL = "aeval";
    public static final String CHG_SYS = "chgsys";
    public static final String CHG_VIEW = "chgview";
    public static final String ARRAY_BOUNDS = "abnds";
    public static final String DEREF = "dref";
    public static final String RESET = "reset";
    public static final String EBCDIC = "ebcdic";
    public static final String ASCII = "ascii";
    public static final String UNICODE = "unicode";
    public static final String HEX = "hex";
    public static final String INC_BASE_CLASSES = "incbscls";
    public static final String CLR_CONSOLE = "clrcon";
    public static final String CURRENT_THREAD = "curthd";
    public static final String NEW_MON = "newmon";
    public static final String DLT_MON = "dltmon";
    public static final String DLT_ALL_MON = "dltamon";
    public static final String SHOW_DSM = "showdsm";
    public static final String HIDE_DSM = "hidedsm";
    public static final String SYNC_SRC = "syncsrc";
    public static final String GOTO_MEMORY = "gotomem";
    public static final String GOTO_OFFSET = "gotooff";
    public static final String NEW_MEMORY = "newmem";
    public static final String KILL = "kill";
    public static final String DEBUG_OPT = "dbgopt";
    public static final String RESOLVE_LOADMAP_SRC = "rslvsrc";
    public static final String ADD_METHOD_BRK = "addmbrk";
    protected DebugContext m_ctxt;
    protected Settings m_userCfg;
    protected String m_key;
    protected char m_mnemonic;
    protected KeyStroke m_keyStroke;
    protected int m_dfltKeyCode;
    protected int m_dfltKeyModifier;
    protected boolean m_dfltEnable;
    protected boolean m_supported;

    private Action() {
    }

    public Action(String string, String string2, int n, int n2, boolean bl) {
        super(Util.parseMnemonic(string2));
        this.m_key = string;
        this.m_mnemonic = Util.getMnemonic();
        this.m_keyStroke = null;
        this.m_dfltKeyCode = n;
        this.m_dfltKeyModifier = n2;
        this.m_dfltEnable = bl;
        this.m_supported = true;
        this.setEnabled(this.m_dfltEnable);
    }

    public Action(String string, String string2, ImageIcon imageIcon, int n, int n2, boolean bl) {
        super(Util.parseMnemonic(string2), imageIcon);
        if (imageIcon != null) {
            imageIcon.setDescription(string2);
        }
        this.m_key = string;
        this.m_mnemonic = Util.getMnemonic();
        this.m_keyStroke = null;
        this.m_dfltKeyCode = n;
        this.m_dfltKeyModifier = n2;
        this.m_dfltEnable = bl;
        this.m_supported = true;
        this.setEnabled(this.m_dfltEnable);
    }

    public void init(DebugContext debugContext, Settings settings) {
        this.m_ctxt = debugContext;
        this.m_userCfg = settings;
        String string = settings.getString(this.m_key + "Key", null);
        if (string != null) {
            try {
                this.m_keyStroke = KeyStroke.getKeyStroke(string);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (this.m_dfltKeyCode > 0) {
                    this.m_keyStroke = KeyStroke.getKeyStroke(this.m_dfltKeyCode, this.m_dfltKeyModifier);
                }
            }
        } else if (this.m_dfltKeyCode > 0) {
            this.m_keyStroke = KeyStroke.getKeyStroke(this.m_dfltKeyCode, this.m_dfltKeyModifier);
        }
    }

    public void cleanUp() {
        this.m_ctxt = null;
        this.m_userCfg = null;
        this.m_keyStroke = null;
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public ImageIcon getIcon() {
        return (ImageIcon)this.getValue("SmallIcon");
    }

    public String toString() {
        return (String)this.getValue("Name");
    }

    public DebugContext getContext() {
        return this.m_ctxt;
    }

    public ActionGroup getActionGroup() {
        return this.m_ctxt.getActionGroup();
    }

    public String getKey() {
        return this.m_key;
    }

    public boolean hasMnemonic() {
        return this.m_mnemonic != '\u0000';
    }

    public char getMnemonic() {
        return this.m_mnemonic;
    }

    public boolean isFKey() {
        return this.m_keyStroke != null && this.m_keyStroke.getKeyCode() >= 112 && this.m_keyStroke.getKeyCode() <= 61451;
    }

    public KeyStroke getKeyStroke() {
        return this.m_keyStroke;
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        this.m_keyStroke = keyStroke;
    }

    public boolean isDefaultKeyStroke() {
        if (this.m_keyStroke == null) {
            return this.m_dfltKeyCode == 0;
        }
        return this.m_keyStroke.getKeyCode() == this.m_dfltKeyCode && this.m_keyStroke.getModifiers() == this.m_dfltKeyModifier;
    }

    public boolean isDefaultKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return this.m_dfltKeyCode == 0;
        }
        return keyStroke.getKeyCode() == this.m_dfltKeyCode && keyStroke.getModifiers() == this.m_dfltKeyModifier;
    }

    public KeyStroke getDefaultKeyStroke() {
        KeyStroke keyStroke = null;
        if (this.m_dfltKeyCode > 0) {
            keyStroke = KeyStroke.getKeyStroke(this.m_dfltKeyCode, this.m_dfltKeyModifier);
        }
        return keyStroke;
    }

    public void setDefaultKeyStroke() {
        this.m_keyStroke = null;
        if (this.m_dfltKeyCode > 0) {
            this.m_keyStroke = KeyStroke.getKeyStroke(this.m_dfltKeyCode, this.m_dfltKeyModifier);
        }
    }

    public String getKeyStrokeString() {
        if (this.m_keyStroke != null) {
            String string = KeyEvent.getKeyModifiersText(this.m_keyStroke.getModifiers());
            String string2 = KeyEvent.getKeyText(this.m_keyStroke.getKeyCode());
            if (string.length() > 0) {
                return string + "+" + string2;
            }
            return string2;
        }
        return "";
    }

    public static String getKeyStrokeString(KeyStroke keyStroke) {
        if (keyStroke != null) {
            String string = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
            String string2 = KeyEvent.getKeyText(keyStroke.getKeyCode());
            if (string.length() > 0) {
                return string + "+" + string2;
            }
            return string2;
        }
        return "";
    }

    public boolean isSupported(double d) {
        return true;
    }

    public void setSupported(double d) {
    }

    public boolean isSupported() {
        return this.m_supported;
    }

    public void setSupported(boolean bl) {
        this.m_supported = bl;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(this.isSupported() && bl);
    }

    public boolean isDefaultEnabled() {
        return this.m_dfltEnable;
    }

    public void restoreDefaultEnabled() {
        this.setEnabled(this.m_dfltEnable);
    }

    public void setDefaultEnabled(boolean bl) {
        this.m_dfltEnable = bl;
    }

    public boolean isOnWhilePgmRunning() {
        return false;
    }

    public boolean isOffWhilePgmRunning() {
        return false;
    }

    public boolean isSelectionDependent() {
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.run();
    }

    public abstract void run();
}

